### Name: BioString-class
### Title: Class "BioString", represents a biological sequence
### Aliases: BioString-class [,BioString-method
###   [,BioString,ANY,ANY,ANY-method [[,BioString-method
###   allSameLetter,BioString,character-method
###   allSameLetter,BioString,BioString-method
###   anySameLetter,BioString,character-method
###   anySameLetter,BioString,BioString-method
###   as.character,BioString-method as.matrix,BioString-method
###   initialize,BioString-method length,BioString-method
###   matchDNAPattern,BioString,BioString-method nchar,BioString-method
###   show,BioString-method substr,BioString-method
###   substring,BioString-method
### Keywords: classes

### ** Examples

new("BioString", DNAAlphabet()) # creates an empty DNA string
x <- DNAString("AAGCTANA", gap="N")
x
as.character(x)
substr(x, 2, 4)
substring(x, 1, seq(length=nchar(x))) # all prefixes of x
substring(x, seq(length=nchar(x)), nchar(x)) # all suffixes of x
matchDNAPattern("GC", x)
x <- substring(x, 1:3, 3:5)
x[1:2]
x[-3] # same as x[1:2]
x[[3]]



