\name{#PKGNAME#OMIM}
\alias{#PKGNAME#OMIM}
\title{Mappings between probe identifiers and Mendelian Inheritance in
  Man (MIM) identifiers}
\description{
  The OMIM database (Online Mendelian Inheritance in Man)
  \url{http://www3.ncbi.nlm.nih.gov/entrez/query.fcgi?db=OMIM} contains
  data for human genes and genetic disorders. #PKGNAME#OMIM maps probe
  identifiers to MIM numbers that can be used to search the database 
}
\details{
  OMIM is based upon the book Mendelian Inheritance in Man
  (V. A. McKusick) and focuses primarily on inherited or heritable
  genetic diseases. It contains textual information, pictures, and reference
  information that can be searched using various terms, among which the
  MIM number is one. 
  
  Mappings were based on data provided by:

  #LLSOURCE#

  Package built #DATE#
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/LocusLink}
}
\examples{
    # Convert the environment to a list
    xx <- as.list(#PKGNAME#OMIM)
    # Remove probe ids that do not map to any MIM number
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # The MIM numbers for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
    }
}

\keyword{datasets}

