\name{GOMFPARENTS}
\alias{GOMFPARENTS}
\title{Annotation of GO identifiers by the GO identifiers of their
  direct parents} 
\description{
This is an R environment (hash table) mapping GO ids to the GO
ids of their direct parents under Molecular function (MF). Direct
parents of a given GO id are those GO ids correponding to all the parents
nodes that have direct link to the node for the GO id of
concern based on the directed acyclic graph defined by Gene Ontology
Consortium. GO terms for parent nodes are more general than that of the
child nods 
}
\details{
  GO ids are keys and the corresponding parent GO ids are values. Values are
  named vectors of length 1 or greater depending on whether the GO id of
  concern has only one or more parents. The name(s) of value(s) is(are)
  the association code (isa or partof) between the GO id and its direct
  parents.GO ids that do not have any parent node are assigned NA as the
  values. 

  Molecular function is defined as the tasks performed by individual
  gene products; examples are transcription factor and DNA helicase as
  defined by Gene Ontology Consortium.

  Mappings were based on data provided by:

  #GOSOURCE#

  Package built: #DATE#
}
\references{
\url{http://www.geneontology.org/} and
\url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
    require("GO", character.only = TRUE) || stop("GO unavailable")
    require("annotate", character.only = TRUE) || stop("annoate unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOMFPARENTS)
    # Remove GO ids that do not have any parent
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # Get the parent GO ids for the first elents of xx
        goids <- xx[[1]]
        # Find out the GO terms for the first parent goid
        GOID(GOTERM[[goids[1]]])
        Term(GOTERM[[goids[1]]])
        Synonym(GOTERM[[goids[1]]])
        Secondary(GOTERM[[goids[1]]])
        Definition(GOTERM[[goids[1]]])
        Category(GOTERM[[goids[1]]])
    }
}
\keyword{datasets}

