\name{installReps}
\alias{installReps}
\title{Install all repository packages}
\description{
  Using reposTools, install/update all packages from given repositories.
}

\usage{
installReps(repNames = c("BIOCData", "BIOCcdf", "BIOCprobes"),
            lib = reposToolsLibPaths()[1])
}
\arguments{
  \item{repNames}{A character vector containing repository names. A listing
    of known repository names can be found with the getReposOption() function.
  }
  \item{lib}{A path to install/update the packages. If this directory does not
    exist, it will be created (if possible).
  }
}

\author{Colin A. Smith \email{webbioc@colinsmith.org}}
\keyword{ file }

\eof
\name{mt.wrapper}
\alias{mt.wrapper}
\title{Multiple Testing Wrapper Function}
\description{
  A wrapper for some of the functionality for the \code{multtest}
  package. It also includes hooks to calculate q-values with John
  D. Storey's \file{q-value.R} code.
}

\usage{
mt.wrapper(proc, X, classlabel, test="t", rawpcalc="Parametric", side="abs", ...)
}
\arguments{
  \item{proc}{A character string containing the name of the multiple
    testing procedure for which adjusted \eqn{p}-values are to be
    computed. This vector should include any of the following:
    \code{"Bonferroni"}, \code{"Holm"}, \code{"Hochberg"},
    \code{"SidakSS"}, \code{"SidakSD"}, \code{"BH"}, \code{"BY"},
    \code{"maxT"}, \code{"minP"}, \code{"q"}.
  }
  \item{X}{A data frame or matrix, with \eqn{m} rows corresponding to variables
    (hypotheses) and
    \eqn{n} columns to observations. In the case of gene expression data, rows
    correspond to genes and columns to mRNA samples. The data can
    be read using \code{\link{read.table}}.
  }
  \item{classlabel}{
    A vector of integers corresponding to observation (column)
    class labels. For \eqn{k} classes, the labels must be integers
    between 0 and \eqn{k-1}. For the \code{blockf} test option,
    observations may be divided into
    \eqn{n/k} blocks of \eqn{k} observations each. The observations are
    ordered by block, and within each block, they are labeled using the
    integers 0 to \eqn{k-1}.
  }	
  \item{test}{A character string specifying the statistic to be
    used to test the null hypothesis of no association between the
    variables and the class labels.\cr
    If \code{test="t"}, the tests are based on two-sample Welch t-statistics
    (unequal variances).  \cr
    If \code{test="t.equalvar"}, the tests are based on two-sample
    t-statistics with equal variance for the two samples. The
    square of the t-statistic is equal to an F-statistic for \eqn{k=2}. \cr
    If \code{test="wilcoxon"}, the tests are based on standardized rank sum Wilcoxon statistics.\cr
    If \code{test="f"}, the tests are based on F-statistics.\cr
    If \code{test="pairt"}, the tests are based on paired t-statistics. The
    square of the paired t-statistic is equal to a block F-statistic for \eqn{k=2}. \cr
    If \code{test="blockf"}, the tests are based on F-statistics which
    adjust for block differences
    (cf. two-way analysis of variance).
  }
  \item{rawpcalc}{A character string specifying how to calculate
    nominal/raw p-values. The possible choices are \code{"Parametric"}
    or \code{"Permutation"}.
  }
  \item{side}{A character string specifying the type of rejection region.\cr
    If \code{side="abs"}, two-tailed tests, the null hypothesis is rejected for large absolute values of the test statistic.\cr
    If \code{side="upper"}, one-tailed tests, the null hypothesis is rejected for large values of the test statistic.\cr
    If \code{side="lower"}, one-tailed tests,  the null hypothesis is rejected for small values of the test statistic.
  }
  \item{...}{Further arguments for \code{mt.maxT}, \code{mt.minP}, \code{qvalue}.}
}

\value{
  A data frame with components
  \item{index}{Vector of row indices, between 1 and \code{nrow(X)},
    where rows are sorted first according to their adjusted
    \eqn{p}-values, next their unadjusted \eqn{p}-values, and
    finally their test statistics. }
  \item{teststat}{Vector of test statistics, ordered according to
    \code{index}.  To get the test statistics in the original data
    order, use \code{teststat[order(index)]}.}
  \item{rawp}{Vector of raw (unadjusted) \eqn{p}-values, ordered according to \code{index}.}
  \item{adjp}{Vector of adjusted \eqn{p}-values, ordered according to \code{index}.}
  \item{plower}{For \code{\link{mt.minP}} function only, vector of
    "adjusted \eqn{p}-values", where ties in the permutation
    distribution of the successive minima of raw \eqn{p}-values
    with the observed \eqn{p}-values are counted only once. Note
    that procedures based on \code{plower} do not control the FWER.
    Comparison of \code{plower} and \code{adjp} gives an idea of
    the discreteness of the permutation distribution. Values in
    \code{plower} are ordered according to \code{index}.}
  }
}

\author{Colin A. Smith \email{webbioc@colinsmith.org}}
\keyword{ file }

\eof
\name{qplot}
\alias{qplot}
\title{Plot q-value Result Diagnostics}
\description{
  Plots diagnostic graphs for the qvalue function.
}

\usage{
qplot(qobj, rng=0.1)
}
\arguments{
  \item{qobj}{a q-value object returned by the qvalue function}
  \item{rng}{the range of q-values to be plotted}
}

\value{
  Four plots:
  \item{Upper-left}{pi0.hat(lambda) versus lambda with a smoother}
  \item{Upper-right}{q-values versus p-values}
  \item{Lower-left}{number of significant tests per each q-value
                    cut-off}
  \item{Lower-right}{number of expected false positives versus
                     number of significant tests}
}

\references{
  Storey JD. (2002) A direct approach to false discovery rates.
  \emph{Journal of the Royal Statistical Society}, Series B, 64:
  479-498.
}
\author{John D. Storey \url{http://faculty.washington.edu/~jstorey/}}
\keyword{ file }

\eof
\name{qvalue}
\alias{qvalue}
\title{Estimate pFDR q-values from p-values}
\description{
  Applies the q-value multiple testing procedure to a group of
  unadjusted p-values.
}

\usage{
qvalue(p, lambda=seq(0,0.95,0.05), pi0.meth="smoother", fdr.level=NULL, robust=F)
}
\arguments{
  \item{p}{a vector of p-values}
  \item{fdr.level}{a level at which to control the FDR}
  \item{lambda}{the value of the tuning parameter to estimate pi0}
  \item{pi0.meth}{either "smoother" or "bootstrap"; the method for
		  automatically choosing tuning parameter in the
		  estimation of pi0, the proportion of true null
		  hypotheses}
  \item{robust}{an indicator of whether it is desired to make the
		estimate more robust for small p-values and a direct
		finite sample estimate of pFDR}
}

\value{
  \item{call}{gives the function call}
  \item{pi0}{an estimate of the proportion of null p-values}
  \item{qvalues}{a vector of the estimated q-values (the main
                 quantity of interest)}
  \item{pvalues}{a vector of the original p-values}
  \item{significant}{if fdr.level is specified, and indicator of
		     whether the q-value fell below fdr.level
		     (taking all such q-values to be significant
		     controls FDR at level fdr.level)}
}

\references{
  Storey JD. (2002) A direct approach to false discovery rates.
  \emph{Journal of the Royal Statistical Society}, Series B, 64:
  479-498.
}
\author{John D. Storey \url{http://faculty.washington.edu/~jstorey/}}
\keyword{ file }

\eof
\name{qwrite}
\alias{qwrite}
\title{Save q-value Results to a File}
\description{
  Saves the object created by the qvalue function to a plain text file.
}

\usage{
qwrite(qobj, filename="my-qvalue-results.txt
}
\arguments{
  \item{qobj}{a q-value object returned by the qvalue function}
  \item{filename}{the name of the file where the results are written}
}

\value{
  A file sent to "filename" with the following:
  \item{First row}{the function call used to produce the estimates}
  \item{Second row}{the estimate of the proportion of false positives,
                    pi0}
  \item{Third row and below}{the p-values (1st column) and the
                             estimated q-values (2nd column)}
}

\references{
  Storey JD. (2002) A direct approach to false discovery rates.
  \emph{Journal of the Royal Statistical Society}, Series B, 64:
  479-498.
}
\author{John D. Storey \url{http://faculty.washington.edu/~jstorey/}}
\keyword{ file }

\eof
