sam.plot              package:siggenes              R Documentation

_S_A_M _A_n_a_l_y_s_i_s _f_o_r _a _s_p_e_c_i_f_i_c _t_h_r_e_s_h_o_l_d

_D_e_s_c_r_i_p_t_i_o_n:

     This functions performs a SAM or a SAM-Wilc analysis,
     respectively, for a specific threshold Delta, and (optionally)
     stores information on the differentially expressed genes in a
     file.

_U_s_a_g_e:

         sam.plot(sam.out,delta,q.values=TRUE,R.fold=TRUE,R.unlog=TRUE,
             na.rm=FALSE,file.out=NA,gene.names=NULL)

_A_r_g_u_m_e_n_t_s:

 sam.out: the object to which the output of a previous analysis with
          'sam' or 'sam.wilc' was stored.

   delta: the value of the threshold Delta for which the analysis
          should be performed.

q.values: if 'TRUE' (default), the q-value for each gene will be
          computed.

  R.fold: if 'TRUE' (default), the fold change for each differentially 
          expressed gene will be computed. If the previous SAM analysis
          was an one class analysis 'R.fold' is automatically set to
          'FALSE'.

 R.unlog: if 'TRUE', 2\^data will be used in the computation of the
          R.fold. This is recommended if 'data' consists of log2
          transformed gene expression data.

   na.rm: if 'FALSE' (default), the fold change of genes with at least
          one missing value will be set to 'NA'. If 'TRUE', missing
          values will be replaced by the genewise mean.

file.out: if specified (i.e. not 'NA'), general information like the
          number of significant genes and the estimated FDR and
          gene-specific information is stored in the corresponding
          file.

gene.names: a vector containing the names of the genes.

_V_a_l_u_e:

     a SAM Plot for the specified Delta and (optionally) an output file
     containing general information like the number of significant
     genes and the FDR and information about the differentially
     expressed genes like their names, q-values and fold changes.

 vec.fdr: a list containing the number of p0, significant genes, the
          FDR etc. for the specified Delta.

sam.output: a table containing gene-specific information about the
          differentially expressed genes like their IDs (i.e. the rows
          of the data set that contain the  expression data of these
          genes), their expression score, q-values, the fold changes
          etc.

row.sig.genes: vector that consists of the rows of the data set that
          contain the expression data of the differentially expressed
          genes.

_N_o_t_e:

     SAM was developed by Tusher et al. (2001).

     !!! There is a patent pending for the SAM technology at Stanford
     University. !!!

_A_u_t_h_o_r(_s):

     Holger Schwender holger.schw@gmx.de

_R_e_f_e_r_e_n_c_e_s:

     Tusher, V.G., Tibshirani, R., and Chu, G. (2001). Significance
     analysis of microarrays applied to the ionizing radiation
     response, _PNAS_, 98, 5116-5121.

     Storey, J.D., and Tibshirani, R. (2003). Statistical significance
     for genome-wide experiments, _Technical Report_, Department of
     Statistics, Stanford University.

     Schwender, H. (2003). Assessing the false discovery rate in a
     statistical analysis of gene expression data, Chapters 5 and 6,
     _Diploma thesis_, Department of Statistics, University of
     Dortmund, <URL: http://de.geocities.com/holgerschw/thesis.pdf>.

_S_e_e _A_l_s_o:

     'sam' 'sam.wilc \code{sam.delta}'

_E_x_a_m_p_l_e_s:

         library(multtest)
         # Load the data of Golub et al. (1999). data(golub) contains a 3051x38 gene expression
         # matrix called golub, a vector of length called golub.cl that consists of the 38 class labels,
         # and a matrix called golub.gnames whose third column contains the gene names.
         data(golub)
         
         # Performing a SAM Analysis of the Golub data. Setting rand=123, to make the results reproducible,
         # and setting med.fdr=FALSE, such that the mean number instead of the median number of falsely called
         # genes is computed. The output is assigned to an object for further analyses.
         if (interactive()) {
         sam.output<-sam(golub,golub.cl,med.fdr=FALSE,rand=123)
         
         # Now sam.plot can be used to obtain the SAM plot and information about the differentially expressed
         # genes for a specified value of delta.
         
         sam.14<-sam.plot(sam.output,1.4,gene.names=golub.gnames[,3])
         
         # sam.plot can also be used in a SAM-Wilc analysis for a specific Delta. 
         
         # For further analyses, the row numbers of the differentially expressed genes can be obtained by
         
         sam.14$row.sig.genes
     }

