\name{arrange.row}
\alias{arrange.row}
\title{
  Reorder a dataset by increasing row order.}

\usage{arrange.row(data)}
\description{The functions could be used to reorder a dataset to make
  sure that all the genes are in the same row before fitting any model.
  The \code{arrange.row} function is also used by the \code{weight.plot}
  function to map all the genes to their position on the slide.
}
\arguments{
  \item{data}{
    A dataset containing the row indices in the first column and the
    column indices in the second column.
    The row indices should all be distinct. All indices should start at zero!
  }  
}

\value{ The ordered dataset.
}

}
\references{Robust Estimation of cDNA Microarray Intensities with Replicates
Raphael Gottardo, Adrian E. Raftery, Ka Yee Yeung, and Roger Bumgarner
Department of Statistics, University of Washington, Box 354322, Seattle, WA 98195-4322} 
}
\seealso{
  \code{weight.plot}
}
\examples{
data(hiv)
### Put the indices in the first two columns and
### reorder the first 4 replicates
new.data<-cbind(hiv[,9:10],hiv[,1:4])
ordered.data<-arrange.row(new.data)
}

\author{Raphael Gottardo}

\keyword{data}

\eof
\name{est.shift}
\alias{est.shift}
\title{Estimate the shift used in the log transformation}
\usage{est.shift(sample1,sample2,B=1000,min.iter=0,batch=10,mcmc.obj=NULL,dye.swap=FALSE,nb.col1=NULL,all.out=TRUE)}
\description{
  Estimate the shift in the log transformation when fitting the
  Hierarchical model as in bayes.rob.
}
\arguments{
  \item{sample1}{
    The matrix of intensity from the sample 1. Each row corresponds to a different gene.}
  \item{sample2}{
    The matrix of intensity from the sample 2. Each row corresponds to a different gene.}
  \item{B}{
    The number of iteration used the MCMC algorithm.}
  \item{min.iter}{
    The length of the burn-in period in the MCMC algorithm.\code{min.iter} should be less than
    B.
  }
  \item{batch}{The thinning value to be used in the MCMC. Only every \code{batch}-th iteration will be stored.}
  \item{mcmc.obj}{An object of type \code{mcmc.shift}, as returned by
    \code{est.shift}.
    If no \code{mcmc.obj}, the MCMC is initialized to the least squares estimates.}
  \item{dye.swap}{A logical value indicating if the experiment was a dye
    swap experiment.}
  \item{nb.col1}{An integer value correspinding to the number of arrays
    (columns) in the first group of the dye swap experiment. In other words, the number of
    replicates before the dyes have been swaped. }
  \item{all.out}{A logical value indicating if all the parameters
    should be outputted. If \code{all.out} is FALSE, only the posterior
    mean is outputted. This could be used to save memory. }
}

\value{
    An object of type \code{mcmc.est} containing the sampled values from the posterior distribution.
  \item{mu}{A vector containing the sampled values from \code{mu}, the baseline intensity.}
  \item{alpha2}{A vector containing the sampled values from \code{alpha2}, the sample effect.}
  \item{beta2}{A vector containing the sampled values from \code{beta2},
    the dye effect.}
  \item{delta22}{A vector containing the sampled values from
    \code{delta_22}, the dye*sample interaction.}
  \item{eta}{A matrix, each row contains the sampled values from the
    corresponding array effect.}
  \item{gamma1}{A matrix, each row contains the sampled values from the
    corresponding gene effect in sample 1.}
  \item{gamma2}{A matrix, each row contains the sampled values from the
    corresponding gene effect in sample 1.}
  \item{lambda.gamma1}{
    A vector containing the sampled values for the precision of the gene
    effect prior in sample 1.}
  \item{lambda.gamma2}{
    A vector containing the sampled values for the precision of the gene
    effect prior in sample 2.}
  \item{rho}{A vector containing the sampled values from between sample
    correlation coefficient \code{rho}}
  \item{lambda_eps1}{A vector containing the sampled values from the
    gene precision in sample 1.}
  \item{lambda_eps2}{A vector containing the sampled values from the
    gene precision in sample 2.}
  \item{shift}{A vector containing the sampled values from the shift.}
}

\details{
  The estimation is done by fitting the same model (as in fit.model) with constant
  variance, Gaussian errors and a prior for the shift.
  The main purpose of this function is to estimate the shift in the log
  transformation.
  Parameter estimation is carried out using Markov Chain Monte
  Carlo. The shift is estimated with the posterior mean.
}
\references{Robust Estimation of cDNA Microarray Intensities with Replicates
Raphael Gottardo, Adrian E. Raftery, Ka Yee Yeung, and Roger Bumgarner
Department of Statistics, University of Washington, Box 354322, Seattle, WA 98195-4322} 
}
\seealso{
\code{fit.model}
}
\examples{
data(hiv)
### Initialize the proposals
mcmc.hiv<-est.shift(hiv[1:10,c(1:4)],hiv[1:10,c(5:8)],B=2000,min.iter=000,batch=1,mcmc.obj=NULL,dye.swap=TRUE,nb.col1=2)
}

\author{Raphael Gottardo}

\keyword{models}


\eof
\name{fit.model}
\alias{fit.model}
\title{Robust estimation of microarray intensities with replicates}
\usage{fit.model(sample1,sample2,B=1000,min.iter=0,batch=10,shift=NULL,mcmc.obj=NULL,dye.swap=FALSE,nb.col1=NULL,all.out=TRUE)
     }
\description{
  Estimate the log transformed intensities of each sample of a replicated
  microarray experiment. The estimation is done via Hiearchical Bayesian
  Modeling.
}
\arguments{
  \item{sample1}{
    The matrix of intensity from the sample 1. Each row corresponds to a different gene.}
  \item{sample2}{
    The matrix of intensity from the sample 2. Each row corresponds to a different gene.}
  \item{B}{
    The number of iteration used the MCMC algorithm.}
  \item{min.iter}{
    The length of the burn-in period in the MCMC algorithm.\code{min.iter} should be less than
    B.
  }
  \item{batch}{The thinning value to be used in the MCMC. Only every \code{batch}-th iteration will be stored.}
  \item{mcmc.obj}{An object of type mcmc, as returned by \code{fit.model}. \code{mcmc.obj} is used to initialized the MCMC.
    If no \code{mcmc.obj}, the MCMC is initialized to the least squares estimates.}
  \item{shift}{The shift to be used in the log transformation. If
    \code{shift=NULL} is specified (default), it is estimated using \code{est.shift}}
    \item{dye.swap}{A logical value indicating if the experiment was a dye
    swap experiment.}
  \item{nb.col1}{An integer value corresponding to the number of arrays
    (columns) in the first group of the dye swap experiment. In other words, the number of
    replicates before the dyes have been swaped. }
  \item{all.out}{A logical value indicating if all the parameters
    should be outputted. If \code{all.out} is FALSE, only the posterior
    mean is outputted. This could be used to save memory. }
}
\value{
  An object of type \code{mcmc} containing the sampled values from the
  posterior distribution.
  \item{mu}{A vector containing the sampled values from \code{mu}, the baseline intensity.}
  \item{alpha2}{A vector containing the sampled values from \code{alpha2}, the sample effect.}
  \item{beta2}{A vector containing the sampled values from \code{beta2},
    the dye effect.}
  \item{delta22}{A vector containing the sampled values from
    \code{delta_22}, the dye*sample interaction.}
  \item{eta}{A matrix, each row contains the sampled values from the
    corresponding array effect.}
  \item{gamma1}{A matrix, each row contains the sampled values from the
    corresponding gene effect in sample 1.}
  \item{gamma2}{A matrix, each row contains the sampled values from the
    corresponding gene effect in sample 1.}
  \item{lambda.gamma1}{
    A vector containing the sampled values for the precision of the gene
    effect prior in sample 1.}
  \item{lambda.gamma2}{
    A vector containing the sampled values for the precision of the gene
    effect prior in sample 2.}
  \item{rho}{A vector containing the sampled values from between sample
    correlation coefficient \code{rho}}
  \item{lambda_eps1}{A matrix, each row contains the sampled values from the
    corresponding gene precision in sample 1.}
  \item{lambda_eps2}{A matrix, each row contains the sampled values from the
    corresponding gene precision in sample 2.}
  \item{a.eps}{A vector containing the sampled values for the mean of
    the prior of the genes precision.}
  \item{b.eps}{A vector containing the sampled values for the variance of
    the prior of the genes precision.}
  \item{w}{A matrix, each element (i,j) correspond to the posterior mean
    of the sampled weights of replicate j in gene i.To save memory, we
    only store the posterior means of the weigths.}
  \item{shift}{The value of the shift.}
  
}

\details{
  The function fits a hierarchical Bayesian model for robust 
  estimation of cDNA microarray intensities.
  Our model addresses classical issues such as design effects, normalization and transformation.
  Outliers are modeled explicitly using a t-distribution.
  Parameter estimation is carried out using Markov Chain Monte Carlo.
}
\references{Robust Estimation of cDNA Microarray Intensities with Replicates
  Raphael Gottardo, Adrian E. Raftery, Ka Yee Yeung, and Roger Bumgarner
  Department of Statistics, University of Washington, Box 354322, Seattle, WA 98195-4322} 
}
\seealso{
  \code{est.shift}
}
\examples{
data(hiv)
mcmc.hiv<-fit.model(hiv[1:10,c(1:4)],hiv[1:10,c(5:8)],B=2000,min.iter=000,batch=1,shift=30,mcmc.obj=NULL,dye.swap=TRUE,nb.col1=2)
}

\author{Raphael Gottardo}

\keyword{models}
\keyword{robust}

\eof
\name{hiv}
\docType{data}
\alias{hiv}
\title{Cellular gene expression upon human immunodeficiency virus type 1
  infection of CD4+-T-Cell lines}
\description{
  This data set consists of 4 experiments using the same RNA preparation on 4
  different slides. The expression levels of ~7000 cellular RNA transcripts were assessed
  in CD4-T-cell lines at time $t=24$ hour after infection with HIV virus
  type 1. The first 4 columns correspond to the first treatment state (hiv
  infected). The second four represent the control state. The experiment
  is a balanced dye swap experiment. Finally, the last two columns
  contain the row and column positions of each gene on the array (slide).
}
\usage{data(hiv)}
\source{http://expression.microslu.washington.edu/expression/vantwoutjvi2002.html}
\references{
  van't Wout, A. B. ,Lehrma, G. K., Mikheeva, S. A., O'Keeffe, G. C.,
  Katze, M. G., Bumgarner, R. E., Geiss, G. K. and Mullins, J. I.
  Cellular gene expression upon human immunodeficiency virus type 1 infection of CD4+-T-Cell lines
  Journal of Virology, 2003. 77(2):1392-1402.}
\keyword{datasets}

\eof
\name{is.row.na}
\alias{is.row.na}
\title{Test if a matrix contains missing values}
\usage{is.row.na(data)
     }
\description{
The function returns a vector of logical variables, one for each row of
the matrix. The variable is \code{TRUE} if the row does not contain any
missing values and \code{FAlSE} otherwise.
}
\arguments{
  \item{data}{
    The data matrix.
  }
}
\value{
  The vector of logical variable    
}

\seealso{
  is.na
}
\examples{

### Generate a matrix
M<-matrix(rnorm(100),10,10)
M[1,1]<-NA
M[1,2]<- -Inf
M[3,10]<-NA

### Indices of the rows without missing values 
ind<-is.row.na(M)

### Submatrix of M with finite values
M.finite<-M[ind,]
}

\author{Raphael Gottardo}

\keyword{}

\eof
\name{ls.effect}
\alias{ls.effect}
\title{Compute the least squares estimates of the all the effects of the
  general model.}
\usage{
ls.effect(sample1,sample2,dye.swap=FALSE,nb.col1=NULL)
     }
\description{
  Compute the least squares estimates of the all the effects of the
  general model.
}
\arguments{
  \item{sample1}{ 
    The matrix of intensity from the sample 1. Each row corresponds to a different gene.}
  \item{sample2}{
    The matrix of intensity from the sample 2. Each row corresponds to a different gene.}
  \item{dye.swap}{A logical value indicating if the experiment was a dye
    swap experiment.}
  \item{nb.col1}{An integer value correspinding to the number of arrays
    (columns) in the first group of the dye swap experiment. In other words, the number of
    replicates before the dyes have been swaped. } 
}
\value{
  \item{mu}{The baseline intensity}
  \item{alpha2}{The sample effect}
  \item{beta2}{The dye effect}
  \item{delta22}{The dye*sample interaction}
  \item{eta}{The array effects}
  \item{gamma1}{The genes effects in sample 1}
  \item{gamma2}{The genes effect in sample 2}
  \item{M1}{The main effects in sample 1}
  \item{M2}{The main effects in sample 2}
  \item{R1}{The residuals from the sample 1}
  \item{R2}{The residuals from the sample 2}
  
}

\details{
 }
\references{Robust Estimation of cDNA Microarray Intensities with Replicates
  Raphael Gottardo, Adrian E. Raftery, Ka Yee Yeung, and Roger Bumgarner
  Department of Statistics, University of Washington, Box 354322, Seattle, WA 98195-4322} 
}
\seealso{
  \code{fit.model}
}
\examples{
### Compute the least squares effects on the log scale
data(hiv)
ls.fx<-ls.effect(log2(hiv[,c(1:4)]),log2(hiv[,c(5:8)]),dye.swap=TRUE,nb.col1=2)
}

\author{Raphael Gottardo}

\keyword{models}

\eof
\name{mat.mean}
\alias{mat.mean}
\title{Compute the mean and standard deviation of each row in a data matrix}
\usage{mat.mean(data)
}
\description{
  This function computes the mean and standard deviation of each row in
  a data matrix. The source code is written in C. As a consequence, the
  computation is quite fast.
  
}
\arguments{
  \item{data}{The data matrix.}
}
\value{A matrix, the first columns contain the means, the second the
  standard deviations.
}
%\details{
%}
%\references{
%}
\author{Raphael Gottardo}
\seealso{\code{\link{mean}},\code{\link{sd}}}
\examples{
data(hiv)
sample1<-hiv[,1:4]
ms1<-mat.mean(sample1)
}
\keyword{arith}

\eof
\name{ratio.plot}
\alias{ratio.plot}
\title{Plot the estimated log ratios against the overall intensities}
\usage{ratio.plot(mcmc.obj,col=1,pch=1)}
\description{
  Plot the estimated log2(gamma1/gamma2) against log2(gamma1*gamma2)/2.
}
\arguments{
  \item{mcmc.obj}{
    An object of class \code{mcmc} as returned by \code{fit.model}}
  \item{col}{
    The color to be used for the symbols}
  \item{pch}{
    The type of symbols to be used.}
}

\value{ The graph!
}

}
\references{Robust Estimation of cDNA Microarray Intensities with Replicates
Raphael Gottardo, Adrian E. Raftery, Ka Yee Yeung, and Roger Bumgarner
Department of Statistics, University of Washington, Box 354322, Seattle, WA 98195-4322} 
}
\seealso{
  \code{fit.model}
}
\examples{
data(hiv)
### Initialize the proposals
mcmc.hiv<-fit.model(hiv[1:10,c(1:4)],hiv[1:10,c(5:8)],B=2000,min.iter=000,batch=1,shift=30,mcmc.obj=NULL,dye.swap=TRUE,nb.col1=2)
ratio.plot(mcmc.hiv,col=1,pch=1)
}

\author{Raphael Gottardo}

\keyword{hplot}

\eof
\name{weight.plot}
\alias{weight.plot}
\title{Plot the weights of a given array using the spatial location of
  the genes on the slide}
\usage{weight.plot(mcmc.obj,coordinate,array=1)}
\description{Plot the weights of a given array using the spatial location of
  the genes on the slide.This function is a useful diagnostic tool.
}
\arguments{
  \item{mcmc.obj}{
    An object of class \code{mcmc} as returned by \code{fit.model}}
  \item{coordinate}{
    The coordinate of each gene on the corresponding array. The
    coordinates should be a two column integer valued matrix containing
    the row indices (column 1) and the column indices (column 2).
    The row indices should all be distinct. All indices should start at zero!
  }
  \item{array}{
    An integer corresponding to the array number to be plotted.}
}

\value{ The image plot of the weights. A small weight (bright color)
  correspond to an outlier.
}

}
\references{Robust Estimation of cDNA Microarray Intensities with Replicates
Raphael Gottardo, Adrian E. Raftery, Ka Yee Yeung, and Roger Bumgarner
Department of Statistics, University of Washington, Box 354322, Seattle, WA 98195-4322} 
}
\seealso{
  \code{arrange.row}
}
\examples{
data(hiv)
### Initialize the proposals
mcmc.hiv<-fit.model(hiv[1:640,c(1:4)],hiv[1:640,c(5:8)],B=1000,min.iter=500,batch=1,shift=30,mcmc.obj=NULL,dye.swap=TRUE,nb.col1=2)
weight.plot(mcmc.hiv,hiv[1:640,9:10],array=3)
}

\author{Raphael Gottardo}

\keyword{hplot}

\eof
