\name{hedenfalk}
\alias{hedenfalk}

\title{Gene expression dataset from Hedenfalk et al. (2001)}

\usage{
data(hedenfalk)
}

\description{
  The data come from the breast cancer cDNA microarray experiment of Hedenfalk et al. (2001).  In 
  the original experiment, comparison was made between 3,226 genes of two mutation types, BRCA1 
  (7 arrays) and BRCA2 (8 arrays).  The data included here are p-values obtained from a two-
  sample t-test analysis on a subset of 3,170 genes, as described in Storey and Tibshirani (2003).}

\value{
  \item{hedenfalk}{Vector of 3,170 p-values of tests comparing BRCA1 to BRCA2.}
}

\references{
Hedenfalk I et al. (2001). Gene expression profiles in hereditary breast cancer. 
New Engl. Jour. Medicine, 344: 539-548.

Storey JD and Tibshirani R. (2003). Statistical significance for genome-wide 
studies. Proceedings of the National Academy of Sciences, 100: 9440-9445.}

\keyword{datasets}  

\eof
\name{qplot}
\alias{qplot}
\alias{plot.qvalue}
\title{Graphical display of qvalue objects}
\description{
  Graphical display of qvalue objects
}
\usage{
qplot(qobj, rng = c(0, 0.1), \ldots)
\method{plot}{qvalue}(x, \ldots)
}
\arguments{
  \item{qobj, x}{Qvalue object}
  \item{rng}{Range of q-values to consider (optional)}
  \item{\ldots}{Any other arguments}
}
\details{
  The function qplot allows one to view several plots:
  \enumerate{
  \item The estimated \eqn{\pi_0}{pi_0} versus the tuning parameter
  \eqn{\lambda}{lambda}.
  \item The q-values versus the p-values
  \item The number of significant tests versus each q-value cutoff
  \item The number of expected false positives versus the number of
  significant tests
  }

  This function makes fours plots. The first is a plot of the
  estimate of \eqn{\pi_0}{pi_0} versus its tuning parameter
  \eqn{\lambda}{lambda}. In most cases, as \eqn{\lambda}{lambda} 
  gets larger, the bias of the estimate decreases, yet the variance 
  increases. Various methods exist for balancing this bias-variance 
  trade-off (Storey 2002, Storey & Tibshirani 2003, Storey, Taylor 
  & Siegmund 2004). Comparing your estimate of \eqn{\pi_0}{pi_0} to this 
  plot allows one to guage its quality. The remaining three plots
  show how many tests are significant, as well as how many false
  positives to expect for each q-value cut-off. A thorough discussion of
  these plots can be found in Storey & Tibshirani (2003).
  
}
\value{
  Nothing of interest.
}
\references{
  Storey JD. (2002) A direct approach to false discovery rates. Journal
  of the Royal Statistical Society, Series B, 64: 479-498.
  
  Storey JD and Tibshirani R. (2003) Statistical significance for
  genome-wide experiments. Proceedings of the National Academy of Sciences, 
  100: 9440-9445. 

  Storey JD. (2003) The positive false discovery rate: A Bayesian
  interpretation and the q-value. Annals of Statistics, 31: 2013-2035.  

  Storey JD, Taylor JE, and Siegmund D. (2004) Strong control,
  conservative point estimation, and simultaneous conservative
  consistency of false discovery rates: A unified approach. Journal of
  the Royal Statistical Society, Series B, 66: 187-205.
  
  QVALUE Manual \url{http://faculty.washington.edu/~jstorey/qvalue/manual.pdf}
}
\author{John D. Storey \email{jstorey@u.washington.edu}}
\seealso{\code{\link{qvalue}}, \code{\link{qwrite}}, \code{\link{qsummary}}, \code{\link{qvalue.gui}}}
\examples{
\dontrun{
p <- scan(pvalues.txt) 
qobj <- qvalue(p) 
qplot(qobj) 
qwrite(qobj, filename=myresults.txt)

# view plots for q-values between 0 and 0.3:
plot(qobj, rng=c(0.0, 0.3))
}
}
\keyword{misc}

\eof
\name{qsummary}
\alias{qsummary}
\alias{summary.qvalue}
\title{Display qvalue object}
\description{
  Display summary information for a qvalue object.  
}
\usage{
qsummary(qobj, cuts = c(1e-04, 0.001, 0.01, 0.025, 0.05, 0.1, 1),
             digits = getOption("digits"), \ldots)
\method{summary}{qvalue}(object, \ldots)
}
\arguments{
  \item{qobj, object}{Qvalue object}
  \item{cuts}{Vector of significance value to use for table (optional)}
  \item{digits}{Significant digits to display (optional)}
  \item{\ldots}{Any other arguments}
}
\details{
  \code{qsummary} shows the original call, estimated proportion of
  true null hypotheses, and a table comparing the number of significant calls
  for the raw p-values and for the calculated q-values using a set of
  cutoffs given by \code{cuts}. 
}
\value{
  Invisibly returns the original object.
}
\author{Alan Dabney \email{adabney@u.washington.edu} and Gregory R. Warnes \email{gregory\_r\_warnes@groton.pfizer.com}}
\seealso{\code{\link{qvalue}}, \code{\link{qplot}},
  \code{\link{qwrite}}, \code{\link{qvalue.gui}}}
\examples{
\dontrun{
qobj <- qvalue(p)
print(qobj)
summary(qobj, cuts=c(0.01, 0.05))
}
}
\keyword{misc}

\eof
\name{qvalue.gui}
\alias{qvalue.gui}
\title{A graphical user interface for QValue}
\description{
  A graphical user interface for QValue
}
\usage{
qvalue.gui(dummy = NULL)
}
\arguments{
  \item{dummy}{Dummy argument to facilitate documentation (no arguments required)}
}
\details{
  This is a point-and-click version of \code{qvalue}.  See the manual at \url{http://faculty.washington.edu/~jstorey/qvalue/manual.pdf} for documentation.
}
\value{
  Nothing of interest.
}
\author{Alan R. Dabney \email{adabney@u.washington.edu}}
\seealso{\code{\link{qvalue}}, \code{\link{qplot}}, \code{\link{qwrite}}, \code{\link{qsummary}}}
\examples{
\dontrun{
qvalue.gui()
}
}
\keyword{misc}

\eof
\name{qvalue}
\alias{qvalue}
\title{Estimate the q-values for a given set of p-values}
\description{
  Estimate the q-values for a given set of p-values.  The q-value of a
  test measures the proportion of false positives incurred (called the
  false discovery rate) when that particular test is called significant.
}
\usage{
qvalue(p, lambda=seq(0,0.95,0.05), pi0.method="smoother", fdr.level=NULL, robust=F, gui=F)
}
\arguments{
  \item{p}{A vector of p-values (only necessary input)}
  \item{lambda}{The value of the tuning parameter to estimate
    \eqn{\pi_0}{pi_0}. Must be in [0,1). Optional, see Storey (2002).}
  \item{pi0.method}{Either "smoother" or "bootstrap"; the method for
    automatically choosing tuning parameter in the estimation of \eqn{\pi_0}{pi_0}, 
    the proportion of true null hypotheses}
  \item{fdr.level}{A level at which to control the FDR. Must be in (0,1]. Optional; if this is
    selected, a vector of TRUE and FALSE is returned that specifies
    whether each q-value is less than fdr.level or not.}
  \item{robust}{An indicator of whether it is desired to make the
    estimate more robust for small p-values and a direct finite sample 
    estimate of pFDR. Optional.}
  \item{gui}{A flag to indicate to 'qvalue' that it should communicate with 
    the gui.  Should not be specified on command line. Optional.}
}
\details{
  If no options are selected, then the method used to estimate \eqn{\pi_0}{pi_0} is
  the smoother method described in Storey and Tibshirani (2003). The
  bootstrap method is described in Storey, Taylor & Siegmund (2004).
}
\value{
  A list containing:
\item{call}{function call}
\item{pi0}{an estimate of the proportion of null p-values}
\item{qvalues}{a vector of the estimated q-values (the main quantity of
  interest)} 
\item{pvalues}{a vector of the original p-values}
\item{significant}{if fdr.level is specified, and indicator of whether the
  q-value fell below fdr.level (taking all such q-values to be significant
  controls FDR at level fdr.level)}
}
\references{
  Storey JD. (2002) A direct approach to false discovery rates. Journal
  of the Royal Statistical Society, Series B, 64: 479-498.
  
  Storey JD and Tibshirani R. (2003) Statistical significance for
  genome-wide experiments. Proceedings of the National Academy of Sciences, 
  100: 9440-9445. 

  Storey JD. (2003) The positive false discovery rate: A Bayesian
  interpretation and the q-value. Annals of Statistics, 31: 2013-2035.  

  Storey JD, Taylor JE, and Siegmund D. (2004) Strong control,
  conservative point estimation, and simultaneous conservative
  consistency of false discovery rates: A unified approach. Journal of
  the Royal Statistical Society, Series B, 66: 187-205.
  
  QVALUE Manual \url{http://faculty.washington.edu/~jstorey/qvalue/manual.pdf}
}
\author{John D. Storey \email{jstorey@u.washington.edu}}
\seealso{\code{\link{qplot}}, \code{\link{qwrite}}, \code{\link{qsummary}}, \code{\link{qvalue.gui}}}
\examples{
\dontrun{
p <- scan("pvalues.txt")
qobj <- qvalue(p)
qplot(qobj)
qwrite(qobj, filename="myresults.txt")

qobj <- qvalue(p, lambda=0.5, robust=TRUE)
qobj <- qvalue(p, fdr.level=0.05, pi0.method="bootstrap")
}
}
\keyword{misc}

\eof
\name{qwrite}
\alias{qwrite}
\title{Write the results of the q-value object qobj to a file}
\description{
  Write the results of the q-value object qobj to a file. 
}
\usage{
qwrite(qobj, filename = "my-qvalue-results.txt")
}
\arguments{
  \item{qobj}{Qvalue object}
  \item{filename}{Output filename (optional)}
}
\details{
  The output file lists the estimate of \eqn{\pi_0}{pi_0}, which is the
  proportion of true null hypotheses.  It also lists each p-value and
  corresponding q-value, one per line.  If an FDR significance level was 
  specified in the call to \code{\link{qvalue}}, the significance level 
  is printed below the estimate of \eqn{\pi_0}{pi_0}, and an indicator 
  of significance is included as a third column for each p-value and q-value.
}
\value{
  Nothing of interest.
}
\author{Alan Dabney \email{adabney@u.washington.edu} and John D. Storey \email{jstorey@u.washington.edu}}
\seealso{\code{\link{qvalue}}, \code{\link{qplot}}, \code{\link{qsummary}}, \code{\link{qvalue.gui}}}
\examples{
\dontrun{
p <- scan("pvalues.txt")
qobj <- qvalue(p)
qplot(qobj)
qwrite(qobj, filename="myresults.txt")
}
}
\keyword{misc}

\eof
