if ("package:prada" %in% search()) detach("package:prada")
library(prada)
options(warn=2, error=recover)

indir  <- "/mga/project/fctassays/expro/zzz-dorit-results-all"
outdir <- "/mga/project/fctassays/wolfgang/data/030909"

infiles  <- dir(indir, pattern = "xml$")
outfiles <- gsub("xml$", "rda", infiles)
## file name root (without the extension and the "magic number")
outfiles.root <- gsub("=.*rda$", "", outfiles)

## which ones are already done as .rda files:
existfiles <- dir(outdir, pattern="rda$")
existfiles.root <- gsub("=.*rda$", "", existfiles)

## check if there are multiple instances of same well/clone
## in indir or outdir
stopifnot(!any(duplicated(outfiles.root)))
stopifnot(!any(duplicated(existfiles.root)))
          
## Check whether .rda file already exists; Also, make sure that no .rda files with 
## the same well/clone Id, but different "magic numbers" are lurking around
isdone <- logical(length(outfiles))
for (i in 1:length(outfiles)) {
  exactmatch <- (outfiles[i] %in% existfiles)
  apprxmatch <- (outfiles.root[i] %in% existfiles.root)
  stopifnot(identical(exactmatch, apprxmatch))
  isdone[i] <- exactmatch
}

## Check whether there are .rda files that have no corresponding XML file
orphans <- setdiff(existfiles, outfiles)
if(length(orphans)>0)
  cat(".rda files without corresponding .xml file:", orphans, sep="\n")

todolist <- which(!isdone)
cat(length(infiles), "files in", indir, "of which", sum(isdone),
    "are already done.\nNow working on the remaining", length(todolist), "\n")

for (i in todolist) {
  dat = readWellXML(infiles[i], indir, verbose=TRUE)
  save(dat, file=file.path(outdir, outfiles[i]))
  gc()
}

