library(rimage)
library(pixmap)

indir <- "/mga/project/fctassays/expro/raw-images/dorit-cfp-done/dorit10_1b"
files <- dir(indir, pattern="tif$")

i <- 120

## ext = "jpg"
ext = "pgm"

tmpfil <- tempfile()
fileconv <- gsub(" ", "_", files[i])
fileconv <- gsub("tif$", ext, fileconv)
file.copy(file.path(indir, files[i]), tmpfil)

cmd <- switch(ext,
       jpg = paste("convert", tmpfil, "-quality 100", fileconv),
       pgm = paste ("convert", tmpfil, fileconv),
       stop(typ))

cat(cmd,"\n")
system(cmd)

x <- switch(ext,
       jpg = read.jpeg(fileconv),
       pgm  = read.pnm(fileconv))

graphics.off(); x11(); par(mai=rep(0,4))
rx <- range(x)
xsc <- (x-rx[1])/(rx[2]-rx[1])
plot(xsc)

x11()
hist(xsc, 100, col="blue")


