mapId <- function(x, withTag=TRUE) {
  stopifnot(is.character(x)) 
  e <- as.environment("package:prada")
  if(!exists("dkfzids2externalids", envir=e)) {
    assign("dkfzids2externalids",
           read.table("/home/whuber/fctassays/data/dkfzids2externalids.txt",
                      as.is=TRUE, header=TRUE, fill=TRUE), envir=e)
    stopifnot(ncol(get("dkfzids2externalids", envir=e))==2,
              is.character(get("dkfzids2externalids", envir=e)[, 1]),
              is.character(get("dkfzids2externalids", envir=e)[, 2]))
  }
  ix  <- tolower(x)
  if(withTag) {
    thedye <- getDye(x)
    ix  <- gsub("_[0-9]*e[0-9][cy][0-9]*$", "", ix)
    ix  <- gsub("_[ab][12xy]$", "", ix)
    ix  <- gsub("_[ab]$", "", ix)
    ix  <- gsub("gy$", "", ix)
    ix  <- gsub("^pd[yc]fp", "", ix)
    ix  <- gsub("^pd", "", ix)
    ix  <- gsub("^dhamy", "hamy", ix)
    ix  <- gsub("^cpd", "", ix)
  }
  mt  <- match(ix, tolower(get("dkfzids2externalids", envir=e)[,1]))
  hit <- !is.na(mt)
  if(!all(hit)) {
    msg <- paste("One or more elements of 'x' were not found in 'dkfzids2externalids[,1]':\n",
                  paste(x[!hit], ix[!hit], sep="\t", collapse="\n"), sep="")
    warning(msg)
  }
  repl <-get("dkfzids2externalids", envir=e)[mt[hit], 2]
  if(withTag) {
    repl <- paste(ifelse(thedye[hit]=="cfp", "CFP-", ""), repl,
                  ifelse(thedye[hit]=="yfp", "-YFP", ""), sep="")
  }
  rv <- x
  rv[hit] <- repl
  return(rv)
}
