create.tables = function(channel) {
  a=paste(
    "CREATE TABLE t_well_analysis",
    "(id              int identity (1,1),",
    "clusterid        int,",
    "plateid          int,",
    "version          nvarchar(8),",
    "platewellnr      int,",
    "noofcells        int,",
    "effect           nvarchar(4),",
    "logp             real,",
    "tfefficiency     real,",
    "fn_scatterplot   nvarchar(256),",
    "fn_boxplot       nvarchar(256))", sep="\n")

  sqlQuery(channel, "DROP TABLE t_well_analysis")
  sqlQuery(channel, a)
  
  a=paste(
    "CREATE TABLE t_plate_analysis",
    " (id             int identity,",
    "  platename      nvarchar(256),",
    "  version        int,",
    "  fn_effect      nvarchar(256),",
    "  fn_noofcells   nvarchar(256))", sep="\n")
  
  sqlQuery(channel, "DROP TABLE t_plate_analysis")
  sqlQuery(channel, a)
  
}

## the 3 tables that contain Urban's "incoming" data:
## ----------------------------------------------------
## LVData  : one row per "experiment" (plate?)
## Array   :      -dito-
##
## Cluster = main table with column names:
## ---------------------------------------
## ID - primary key
## IDNode, Name, NumElts  - ignore
## Experiment: name of the experiment  (26 levels)
## ArrayID : key into Array table
## Wells: filename with the brdU and transf intensities (in datadir)
## Wellnr: 1..96
## ExperimentID: unique identifier for each experiment/well
## ExDestinationCloneID: name of the clone (extracted from data file)
## transfefficiency: trans. efficiency for that well
## noofcells: no. cells
