\name{Simulation.pickgene}
\alias{Simulation.pickgene}
\title{Yi Lin's simulations for microarray analysis}
\usage{
}
\description{}
\details{}
\keyword{}
\seealso{\cite{multipickgene}}
\examples{
### Note: This uses old pickgene
#detail of the model (7-8). (first run does not include meas error \eta_i)
#par(mfrow=c(3,3))
t<-rnorm(10000,4,2)
changes1<-rep(0,10000)
changes1[1:500]<-rnorm(500)
t1<-t+changes1
changes2<-rep(0,10000)
changes2[1:500]<-rnorm(500)
t2<-t+changes2
s<-rnorm(10000,0,0.1)
cx<-3
cy<-2
t1<-t1+rnorm(10000,0,0.1)
t2<-t2+rnorm(10000,0,0.1)
x<-cx*exp(t1)
y<-cy*exp(t2)
#x<-cx*exp(t1)+rnorm(10000,0,50)
#y<-cy*exp(t2)+rnorm(10000,0,40)
xx<-qnorm(rank(x)/(10000+1))
yy<-qnorm(rank(y)/(10000+1))
#hist(x,breaks=100)
#hist(y,breaks=100)
#plot(x,y)
#hist(y[x<=0],breaks=20)
#hist(x[y<=0],breaks=20)
#plot(xx,yy)
topgenepick<-multipickgene( cbind(xx,yy),condi=0:1,geneID=1:10000, d=1,
                           npickgene=500)$pick[[1]]$probe
abchangesrank<-rank((-1)*abs(t1-t2))
count <- rep(NA,500)
for( i in 1:500 ) {
topipick <- topgenepick[1:i]
count[i] <- sum( abchangesrank[topipick] <= i ) 
}

## Figure 2
plot( 1:500, 1:500, type="n",
     xlab="Rank of 500 most changed genes by our procedure",
     ylab="Number similarly ranked by the 'optimal' procedure",
     xaxs="i", yaxs="i" )
lines( 1:500, count, type="s", lty=1, lwd=2 )
abline(0,1)
\dontrun{dev.print( hor=F, height=6.5, width=6.5, file="rank1.ps" )}

#again, but with the additive noise. (includes \eta_i)
par(mfrow=c(2,2))
t<-rnorm(10000,4,2)
changes1<-rep(0,10000)
changes1[1:500]<-rnorm(500)
t1<-t+changes1
changes2<-rep(0,10000)
changes2[1:500]<-rnorm(500)
t2<-t+changes2
s<-rnorm(10000,0,0.1)
cx<-3
cy<-2
t1<-t1+rnorm(10000,0,0.1)
t2<-t2+rnorm(10000,0,0.1)
### note that noise is very large here (50,40)
x<-cx*exp(t1)+rnorm(10000,0,50)
y<-cy*exp(t2)+rnorm(10000,0,40)
xx<-qnorm(rank(x)/(10000+1))
yy<-qnorm(rank(y)/(10000+1))
hist(x,breaks=100)
hist(y,breaks=100)
plot(x,y,cex=0.4)
#hist(y[x<=0],breaks=20)
#hist(x[y<=0],breaks=20)
plot(xx,yy,cex=0.4)
\dontrun{dev.print( hor=F, height=6.5, width=6.5, file="simudata.ps" )}

topgenepick<-multipickgene(cbind(xx,yy),condi=0:1,geneID=1:10000, d=1,
                           npickgene=500)$pick[[1]]$probe
abchangesrank<-rank((-1)*abs(t1-t2))
count <- rep(NA,500)
for( i in 1:500 ) {
topipick <- topgenepick[1:i]
count[i] <- sum( abchangesrank[topipick] <= i ) 
}
par(mfrow=c(1,1)) # figure 4
plot( 1:500, 1:500, type="n",
     xlab="Rank of 500 most changed genes by our procedure",
     ylab="Number similarly ranked by the 'optimal' procedure",
     xaxs="i", yaxs="i" )
lines( 1:500, count, type="s", lty=1, lwd=2 )
abline(0,1)
\dontrun{dev.print( hor=F, height=6.5, width=6.5, file="rank2.ps" )}

### Figure 5
genepick <- multipickgene( cbind(xx,yy), condi=0:1, geneID=1:10000, d=1)
\dontrun{dev.print( hor=F, height=6.5, width=6.5, file="simutest.ps" )$pick[[1]]$probe}
npick<-length(genepick$pickedgene)
genepick$pickedgene
npick
count[npick]
}

\eof
\name{em.ggb}
\alias{em.ggb}
\title{EM calculation for Gamma-Gamma-Bernoulli Model}
\description{
    The function plots contours for the odds that points on microarray show
    differential expression between two conditions (e.g. Cy3 and Cy5 dye
    channels on the same microarray).
}
\usage{
em.ggb(x, y, theta, start = c(2,1.2,2.7), pprior = 2,
  printit = FALSE, tol = 1e-9, offset = 0 )
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{first condition expression levels}
  \item{y}{second condition expression levels}
  \item{theta}{four parameters \code{a,a0,nu,p}}
  \item{start}{starting estimates for theta}
  \item{pprior}{Beta hyperparameter for prob \code{p} of differential
      expression} 
  \item{printit}{print iterations if TRUE}
  \item{tol}{parameter tolerance for convergence}
  \item{offset}{offset added to xx and yy before taking log (can help
      with negative adjusted values)}
}
\details{
Fit Gamma/Gamma/Bernoulli model (equal marginal distributions)
The model has spot intensities x ~ Gamma(a,b); y ~ Gamma(a,c).
The shape parameters b and c are ~ Gamma(a0,nu).
With probability p, b = c; otherwise b != c. All spots are assumed to be
independent.}
\value{
    Four parameter vector \code{theta} after convergence.
}
\references{MA Newton, CM Kendziorski, CS Richmond, FR Blattner and KW
    Tsui (2000) ``On differential variability of expression ratios:
    improving statistical inference about gene expression changes from
    microarray data,''
    \emph{J Computational Biology 00}: 000-000.
}
\author{Michael Newton}
\seealso{\code{\link{oddsplot}}}
\examples{
\dontrun{
em.ggb( x, y )
}}
\keyword{models}

\eof
\name{model.pickgene}
\alias{model.pickgene}
\title{Create Model Matrix for Orthogonal Contrasts}
\description{
    The function created a model matrix of orthogonal contrasts to be
    used by pickgene.
}
\usage{
model.pickgene( faclevel, facnames = <<see below>>,
  contrasts.fac = "contr.poly", collapse = "+", show = <<see below>>,
  renorm = 1, modelexpr = <<see below>>, contrasts.list = <<see below>> )
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{faclevel}{vector with number of levels for each factor}
  \item{facnames}{vector of factor names (default = "a","b",...)}
  \item{contrasts.fac}{vector of contrast types}
  \item{collapse}{"+" for additive model, "*" for full model with interactions}
  \item{show}{vector of contrast numbers to show (default is all)}
  \item{renorm}{vector to renormalize contrasts (e.g. use \code{sqrt(2)}
      to turn two-condition contrast into fold change)}
  \item{modelexpr}{model formula}
  \item{contrasts.list}{list of contrasts indexed by \index{facnames}}
}
\details{
Creates a model matrix data frame with first column having all 1's and
other columns having contrasts.
}
\value{
Result of call to model.matrix
}
\author{Brian Yandell}
\seealso{\code{\link{model.matrix}}}
\examples{
model.pickgene( c(2,3), c("sex","genotype"))
}
\keyword{utilities}

\eof
\name{oddsplot}
\alias{oddsplot}
\title{Odds Plot for Differential Microarray Expression}
\description{
    The function plots contours for the odds that points on microarray show
    differential expression between two conditions (e.g. Cy3 and Cy5 dye
    channels on the same microarray).
}
\usage{
oddsplot(x, y, theta, by.level = 10, rotate = FALSE, offset = 0,
  main="", xlab = <<see below>>, ylab = <<see below>>,
  col=<<see below>>, cex = <<see below>>,
  shrink = FALSE, lims = range( c( x, y )))
}
\arguments{
  \item{x}{first condition expression levels}
  \item{y}{second condition expression levels}
  \item{theta}{four parameters from \code{em.ggb}}
  \item{by.level}{odds plot contours increase by this level}
  \item{rotate}{rotate to average versus ratio if TRUE, otherwise plot
    conditions against each other}
  \item{offset}{offset for \code{log} transform}
  \item{main}{main title for plot}
  \item{xlab}{horizontal axis label (default if \code{Cy3} if
      \code{rotate} is FALSE, \code{Average Intensity} otherwise}
  \item{ylab}{vertical axis label (default if \code{Cy5} if
      \code{rotate} is FALSE, \code{Cy3 / Cy5} otherwise}
  \item{col}{color of points (if NULL, use black for non-changing
      points, blue for changing points)}
  \item{cex}{character expansion (use \code{rep(.25,2)} to have all points the
      same size)}
  \item{shrink}{use shrinkage on expression levels if TRUE (default is FALSE)}
  \item{lims}{limits for plot area}
}
\details{
Fit Gamma/Gamma/Bernoulli model (equal marginal distributions)
The model has spot intensities x ~ Gamma(a,b); y ~ Gamma(a,c).
The shape parameters b and c are ~ Gamma(a0,nu).
With probability p, b = c; otherwise b != c. All spots are assumed to be
independent.}
\value{
    Log odds for all points in original order.
}
\references{MA Newton, CM Kendziorski, CS Richmond, FR Blattner and KW
    Tsui (2000) ``On differential variability of expression ratios:
    improving statistical inference about gene expression changes from
    microarray data,''
    \emph{J Computational Biology 00}: 000-000.
}
\author{Michael Newton}
\seealso{\code{\link{em.ggb}}}
\examples{
\dontrun{
oddsplot( x, y )
}}
\keyword{hplot}
\keyword{models}

\eof
\name{pickgene-internal}
\alias{pickgene-internal}
\alias{adjustlevel}
\alias{chen.poly}
\alias{chipnorm}           
\alias{dencont}
\alias{dencum}
\alias{denlines}           
\alias{do.oddsplot}
\alias{fitgg}
\alias{gammaden}           
\alias{holms}
\alias{lod.ggb}
\alias{lod.plot}           
\alias{lodprobes}
\alias{loglik}
\alias{makecont}           
\alias{multipickgene}
\alias{nlminb}
\alias{nloglik}            
\alias{normal.richmond}
\alias{npdiag}
\alias{nploglik}           
\alias{orangene}
\alias{pickedchisq}
\alias{pickedhist}         
\alias{pickedpair}
\alias{pickedscore}
\alias{pickgene2}          
\alias{pickgene.poly}
\alias{pickgene.two}
\alias{pmarg}              
\alias{predrecur}
\alias{rangene}
\alias{rankgene}           
\alias{robustbox}
\alias{s.check0}
\alias{s.check1}           
\alias{s.check2}
\alias{shrinkplot}
\alias{sixden}             
\alias{s.marg}
\alias{toprankgene}
\alias{twoarray.norm}      
\alias{twoarray.plot}
\alias{twowayanovapickgene}
\title{Internal pickgene functions.}
\description{  These are generally not to be called by the user.
}
\usage{
adjustlevel(ntest, alpha)
chen.poly(cv, err)
chipnorm(xx, chip)
dencont(x, y, align, crit, xlim, ylim, dolog, byranks, dif,
                 ave, numlines, levels.z)
dencum(x, y, align, crit, xlim, ylim, dolog, byranks,
                 standardize, dif, ave, splineit, numlines, show,
                 levels.z)
denlines(x, y, align, crit, xlim, ylim, dolog, dif, ave,
                 numlines, offset)
do.oddsplot(data, main, theta, col, redo, conditions, identifier,
                 ...)
fitgg(xx, yy, start)
gammaden(x, a, b)
holms(x, alpha, cut)
lod.ggb(x, y, theta)
lod.plot(data, x, y, theta, filename, probe, xlab, ylab, ps,
                 col, lowlod, ...)
lodprobes(xx, yy, theta, lod, probes, col, lowlod, offset)
loglik(theta, xx, yy)
makecont(x, y, size, cex, levels)
multipickgene(...)
nlminb(start, objective, lower, xx, yy, zz, use.optim)
nloglik(theta, xx, yy)
normal.richmond(foo, channel)
npdiag(xx, yy, aa, a0, nu, pp)
nploglik(theta, xx, yy, zz)
orangene(n, center, spread, contamination, alpha, noise,
                 omega)
pickedchisq(pick, show, title, plotit, alpha)
pickedhist(pick, show, title, p1, plotit, rotate, mfrow, bw)
pickedpair(x, columns, description, probe, renorm, pick, main,
                 ...)
pickedscore(pick, description, show, alpha, xlab, ylab, main,
                 mfrow)
pickgene2(...)
pickgene.poly(x, condi, geneID, overalllevel, npickgene, d, ylabs,
                 contrastnames, ...)
pickgene.two(y, intensity, geneid, singlelevel, npickgene,
                 meanrank, xlab, ylab, main, plotit, col, negative,
                 ...)
pmarg(xx, yy, theta, nsupp)
predrecur(xx, theta, gridlim)
rangene(n, center, spread, contamination, alpha, noise,
                 omega)
rankgene(xx, yy, fits)
robustbox(y, x, nslice, xlab, ylab, shrink, crit, overalllevel,
                 cex, lwd, plotit)
s.check0(xx, yy, theta1, theta2, chip)
s.check1(xx, yy, theta, chip)
s.check2(foo, xa, ya, thetaa, xb, yb, thetab, spots)
shrinkplot(xx, yy, fits, chip)
sixden(x, y, align, crit, xlim, dolog, dif, ave)
s.marg(xx, yy, aa, a0, nuA, nu0, p)
toprankgene(yy, n)
twoarray.norm(foo, ..., conditions, reduce, identifier)
twoarray.plot(mydata, main, theta, conditions, identifier)
twowayanovapickgene(x, fac1level, fac2level, ...)
}
\author{ Brian S. Yandell, yandell@stat.wisc.edu }
\keyword{internal}

\eof
\name{pickgene}
\alias{pickgene}
\title{Plot and Pick Genes based on Differential Expression}
\description{
    The function picks plots the average intensity versus linear
    contrasts (currently linear, quadratic up to cubic) across
    experimental conditions. Critical line
    is determine according to Bonferroni-like multiple comparisons,
    allowing SD to vary with intensity.
}
\usage{
pickgene(data, geneID=1:nrow(x), overalllevel=0.05, npickgene=-1,
  marginal = FALSE, rankbased=TRUE, allrank=FALSE, meanrank=FALSE,
  offset=0, modelmatrix = <<see below>>, faclevel=ncol(x),
  facnames=<<see below>>, contrasts.fac="contr.poly",
  show=<<see below>>, main="", renorm=1, drop.negative=F,
  plotit, mfrow=<<see below>>, mfcol=<<see below>>, ylab, ... )
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{data matrix}
  \item{geneID}{gene identifier (default \code{1:nrow(x)})}
  \item{overalllevel}{overall significance level (default \code{0.05})}
  \item{npickgene}{number of genes to pick (default \code{-1} allows
      automatic selection)}
  \item{marginal}{additive model if TRUE, include interactions if FALSE}
  \item{rankbased}{use ranks if TRUE, log tranform if FALSE}
  \item{allrank}{rank all chips together if true, otherwise rank separately}
  \item{meanrank}{show mean abundance as rank if TRUE}
  \item{offset}{offset for log transform}
  \item{modelmatrix}{model matrix with first row all 1's and other rows
      corresponding to design contrasts; automatically created by call
      to \code{model.pickgene} if omitted}
  \item{faclevel}{number of factor levels for each factor}
  \item{facnames}{factor names}
  \item{contrasts.fac}{type of contrasts}
  \item{show}{vector of contrast numbers to show (default is all)}
  \item{main}{vector of main titles for plots (default is none)}
  \item{renorm}{vector to renormalize contrasts (e.g. use \code{sqrt(2)}
      to turn two-condition contrast into fold change)}
  \item{drop.negative}{drop negative values in log transform}
  \item{plotit}{plot if TRUE}
  \item{mfrow}{\code{par()} plot arrangement by rows (default up to 6
      per page; set to NULL to not change)}
  \item{mfcol}{\code{par()} plot arrangement by columns (default is NULL)}
  \item{ylab}{vertical axis labels}
  \item{...}{parameters for \code{robustscale}}
}
\details{
Infer genes that differentially express across conditions using a robust
data-driven method. Adjusted gene expression levels \code{A} are
replaced by \code{qnorm(rank(A))}, followed by \code{robustscale}
estimation of center and spread. Then Bonferroni-style gene by gene
tests are performed and displayed graphically.
}
\value{
    Data frame containing significant genes with the following information:
    \item{pick}{data frame with picked genes}
    \item{score}{data frame with center and spread for plotting}
    Each of these is a list with elements for each contrast.
    The \code{pick} data frame elements have the following information:
  \item{probe}{gene identifier}
  \item{average}{average gene intensity}
  \item{fold1}{positive fold change}
  \item{fold2}{negative fold change}
  \item{pvalue}{Bonferroni-corrected p-value}
  The \code{score} data frame elements have the following:
  \item{x}{mean expression level (antilog scale)}
  \item{y}{contrast (antilog scale)}
  \item{center}{center for contrast}
  \item{scale}{scale (spread) for contrast}
  \item{lower}{lower test limit}
  \item{upper}{upper test limit}
}
\references{Y Lin, BS Yandell and ST Nadler (2000)
    ``Robust Data-Driven Inference for Gene Expression Microarray
    Experiments,'' Technical Report, Department of Statistics, UW-Madison.
}
\author{Yi Lin and Brian Yandell}
\seealso{\code{\link{pickgene}}}
\examples{
\dontrun{
pickgene( data )
}
}
\keyword{hplot}
\keyword{models}


\eof
\name{robustscale}
\alias{robustscale}
\title{Robust Estimation of Median (center) and MAD (scale)}
\description{
    Smoothing spline estimate of median and mean absolute deviation (MAD).
}
\usage{
robustscale(y, x, nslice=400, corcenter=TRUE, decrease=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{y}{response}
  \item{x}{predictor}
  \item{nslice}{number of slices (should be "large")}
  \item{corcenter}{correct for center}
  \item{decrease}{force MAD to decrease with \code{x}}
}
\details{
    This divides data into roughly many \code{nslice} slices and computes
    median and mean absolute deviation (\code{mad}) for each slice. These are
    then smoothed using \code{smooth.spline}.
}
\value{
    Data frame containing significant genes with the following information:
  \item{center}{estimate of center median}
  \item{scale}{MAD estimate of scale}
  \item{x}{ordered \code{x} values for plotting}
  \item{y}{\code{y} sorted by \code{x}}
}
\author{Yi Lin}
\seealso{\code{\link{mad}}, \code{\link{smooth.spline}}}
\examples{
\dontrun{
robustscale(y,x)
}
}
\keyword{robust}
\keyword{smooth}

\eof
