\name{AAAlignment-class}
\docType{class}
\alias{AAAlignment-class}
\alias{show,AAAlignment-method}
\alias{summary,AAAlignment-method}

\title{"AAAlignment" result of pairwise sequence alignment.}
\description{Result of a pairwise sequence alignment.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("AAAlignment", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{info1}:}{Object of class \code{"character"} :  name of
      first sequence. }
    \item{\code{info2}:}{Object of class \code{"character"} : name of
      second sequence }
    \item{\code{selfs1}:}{Object of class \code{"numeric"} : selfscore
      of sequence 1 }
    \item{\code{selfs2}:}{Object of class \code{"numeric"} : selfscore
      of sequence 2}
    \item{\code{score}:}{Object of class \code{"numeric"} : Smith
      Watermann score of alignment. }
    \item{\code{identity}:}{Object of class \code{"numeric"} : nr of
      identitacal AA in the alignment.}
    \item{\code{alignsimilarity}:}{Object of class \code{"numeric"} : nr
    of similarities.}
    \item{\code{lch1}:}{Object of class \code{"numeric"} : length of
      sequence 1.}
    \item{\code{lch2}:}{Object of class \code{"numeric"} : length of
      sequence 2 }
    \item{\code{alig1}:}{Object of class \code{"character"} : alignment string }
    \item{\code{alig2}:}{Object of class \code{"character"} : alignment string }
    \item{\code{beautify}:}{Object of class \code{"character"} :
      internal }
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "AAAlignment")}: show }
    \item{summary}{\code{signature(object = "AAAlignment")}: summary }
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{Witold E. Wolski}
%\note{ ~~further notes~~ }

\seealso{
  \code{\link{salign-methods}} 
}
\examples{
data(EBLOSUM62)
seq1<-new("AASequence","MEDQVGFGFRPNDEEL",info="seq1")
seq2<-AASequence("seq1","VAISEVNICSYDPWNL")
res<-salign(seq1,seq2,EBLOSUM62,delta=-10,gapext=-1,alignment="global")
class(res)
summary(res)
}
\keyword{classes}

\eof
\name{AAAlphabet-class}
\docType{class}
\alias{AAAlphabet-class}
\alias{levels,AAAlphabet-method}
\alias{show,AAAlphabet-method}

\title{Class "AAAlphabet" Amino Acid Alphabet }
\description{Chars alowed in a protein sequence. It is used by the
  method \code{initialize} of class AASequence to check if the chars in
  the sequence are known (recognized by the package).}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("AAAlphabet", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{.Data}:}{Object of class \code{"character"} Chars
      allowed in protein sequences}
    \item{\code{info}:}{Object of class \code{"character"} "AAAlphabet"}
  }
}
\section{Extends}{
Class \code{"character"}, directly.
}
\section{Methods}{
  \describe{
    \item{levels}{\code{signature(x = "AAAlphabet")}:  internal}
    \item{show}{\code{signature(object = "AAAlphabet")}:  show}
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{ Witold E. Wolski }
%\note{ ~~further notes~~ }

\seealso{
}
\examples{
new("AAAlphabet")
}
\keyword{classes}

\eof
\name{AASequence-class}
\docType{class}
\alias{AASequence-class}
\alias{frequency,AASequence-method}
\alias{initialize,AASequence-method}
\alias{selfalign}
%\alias{readFasta,AASequence-method}
%\alias{salign,AASequenceList,AASequence-method}
%\alias{salign,AASequence,AASequenceList-method}
%\alias{salign,AASequence,AASequence-method}
\alias{selfalign,AASequence,Submatrix-method}
\alias{show,AASequence-method}
%\alias{testalign,AASequence,AASequence-method}

\title{"AASequence" Object representation of a protein Sequence}
\description{Object representation of a protein Sequence}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("AASequence", sequence, info, alphabet)}.
or by call to \code{AASequence("PROTINSEQUENCEHERE",info="my prot seq")}
}
\section{Slots}{
  \describe{
    \item{\code{.Data}:}{Object of class \code{"character"} the sequence}
    \item{\code{info}:}{Object of class \code{"character"} the info }
  }
}
\section{Extends}{
Class \code{"character"}, directly.
}
\section{Methods}{
  \describe{
    \item{frequency}{\code{signature(x = "AASequence")}: returns the
      amino acid frequencies }
    \item{initialize}{\code{signature(.Object = "AASequence")}: internal }
    \item{readFasta}{\code{signature(object = "AASequence")}: read FASTA
    file format}
    \item{salign}{\code{signature(obj1 = "AASequenceList", obj2 = "AASequence")}: see: \code{\link{salign-methods}}}
    \item{salign}{\code{signature(obj1 = "AASequence", obj2 = "AASequenceList")}: see: \code{\link{salign-methods}}}
    \item{salign}{\code{signature(obj1 = "AASequence", obj2 = "AASequence")}: see: \code{\link{salign-methods}}}
    \item{selfalign}{\code{signature(object = "AASequence", sub =
	"Submatrix")}: Computes Smith-Waterman score of the alignment of
    the sequence with itself.}
    \item{show}{\code{signature(object = "AASequence")}: }
    \item{testalign}{\code{signature(obj1 = "AASequence", obj2 =
	"AASequence")}: internal, see: \code{\link{testalign-methods}}}
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{Witold E. Wolski}
%\note{ ~~further notes~~ }

\seealso{
\code{\link{salign-methods}},\code{\link{readFasta-methods}}
}
\examples{
seq1<-new("AASequence","MEDQVGFGFRPNDEEL",info="seq1")
seq2<-AASequence("seq2","VAISEVNICSY")
}
\keyword{classes}

\eof
\name{AASequence}
\alias{AASequence}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{AASequence constructor}
\description{
  AASequence constructor
}
\usage{
AASequence(info, sequence)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{info}{info character}
  \item{sequence}{Protein sequence character}
}
\details{
}
\value{
  Returns object of class \code{AAsequence}
}
%\references{ ~put references to the literature/web site here ~ }
\author{Witold E. Wolski}
%\note{ ~~further notes~~ }
\seealso{\code{\link{AASequence-class}}}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.
AASequence("my seq","MEDQVGFGFR")
## The function is currently defined as
function(info,sequence)
  {
    if(!missing(info) && !missing(sequence))
      new("AASequence",sequence,info)
    else if(!missing(sequence))
      new("AASequence",sequence)
    else
      new("AASequnece")
  }
}
\keyword{misc}% at least one, from doc/KEYWORDS

\eof
\name{AASequenceList-class}
\docType{class}
\alias{AASequenceList-class}
\alias{[,AASequenceList-method}
\alias{[[<-,AASequenceList-method}
\alias{[<-,AASequenceList-method}
%\alias{readFasta,AASequenceList-method}
%\alias{salign,AASequenceList,NULL-method}
%\alias{salign,AASequenceList,AASequence-method}
%\alias{salign,AASequence,AASequenceList-method}

\title{Class "AASequenceList" - Container}
\description{Container for objects of calss AASequence. The AASequences
  in the list can be accessed and manipulated like normal list elements.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("AASequenceList", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{.Data}:}{Object of class \code{"list"} : list of
      AASequence objects.}
    \item{\code{info}:}{Object of class \code{"character"} : info character}
  }
}
\section{Extends}{
Class \code{"list"}, directly.
}
\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "AASequenceList")}: create subset AASequenceList }
    \item{[[<-}{\code{signature(x = "AASequenceList")}: assign AASequence}
    \item{[<-}{\code{signature(x = "AASequenceList")}: replace subset of
    AASequenceList}
    \item{readFasta}{\code{signature(object = "AASequenceList")}:
      read file in FASTA format. }
    \item{salign}{\code{signature(obj1 = "AASequenceList", obj2 =
	"NULL")}: see: \code{salign}}
    \item{salign}{\code{signature(obj1 = "AASequenceList", obj2 = "AASequence")}:  see: \code{salign} }
    \item{salign}{\code{signature(obj1 = "AASequence", obj2 = "AASequenceList")}:  see: \code{salign} }
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{ Wolski E. Witold }
%\note{ ~~further notes~~ }

\seealso{
  \code{\link{salign-methods}}, or \code{\link{readFasta-methods}}
}
\examples{
data(sequlist)
sequlist[1:2]
sequlist[[1]]
sequlist[1:2]<-sequlist[3:4]
}
\keyword{classes}

\eof
\name{EPAM110}
\alias{EBLOSUM40}
\alias{EPAM300}
\alias{EPAM110}
\alias{EBLOSUM30}
\alias{EBLOSUM35}
\alias{EBLOSUM40
\alias{EBLOSUM45}
\alias{EBLOSUM50}
\alias{EBLOSUM55}
\alias{EBLOSUM60}
\alias{EBLOSUM62}
\alias{EBLOSUM65}
\alias{EBLOSUM70}
\alias{EBLOSUM75}
\alias{EBLOSUM80}
\alias{EBLOSUM85}
\alias{EBLOSUM90}
\alias{EPAM10}
\alias{EPAM100}
\alias{EPAM110}
\alias{EPAM120}
\alias{EPAM130}
\alias{EPAM140}
\alias{EPAM150}
\alias{EPAM160}
\alias{EPAM170}
\alias{EPAM180}
\alias{EPAM190}
\alias{EPAM20}
\alias{EPAM200}
\alias{EPAM210}
\alias{EPAM220}
\alias{EPAM230}
\alias{EPAM240}
\alias{EPAM250}
\alias{EPAM260}
\alias{EPAM270}
\alias{EPAM280}
\alias{EPAM290}
\alias{EPAM30}
\alias{PAM300}
\alias{EPAM310}
\alias{EPAM320}
\alias{EPAM330}
\alias{EPAM340}
\alias{EPAM350}
\alias{EPAM360}
\alias{EPAM370}
\alias{EPAM380}
\alias{EPAM390}
\alias{EPAM40}
\alias{EPAM400}
\alias{EPAM410}
\alias{EPAM420}
\alias{EPAM430}
\alias{EPAM440}
\alias{EPAM450}
\alias{EPAM460}
\alias{EPAM470}
\alias{EPAM480}
\alias{EPAM490}
\alias{EPAM50}
\alias{EPAM500}
\alias{EPAM60}
\alias{EPAM70}
\alias{EPAM80}
\alias{EPAM90}

\docType{data}
\title{Amino Acid Substitution matrices}
\description{

}
\usage{data(EPAM110)}
\format{}
\details{
Amino Acid Substitution Matrices.
}
\source{
\url{http://www.hgmp.mrc.ac.uk/Software/EMBOSS/}
}
\references{
}
\examples{
data(EPAM110)
}
\keyword{datasets}

\eof
\name{Submatrix-class}
\docType{class}
\alias{Submatrix}
\alias{Submatrix-class}
%\alias{selfalign,AASequence,Submatrix-method}
\alias{show,Submatrix-method}
\alias{subFromEmboss,Submatrix,character-method}
\alias{subFromEmboss}

\title{Class "Submatrix" Substitution Matrix}
\description{Amino Acid Substitution Matrices}
\section{Objects from the Class}{
\code{new("Submatrix", ...)}.
or \code{data(EPAM100}}
}
\section{Slots}{
  \describe{
    \item{\code{.Data}:}{Object of class \code{"matrix"} substitution matrix }
    \item{\code{copyright}:}{Object of class \code{"character"} GNU GPL2 }
    \item{\code{info}:}{Object of class \code{"character"} name}
    \item{\code{head}:}{Object of class \code{"character"} description}
    \item{\code{alphabet}:}{Object of class \code{"character"} alphabet}
  }
}
\section{Extends}{
Class \code{"matrix"}, directly.
}
\section{Methods}{
  \describe{
    \item{selfalign}{\code{signature(object = "AASequence", sub =
	"Submatrix")}: compute teh score for aligning the sequence with itself }
    \item{show}{\code{signature(object = "Submatrix")}: show}
    \item{subFromEmboss}{\code{signature(object = "Submatrix", path =
	"character")}: read Substitution matrices from EMBOSS package }
  }
}
\references{http://www.hgmp.mrc.ac.uk/Software/EMBOSS/overview.html}
\author{ Witold Eryk Wolski }
\keyword{classes}

\eof
\name{listdist-methods}
\docType{methods}
\alias{listdist}
\alias{listdist-methods}
\alias{listdist,list-method}
\title{Compute distance matrix from a list}
\section{Methods}{\describe{

\item{object = "list"}{Compute distance matrix from a list.}
}}
\description{
  Compute distance matrix from list. Internal use.
}
\arguments{
  \item{object}{object of class \code{list}}
  \item{FUN}{Function to apply to list entries}
  \item{diag}{default \code{FALSE}}
}
\value{
  Returns an object of class \code{dist}.
}
\author{Witold E. Wolski}
\keyword{methods}

\eof
\name{readFasta-methods}
\docType{methods}
\alias{seqgrep}
\alias{infogrep}
\alias{readFasta}
\alias{readFasta-methods}
\alias{readFasta,AASequence-method}
\alias{readFasta,AASequenceList-method}
\title{reader for databases in Fasta file format.}
\section{Methods}{\describe{
\item{object = "AASequenceList"}{Read sequence database in FASTA format.}
}}
\description{
  Reads file in FASTA format. An sequence entry in the fasta dabase
  consists of a header line starting with the \">\" sign which contains
  the id of the sequence. It is followed by several lines of the protein
  sequence. Because the header line may vary the user can specify a
  function which will extract (grep) the id.
\code{
  infogrep <- function(x)
  {
    return(sub("^>([a-zA-Z0-9]+) .+","\\1",x,perl=TRUE))
  }
  }
}
\arguments{
  \item{object}{either \code{AASequence} or \code{AASequenceList}}
  \item{file}{Path to the file}
  \item{grepinfo}{Function which extracts the id from the fasta
    description line.}
  \item{grepseq}{Function to pre-process the sequence.}
}
\value{
  Returns an object of class \code{AASequenceList}.
}
\seealso{\code{\link{AASequenceList-class}}}
\author{Witold E. Wolski}
\examples{
mySequlist <- new("AASequenceList",info="my sequence list")
#mySequlist<-readFasta(mySequlist,"ex.fasta",grepinfo=infogrep,grepseq=seqgrep)
}
\keyword{methods}


\eof
\name{salign-methods}
\docType{methods}
\alias{salign}
\alias{salign-methods}
\alias{salign,AASequenceList,NULL-method}
\alias{salign,AASequenceList,AASequence-method}
\alias{salign,AASequence,AASequenceList-method}
\alias{salign,AASequence,AASequence-method}
\title{Optimal pairwise alignment of two protein sequences.}
\section{Methods}{\describe{
\item{obj1 = "AASequenceList", obj2 = "NULL"}{Compute distance matrix.}
\item{obj1 = "AASequenceList", obj2 = "AASequence"}{Compute scores.}
\item{obj1 = "AASequence", obj2 = "AASequenceList"}{Compute scores.}
\item{obj1 = "AASequence", obj2 = "AASequence"}{Compute alignment.}
}}
\description{
  Computes optimal pairwise alignment of 2 protein sequences.
}
\arguments{
  \item{obj1}{see above}
  \item{obj2}{see above}
  \item{sub}{Substitution matrix}
  \item{delta}{gap opening penalty}
  \item{gapext}{gap extension penalty}
  \item{alignment}{type of alignment: c("global","local","overlap")}
  \item{scoring}{type of scoring, identity, similarity, score, scoreN,
    AAAlignemnt, pozitive}
}
\value{
  For two objects of class \code{AASequence} returns an object of class
  \code{AAAlignment}.  Otherwise it returns a score. If used with \code{NULL} as second parameter it
  returns a distance matrix. The scores than are transformed into distances. For details see the vignette.
}
\references{Hilary S Booth, John H Maindonald, Ole M Nielsen, Susan R
  Wilson "Normalizing sequence alignment scores for composition bias"
  Recomb 2003 - Berlin}
\author{Witold E. Wolski}
\examples{
data(sequlist)
data(EPAM110)
#example of alignment
res<-salign(sequlist[[1]],sequlist[[2]],EPAM110,delta=-4,gapext=-1,alignment="global")
summary(res)
#scoring a sequence against a list of sequences.
res <- salign( sequlist[1:10] , sequlist[[1]], EPAM110 , delta = -4,gapext = -1,alignment = "local", scoring = "score")
hist(res)
#computing a distance matrix.
res<-salign(sequlist[1:10],NULL,EPAM110,delta=-10,gapext=-1,alignment="overlap",scoring="pozitive")
hist(as.numeric(res))
}
\keyword{methods}


\eof
\name{sequlist}
\alias{sequlist}
\docType{data}
\title{AASequenceList with 66 entries.}
\description{
  66 arbitrary entries from the \emph{ arabidopsis thaliana} sequence database (arabi\_all\_proteins\_v110402.fasta). 
}
\usage{data(sequlist)}
\format{
}
\details{
}
\source{
  \url{}
}
\references{
}
\examples{
data(sequlist)
## maybe str(sequlist) ; plot(sequlist) ...
length(sequlist)
}
\keyword{datasets}

\eof
\name{testalign-methods}
\docType{methods}
\alias{testalign}
\alias{testalign-methods}
\alias{testalign,AASequence,AASequence-method}
\title{Scoring of optimal alingments.}
\section{Methods}{\describe{
\item{obj1 = "AASequence", obj2 = "AASequence"}{Computes obtimal
  alignment of two sequences and returns score.}
}}
\description{
  Computes optimal pairwise alignment of 2 protein sequences. For
  internal use.
}
\arguments{
  \item{obj1}{see above}
  \item{obj2}{see above}
  \item{sub}{Substitution matrix}
  \item{delta}{gap opening penalty}
  \item{gapext}{gap extension penalty}
  \item{alignment}{type of alignment: c("global","local","overlap")}
  \item{scoring}{type of scoring, identity, similarity, score, scoreN, pozitive}
}
\value{
  For two objects of class \code{AASequence} returns an object of class
  \code{AAAlignment}.\\
  Otherwise it returns a score. If used with NULL as second parameter it
  returns a distance matrix. The scores are transformed into
  distances. For details see the vignette.
}
\author{Witold E. Wolski}
\keyword{methods}

\eof
