\name{Internal functions}
\alias{read.fname}

\title{Internal marrayInput functions}
 
\description{Internal marrayInput functions}
 
\details{These are not to be called by the user.}

\keyword{methods}

\eof
\name{read.Galfile}
\alias{read.Galfile}

\title{Reading GenePix Gal file}
\description{
  Reading a standard Gal file containing gene information.
}
\usage{
read.Galfile(galfile, path = ".", info.id = c("Name", "ID"),
labels = "ID", notes = galfile, sep = "\t", skip = NULL, quote = "\"",
fill=TRUE, ncolumns=4, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{galfile}{a character string representing the Gal file.}
  \item{path}{a character string representing the data directory. By
    default this is set to the current working directory ("."). }
  \item{info.id}{the column numbers in `fname' that contain the required
    information.}
  \item{labels}{the column number in \code{fname} which contains the names that the user would like to use to label spots or arrays (e.g. for default titles in \code{\link{maPlot}}.}
  \item{notes}{object of class character, vector of explanatory text}
  \item{sep}{the field separator character.  Values on each line of the
    file are separated by this character. The
    default is to read a tab delimited file.}
  \item{skip}{the number of lines of the data file to skip before
    beginning to read data.}
  \item{quote}{the set of quoting characters. By default, this is disable
    by setting `quote=""'.}
  \item{fill}{logical: if `TRUE', `scan' will implicitly add empty fields
    to any lines with fewer fields than implied by `what'.}
  \item{ncolumns}{an integer representing the number of columns of
    sub-array (print-tips) on a slides.}
  \item{\dots}{further arguments to \code{\link{scan}}.}
}

\value{
  \item{gnames}{An object of class \code{\link{marrayInfo}}.}
  \item{layout}{An object of class \code{\link{marrayLayout}}.}
}

\author{Yee Hwa (Jean) Yang}

\seealso{\code{\link{read.marrayInfo}}, \code{\link{read.marrayLayout}}}

\examples{
library(marrayInput)
datadir <- system.file("data", package="marrayInput")
try <- read.Galfile(galfile="fish.gal", path=datadir)
names(try)
try$layout
try$gnames
}

\keyword{file}% at least one, from doc/KEYWORDS

\eof
\name{read.marrayInfo}
\alias{read.marrayInfo}
\alias{widget.marrayInfo}

\title{Create objects of class marrayInfo}
\description{
  This function creates objects of class \code{\link{marrayInfo}}. The \code{\link{marrayInfo}} class is used to store
  information regarding the target mRNA samples co-hybridized on the arrays or
  the spotted probe sequences (e.g. data frame of gene names, annotations, and other identifiers).
}
\usage{
read.marrayInfo(fname, info.id=NULL, labels=NULL, notes=fname, sep="\t",skip=0, quote="\"", ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{fname}{the name of the file that stores information on target samples or probe sequences. This is usually a file obtained from a database.}
  \item{info.id}{the column numbers in \code{fname} that contain the
    required information.}
  \item{labels}{the column number in \code{fname} which contains the names that the user would like to use to label spots or arrays (e.g. for default titles in \code{\link{maPlot}}.}
  \item{notes}{object of class character, vector of explanatory text}
    \item{sep}{the field separator character.  Values on each line of the
    file are separated by this character. The
    default is to read a tab delimited file.}
\item{skip}{the number of lines of the data file to skip before
  beginning to read data.}
\item{quote}{the set of quoting characters. By default, this is disable
  by setting `quote="\""'.}
  \item{\dots}{further arguments to \code{\link{scan}}.}
}
\details{

}
\value{
  An object of class \code{\link{marrayInfo}}.
}
\references{http://www.bioconductor.org/}
\author{Jean Yang, \email{yeehwa@stat.berkeley.edu}}

\examples{
datadir <- system.file("data", package="marrayInput")

## Reading target sample information
swirl.samples <- read.marrayInfo(file.path(datadir, "SwirlSample.txt"))

## Reading probe sequence information
swirl.gnames <- read.marrayInfo(file.path(datadir, "fish.gal"),
                                info.id=4:5, labels=5, skip=21)
}

\keyword{file}% at least one, from doc/KEYWORDS
\keyword{connection}

\eof
\name{read.marrayLayout}
\alias{read.marrayLayout}
\alias{widget.marrayLayout}

\title{Create objects of class marrayLayout}
\description{
  This function creates objects of class \code{\link{marrayLayout}} to store layout parameters for  two-color cDNA microarrays.
}
\usage{
read.marrayLayoutfname = NULL, ngr, ngc, nsr, nsc, pl.col = NULL,
                 ctl.col = NULL, sub.col = NULL, notes = fname, skip,
                 sep = "\t", quote = "\"", ...)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{fname}{the name of the file that stores plate and control
    information. This is usually a file obtained from a database.}
  \item{ngr}{the number of rows of grids per image.}
  \item{ngc}{the number of columns of grids per image.}
  \item{nsr}{the number of rows of spots per grid.}
  \item{nsc}{the number of columns of spots per grid.}
  \item{pl.col}{the column number in \code{fname} that contains plate information.}
  \item{ctl.col}{the column number in \code{fname} that contains control information.}
    \item{sub.col}{the column number in \code{fname} that contains full ID information.}
  \item{notes}{object of class character, vector of explanatory text.}
  \item{skip}{the number of lines of the data file to skip before
    beginning to read data.} 
  \item{sep}{the field separator character.  Values on each line of the
    file are separated by this character. The
    default is to read a tab delimited file.}
  \item{quote}{the set of quoting characters. By default, this is disable
  by setting `quote="\""'.}
  \item{\dots}{further arguments to \code{\link{scan}}.}
}

\details{}
\value{
  An object of class \code{\link{marrayLayout}}.
}

\references{http://www.bioconductor.org/ }
\author{Jean Yang \email{yeehwa@stat.berkeley.edu}}
\note{}

\examples{
datadir <- system.file("data", package="marrayInput")

### Reading in control information from file
skip <-  grep("Row", readLines(file.path(datadir,"fish.gal"), n=100)) - 1
swirl.layout <- read.marrayLayout(fname=file.path(datadir,"fish.gal"), ngr=4, ngc=4,
nsr=22, nsc=24, ctl.col=4, skip=skip)

### Setting control information.
swirl.gnames <- read.marrayInfo(file.path(datadir,"fish.gal"), info.id=4:5, labels=5, skip=21)
x <-  maInfo(swirl.gnames)[,1]
y <- rep(0, maNspots(swirl.layout))
y[x == "control"] <- 1
slot(swirl.layout, "maControls") <- as.factor(y)
}

\keyword{file}% at least one, from doc/KEYWORDS
\keyword{connection}

\eof
\name{read.marrayRaw}
\alias{read.marrayRaw}
\alias{read.Spot}
\alias{read.GenePix}
\alias{read.SMD}
\alias{widget.marrayRaw}

\title{Create objects of class "marrayRaw"}
\description{
  This function reads in cDNA microarray data from a directory and creates objects of
  class \code{"\link{marrayRaw}"} from spot quantification data files obtained from image analysis software or databases.
}

\usage{
read.marrayRaw(fnames, path=".", name.Gf, name.Gb=NULL, name.Rf,
name.Rb=NULL,name.W=NULL, layout=NULL, gnames=NULL, targets=NULL,
notes=NULL, skip=0, sep="	", quote="\"",...)

read.GenePix(fnames = NULL, path = ".", name.Gf = "F532 Mean",
name.Gb ="B532 Median", name.Rf = "F635 Mean", name.Rb = "B635 Median",
name.W =NULL, layout = NULL, gnames = NULL, targets = NULL,
notes = NULL, skip=0, sep = "	", quote = "\"", ...)

read.SMDfnames = NULL, path = ".", name.Gf = "CH1I_MEAN",
                 name.Gb = "CH1B_MEDIAN", name.Rf = "CH2I_MEAN",
                 name.Rb = "CH2B_MEDIAN", name.W = NULL, layout =
                 NULL, gnames = NULL, targets = NULL, notes = NULL,
                 skip = 0, sep = "\t", quote = "", ...)

read.Spot(fnames = NULL, path = ".", name.Gf = "Gmean",
name.Gb = "morphG", name.Rf = "Rmean", name.Rb = "morphR",
name.W = NULL, layout = NULL, gnames = NULL, targets = NULL,
notes = NULL, skip = 0, sep = "	", quote = "\"", ...)

widget.marrayRawext = c("spot", "xls", "gpr"), skip = 0, sep = "\t",
                 quote = "", ...)
}

\arguments{
  \item{fnames}{a vector of character strings containing the file names of
    each spot quantification data file.  These typically end in \code{.spot}
    for the software \code{Spot} or \code{.gpr} for the software \code{GenePix}.}
  \item{path}{a character string representing the data directory. By
    default this is set to the current working directory (".").  In the
    case where \code{fnames} contains the full path name, path should be set
    to NULL.}
  \item{name.Gf}{character string for the column header for green foreground intensities.}
  \item{name.Gb}{character string for the column header for green background intensities.}
  \item{name.Rf}{character string for the column header for red foreground intensities.}
  \item{name.Rb}{character string for the column header for red background intensities.}
  \item{name.W}{character string for the column header for spot quality weights.}
  \item{layout}{object of class \code{"\link{marrayLayout}"}, containing microarray layout parameters.}
  \item{gnames}{object of class \code{"\link{marrayInfo}"} containing probe sequence information.}
  \item{targets}{object of class \code{"\link{marrayInfo}"} containing target sample information.}
  \item{notes}{object of class \code{"character"}, vector of explanatory text.}
  \item{skip}{the number of lines of the data file to skip before beginning to read in data.}
  \item{sep}{the field separator character.  Values on each line of the
    file are separated by this character. The
    default is to read a tab delimited file.}
  \item{quote}{the set of quoting characters. By default, this is
    disabled by setting \code{quote="\""}.}
  \item{\dots}{further arguments to \code{\link{scan}}.}
}
\details{
  
}
\value{
  An object of class \code{"\link{marrayRaw}"}.
}
\references{\url{http://www.bioconductor.org/}.}
\author{Jean Yang, \email{yeehwa@stat.berkeley.edu}}

\seealso{\code{\link{scan}}, \code{\link{read.marrayLayout}},
  \code{\link{read.marrayInfo}} }

\examples{
datadir <- system.file("data", package="marrayInput")

skip <-  grep("Row", readLines(file.path(datadir,"fish.gal"), n=100)) - 1

swirl.layout <- read.marrayLayout(ngr=4, ngc=4, nsr=22, nsc=24)

swirl.targets <- read.marrayInfo(file.path(datadir, "SwirlSample.txt"))

swirl.gnames <- read.marrayInfo(file.path(datadir, "fish.gal"),
                                info.id=4:5, labels=5, skip=skip)

x <-  maInfo(swirl.gnames)[,1]
y <- rep(0, maNspots(swirl.layout))
y[x == "control"] <- 1
slot(swirl.layout, "maControls") <- as.factor(y)

fnames <- dir(path=datadir,pattern=paste("*", "spot", sep="\."))
swirl<- read.Spot(fnames, path=datadir,
                       layout = swirl.layout,
                       gnames = swirl.gnames,
                       targets = swirl.targets)

}

\keyword{file}% at least one, from doc/KEYWORDS

\eof
\name{swirl}
\alias{swirl}
\alias{swirl.1.spot}
\alias{swirl.2.spot}
\alias{swirl.3.spot}
\alias{swirl.4.spot}
\alias{fish.gal}
\alias{SwirlSample.txt}
\alias{SwirlSample}


\title{Gene expression data from Swirl zebrafish cDNA microarray experiment}

\description{
  The \code{swirlRaw} dataset consists of an object \code{swirl}
  of class \code{"\link{marrayRaw}"}, which represents
  pre-normalization intensity data for a batch of cDNA microarrays.  \cr

This experiment was carried out
using zebrafish as a model organism to study early development in
vertebrates. Swirl is a point mutant in the BMP2 gene that affects the
dorsal/ventral body axis. Ventral fates such as blood are reduced, whereas
dorsal structures such as somites and notochord are expanded. A goal of
the Swirl experiment is to identify genes with altered expression in
the swirl mutant compared to wild-type zebrafish. Two sets of dye-swap experiments were performed, for a total of four replicate hybridizations. For
each of these hybridizations, target cDNA from the swirl mutant was labeled using
one of the Cy3 or Cy5 dyes and the target cDNA wild-type mutant was labeled using
the other dye. Target cDNA was hybridized to microarrays containing
8,448 cDNA probes, including 768 controls spots (e.g. negative, positive,
and normalization controls spots). Microarrays were printed using \eqn{4 \times 4} print-tips and are thus partitioned into a \eqn{4 \times 4} grid matrix. Each grid consists of a \eqn{22
\times 24} spot matrix that was printed with a single print-tip. Here, spot row and plate coordinates should coincide, as each row of spots corresponds to probe sequences from the same 384 well-plate.\cr


Each of the four hybridizations produced
a pair of 16-bit images, which were processed using the image analysis software package \code{Spot}. Raw images of the Cy3 and Cy5 fluorescence intensities for all fourhybridizations are available at \url{http://fgl.lsa.berkeley.edu/Swirl/index.html}.the dataset includes four output files
\code{swirl.1.spot},
\code{swirl.2.spot},
\code{swirl.3.spot}, and
\code{swirl.4.spot}
from the \code{Spot} package.  Each of these files contains
8,448 rows and 30 columns; rows correspond to spots and columns to
different statistics from the \code{Spot} image analysis output. The file
\code{fish.gal} is a gal file generated by the \code{GenePix} program; it contains information on individual probe sequences, such as gene names, spot ID, spot coordinates.  Hybridization information for the mutant and wild-type target samples is stored in \code{SwirlSample.txt}.


}

\usage{data(swirl)}

\source{These data were provided by Katrin Wuennenberg-Stapleton from the Ngai Lab at UC Berkeley. The swirl embryos for this experiment were provided by David Kimelman and David
Raible at the University of Washington.}

\keyword{datasets}



\eof
\name{write.list}
\alias{write.list}

\title{Data Output}

\description{
  Writes information from a list into a text file.
}

\usage{
write.list(x, filename = "data", append = FALSE, closefile = TRUE, outfile)
}
\arguments{
  \item{x}{the list object to be written.}
  \item{filename}{a character string representing the file name.}
  \item{append}{logical; if true, the data \code{x} is appended to file
    \code{filename}.}
  \item{closefile}{logical indicating if the file connection should be closed.}
  \item{outfile}{file name or connections.}
}
\details{
  This function may be called recursively if there exists list structure
  within a list.
}

\author{Jean Yee Hwa Yang}

\seealso{\code{\link{write.table}}, \code{\link{write}}}

\examples{
data(swirl)
test <- list(A = 1:10, B= maM(swirl)[1:10,], C=list(x=1:10, y=1:4),
             D = summary(maA(swirl[,1])))
write.list(test, filename="test.txt")
}
\keyword{file}

\eof
\name{write.xls}
\alias{write.xls}

\title{Data Output}
\description{
  Calls the function write.table with predefine argument.   The entries
  in each line (row) are separated by tab. 
}

\usage{
write.xls(res, file = "test.xls", ...)
}

\arguments{
  \item{res}{the object to be written, typically a data frame.  If not, it
          is attempted to coerce `x' to a data frame.}
  \item{file}{a character string representing the file name.}
  \item{\dots}{further arguments to \code{\link{write.table}}.}
}
\details{
  see \code{\link{write.table}}
}

\author{Jean Yee Hwa Yang}

\seealso{\code{\link{write.table}}, \code{\link{write.list}}}

\examples{
data(swirl)
write.xls(maM(swirl)[1:10,], "normM.xls")
}

\keyword{file}% at least one, from doc/KEYWORDS


\eof
