### Name: hray
### Title: Represent Values and Confidence Bounds on a Map Using Rays
### Aliases: hray
### Keywords: aplot

### ** Examples

# Random  locations values and bounds
x <- rnorm(100)
y <- rnorm(100)
val <- rnorm(100)
inc <- abs(rnorm(100,sd=.4))
lowbnd <- val-inc
highbnd <- val+inc

#no confidence bounds
plot(x,y,type='n')
hray(x,y,val)

#confidence bounds
plot(x,y,type='n')
hray(x,y,val,lowbnd,highbnd)

# Clockwise orientation
plot(x,y,type='n')
hray(x,y,val,lowbnd,highbnd)

# No tics and small filled dots
plot(x,y,type='n')
hray(x,y,val,lowbnd,highbnd,ticlength=0,dotside=20,dotlength=.025,dotden=-1)

# bivariate rays for smoothed data on a hexagon grid
# Data not provided
#plot(mymap,type='l') ## Do not work. Commented out.
#hray(grid$x,grid$y,pred$so4)
#hray(grid$x,grid$y,pred$no3,clockwise=TRUE,tics=FALSE)
## End of commented out code

# temporal trends with confidence bounds plotted on a map
# Data and user function not provided
#  mtapply()   like tapply but for matrices
#  sens.season.slope()  computes sen's seasonal slope
#bin  <- hcell(x,y)
#  x and y are in map projection units
#newdat < dat[,c('month','year','value')]
# extract columns
#stats <- mtapply(newdat,bin$cell,sens.season.slope,season=12)
#plot(mymap,type='l')
# map boundaries in map projection units
#xy <- hcell2xy(bin)
# x and y coordinates for hexagon cell centers
#hray(xy$x, xy$y,stat[,1],lowbnd= stat[,2],highbnd=stat[,3])



