### Name: hdiffplot
### Title: Plot of Domain and Median Differences of Two `hbin' Objects
### Aliases: hdiffplot
### Keywords: hplot

### ** Examples

#  Comparison of two bivariate boxplots
x1 <- rnorm(10000)
y1 <- rnorm(10000)
x2 <- rnorm(10000,mean=.3)
y2 <- rnorm(10000,mean=.3)
xbnds <- range(x1,x2)
ybnds <- range(y2,y2)

bin1 <- hexbin(x1,y1,xbnds=xbnds,ybnds=ybnds)
bin2 <- hexbin(x2,y2,xbnds=xbnds,ybnds=ybnds)
erodebin1 <- erode.hexbin(smooth.hexbin(bin1))
erodebin2 <- erode.hexbin(smooth.hexbin(bin2))

hdiffplot(erodebin1,erodebin2)



