\name{MmDEGenes}
\alias{MmDEGenes}

\title{Known DE genes for Mouse quality hybridizations.}

\description{
  MmDEGenes contains information about probes known to be DE from
  previous quality hybridizations. It is used to verify reproducibility
  of print-runs.
}

\source{These data were provided by members of the UCSF Shared
  functional genomics core lab.}

\keyword{datasets}

\eof
\name{PRv9mers}
\alias{PRv9mers}

\title{Print Run Quality version 9mers}
\description{
  Qualitative diagnostic plots looking at print-run quality.  This
  component examine the 9mers hybridizations.
}
\usage{
PRv9mers(fnames, path = ".", dev = "png", DEBUG = FALSE, prargs = NULL, samepr = TRUE, prname = "xMm", save = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{

  \item{fnames}{A "character" string naming the input files.}
  \item{path}{A "character" string representing the data directory. By
          default this is set to the current working directory (".").}
  \item{dev}{A "character" string naming the graphics device. This will
    take arguments "png", "jpeg" and "ps" only.}
  \item{DEBUG}{If 'TRUE', debug statements are printed.}
  \item{prargs}{A list with 4 components: Block, Row, Column and
    ncolumns. See Details for more information.}
  \item{samepr}{If 'TRUE', we assume everything in the directory are
    from the same print-run.}
  \item{prname}{A "character" string giving the name of the print-run.}
  \item{save}{If `TRUE', the figures will be saved to files.}
  \item{\dots}{additional arguments}
}
\details{
  The argument "prargs" is used to calculate the layout information
  about a print-run.  Components Block, Row and Columns denote the
  column names from the input data representing the print-tip location.
  The component "ncolumns" is an integer representing the number of
  print-tip columns in the data.  If the arguement is set to NULL,
  the the following default will be used.  list(Block="Block",
  Row="Row", Column="Column", ncolumns=4)} 
}
\value{
  Files of diagnostic plots and  excel files containings probe IDs of
  problematic probes.
}

\author{Jean Yee Hwa Yang}

\examples{
   datadir <- system.file("data", package="arrayQuality")
   PRv9mers(fnames="12Mm250.gpr", path=datadir, prname="12Mm")
}
\keyword{hplot}% at least one, from doc/KEYWORDS


\eof
\name{PRvQCHyb}
\alias{PRvQCHyb}

\title{Print run Quality version Quality Control Hybridization}
\description{
    Qualitative diagnostic plots looking at print-run quality.  This
  component examine the QC hybridizations.
}

\usage{
PRvQCHyb(fnames, path=".", dev = "png", DEBUG=FALSE, prargs=NULL, samepr=TRUE, prname="xMm", save = TRUE, col,...)
}

\arguments{
  \item{fnames}{A "character" string naming the input files.}
  \item{path}{a character string representing the data directory. By
    default this is set to the current working directory (".").}
  \item{dev}{A "character" string naming the graphics device. This will
    take arguments "png", "jpeg" and "ps" only.}
  \item{DEBUG}{If 'TRUE', debug statements are printed.}
  \item{prargs}{A list with 4 components: Block, Row, Column and
    ncolumns. See Details for more information.}
  \item{samepr}{If 'TRUE', we assume everything in the directory are
    from the same print-run.}
  \item{prname}{A "character" string giving the name of the print-run.}
  \item{save}{If `TRUE', the figures will be saved to files.}
  \item{col}{color code for different control samples.}
  \item{\dots}{additional arguments.}
}

\details{
  The argument "prargs" is used to calculate the layout information
  about a print-run.  Components Block, Row and Columns denote the
  column names from the input data representing the print-tip location.
  The component "ncolumns" is an integer representing the number of
  print-tip columns in the data.  If the arguement is set to NULL,
  the the following default will be used.  list(Block="Block",
  Row="Row", Column="Column", ncolumns=4)
}

\value{
  Files of diagnostic plots.
}

\author{Jean Yee Hwa Yang}

\examples{
  datadir <- system.file("data", package="arrayQuality")
  PRvQCHyb(fnames="9Mm137.gpr", path=datadir, prname="9Mm")
}
\keyword{hplot}% at least one, from doc/KEYWORDS

\eof
\name{agQuality}
\alias{agQuality}
\alias{agcontrolCode}
\title{Diagnostic plots and comparative boxplots for general
  hybridization, Agilent format}
\description{
  This component provides qualitative diagnostic plots and quantitative
  measures for assessing general hybridization quality. All results are
  displayed in a HTML report. Agilent format only.}
\usage{
agQuality(fnames = NULL, path = ".", organism = c("Mm", "Hs"),
compBoxplot = TRUE, reference = NULL, controlMatrix = agcontrolCode,
controlId = c("ProbeName"), output = FALSE, resdir = ".", dev= "png", DEBUG = FALSE,...)
}
\arguments{ 
  \item{fnames}{A "character" string naming the input files.}
  \item{path}{A "character" string representing the data directory. By
    default this is set to the current working directory (".").}
  \item{organism}{A "character" string naming the organism genome
    printed on the array, either "Mm" or "Hs". By default, organism is
    set to "Mm". It is used to retrieve the corresponding reference tables.}
  \item{compBoxplot}{Logical. If set to 'FALSE', only qualitative
    diagnostic plots will be plotted. agQuality ouput will be limited to
    a diagnostic plot by file and a marrayRaw object.}
  \item{reference}{A matrix resulting from globalQuality, to be used as
    reference table to compare slides. If 'NULL', the default table
    corresponding to organism will be used. See details for more information.}
  \item{controlMatrix}{A character matrix of n by 2 columns. The first
    column contains a few regular expression of spotted probe sequences
    and the second column contains the corresponding control status. By
    default, is it set to be agcontrolCode.}
  \item{controlId}{Character string. Name of the column of the file used
    to define controls.}
  \item{output}{Logical. If 'TRUE', normalized M values corresponding to
    the input Agilent files and quality measures are printed to a file.}
  \item{resdir}{A "character" string representing the directory where
    the results will be saved. By default, this is set to the current
    working directory (".").}
  \item{dev}{A "character" string naming the graphics device. This will
    take arguments "png", "jpeg" and "ps" only. By default, dev is set to "png".}
  \item{DEBUG}{If 'TRUE', debug statements are printed.}
  \item{\dots}{Additional arguments.}
}
\details{
  agQuality returns 2 plots for each Agilent files passed as argument. The
  first one is a qualitative diagnostic plot, a quick visual way to assess
  slide quality. The second one is a comparative boxplot: each quality
  control measure is compared to the range obtained for a database of 'good'
  slides used as reference. You can use your own set of references created
  using \code{globalQuality} passed in the arguments "reference", or use
  the reference QC values stored in the datasets \code{MmReferenceDB} and
  \code{HsReferenceDB}. All results and quality scores are gathered in a
  HTML report. For more details about the QC measures and the plots,
  please refer to the online manual.
}
\value{
  A list of 2 elements:
  \item{mraw}{A marrayRaw object created from the input files.}
  \item{quality}{A matrix containing Quality Control measures for all slides.}
}
\author{Agnes Paquet}
\seealso{
  \code{\link{globalQuality}}, \code{\link{qualBoxplot}},
  \code{\link{readAgilent}}
}
\examples{ example}
\keyword{hplot}




\eof
\name{Internal functions}
\alias{arrayScal}
\alias{quality2HTML}
\alias{EMSplit}
\alias{qpS2N}
\alias{qpPTLoess}
\alias{qpImage}
\alias{qpHexbin}
\alias{gpFlagWt}
\alias{qpDotPlots}
\alias{qpMAPlots}
\alias{setCtlCol}
\alias{arrayControls}
\alias{replicatesAvariance}
\alias{arrayReplicates}
\alias{outputNormData}

\title{Internal arrayQuality functions}
 
\description{Internal arrayQuality functions}
 
\details{These are not to be called by the user.}

\keyword{methods}

\eof
\name{globalQuality}
\alias{globalQuality}

\title{Quality measures for general hybridization.}

\description{
  This function provides Quality Control measures for GenePix, Spot and
  Agilent format files. It is used to create a table of measures to be used as
  reference in gpQuality, spotQuality or agQuality.
}

\usage{
globalQuality(fnames = NULL, path = ".", organism = c("Mm", "Hs"),
output = FALSE, resdir = ".", DEBUG = FALSE, inputsource = "readGPR",...)
}

\arguments{
  \item{fnames}{A "character" string naming the input files.}
  
  \item{path}{a "character" string representing the data directory.  By
    default this is set to the current working directory (".").}
  
  \item{organism}{A "character" string naming the organism genome
    printed on the array, either "Mm" or "Hs". By default, organism is
    set to "Mm". It is used to retrieve the corresponding reference tables.}

  \item{output}{Logical. If 'TRUE', the quality measures are printed to
    a file.
  }

  \item{resdir}{A "character" string representing the directory where
    the results will be saved. By default, this is set to the current
    working directory ("."). }

  \item{DEBUG}{If 'TRUE', debug statements are printed.}

  \item{inputsource}{A "character" string providing the name of the function to
    use to read the input files. It should be inputsource = "readGPR"
    for GenePix format files, inputsource = "readSpot" for Spot files, or
    inputsource = "readAgilent" for Agilent format. By default,
    'inputsource' is set to "readGPR".}
  
  \item{\dots}{additional arguments}
}

\value{
  A matrix of Quality Control measures, each column representing a
  different input slide. 
}

\author{Agnes Paquet}

\seealso{\code{\link{gpQuality}}, \code{\link{slideQuality}},
  \code{\link{MmReferenceDB}}, \code{\link{readGPR}},
  \code{\link{readSpot}}, \code{\link{readAgilent}}
}

\examples{
datadir <- system.file("data", package="arrayQuality")
reference <- globalQuality(fnames="9Mm137.gpr", path=datadir, organism="Mm")
}

\keyword{programming}







\eof
\name{gpQuality}
\alias{gpQuality}

\title{Diagnostic plots and comparative boxplots for general hybridization}
 
\description{
  This component provides qualitative diagnostic plots and quantitative
  measures for assessing general hybridization quality. All results are
  displayed in a HTML report. GenePix format only.
}

\usage{

gpQuality(fnames = NULL, path = ".", organism = c("Mm", "Hs"),
compBoxplot = TRUE, reference = NULL, controlMatrix = controlCode,
controlId = c("ID", "Name"), output = FALSE, resdir = ".", dev= "png", DEBUG = FALSE,...)
}

\arguments{
  
  \item{fnames}{A "character" string naming the input files.}
  
  \item{path}{A "character" string representing the data directory.  By
    default this is set to the current working directory (".").}
  
  \item{organism}{A "character" string naming the organism genome
    printed on the array, either "Mm" or "Hs". By default, organism is
    set to "Mm". It is used to retrieve the corresponding reference
    tables.}

  \item{compBoxplot}{Logical. If set to 'FALSE', only qualitative
    diagnostic plots will be plotted. gpQuality ouput will be limited to
    a diagnostic plot by gpr file and a marrayRaw object.}

  \item{reference}{A matrix resulting from globalQuality, to be used as
    reference table to compare slides. If 'NULL', the default table
    corresponding to organism will be used. See details for more information.}
  
 
  \item{controlMatrix}{A character matrix of n by 2 columns. The first
    column contains a few regular expression of spotted probe sequences
    and the second column contains the corresponding control status. By
    default, controlMatrix is set to controlCode.}

  \item{controlId}{Character string. Name of the column of the gpr
    file used to define controls.}

  \item{output}{Logical. If 'TRUE', normalized M values corresponding to
    the input GenePix files and quality measures are printed to a file.}

  \item{resdir}{A "character" string representing the directory where
    the results will be saved. By default, this is set to the current
    working directory ("."). }

  \item{dev}{A "character" string naming the graphics device. This will
    take arguments "png", "jpeg" and "ps" only. By default, dev is set
    to "png".}
  
  \item{DEBUG}{If 'TRUE', debug statements are printed.}

  \item{\dots}{additional arguments}
}


\details{
gpQuality returns 2 plots for each GenePix files passed as argument. The
first one is a qualitative diagnostic plot, a quick visual way to assess
slide quality. The second one is a comparative boxplot: each quality
control measure is compared to the range obtained for a database of 'good'
slides used as reference. You can use your own set of references created
using \code{globalQuality} and \code{qualRefTable} passed
in the arguments "reference" and "scalingTable", or use
the reference QC values stored in the datasets \code{MmReferenceDB} and
\code{MmScalingTable}. All results and quality scores are gathered in a
HTML report. For more details about the QC measures and the plots, please refer to the online manual.
}

\value{
  A list of 2 elements:

  \item{mraw}{A marrayRaw object created from the input files.}
  \item{quality}{A matrix containing Quality Control measures for all slides.}
}

\author{Agnes Paquet}

\seealso{\code{\link{globalQuality}}, \code{\link{qualBoxplot}},
  \code{\link{scaleRefTable}}, \link{marray}
}

\examples{
  datadir <- system.file("data", package="arrayQuality")
  results <- gpQuality(fnames="9Mm137.gpr", path=datadir, organism="Mm")
}

\keyword{hplot}



\eof
\name{gprDB}
\alias{MmScalingTable}
\alias{MmReferenceDB}
\alias{index.html}
\alias{HsReferenceDB}
\alias{HsScalingTable}

\title{Reference slides for Mouse oligos hybridizations}

\description{
MmReferenceDB, HsReferenceDB: quality matrix compiling results from a pool of
good hybridization slides for Mouse and Human genomes respectively.

MmScalingTable, HsScalingTable: matrix of means and iqr calculated from the pool of good
hybridization slides for Mouse and Human genomes respectively, for each quality measure. It is used to scale
other arrays quality results.

index.html: HTML file used for quality report.
}

\source{These data were provided by members of the UCSF Shared
  functional genomics core lab.}

\keyword{datasets}


\eof
\name{maQualityPlots}
\alias{maQualityPlots}

\title{Qualitative diagnostic plot for general hybridization}

\description{
  This function generates diagnostic plots for a qualitative assessment of
  slide quality.  
}

\usage{
maQualityPlots(mrawObj, headerInfo = "", save = TRUE, dev = "png", col=NULL,
badspotfunction=NULL, controlId = c("ID", "Name"), DEBUG = FALSE, ...)
}

\arguments{
  \item{mrawObj}{\code{marrayRaw}  or \code{RGList} object representing
    the slides to be tested.}

  \item{headerInfo}{Text to be used as header in the diagnostic plot.}

  \item{save}{Logical. If 'TRUE', the plot is saved to a file.}

  \item{dev}{A "character" string naming the graphics device. This will
    take arguments "png", "jpeg" and "ps" only. By default, dev is set
    to "png".}

  \item{col}{Vector of colors to use to describe different
    categories of spots.}

  \item{badspotfunction}{Function to use for bad spots on the array.}

  \item{controlId}{Character string. Name of the column of the gpr
    file used to define controls (or provides the name of the probes).}

  \item{DEBUG}{If 'TRUE', debug statements are printed.}
  
  \item{\dots}{additional arguments}
}

\author{Jean Yang}

\examples{
# Example uses swirl dataset...

}

\keyword{hplot}


\eof
\name{prdata}
\alias{9Mm137.gpr}
\alias{12Mm250.gpr}

\title{Example GPR files}

\description{
  9Mm137.gpr is QCHyb from 9Mm printrun.\\
  12Mm250.gpr is 9mers Hyb from 12Mm printrun.
}

\source{These data were provided by members of the UCSF Shared
  Functional Genomics Core Facility.}

\keyword{datasets}





\eof
\name{qualBoxplot}
\alias{qualBoxplot}

\title{Comparative boxplot for general hybridization Quality Control}

\description{This functions allows you to graphically compare your slide
  quality measures to results obtained for a database of 'good quality'
  slides.}

\usage{
qualBoxplot(arrayQuality = NULL, reference = NULL, organism = c("Mm", "Hs"), DEBUG=FALSE,...)
}

\arguments{
  \item{arrayQuality}{Matrix of quality results from \code{slideQuality}
    or \code{globalQuality}.}

  \item{reference}{A matrix resulting from globalQuality, to be used as
    reference table to compare slides. If 'NULL', the default table
    corresponding to "organism" will be used. See details for more information.}
  
  \item{organism}{A "character" string naming the organism genome
    printed on the array, either "Mm" or "Hs". By default, organism is
    set to "Mm". It is used to retrieve the corresponding reference
    tables.}

  \item{DEBUG}{If 'TRUE', debug statements are printed.}

  \item{\dots}{additional arguments}

}

\details{
  You can use your own set of references created
  using \code{globalQuality} passed
  in the arguments "reference", or use
  the reference QC values stored in the datasets \code{MmReferenceDB}.}
 
\value{
  Returns a score vector containing, for each column in "arrayQuality",
  the number of quality measures below the range of "reference". The
  last element of the score vector is the total number of quality
  measures tested.
}

\author{Agnes Paquet}

\seealso{\code{\link{globalQuality}}, \code{\link{gpQuality}},
  \code{\link{spotQuality}}, \code{\link{agQuality}}}

\examples{
#datadir <- system.file("data", package="arrayQuality")
#gprData <- readGPR(fnames="9Mm137.gpr", path=datadir)
#arrayQuality <- slideQuality(gprData, organism="Mm")
#qualBoxplot(arrayQuality)
}

\keyword{hplot}

\eof
\name{qualityScore}
\alias{qualityScore}

\title{Quality Control score for general hybridization}

\description{This function returns, for each quality measure, the
  percentage of reference slides measures which are below the tested
  slide values. For more details on this score, refer to the online
  manual.
}

\usage{qualityScore(slidequality, organism = c("Mm", "Hs"), reference =
NULL)
}

\arguments{
  \item{slidequality}{A quality matrix from slideQuality.}

  \item{reference}{A matrix resulting from globalQuality, to be used as
    reference table to compare slides. If 'NULL', the default table
    corresponding to organism will be used. See details for more
    information.}
  
  \item{organism}{A "character" string naming the organism genome
    printed on the array, either "Mm" or "Hs". By default, organism is
    set to "Mm". It is used to retrieve the corresponding reference tables.}
}

\value{A matrix of percentages.}

\author{Agnes Paquet}

\keyword{programming}


\eof
\name{readAgilent}
\alias{readAgilent}

\title{Extraction of measures from Agilent (.txt) files.}

\description{This component reads an Agilent file (.txt) and returns
  columns used for quality control.
}

\usage{
readAgilent(fnames = NULL, path= ".", DEBUG=FALSE, skip = 0, sep ="\t",
quote="\"",controlId=c("ProbeName"), ...)
}

\arguments{
  \item{fnames}{A "character" string naming the input file.}
  
  \item{path}{a "character" string representing the data directory.  By
    default this is set to the current working directory (".").}
  
  \item{DEBUG}{If 'TRUE', debug statements are printed.}

  \item{skip}{Number of lines to skip in the gpr files.}

  \item{sep}{A "character" string defining the type of separation for
    the columns in the gpr files.}

  \item{quote}{A "character" string defining the type of quote in the
    gpr files.}
  
  \item{controlId}{Character string. Name of the column of the 
    file used to define controls.}

  \item{\dots}{additional arguments.}
}

\value{A list of vectors containing information extracted from the
  Agilent file}

\author{Agnes Paquet}

\seealso{
  \code{\link{slideQuality}}, \code{\link{agQuality}}, \code{\link{globalQuality}}
}

\examples{
}

\keyword{programming}


\eof
\name{readGPR}
\alias{readGPR}

\title{Reading GenePix gpr file}

\description{This component reads a GenePix file (.gpr) and returns
  columns used for quality control.
}

\usage{
readGPR(fnames = NULL, path= ".", DEBUG=FALSE, skip = 0, sep ="\t",
quote="\"", ...)
}

\arguments{
  \item{fnames}{A "character" string naming the input file.}
  
  \item{path}{a "character" string representing the data directory.  By
    default this is set to the current working directory (".").}
  
  \item{DEBUG}{If 'TRUE', debug statements are printed.}

  \item{skip}{Number of lines to skip in the gpr files.}

  \item{sep}{A "character" string defining the type of separation for
    the columns in the gpr files.}

  \item{quote}{A "character" string defining the type of quote in the
    gpr files.}

  \item{\dots}{additional arguments.}
}

\value{A list of vectors containing information extracted from the
  GenePix file}

\author{Agnes Paquet}

\seealso{
  \code{\link{slideQuality}}, \code{\link{gpQuality}}, \code{\link{globalQuality}}
}

\examples{
datadir <- system.file("data", package="arrayQuality")
gprData <- readGPR(fnames="9Mm137.gpr", path=datadir)
}

\keyword{programming}


\eof
\name{readSpot}
\alias{readSpot}

\title{Extraction of measures from Spot (.spot) files.}

\description{This component reads a Spot file (.spot) and returns
  columns used for quality control.
}

\usage{
readSpot(fnames = NULL, path= ".", galfile=NULL,DEBUG=FALSE, skip = 0, sep ="\t",quote="\"",controlId="ID", ...)
}

\arguments{
  \item{fnames}{A "character" string naming the input file.}
  
  \item{path}{a "character" string representing the data directory.  By
    default this is set to the current working directory (".").}

  \item{galfile}{ A "character" string naming the galfile associated
    with the input file. If galfile = NULL, readSpot will use the first
    .gal file found in the working directory.}
  
  \item{DEBUG}{If 'TRUE', debug statements are printed.}

  \item{skip}{Number of lines to skip in the gpr files.}

  \item{sep}{A "character" string defining the type of separation for
    the columns in the gpr files.}

  \item{quote}{A "character" string defining the type of quote in the
    gpr files.}
  
  \item{controlId}{Character string. Name of the column of the Spot
    file used to define controls.}

  \item{\dots}{additional arguments.}
}

\value{A list of vectors containing information extracted from the
  Agilent file}

\author{Agnes Paquet}

\seealso{
  \code{\link{slideQuality}}, \code{\link{agQuality}}, \code{\link{globalQuality}}
}

\examples{
}

\keyword{programming}


\eof
\name{readcontrolCode}
\alias{readcontrolCode}

\title{Control status information}
 
\description{
  This component reads spot type information from a tab delimited text
  file to a matrix.}

\usage{
readcontrolCode(file = "SpotTypes.txt", path = NULL, sep = "\t", check.names = FALSE, controlId=c("ID", "Name"), ...) 
}

\arguments{
  
  \item{file}{Character string giving the name of the file specifying the
    spot types.}
  
  \item{path}{Character string giving the directory containing the file.
    Can be omitted if the file is in the current working directory.}
  
  \item{sep}{the field separator character.}
  
  \item{check.names}{Logical, if 'FALSE' column names will not be converted to
    valid variable names, for example spaces in column names will not be left as is.}

  \item{controlId}{Character string. Name of the column of the gpr
    file used to define controls.}

  \item{\dots}{additional arguments}
}

\value{
  A 2 column matrix named controlCode.
  }

\author{Jean Yee Hwa Yang, Agnes Paquet}

\seealso{\code{\link{readSpotTypes}}}

\keyword{hplot}



\eof
\name{scaleRefTable}
\alias{scaleRefTable}

\title{General hybridization quality scaling}

\description{This function helps you scale quality measures in order
  to compare them on the same plot. It is used on reference slides to
  create a look-up table, which will be used to scale other slides.}

\usage{scaleRefTable(reference=NULL, organism=c("Mm", "Hs"))}
}

\arguments{

  \item{organism}{A "character" string naming the organism genome
    printed on the array, either "Mm" or "Hs". By default, organism is
    set to "Mm". It is used to retrieve the corresponding reference
    tables.}

  \item{reference}{A matrix resulting from globalQuality, to be used as
    reference table to compare slides. If 'NULL', the default table
    corresponding to organism will be used.}
}

\value{A matrix containing median and iqr for each quality measure for
  tested slides.}

\author{Agnes Paquet}

\seealso{\code{\link{gpQuality}}, \code{\link{globalQuality}},
  \code{\link{qualBoxplot}}, \code{\link{MmScalingTable}}
}

\keyword{programming}

\eof
\name{slideQuality}
\alias{slideQuality}

\title{Quality Control statistics for general hybridization}

\description{This component uses data extracted from GenePix file to
  provide quality control statistics.}

\usage{
slideQuality(gprData = NULL, controlMatrix = controlCode, controlId = c("ID", "Name"), DEBUG = FALSE,...)
}

\arguments{
  \item{gprData}{A list of vector, results from \code{readGPR},
    containing information extracted from the gpr file.}

  \item{controlMatrix}{A matrix defining control status information.}

  \item{controlId}{Character string. Name of the column of the gpr
    file used to define controls.}

  \item{DEBUG}{If 'TRUE', debug statements are printed.}
  
  \item{\dots}{additional arguments}
}

\value{
  A matrix of numbers.}

\author{Agnes Paquet}

\seealso{\code{\link{gpQuality}}, \code{\link{globalQuality}},
  \code{\link{readGPR}}
}

\examples{
datadir <- system.file("data", package="arrayQuality")
gprdata <- readGPR(fnames="9Mm137.gpr", path=datadir)
results <- slideQuality(gprdata)
}

\keyword{programming}



\eof
\name{spotQuality}
\alias{spotQuality}

\title{Diagnostic plots and comparative boxplots for general
  hybridization, Spot format}
 
\description{
  This component provides qualitative diagnostic plots and quantitative
  measures for assessing general hybridization quality. All results are
  displayed in a HTML report. Spot format only.
}

\usage{

spotQuality(fnames = NULL, path = ".", galfile = NULL, organism = c("Mm", "Hs"),
compBoxplot = TRUE, reference = NULL, controlMatrix = controlCode,
controlId = c("ID"), output = FALSE, resdir = ".", dev= "png", DEBUG = FALSE,...)
}

\arguments{
  
  \item{fnames}{A "character" string naming the input files.}
  
  \item{path}{A "character" string representing the data directory.  By
    default this is set to the current working directory (".").}

  \item{galfile}{A "character" string naming the galfile associated with
    the input files. If galfile = NULL, spotQuality will use the first
    .gal file available in the working directory.}
  
  \item{organism}{A "character" string naming the organism genome
    printed on the array, either "Mm" or "Hs". By default, organism is
    set to "Mm". It is used to retrieve the corresponding reference
    tables.}

  \item{compBoxplot}{Logical. If set to 'FALSE', only qualitative
    diagnostic plots will be plotted. gpQuality ouput will be limited to
    a diagnostic plot by gpr file and a marrayRaw object.}

  \item{reference}{A matrix resulting from globalQuality, to be used as
    reference table to compare slides. If 'NULL', the default table
    corresponding to organism will be used. See details for more information.}
  
 
  \item{controlMatrix}{A character matrix of n by 2 columns. The first
    column contains a few regular expression of spotted probe sequences
    and the second column contains the corresponding control status.}

  \item{controlId}{Character string. Name of the column of the gpr
    file used to define controls.}

  \item{output}{Logical. If 'TRUE', normalized M values corresponding to
    the input GenePix files and quality measures are printed to a file.}

  \item{resdir}{A "character" string representing the directory where
    the results will be saved. By default, this is set to the current
    working directory ("."). }

  \item{dev}{A "character" string naming the graphics device. This will
    take arguments "png", "jpeg" and "ps" only. By default, dev is set
    to "png".}
  
  \item{DEBUG}{If 'TRUE', debug statements are printed.}

  \item{\dots}{additional arguments}
}


\details{
agQuality returns 2 plots for each Agilent files passed as argument. The
first one is a qualitative diagnostic plot, a quick visual way to assess
slide quality. The second one is a comparative boxplot: each quality
control measure is compared to the range obtained for a database of 'good'
slides used as reference. You can use your own set of references created
using \code{globalQuality} passed in the arguments "reference", or use
the reference QC values stored in the datasets \code{MmReferenceDB} and \code{HsReferenceDB}. All results and quality
scores are gathered in a HTML report. For more details about the QC measures and the plots, please refer to the online manual.
}

\value{
  A list of 2 elements:

  \item{mraw}{A marrayRaw object created from the input files.}
  \item{quality}{A matrix containing Quality Control measures for all slides.}
}

\author{Agnes Paquet}

\seealso{\code{\link{globalQuality}}, \code{\link{qualBoxplot}},
\code{\link{readAgilent}}}

\examples{
}

\keyword{hplot}



\eof
