%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/arrayData-class.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{arrayData-class}
 \docType{class}

 \alias{arrayData-class}
 \alias{arrayData}

 \alias{intensities<-}
 \alias{weights<-}
 \alias{spotAttr<-}
 \alias{hybAttrList<-}
 \alias{getIntensities}
 \alias{getWeights}
 \alias{getSpotAttr}
 \alias{getHybAttr}
 \alias{getHybAttrGreen}
 \alias{getHybAttrRed}
 \alias{getHybAttrList}

 \alias{intensities<-,arrayData-method}
 \alias{weights<-,arrayData-method}
 \alias{spotAttr<-,arrayData-method}
 \alias{hybAttrList<-,arrayData-method}
 \alias{getIntensities,arrayData-method}
 \alias{getWeights,arrayData-method}
 \alias{getSpotAttr,arrayData-method}
 \alias{getHybAttr,arrayData-method}
 \alias{getHybAttrGreen,arrayData-method}
 \alias{getHybAttrRed,arrayData-method}
 \alias{getHybAttrList,arrayData-method}
 \alias{initialize,arrayData-method}
 \alias{[,arrayData-method}
 \alias{show,arrayData-method}



 \title{Class arrayData, a simple container for
        raw data and related information }


 \description{ A simple class to store
        raw data, annotation information for spots and
        hybridisations, as well as weights.
        }

\section{Creating Objects}{
 \code{  new('arrayData',}\cr
 \code{    intensities = ..., # optional; object of class array}\cr
 \code{    weights     = ..., # optional; object of class matrix}\cr
 \code{    spotAttr    = ..., # optional; object of class data.frame}\cr
 \code{    hybAttrList = ..., # optional; list of two objects of class data.frame}\cr
 \code{  )}
}

\section{Slots}{
  \describe{
    \item{\code{intensities}:}{Object of class \code{array};
                               three-dimensional;
        dim = nrOfSpots x nrOfChannels x nrOfHybridisations;
        second dimension must contain "green"  and "red" and possibly
        "greenBackground" and "redBackground"; default: \code{NULL}}
    \item{\code{weights}:}{Object of class \code{matrix};
                           dim = nrOfSpots x nrOfHybridisations;
                           range = [0,1]; default: \code{NULL}.
         }
    \item{\code{spotAttr}:}{Object of class \code{data.frame};
                            dim = nrOfSpots x nrOfSpotCharacteristics;
        default: \code{NULL}}
    \item{\code{hybAttrList}:}{list of two objects named "green" and "red"
        of class \code{data.frame}; the dimension of
        each \code{data.frame} is given by
        nrOfHybridisations x nrOfHybridisationCharacteristics ;
        default: \code{NULL}}
  }
}

 \section{Methods}{
  \describe{

    \item{intensities<-}{(arrayData): Set the \code{intensities} of
                           \code{arrayData}. }
    \item{getIntensities}{(arrayData): Returns the \code{intensities}
                           \code{array}.}
    \item{weights<-}{(arrayData): Set the \code{weights} of
                           \code{arrayData}. }
    \item{getWeights}{(arrayData): Returns the \code{weights} object. }
    \item{spotAttr<-}{(arrayData): Set the \code{spotAttr} of
                           \code{arrayData}. }
    \item{getSpotAttr}{(arrayData): Returns the \code{spotAttr} \code{data.frame}.}
    \item{getHybAttr}{(arrayData): Returns the "intersection" of the "red"
                      and "green" \code{data.frame} of \code{hybAttrList}
                      or if one is \code{NULL} the other one. The "intersection"
                      are those columns which match in column name and its content
                      otherwise \code{NULL} is returned.}
    \item{getHybAttrGreen}{(arrayData): Returns the "green" list element 
                         of \code{hybAttrList}, i.e. a \code{data.frame}. }
    \item{getHybAttrRed}{(arrayData): Returns the "red" list element
                         of \code{hybAttrList}, i.e. a \code{data.frame}. }
    \item{hybAttrList<-}{(arrayData): Set the \code{hybAttrList} of
                           \code{arrayData}. }
    \item{getHybAttrList}{(arrayData): Returns the \code{hybAttrList} object. }
    \item{show}{(arrayData): Renders information about the \code{arrayData} object
                             on standard out.}
    \item{[}{(arrayData,i,j):
             A subset operator, where i corresponds to the spots and
             j to the hybridisations.}

    \item{cbind}{(...): Concatenates \code{arrayData} objects.
                        Spots/rows are assumed to match;
                        possibly you have to subset and reorder
                        the objects beforehand
                        cf. function \code{\link{cbind.arrayData}}.
                }

     
  }
}

 \seealso{
           \code{\link{exprSetRG-class}}
         }

 \keyword{methods}
 \keyword{classes}

 \examples{

intensities <- array(data=runif(120),dim=c(20,2,3))
dimnames(intensities) <- list(NULL, c("green","red"), NULL)
spotAttr <- data.frame(Name=I(rep(c("x","y","k","l","z"),4)),
                       Index=c(1:20))
arrayDataObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                       spotAttr=spotAttr, hybAttrList=NULL)
print(arrayDataObject)
hybs <- c(1,3)
spots <- c(1:10, 14)
aD <- arrayDataObject[spots,hybs]
print(aD)
stopifnot( all( getIntensities(arrayDataObject)[spots, , hybs] == getIntensities(aD) ) )
stopifnot( all( getWeights(arrayDataObject)[spots, hybs] == getWeights(aD) ) )
stopifnot( all( getSpotAttr(arrayDataObject)[spots, ] == getSpotAttr(aD) ) )

hybAttr <- data.frame(Name=I(c("hx","hy","hz")),
                      Index=c(1:3))
arrayDataObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                       spotAttr=spotAttr, hybAttrList=list(green=hybAttr,red=hybAttr))
hybAttrGreen <- data.frame(Name=I(c("hx","hy","hz")),
                      Index=c(4:6))
aDObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                       spotAttr=spotAttr, hybAttrList=list(green=hybAttrGreen,red=hybAttr))
print(arrayDataObject)
cbind(aDObject,aDObject)
hybs <- c(1)
spots <- c(1)
aD <- arrayDataObject[spots,hybs]
print(aD)
stopifnot( all( getIntensities(arrayDataObject)[spots, , hybs] == getIntensities(aD) ) )
stopifnot( all( getWeights(arrayDataObject)[spots, hybs] == getWeights(aD) ) )
stopifnot( all( getSpotAttr(arrayDataObject)[spots, ] == getSpotAttr(aD) ) )
stopifnot( all( getHybAttr(arrayDataObject)[spots, ] == getHybAttr(aD) ) )
stopifnot( all( getHybAttrRed(arrayDataObject)[spots, ] == getHybAttrRed(aD) ) )
stopifnot( all( getHybAttrGreen(arrayDataObject)[spots, ] == getHybAttrGreen(aD) ) )

stopifnot( all( getHybAttrRed(aDObject) == hybAttr) )
stopifnot( all( getHybAttrGreen(aDObject) == hybAttrGreen) )
stopifnot( all( getHybAttr(aDObject) == data.frame(Name=I(c("hx","hy","hz"))) ) )
weights(aDObject) <- intensities[,2,]
intensities(aDObject) <- intensities
spotAttr(aDObject) <- spotAttr
hybAttrList(aDObject) <- list(green=hybAttr,red=hybAttrGreen)
aD <- new("arrayData")
stopifnot(is(aD, "arrayData"))
 \dontshow{
 print(aD)
 xAD<-cbind(aD,aD)
 weights(aD) <- matrix(1,nrow=2,ncol=3)
 xAD<-cbind(aD,aD)
 spotAttr(aD) <- data.frame(hallo=c("a","b"))
 xAD<-cbind(aD,aD)
 hybAttrRed <- data.frame(colour=1:3)
 hybAttrGreen <- data.frame(colour=10:12)
 hybAttrList <- list(red=hybAttrRed,green=hybAttrGreen)
 hybAttrList(aD) <- hybAttrList
 xAD<-cbind(aD,aD)
 intensities <- array(data=c(1:12),dim=c(2,2,3))
 dimnames(intensities) <- list(NULL, c("green","red"), NULL)
 intensities(aD) <- intensities
 xAD<-cbind(aD,aD)
 i <- intensities * 0
 aD2<- aD
 intensities(aD2) <- i
 weights(aD2) <- getWeights(aD2) * 0.5
 xAD2 <- cbind(aD, aD2)
 stopifnot( all( getIntensities(xAD2[,1:3])  == getIntensities(aD) ) )
 stopifnot( all( getIntensities(xAD2[,4:6])  == getIntensities(aD2) ) )
 stopifnot( all( getWeights(xAD2[,1:3])  == getWeights(aD) ) )
 stopifnot( all( getWeights(xAD2[,4:6])  == getWeights(aD2) ) )
 aDThreeA <- cbind(aD,aD,aD)
 aDThreeB <- cbind( aD, cbind(aD,aD) )
 aDThreeC <- cbind( cbind(aD,aD), aD)
 stopifnot( identical( aDThreeA, aDThreeC ) )
 stopifnot( all( getSpotAttr(aDThreeA)[,1,drop=FALSE] == getSpotAttr(aD) ) )
 stopifnot( identical(getSpotAttr(aDThreeA), getSpotAttr(aDThreeB) ) )
 stopifnot( identical(getWeights(aDThreeA), getWeights(aDThreeB) ) )
 stopifnot( identical(getIntensities(aDThreeA), getIntensities(aDThreeB)))
 stopifnot( all(getHybAttrGreen(aDThreeA) == getHybAttrGreen(aDThreeB)))
 stopifnot( all(getHybAttrGreen(aDThreeA) == getHybAttrGreen(aDThreeB)))
 }
}
 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{cbind.arrayData}
\alias{cbind.arrayData}
\title{Cbind for objects of class arrayData}
\description{Cbind for objects of class arrayData,
  cf. \code{\link{arrayData-class}}, you may simply
  use cbind instead of cbind.arrayData .}
\usage{cbind.arrayData(...)}
\arguments{
  \item{...}{\code{\link{arrayData}} objects}
}

\details{  cf. \code{\link{arrayData-class}}  }

\value{an object of class \code{\link{arrayData}}}

\author{Andreas Buness <a.buness@dkfz.de>}


\seealso{ \code{\link{cbind}}, 
          \code{\link{arrayData-class}}
        }
\examples{}
\keyword{methods}

\eof
\name{cbind.exprSetRG}
\alias{cbind.exprSetRG}
\title{Cbind for objects of class exprSetRG}
\description{Cbind for objects of class exprSetRG,
  cf. \code{\link{exprSetRG-class}}, you may simply
  use cbind instead of cbind.exprSetRG.}
\usage{cbind.exprSetRG(...)}
\arguments{
  \item{...}{ \code{\link{exprSetRG}} objects}
}

\details{  cf. \code{\link{exprSetRG-class}}  }

\value{an object of class \code{\link{exprSetRG}} }

\author{Andreas Buness <a.buness@dkfz.de>}


\seealso{ \code{\link{cbind}}, 
          \code{\link{exprSetRG-class}}
        }
\examples{}
\keyword{methods}

\eof
\name{colCors}
\alias{rowCors}
\alias{colCors}

\title{Correlation coefficients between the corresponding columns (rows)
  of two matrices that have the same size.}
\description{Correlation coefficients between the corresponding columns (rows)
  of two matrices that have the same size.}

\usage{
rowCors(x,y)
colCors(x,y)
}
\arguments{
  \item{x}{Matrix}
  \item{y}{Matrix, same size as \code{x}}
}

\details{The implementation is naive.}

\value{  
A vector with the correlation coefficients for each row (\code{rowWiseSds}),
or column  (\code{rowWiseSds})
}

\seealso{\code{\link{colSums}}}

\examples{
x  = matrix(runif(1e6), ncol=100)
y  = matrix(runif(1e6), ncol=100)

commands = c(
  "c1 <<- colCors(x,y)",
  "c2 <<- sapply(1:ncol(x), function(i) cor(x[,i], y[,i]))",
  "c3 <<- rowCors(x,y)",
  "c4 <<- sapply(1:nrow(x), function(i) cor(x[i,], y[i,]))")
  
times = sapply(commands, function(text) system.time(eval(parse(text=text)))[1])
print(t(times))

stopifnot(all(abs(c1-c2) < 1e-3))
stopifnot(all(abs(c3-c4) < 1e-3))

}

\keyword{math}



\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/colorramp.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{colorramp}

 \title{colorramp}

 \alias{colorramp}

 \keyword{color}

 \description{Returns a function which allows to create color ramps.}

 \value{A function with a single argument n to specify the length of the
        desired color ramp.}


 \arguments{
  \item{palette}{vector, defining a color palette}
 }
 
 \examples{
   RdBu11 <- c("#67001F", "#B2182B", "#D6604D", "#F4A582", "#FDDBC7",
               "#F7F7F7", "#D1E5F0", "#92C5DE", "#4393C3", "#2166AC", "#053061")
   finerGraded <- colorramp(RdBu11)(33)
   barplot(rep(1,33), col=finerGraded)
	}

 \author{}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/controlledApply.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{controlledApply}

 \title{controlledApply}

 \alias{controlledApply}

 \usage{controlledApply(arrayObject, dimensions, func, funcResultDimensionality)}

 \keyword{iteration}

 \description{Same functionality as \code{\link{simpleApply}} but
              possibly faster. In certain circumstances the function
              \code{apply} is used instead of \code{\link{simpleApply}}
              which improves the performace.}

 \value{An array of
        \code{dim=c(dim(arrayObject[dimensions]),funcResultDimensionality)}.
        You may want to use \code{\link{aperm}} to rearrange the dimensions.}


 \arguments{
  \item{arrayObject}{object of class \code{array}}
  \item{dimensions}{increasing numeric vector}
  \item{func}{unary function}
  \item{funcResultDimensionality}{numeric (vector) specifying
                           the dimensionality of the return value of \code{func}}
  }

 \examples{

a <- array(c(1:30),dim=c(3,2,5))
r <- controlledApply(a, 1, function(x){return(x[2,5])}, 1)
stopifnot( all(r == matrix(data=c(28:30))))

r <- controlledApply(a, 2, function(x){return(x[,])}, c(3,5))
stopifnot( all( a == aperm(r,c(2,1,3)) ) )

vec <- 1:10; dim(vec) <- c(10,1)
mat <- matrix(data=rep(1:10,4),nrow=10,ncol=4,byrow=FALSE)
r <- controlledApply(mat,1,function(y){return(mean(y))},1)
stopifnot(all(r==vec))

r <- controlledApply(mat, 1:2, function(x) return(x), 1)
stopifnot( all(r[,,1] == mat) )

r <- controlledApply(a, c(1,3) , function(x) return(x), dim(a)[2])
stopifnot( all(aperm(r[,,],c(1,3,2)) == a) )

r <- controlledApply(a, 1:2, function(x) return(x[2]), 1)
stopifnot( all(r[,,] == a[,,2]) )

r <- controlledApply(a, 1, function(x) return(x), c(dim(a)[2],dim(a)[3]))
stopifnot( all( r== a ) )

 \dontshow{

     nrOfDimensions <- as.integer(runif(n=1,min=1,max=7))
     allDimensions <- as.integer(runif(n=nrOfDimensions,min=4,max=8))
     arrayObject <- array(data=runif(prod(allDimensions)),dim=allDimensions)
     dimensionsLength <- as.integer(runif(n=1,min=1,max=nrOfDimensions))
     dimensions <- unique(as.integer(
                      runif(n=dimensionsLength,min=1,max=nrOfDimensions)))
     func <- mean
     result <- simpleApply(arrayObject=arrayObject,
                           dimensions=dimensions,
                           func=func,
                           funcResultDimensionality = 1)

     result2 <- simpleApply(arrayObject=arrayObject,
                            dimensions=dimensions,
                            func=func,
                            funcResultDimensionality = 1)
     stopifnot( identical(result, result2))
    

r <- controlledApply(matrix(c(1, 2)), 1, sum, 1)
stopifnot( all(r == matrix(c(1,2))) )

a <- array(c(1:30),dim=c(3,2,5))
r <- controlledApply(a, 1, function(x){return(x[1])}, 1)
stopifnot( all(r == matrix(data=c(1:3))))

r <- controlledApply(a, 1, function(x){return(x[1,3])}, 1)
stopifnot( all(r == matrix(data=c(13:15))))

r <- controlledApply(a, 1, function(x){return(x[,])}, c(2,5))
stopifnot( all( a == r))

r <- controlledApply(a, 3, function(x){return(x[,])}, c(3,2))
stopifnot( all( a == aperm(r,c(2,3,1)) ) )

r2 <- controlledApply(a, 1, function(x){ return(as.vector(x))}, 10)

r <- controlledApply(a, 1:3, function(x) return(x), 1)
stopifnot( all(r[,,,1] == a) )

r <- controlledApply(a, 1:2, function(x) return(x), dim(a)[3])
stopifnot( all(r[,,] == a) )

r <- controlledApply(a, 1:2, function(x) return(x[1]), 1)

r <- controlledApply(a, 1:2, function(x) return(x[1]), 1)
stopifnot( all(r[,,] == a[,,1]) )

       }

 }

 \author{Andreas Buness <a.buness@dkfz.de>}

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/detectReplicas.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{detectReplicas}

 \title{detectReplicas}

 \alias{detectReplicas}

 \keyword{utilities}

 \usage{detectReplicas(arrayDescription, spotIdentifier = "ID", identifiersToBeSkipped = "Blank")}

 \description{The function returns for each unique item all corresponding indexes.}

 \arguments{
  \item{arrayDescription}{an object of class \code{data.frame}
                          which contains a column named as
                          \code{spotIdentifier}; required; default missing
                          }
  \item{spotIdentifier}{character string; required; default: "ID"}
  \item{identifiersToBeSkipped}{vector of character strings;
                                required; default: "Blank";
                                items of the column \code{spotIdentifier}
                                for which no replica detection takes place}
 }

 \value{A list which contains \code{nrOfReplicas} and
        \code{spotReplicas}.  \code{nrOfReplicas}: one
        integer characterizing the number of spot replicas
        given for each identifier if existing or otherwise  \code{NA}.
        \code{spotReplicas}: a list of the length of the unique
        identifiers where each element contains a vector of
        indexes corresponding to the given identifier (i.e. the
        name of the list element) otherwise \code{NA}.}

 \examples{

aD <- data.frame(ID=c("z", "x", "x", "x", "y", "z", "z", "y", "y"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(re[["nrOfReplicas"]] == 3 )

aD <- data.frame(ID=c("Blank", "Control1", "Blank", "Control2"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(is.na(re[["nrOfReplicas"]]))

 \dontshow{
aD <- data.frame(ID=c("Blank", "Blank", "x", "x", "Control1", "y", "x", "z", "y", "Control2"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(is.na(re[["nrOfReplicas"]]))

aD <- data.frame(ID=c("z", "x", "Control1", "y"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Control1"))
stopifnot(re[["nrOfReplicas"]] == 1 )

aD <- data.frame(ID=c("Blank", "x", "x", "Control1", "y", "z", "z", "y", "Control2"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(re[["nrOfReplicas"]] == 2 )
 }
  }

 \author{Andreas Buness <a.buness@dkfz.de>}

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/exprSetRG-class.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



\name{exprSetRG-class}
\docType{class}

\alias{exprSetRG-class}
\alias{exprSetRG}

  ##\alias{cbind} ## cf. help for cbind.exprSetRG
\alias{as.exprSet}
\alias{getExprSetGreen}
\alias{getExprSetGreenMinusRed}
\alias{getExprSetRedMinusGreen}
\alias{getExprSetRed}
\alias{getExprSetLogRatio}
\alias{getIndGreen}
\alias{getIndRed}
\alias{pDataGreen}
\alias{pDataRed}
\alias{pDataSlide}
\alias{phenoDataGreen}
\alias{phenoDataRed}
\alias{phenoDataSlide}
\alias{slideSubset}

\alias{[,exprSetRG-method}
  ##\alias{cbind,exprSetRG,exprSetRG-method} ## cf. help for cbind.exprSetRG
\alias{as.exprSet,exprSetRG-method}
\alias{getExprSetGreen,exprSetRG-method}
\alias{getExprSetGreenMinusRed,exprSetRG-method}
\alias{getExprSetRedMinusGreen,exprSetRG-method}
\alias{getExprSetRed,exprSetRG-method}
\alias{getExprSetLogRatio,exprSetRG-method}
\alias{getIndGreen,exprSetRG-method}
\alias{getIndRed,exprSetRG-method}
\alias{initialize,exprSetRG-method}
\alias{pDataGreen,exprSetRG-method}
\alias{pDataRed,exprSetRG-method}
\alias{pDataSlide,exprSetRG-method}
\alias{phenoDataGreen,exprSetRG-method}
\alias{phenoDataRed,exprSetRG-method}
\alias{phenoDataSlide,exprSetRG-method}
\alias{show,exprSetRG-method}
\alias{slideSubset,exprSetRG-method}



 \title{Class exprSetRG for two colour DNA microarray data
        (extension of exprSet)} 

 \description{ This is a class representation for two colour
               DNA microarray data. The class is based on the
               class \code{exprSet} of the \code{Biobase} package.
               The red and green channels  are stored in a
               single \code{exprSet} object. The information on the
               corresponding red-green pairs is stored separately.
               Several class methods offer a convienent way
               to access and set data.
               }


\section{Creating Objects}{
\code{  new('exprSetRG',}\cr
\code{    channels = ..., # object of class matrix with columns "green" and "red" }\cr
\code{    exprs    = ..., # object of class matrix}\cr
\code{    se.exprs = ..., # object of class matrix}\cr
\code{    phenoData= ..., # object of class phenoData}\cr
\code{    notes    = ..., # object of class character}\cr
\code{    annotation    = ..., # object of class character}\cr
\code{  )}}

\section{Slots}{
  \describe{
    \item{\code{indGreen}:}{Object of class \code{vector}; indexes of the
      green channel}
    \item{\code{indRed}:}{Object of class \code{vector}; indexes of the
      red channel}
    \item{\code{exprs}:}{Object of class \code{matrix}; the observed
      expression levels. This is a matrix with columns representing
      the red and green channels and rows representing genes. Each row
      in \code{channels} lists the indexes of the corresponding
      pair of red and green channels representing a single
      microarray slide.}
    \item{\code{se.exprs}:}{Object of class \code{matrix}; this is
      a matrix of the same dimensions as \code{exprs}, e.g. useful to
      represent the standard error estimates for the corresponding
      expression levels. }
    \item{\code{phenoData}:}{Object of class \code{phenoData}, i.e.
      an instance of class \code{phenoData} 
      containing annotation information on the individual channels.
      The columns of the pData slot of this entity represent
      variables and the rows represent channels. }
    \item{\code{notes}:}{Object of class \code{character} containing
      explanatory text; default: ""}
    \item{\code{annotation}:}{Object of class \code{character};
      default: ""}
  }
}

\section{Extends}{
Class \code{exprSet}, directly.
}


 \section{Methods}{
  \describe{

    \item{show}{(exprSetRG):
      renders information about the exprSetRG
      in a concise way on stdout, cf. class exprSet.}
    
    \item{getExprSetLogRatio}{(exprSetRG, seExprsHandling):
      Returns an \code{exprSet}
      object of the difference of the expression levels, i.e. the green
      channel minus the red channel. 
      The \code{phenoData} slot it the result
      of calling the class method \code{phenoDataSlide}
      on the object \code{exprSetRG}.
      The \code{se.exprs} slot contains
      the root-mean-square or the mean of the se.exprs of both channels
      depending on the argument \code{seExprsHandling}.
      The root-mean-square might be useful if the two
      se.exprs values are estimated standard deviations
      based on the same number observations and identical
      distribution. \code{seExprsHandling} must be a character string;
      possible values are "rootMeanSquare" or "mean";
      the default value is "rootMeanSquare". }

    \item{getExprSetGreenMinusRed}{ same as method
      \code{getExprSetLogRatio} }

    \item{getExprSetRedMinusGreen}{ similar to method
      \code{getExprSetLogRatio}; the "negative" difference
      of the expression levels is returned, i.e. the red
      channel minus the green channel.
      }

    \item{getExprSetGreen}{(exprSetRG): Returns an \code{exprSet}
      object which contains the expression levels of the green channel
      and the corresponding annotation.}
    
    \item{getExprSetRed}{(exprSetRG): Returns an \code{exprSet}
      object which contains the expression levels of the red channel
      and the corresponding annotation.}

    \item{phenoDataSlide}{(exprSetRG): Returns an \code{phenoData}
      object characterizing all microarray slides.
      Those annotation information, which is the same for both channels
      (and not \code{NA}) is taken directly, e.g. the
      the slide number. All other annotation variables are added
      specifically for each channel, i.e. prefixed with
      "greenSpecific\_" and "redSpecific\_".
      Do not use varLabels-names for subsetting.}
      
    \item{pDataSlide}{(exprSetRG): Returns an \code{pData}
      object, i.e. \code{pData(phenoDataSlide(exprSetRG))};
      cf. \code{phenoDataSlide}.
      Do not use varLabels-names for subsetting.}

    \item{phenoDataGreen}{(exprSetRG): Returns an \code{phenoData}
      object of the annotation information given for the green channel.
      Do not use varLabels-names for subsetting.}
      
    \item{pDataGreen}{(exprSetRG): Returns the \code{pData}
      object taken out of the result of calling \code{phenoDataGreen}.
      Do not use varLabels-names for subsetting.}

    \item{phenoDataRed}{(exprSetRG): Returns an \code{phenoData}
      object of the annotation information given for the red channel.
      Do not use varLabels-names for subsetting.}
      
    \item{pDataRed}{(exprSetRG): Returns the \code{pData}
      object taken out of the result of calling \code{phenoDataRed}.
      Do not use varLabels-names for subsetting.}

    \item{slideSubset}{(exprSetRG,i,j): Subsetting operation; where
      i corresponds to the rows  and j corresponds to the
      microarray slides.
      j is given by indexes or logicals related to the order
      of the channel pairs in \code{channels};
      cf. the constructor slot \code{channels}.}

    \item{getIndGreen}{(exprSetRG): An accessor function for slot
      \code{indGreen}. The corresponding elements of indGreen and indRed
      define microarray slides.}

    \item{getIndRed}{(exprSetRG): An accessor function for slot
      \code{indRed}. The corresponding elements of indGreen and indRed
      define microarray slides.}

    \item{[}{(exprSetRG,i,j,type):
      A subset operator.
      Ensures that both the data and the annotation
      information (\code{phenoData}) are subseted properly.
      This may only mix up the pairing of the channels,
      i.e. the validity of an exprSetRG,
      if you use argument option type == "invalidExprSetRG".
      Default: "validExprSetRG".}

    \item{cbind}{(...): Concatenates \code{exprSetRG} objects.
                        Genes (rows) are assumed to match;
                        cf. \code{\link{cbind.exprSetRG}} }

    \item{as.exprSet}{(exprSetRG): Class cast, returns an object of
      \code{exprSet}, the information on the red and green channesl
      is discarded.}
    
    } 
  }
}
 
 \keyword{classes}
 \keyword{methods}

 \examples{
  indGreen=1:3
  indRed=4:6
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  eSA <- new("exprSetRG", exprs=matrix(1:60, ncol=6, nrow=10), phenoData=
          new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)
  stopifnot( all(pDataSlide(eSA) ==pData(eSA)[1:3,,drop=FALSE]) )
  eSAGreen <- getExprSetGreen(eSA)
  eSARed <- getExprSetRed(eSA)
  eSALogRatio <- getExprSetLogRatio(eSA)
  eSALogRatio2 <- getExprSetGreenMinusRed(eSA)
  eSALogRatio3 <- getExprSetRedMinusGreen(eSA)
  stopifnot( identical( eSALogRatio, eSALogRatio2 ) )
  stopifnot( identical( exprs(eSALogRatio), exprs(eSAGreen)-exprs(eSARed)) )
  stopifnot( all.equal.numeric( exprs(eSALogRatio3), exprs(eSARed)-exprs(eSAGreen)) )
  eSAPart <- eSA[,c(1,3,1,4,6,4)]
  eSAInvalid <- eSA[,c(1,3,1,5,6,4),type="invalidExprSetRG"]
  eSAPart2 <- slideSubset(eSA,j=c(1,3,1))

  eSAeSA <- cbind(eSA, eSA)
  eSAeSAPart2 <- cbind(eSA, eSAPart2)
  stopifnot(is(as.exprSet(eSA), "exprSet"))
  \dontshow{
  stopifnot( identical( exprs(eSAPart), exprs(eSAPart2) ) )
  ind <- c(1,1,3,2,3,3)
  stopifnot( identical( exprs(eSALogRatio[,ind]), exprs(eSAGreen[,ind])-exprs(eSARed[,ind])) )
  stopifnot( dim(exprs(eSALogRatio[,ind]))[2] == length(ind) )
  eSAPart <- eSA[,1:3, type="invalidExprSetRG"] # not recommended
  stopifnot(identical(eSAGreen, getExprSetGreen(eSAPart)))
  stopifnot(identical(eSAGreen[,c(1,1,1)], getExprSetGreen(eSAPart[,c(1,1,1),type="invalidExprSetRG"])))
  stopifnot(identical(eSAGreen[,c(TRUE,TRUE,TRUE)], getExprSetGreen(eSAPart[,c(TRUE,TRUE,TRUE),type="invalidExprSetRG"])))
  stopifnot(identical(eSAGreen[,c(FALSE,FALSE,FALSE)], getExprSetGreen(eSAPart[,c(FALSE,FALSE,FALSE), type="invalidExprSetRG"])))
  stopifnot(identical(eSAGreen[,c(FALSE,TRUE,FALSE)], getExprSetGreen(eSAPart[,c(FALSE,TRUE,FALSE), type="invalidExprSetRG"])))
  print(eSA)
  print(phenoDataSlide(eSA))
  print(pDataSlide(eSA))
  print(phenoDataGreen(eSA))
  print(pDataGreen(eSA))
  print(phenoDataRed(eSA))
  print(pDataRed(eSA))

  indGreen <- c(2,4); indRed <- c(1,3)
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  myPData <- data.frame(commonOne=c(1,1,2,2), first=c(1,2,3,4))
  myPDataTwo <- data.frame(commonOne=c(1,1,2,2), second=c("a","b","a","b"))
  myPDataThree <- data.frame(commonOne=c(1,1,2,2))
  myPhenoData <- new("phenoData", pData=myPData, varLabels=as.list(colnames(myPData)))
  myPhenoDataTwo <- new("phenoData", pData=myPDataTwo, varLabels=as.list(colnames(myPDataTwo)))
  myPhenoDataThree <- new("phenoData", pData=myPDataThree, varLabels=as.list(colnames(myPDataThree)))
  myMatrix <- cbind(c(1,1,1,1),c(2,2,2,2),c(3,3,3,3),c(4,4,4,4))
  myExprSetRG <- new("exprSetRG", exprs=myMatrix, se.exprs=myMatrix, phenoData=myPhenoData, channels=channels)
  myExprSetRGTwo <- new("exprSetRG", exprs=myMatrix, se.exprs=myMatrix, phenoData=myPhenoDataTwo, channels=channels)
  myExprSetRGThree <- new("exprSetRG", exprs=myMatrix, se.exprs=myMatrix, phenoData=myPhenoDataThree, channels=channels)
  stopifnot( all.equal.numeric(se.exprs(getExprSetGreen(myExprSetRG)), cbind(c(2,2,2,2),c(4,4,4,4))))
  stopifnot( all.equal.numeric(se.exprs(getExprSetRed(myExprSetRG)), cbind(c(1,1,1,1),c(3,3,3,3))))
  stopifnot( all.equal.numeric(se.exprs(getExprSetLogRatio(myExprSetRG, seExprsHandling="mean")), 0.5*cbind(c(3,3,3,3),c(7,7,7,7))))
  stopifnot( all.equal.numeric(as.vector(se.exprs(myExprSetRG[2,])) , c(1,2,3,4)) )
  stopifnot( all.equal.numeric(as.vector(se.exprs(myExprSetRG[2,3:4])) , c(3,4)) )
  stopifnot( all.equal.numeric( se.exprs(cbind(myExprSetRG,myExprSetRG)), cbind(se.exprs(myExprSetRG),se.exprs(myExprSetRG))) )
  stopifnot( all.equal.numeric(exprs(getExprSetLogRatio(myExprSetRG)), matrix(1,ncol=4,nrow=2))) 
  cTwo <- cbind(myExprSetRG, myExprSetRGTwo)
  cThree <- cbind(myExprSetRG, myExprSetRGTwo, myExprSetRGThree)
  cTwob <- cbind(myExprSetRG, myExprSetRGThree)
  # match corresponds to \%in\% , i.e. %in%
  stopifnot( all( match(varLabels(cTwo),  c("commonOne", "first", "second")) ) ) 
  stopifnot( all( match(varLabels(cTwob),c("commonOne", "first")) ) )
  stopifnot( all( match(varLabels(cThree), c("commonOne", "first", "second")) ) )
  stopifnot( all( pData(cTwo)[,"commonOne"] ==  pData(cTwob)[,"commonOne"] ) )

  indGreen <- c(2,4,6); indRed <- c(1,3,5)
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  myPData <- data.frame(commonOne=c(1,1,2,2,3,3), commonTwo=c(1,1,1,1,2,2), redOne=c(1,NA,2,NA,3,NA), redTwo=c(1,-1,2,-1,3,-1), greenOne=c(NA,10,NA,20,NA,30), greenTwo=c(-10,10,-10,20,-10,30))
  myPhenoData <- new("phenoData", pData=myPData, varLabels=as.list(colnames(myPData)))
  myExprSetRG <- new("exprSetRG", exprs=matrix(1,nrow=10,ncol=6), phenoData=myPhenoData, channels=channels)
  stopifnot( all.equal( myPData[indRed,] , pDataRed(myExprSetRG) ) )
  stopifnot( all.equal( myPData[indGreen,] , pDataGreen(myExprSetRG) ) )
  stopifnot( all.equal( myPhenoData[indRed,] , phenoDataRed(myExprSetRG) ) )
  stopifnot( all.equal( myPhenoData[indGreen,] , phenoDataGreen(myExprSetRG) ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("commonOne","commonTwo")] == pDataRed(myExprSetRG)[,c("commonOne","commonTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("commonOne","commonTwo")] == pDataGreen(myExprSetRG)[,c("commonOne","commonTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("greenSpecific_greenOne","greenSpecific_greenTwo")] == pDataGreen(myExprSetRG)[,c("greenOne","greenTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("redSpecific_redOne","redSpecific_redTwo")] == pDataRed(myExprSetRG)[,c("redOne","redTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("greenSpecific_redTwo")] == pDataGreen(myExprSetRG)[,c("redTwo")] ) )
  stopifnot( all( pDataSlide(myExprSetRG)[,c("redSpecific_greenTwo")] == pDataRed(myExprSetRG)[,c("greenTwo")] ) )
  }
 }

  ## no link found for exprSet-class
  \seealso{ \code{exprSet-class},
            \code{\link{arrayData-class}}
          }

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{fdc}
\alias{fdc}

\title{FDC (false discovery count)}
\description{Estimate the FDC (false discovery count) through permutations}

\usage{fdc(x, fac,
  teststatfun = "rowFtests",
  nrperm      = 100,
  nrgenesel   = c(10, 20, 40, 60, 80, 100, 200),
  ...)
} 

\arguments{
  \item{x}{Matrix.}
  \item{fac}{Factor, with \code{length(fac)=ncol(x)}.}
  \item{teststatfun}{Character. Name of a function that takes arguments
    \code{x} and \code{fac}, and returns a list with component
    \code{statistic}. See for example \code{\link{rowFtests}}.}
  \item{nrperm}{Numeric. Number of permutations.}
  \item{nrgenesel}{Numeric. A vector with the 'number of genes' for which
    the FDC is to be calculated.}
  \item{...}{Further arguments passed to code{teststatfun}.}
}

\value{  
  A list with elements
  \code{stat}: the test statistics;
  \code{mpstat}: median permuted test statistics;
  \code{fdc}: estimated false discovery counts;
  \code{thresh}: the threshholds associated with \code{nrgenesel};
  \code{nrgenesel}
}

\author{Wolfgang Huber <w.huber@dkfz.de>}
\seealso{\code{\link{rowFtests}}}
\examples{
   ## data matrix: 2000 genes, 16 samples
   x  <- matrix(runif(2000*16), ncol=16)
   ## 8 blue and 8 red samples
   fac <- factor(c(rep("blue", 8), rep("red", 8)))
   ## implant differential signal into the first 50 genes
   x[1:50, fac=="blue"] <- x[1:50, fac=="blue"] + 1

   res <- fdc(x, fac)
   plot(res$nrgenesel, res$fdc, pch=16, col="blue",
       xlab="Number of genes selected",
       ylab="Expected number of false discoveries")
   abline(a=0, b=1, col="red", lwd=2)

   qqplot(res$stat, res$mpstat, pch=".")
   abline(a=0, b=1, col="red", lwd=2)

}
 
\keyword{math}

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/interweave.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{interweave}

 \title{interweave}

 \alias{interweave}

 \description{
          The first object is "interweaved" with the second object
          and the resulting object with the following object and
          continued as long as the last object is reached.
          Note: \code{AsIs} class objects are coerced to a vector
                before interweaving starts.}

 \value{An "interweaved" object, cf. example.}

 \usage{interweave(...)}

 \arguments{
  \item{...}{vectors, matrices, one- and two-dimensional arrays;
             an \code{AsIs} class object is coerced to a vector.}
 }
 
 \examples{
    x <- seq(1,100,2)
    y <- seq(2,100,2)
    z <- interweave(x,y)
    stopifnot( all.equal(z,1:100) )
	}

 \keyword{manip}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/normalise.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{normalise}

 \title{Normalisation of Microarray Data}

 \alias{normalise}

 \keyword{utilities}

 \usage{normalise(arrayDataObject, subtractBackground = FALSE, method = "vsn", subGroups = NULL, channelsSeparately = FALSE, hybridisationGroups, spotIdentifier, verbose = TRUE)}

 \description{An object of class \code{\link{exprSetRG}} is generated
              which contains the resulting normalised data.}

 \arguments{
  \item{arrayDataObject}{object of class \code{\link{arrayData}};
                         required; default missing.
                 \code{arrayDataObject} must contain the raw data, i.e.
                 a three dimensional array
                 (spot x channel x hybridisation),
                 cf. the class methods \code{\link{getIntensities}}
                 and \code{\link{intensities<-}},
                 and must contain information
                 on the hybridisations,
                 cf. class methods \code{\link{getHybAttr}} and
                 \code{{hybAttrList<-}}.
                 If the argument \code{subGroups} (see below)
                 is specified it must also contain 
                 information on the spots, cf. the class methods
                 \code{\link{getSpotAttr}} and
                 \code{\link{spotAttr<-}}.
                 Note: Weights are only used by loess-type normalisations.
                }
  \item{subtractBackground}{logical; default: \code{FALSE}}
  \item{method}{character string; required; default: "\code{vsn}";
        possible values:
        "\code{none}", "\code{vsn}", "\code{quantile}",
        "\code{loess}", "\code{loessScale}", "\code{loessQuantile}".
        Note: "\code{quantile}" and  "\code{loess*}" normalisation
              transforms the data to the (natural) logarithmic scale.
        Note: Weights are only used by loess-type normalisations.
        Note: "\code{loessScale}" and "\code{loessQuantile}" refer
              to a loess normalisation followed by a
              between slide normalisation, cf. the function
              \code{normalizeBetweenArrays} of the
              \code{limma} package.
        Note: "\code{quantile}" and  "\code{loess*}" normalisations
              do call the corresponding methods of the \code{limma} package
              and "\code{vsn}" uses the \code{vsn} package.
        }
  \item{subGroups}{character string or \code{NULL};
                   required; default: \code{NULL};
                   \code{subGroups} allows to define subgroups
                   of spots of each hybridisation
                   which are normalised separately like a 
                   print-tip normalisation.
                   The list must contain a column name refering to the
                   \code{data.frame} of \code{getSpotAttr(arrayDataObject)}.
                   In case of GenePix data you may for example
                   specify the column name "Block".
                   The column itself must contain integer values.
                   Note: In case of \code{method == "vsn"},
                   \code{vsn} is called with
                   the argument \code{strata}, which differs
                   to a separate normalisation of each subgroup
                   with \code{vsn} itself. 
                   }
  \item{channelsSeparately}{logical; required; default: \code{FALSE};
                            If \code{channelsSeparately} ist set to \code{TRUE}
                            each channel is normalised separately. Only meaningful
                            for single channel normalisation methods like
                            "\code{vsn}" and
                            "\code{quantile}" normalisation
                            but not for ratio based
                            normalisation like "\code{loess}".}
  \item{hybridisationGroups}{list of vectors of indexes or
                             the character string "slideBySlide";
                             optional; default: missing.
                             Each group of hybridisations
                             is normalised separately. If
                             missing all hybridisations are
                             taken as one group. Only meaningful for
                             normalisation methods like "vsn" and "quantile".
                             The indexes must refer to the third
                             dimension of \code{getIntensities(arrayDataObject)}
                             and have to contain all hybridisations.
                             }
  \item{spotIdentifier}{ character string; optional; default missing.
                         \code{spotIdentifier} specifies the column
                         of \code{getSpotAttr(arrayDataObject)} which must
                         contain non-unique spot or gene identifiers.
                         The identifiers are used as names for the
                         resulting \code{exprSetRG}-object; cf. the function
                         \code{geneNames} of the \code{exprSetRG-class}. }
  \item{verbose}{ logical; required; default: \code{TRUE}}

 }

 \value{object of class \code{\link{exprSetRG}} }

 \seealso{ 
           \code{\link{exprSetRG-class}},
           \code{\link{processArrayData}},
           \code{\link{processArrayDataObject}}
         }

 \author{Andreas Buness <a.buness@dkfz.de>}
 \examples{

       intensities <- array(data=runif(720),dim=c(120,2,3))
       dimnames(intensities) <- list(NULL, c("green","red"), NULL)
       hybAttr <- data.frame(Name=I(c("hx","hy","hz")), Index=c(1:3))
 	arrayDataObject <- new("arrayData",
                              intensities=intensities,
                              hybAttrList=list(red=hybAttr,green=hybAttr)
                             )
       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( nRed, intensities[,"red",] ) )
       stopifnot( all.equal.numeric( nGreen, intensities[,"green",] ) ) 

   \dontshow{
       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               channelsSeparately = TRUE,
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( nRed, intensities[,"red",] ) )
       stopifnot( all.equal.numeric( nGreen, intensities[,"green",] ) )

       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               hybridisationGroups= list(c(1,3),2),
                               verbose = FALSE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( nRed, intensities[,"red",] ) )
       stopifnot( all.equal.numeric( nGreen, intensities[,"green",] ) ) 

       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = FALSE,
                               method = "none",
                               channelsSeparately = TRUE,
                               hybridisationGroups= list(c(2,3),1),
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( nRed, intensities[,"red",] ) )
       stopifnot( all.equal.numeric( nGreen, intensities[,"green",] ) ) 

       intensities <- array(data=runif(1440),dim=c(120,4,3))
       dimnames(intensities) <- list(NULL,
                                     c("green","red","greenBackground","redBackground"),
                                     NULL)
       intensities[,c("greenBackground","redBackground"),] <- -1
       hybAttr <- data.frame(Name=I(c("hx","hy","hz")), Index=c(1:3))
 	arrayDataObject <- new("arrayData",
                              intensities=intensities,
                              hybAttrList=list(red=hybAttr,green=hybAttr)
                             )
       exprSetRGObject <- normalise(arrayDataObject = arrayDataObject,
                               subtractBackground = TRUE,
                               method = "none",
                               channelsSeparately = TRUE,
                               hybridisationGroups= list(c(2,3),1),
                               verbose = TRUE
                               )
       nRed <- exprs(getExprSetRed(exprSetRGObject))
       nGreen <- exprs(getExprSetGreen(exprSetRGObject))
       stopifnot( all.equal.numeric( nRed, (intensities[,"red",] + 1) ) )
       stopifnot( all.equal.numeric( nGreen, (intensities[,"green",] + 1) ) )

   }      
 }

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:41.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/plot.imageMatrix.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{plot.imageMatrix}

 \title{Visualisation of a matrix}

 \alias{plot.imageMatrix}

 \keyword{hplot}

 \description{Visualisation of a data matrix, e.g. a matrix representing
  a two dimensional area, a matrix of distance or similarity scores,
  or any numeric matrix. Coloured boxes represent values, labels will
  be drawn inside the box.}

 \usage{plot.imageMatrix(x, labelMatrix, zlim, separateZScale=FALSE, zScale=TRUE, colourRamp, reverseYaxis = TRUE, labels, xLabels, yLabels, width=8, height=7, labelMatrixTextScaling=0.7, plotOutput="standard", fileName, ...)}

 \arguments{
  \item{x}{data matrix, class \code{matrix}; required; default missing}
  \item{labelMatrix}{matrix of labels of class \code{array} of dim(\code{x});
                     optional; default missing}
  \item{zlim}{numeric vector; defines the maximal z-range of the plot;
              default missing}
  \item{zScale}{logical; adds a scale to the plot; required; default TRUE}
  \item{separateZScale}{logical; extra plot of the scale; required; default FALSE}
  \item{colourRamp}{vector of colours; optional; default missing}
  \item{reverseYaxis}{logical; required; default \code{TRUE}}
  \item{labels}{vector of names corresponding to  a quadratic \code{x};
                optional; default missing}
  \item{xLabels}{vector of names corresponding to the columns of
                 \code{x} overrides \code{labels}; optional; default missing}
  \item{yLabels}{vector of names corresponding to the rows of
                 \code{x} overrides \code{labels}; optional; default missing}
  \item{width}{graphics window width; required; default: 8}
  \item{height}{graphics window height; required; default: 7}
  \item{labelMatrixTextScaling}{numeric; required; default: 0.7}

  \item{plotOutput}{character string specifying
          either "standard", "screen", "twoScreens", "pdf" or "win.metafile";
          required; default: "standard"}
  \item{fileName}{character string specifying the file path and file name;
                  optional; default missing}
  \item{...}{arguments are passed to \code{image}(), for example
             \code{xlab}, \code{ylab} (x- and y-axis label) and
             \code{main} (plot title)}
 }

 \details{If no labels are supplied, the dimnames of \code{x} or if missing
          a simple numbering is used instead.}

 \examples{


 plot.imageMatrix(x=matrix(c(3,4,4,3),nrow=2, ncol=2),labels=c("one","two"))
 ma <- matrix(c(0.3,0.01,0.7,0.1,0.5,0.3,1,0.5,01), nrow=3,ncol=3)
 class(ma) <- c("imageMatrix", "matrix")
 plot(ma, labelMatrix=ma,labels=c("one","two", "three"), zlim=c(0,1))
 ma <- matrix(c(0.3, 0.01, 0.7, 0.1, 0.5, 0.3, 1, 0.5, 1, 0, 1, 0), nrow = 4, ncol = 3, byrow=TRUE )
 class(ma) <- c("imageMatrix", "matrix")
 plot(ma, labelMatrix = ma, xLabels = c("one", "two", "three"), zlim=c(0,1))
 plot(ma, reverseYaxis=FALSE, labelMatrix = ma, xLabels = c("one", "two", "three"), zlim=c(0,1))

\dontshow{

 plot.imageMatrix(main="Similarities",x=matrix(c(3,4,4,3),nrow=2, ncol=2),labels=c("one","two"))
 ma <- matrix(c(0.3,0.01,0.7,0.1,0.5,0.3,1,0.5,01), nrow=3,ncol=3)
 plot.imageMatrix(main="Similarities",x=ma, labelMatrix=ma,labels=c("one","two", "three"), zlim=c(0,1))
 ma <- matrix(c(0.3, 0.01, 0.7, 0.1, 0.5, 0.3, 1, 0.5, 1, 0, 1, 0), nrow = 4, ncol = 3, byrow=TRUE )
 plot.imageMatrix(main = "x", x = ma, labelMatrix = ma, xLabels = c("one", "two", "three"), zlim=c(0,1) )

}


 }

 \author{Andreas Buness <a.buness@dkfz.de>}

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:42.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/plotDistributions.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{plotDistributions}

 \title{Visualise Distributions}

 \alias{plotDistributions}

 \usage{plotDistributions(dataMatrix, transFunc, quantiles, main, labels, xlab, ylab, colourVector, width=8, height=6, fileName="plotDistributionsOutput", savePath, plotOutput="standard")}

 \keyword{hplot}

 \description{Boxplot like visualisation of distributions, only the boxes,
   i.e. the median and the second and third quartile are plotted
   (cf. \code{boxplot.stats} for the details on the calculation).
   The plots may help to identify shortcomings of the raw data
   or normalised data. The argument \code{quantiles} can be used
   to visualize two or three arbitrary quantiles with boxes.}

 \value{The function is called for its side effect.}


 \arguments{
  \item{dataMatrix}{numeric data matrix,
                    where columns represent distributions, e.g.
                    raw array data or normalised data;
                    required; default missing}
  \item{transFunc}{unary function; optional; default missing.
                   Data transformation function, e.g. log}
  \item{quantiles}{missing by default; a vector of two or
          three increasing quantiles used to determine the boxes to be drawn}
  \item{main}{plot title; type character string; optional; default missing}
  \item{labels}{vector of names, may substitute column names
                of \code{dataMatrix}; optional; default missing}
  \item{xlab}{label for x axis; type character string; optional; default missing}
  \item{ylab}{label for y axis; type character string; optional; default missing}
  \item{colourVector}{vector of colours; optional; default missing}
  \item{width}{graphics window width; required; default: 8}
  \item{height}{graphics window height; required; default: 6}
  \item{fileName}{optional; default: "plotDistributionsOutput"}
  \item{savePath}{optional; default: missing}
  \item{plotOutput}{character string specifying
        either "standard", "screen", "pdf", "win.metafile"; default: "standard"}

 }
 
 \details{Default of \code{transFunc} is no transformation, i.e. identity.
          If \code{labels} are supplied at first the column names or
          secondly a numbering  are used instead.
          By default the \code{colourVector} is defined as alternating
          "darkred" and "darkgreen".}

 \seealso{\code{boxplot.stats}}

 \examples{
      plotDistributions(cbind(rnorm(100),rnorm(100)),
             main="Random Gaussians", labels = c("N1","N2"), ylab="scale")
      plotDistributions(as.matrix(1:100), quantiles=c(0.25,0.85),
             main = "Random Gaussians", labels = c("N1"), ylab = "scale")}
      plotDistributions(as.matrix(1:100), transFunc=log,
             quantiles=c(0.1,0.95), main = "Random Gaussians",
             labels = c("N1"), ylab = "scale")

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:42.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/processArrayData.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{processArrayData}

 \title{Automated processing of two colour DNA microarray data}

 \alias{processArrayData}

 \description{Automated processing of image analyis result files
              and related annotation information. Combines several
              steps of microarray data processing, read
              the package vignette for a detailed example. To access
              the vignette call openVignette()
              after calling library(arrayMagic).
	      }


 ## recall: the "value" is generated by the function processArrayDataObject

 \value{
        A list of objects, i.e.  an "exprSetRGObject" and an
        "arrayDataObject" with corresponding class types
        \code{\link{exprSetRG-class}} and
        \code{\link{arrayData-class}}.
        Side-effects: The result list "resultList" is stored
        as file \code{objectsFileName} in the directory \code{savePath}
        if the argument \code{objectsFileName} is supplied.
        The \code{slideDescriptionFile} is stored
        with suffix "\_processed"
        in the directory \code{savePath}.
 }

 \usage{processArrayData(spotIdentifier = "Name", verbose = TRUE, loadPath = ".", slideDescriptionFile = "slideDescription.txt", deleteBlanks = TRUE, fileNameColumn = "fileName", slideNameColumn, type = "GenePix", dataColumns = NULL, spotAnnoColumns = NULL, channelColumn = NULL, removePattern = NULL, skip = NULL, quote = "\"'", normalisationMethod = "vsn", subtractBackground=FALSE, spotsRemovedBeforeNormalisation = NULL, spotsRemovedAfterNormalisation = NULL, subGroups = NULL, channelsSeparately = FALSE, hybridisationGroups = NULL, savePath = ".", objectsFileName, plotOutput = "screen")}

 ## recall: arguments are divided into groups separated by empty lines ...

 \arguments{


  \item{spotIdentifier}{ character string; required; default "Name".
                         \code{spotIdentifier} specifies the column
                         in the image analysis result files which contain
                         spot or gene identifiers}
  \item{verbose}{ logical; required; default: \code{TRUE}}
                             

  \item{loadPath}{ character string; required; default: ".".
      The path is used for loading of the \code{slideDescriptionFile}
      and the image analysis result files;
      note: "." refers to the working directory.
      }

  \item{slideDescriptionFile}{ character string;
       required; default "slideDescription.txt".
       The first line of the tab-deliminated file
       must contain all column names, i.e. a header
       line. In particular it must contain the
       column named \code{fileNameColum} and possibly
       additionally a column named \code{slideNameColumn}. }



  \item{deleteBlanks}{ logical; required; default: \code{TRUE}.
                       If set to \code{TRUE} any blank character (space)
                       is removed from the text body of the
                       \code{slideDescriptionFile}. }



  \item{fileNameColumn}{ character string; required; default: "fileName".
                         \code{fileNameColumn} specifies the column which
                         contains the names of all
                         image analysis result files.}
  \item{slideNameColumn}{ character string; optional; default missing.
        If \code{slideNameColumn} is missing the value is set
        to \code{fileNameColumn}.}
  \item{channelColumn}{optional; cf. \code{\link{readIntensities}};
                       default: \code{NULL} }

  \item{type}{character string to characterize
              the file type like "GenePix" or "generic";
              note e.g. "generic" requires the arguments \code{dataColumns}
              and \code{spotAnnoColumns}; default: "GenePix"; cf.
              \code{\link{readIntensities}} for details}
  \item{dataColumns}{required for \code{type} "generic";
                     cf. \code{\link{readIntensities}}; default: \code{NULL} }
  \item{spotAnnoColumns}{required for \code{type} "generic";
                     cf. \code{\link{readIntensities}}; default: \code{NULL} }
  \item{removePattern}{optional; cf.  \code{\link{readIntensities}};
                       default: \code{NULL} }
  \item{skip}{optional; cf.  \code{\link{readIntensities}};
                       default: \code{NULL} }
  \item{quote}{ character string; cf. \code{\link{readIntensities}};
                required; default: \code{quote = "\"'"}}.





  \item{normalisationMethod}{character string; required; default: "vsn";
        cf. argument \code{method} of \code{\link{normalise}} }
  \item{subtractBackground}{ logical; required; default: \code{FALSE}
        cf. \code{\link{normalise}} }
  \item{spotsRemovedBeforeNormalisation}{ vector of character strings;
       required; default: \code{NULL}.
       All spots which match the string(s) will be excluded  
       already before normalisation and will not be present
       in the resulting objects at all.
       }
  \item{spotsRemovedAfterNormalisation}{ vector of character strings;
       required; default: \code{NULL};
       cf. argument \code{spotsRemovedBeforeNormalisation}.
       }
  \item{subGroups}{character string or \code{NULL};
                   required; cf. \code{\link{normalise}};
                   default: \code{NULL} }
  \item{channelsSeparately}{logical; required;
                            cf. \code{\link{normalise}};
                            default \code{FALSE}}
  \item{hybridisationGroups}{list of numeric vectors;
                             cf. \code{\link{normalise}};
                             required; default: \code{NULL}}
 




  \item{savePath}{ character string; required; default: ".".
      The directory \code{savePath} used to store
      the results (cf. argument \code{objectsFileName}
      and processed files.
      If the path does not exist a directory is created;
      note: "." refers to the working directory.
      }
  \item{objectsFileName}{character string; optional;
                         default missing, i.e. no file is created.
                         \code{objectsFileName} specifies
                         the name of the file used to store the object
                         "resultList", i.e. the return value of the function.
  }
  \item{plotOutput}{character string; required; default: "screen";
        Possible values: "screen", "pdf" or "win.metafile". }

 }

 \seealso{ \code{\link{readpDataSlides}},
           \code{\link{readIntensities}},
           \code{\link{processArrayDataObject}},
           \code{\link{normalise}},
           \code{\link{exprSetRG-class}},
           \code{\link{arrayData-class}}
         }

 \author{Andreas Buness <a.buness@dkfz.de>}


 \examples{

       LOADPATH <- file.path(.path.package("arrayMagic"), "extdata")
       SAVEPATH <- tempdir()
 	SLIDEDESCRIPTIONFILE <- "slideDescription"
  
 	resultList <- processArrayData(
                             loadPath=LOADPATH, 
  	                      savePath=SAVEPATH,
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE
                  )
       writeToFile(arrayDataObject=resultList$arrayDataObject,
                   exprSetRGObject=resultList$exprSetRGObject,
                   fileName="normalisedData.txt",
                   savePath=SAVEPATH)

       summarizedResult <- slideMerge(exprSetRGObject=resultList$exprSetRGObject, slideMergeColumn="replicates" )

        qPL <- qualityParameters(arrayDataObject=resultList$arrayDataObject,
                                 exprSetRGObject=resultList$exprSetRGObject)


        visualiseQualityParameters(qualityParameters=qPL$qualityParameters,
                                   savePath=tempdir())

        qualityDiagnostics(
                    arrayDataObject=resultList$arrayDataObject,
                    exprSetRGObject=resultList$exprSetRGObject,
                    qualityParametersList=qPL,
                    slideNameColumn="fileName",
                    savePath=tempdir(),
                    plotOutput="pdf")

        unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))
 	 resultListG <- processArrayData(
                             loadPath=LOADPATH, 
  	                      savePath=SAVEPATH,
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                             plotOutput="pdf",
                             hybridisationGroups = list((1:4),(5:9))
                  )
 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))
 resultListG2 <- processArrayData(
                             loadPath=LOADPATH, 
  	                      savePath=SAVEPATH,
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                             plotOutput="pdf",
                             objectsFileName = "exprSetRG.RData",
                             hybridisationGroups = "slideBySlide"
                                         )
 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))

 SLIDEDESCRIPTIONFILE <- "genericChannelsPerFile"
 spotAnnoColumns <- c("Index", "Label" , "Type" , "Name" , "ID" )
 dataColumns <- c("Normalized....","Average....","Normalized....","Average....")
 names(dataColumns) <- c("greenForeground","greenBackground",
 		      "redForeground","redBackground")

 resultGenericChannel <- processArrayData(
                                spotIdentifier="Index",
                                loadPath=LOADPATH, 
                                savePath=SAVEPATH,
                                slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                                normalisationMethod="none",
                                channelColumn="channel",
                                fileNameColumn="files",
                                slideNameColumn="name",
                                type="genericOneFilePerChannel",
                                spotAnnoColumns=spotAnnoColumns,
                                dataColumns=dataColumns
                            )

 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))
 SLIDEDESCRIPTIONFILE <- "genericChannelsPerFileTwo"
 dataColumns <- c("Integral..QL.","Bkg..QL.", "Integral..QL.","Bkg..QL.")
 names(dataColumns) <- c("greenForeground","greenBackground",
 		      "redForeground","redBackground")

 resultGenericChannelTwo <- processArrayData(
                                spotIdentifier="ID",
                                loadPath=LOADPATH, 
                                savePath=SAVEPATH,
                                slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                                normalisationMethod="vsn",
                                channelColumn="channel",
                                fileNameColumn="files",
                                slideNameColumn="name",
                                subtractBackground=TRUE,
                                type="genericOneFilePerChannel",
                                spotAnnoColumns=spotAnnoColumns,
                                dataColumns=dataColumns
                            )
 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))

  \dontshow{

    }     
 }
 
 \keyword{utilities}

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:42.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/processArrayDataObject.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{processArrayDataObject}


 \title{Automated processing and normalisation of an arrayData-object
        (part of function processArrayData)}

 \alias{processArrayDataObject}

 \keyword{utilities}

 \description{ Automated processing and normalisation of an
               \code{\link{arrayData}}-object.
               The function is called
               by \code{\link{processArrayData}}.
	}

 \value{
        A list of objects, i.e.  an "exprSetRGObject" and and
        "arrayDataObject" with corresponding class types
        \code{\link{exprSetRG-class}} and
        \code{\link{arrayData-class}}.
       }

 \usage{processArrayDataObject(arrayDataObject, spotIdentifier = "Name", verbose = TRUE, normalisationMethod = "vsn", subtractBackground=FALSE, spotsRemovedBeforeNormalisation = NULL, spotsRemovedAfterNormalisation = NULL, subGroups = NULL, channelsSeparately = FALSE, hybridisationGroups = NULL)}

 \arguments{

  \item{arrayDataObject}{object of class \code{\link{arrayData-class}};
                         required; default missing
                        }



  \item{spotIdentifier}{ character string; required; default "Name".
                         \code{spotIdentifier} specifies the column
                         in the image analysis result files which contain
                         spot or gene identifiers.}
  \item{verbose}{ logical; required; default: \code{TRUE} }



  \item{normalisationMethod}{character string; required; default: "vsn";
        cf. argument \code{method} of \code{\link{normalise}} }
  \item{subtractBackground}{ logical; required; default: \code{FALSE}
        cf. \code{\link{normalise}} }
  \item{spotsRemovedBeforeNormalisation}{ vector of character strings;
       required; default \code{NULL}.
       All spots which match the string(s) will be excluded  
       already before normalisation and will not be present
       in the resulting objects at all.
       }
  \item{spotsRemovedAfterNormalisation}{ vector of character strings;
       required; default: \code{NULL};
       cf. argument \code{spotsRemovedBeforeNormalisation}
       }
  \item{subGroups}{character string or \code{NULL};
                   required; cf. \code{\link{normalise}};
                   default: \code{NULL} }
  \item{channelsSeparately}{logical; required;
                            cf. \code{\link{normalise}};
                            default: \code{FALSE}}
  \item{hybridisationGroups}{list of numeric vectors;
                            cf. \code{\link{normalise}};
                            required; default: \code{NULL}}

 }

 \examples{
       LOADPATH <- file.path(.path.package("arrayMagic"), "extdata")
 	SLIDEDESCRIPTIONFILE <- "slideDescription"

       slideDescription <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE
                           )
 	arrayDataObject <- readIntensities(
                             loadPath=LOADPATH,
                             slideDescription=slideDescription
                          )

       resultList <- processArrayDataObject( arrayDataObject=arrayDataObject )
         
 }
 

 \seealso{ \code{\link{processArrayData}},
           \code{\link{normalise}},
           \code{\link{exprSetRG-class}},
           \code{\link{arrayData-class}}
         }

 \author{Andreas Buness <a.buness@dkfz.de>}

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:42.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/qualityDiagnostics.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{qualityDiagnostics}

 \title{Generates quality diagnostic plots}

 \alias{qualityDiagnostics}

 \usage{qualityDiagnostics(arrayDataObject, exprSetRGObject, qualityParametersList, slideNameColumn, savePath=".", completeOutput=FALSE, verbose=TRUE, plotOutput="pdf")}

 \description{Several quality diagnostic plots are generated.
              The distributions of the (normalised) intensities,
              as well as overall similarities between hybridisations and
              several other quality parameters are graphically visualised
              (cf. function \code{\link{qualityParameters}}).
             }

 \value{The function is called for its side effect.}


 \arguments{
  \item{arrayDataObject}{\code{\link{arrayData-class}};
                         required; default: missing}
  \item{exprSetRGObject}{\code{\link{exprSetRG-class}};
                         required, default: missing}
  \item{qualityParametersList}{the return value of
                               \code{\link{qualityParameters}}
                               required; default: missing}
                               
  \item{slideNameColumn}{character string; optional; default: missing;
                         specifies a column of
                         \code{pDataSlide(exprSetRGObject)}.}
  \item{savePath}{character string; required; default: "."}
  \item{completeOutput}{required; default: \code{FALSE}}
  \item{verbose}{ logical; required; default: \code{TRUE}}
  \item{plotOutput}{character string specifying the output type;
        either "screen", "pdf" or "win.metafile"; default: "pdf"}
 }
 
 \details{}

 \seealso{\code{\link{qualityParameters}},
          \code{\link{exprSetRG-class}},
          \code{\link{arrayData-class}}
         }

 \examples{
	}

 \keyword{hplot}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:42.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/qualityParameters.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{qualityParameters}

 \title{Calculation of quality characteristics for
        DNA microarray hybridisations}

 \alias{qualityParameters}

 \description{Several quality measures are calculated.
              The return value, i.e. a list of quality scores,
              should be used as input argument for the function
              \code{\link{qualityDiagnostics}}.
              For details on the quality measures
              read the value section. } 

 \usage{qualityParameters(arrayDataObject, exprSetRGObject, spotIdentifier = "Name", slideNameColumn = "slideName", identifiersToBeSkipped=NA, resultFileName, verbose = TRUE)}

 \value{returns a list of results, i.e. a
   \code{data.frame} \code{qualityParameters} containing
   several scores for each hybridisation, as well as
   pairwise comparisons, i.e.
   a matrix \code{slideDistance},
   a matrix \code{slideDistanceLogRaw},
   a matrix \code{slideDistanceGreen},
   a matrix \code{slideDistanceGreenLogRaw},
   a matrix \code{slideDistanceRed},
   a matrix \code{slideDistanceRedLogRaw},
   and an integer \code{replicateSpots},
   i.e. the number of detected spot replicas.
 
   The matrix \code{slideDistanceLogRaw} contains a  calculated
   distance (similarity) for each pair of slides$_{ij}$,
   i.e. the median absolute deviation (mad)
   taken over all spots of the log-ratio of the raw data;
   alike the matrix \code{slideDistance}
   the mad taken over all spots of the difference
   of the log-ratios 
   (here: the difference of the normalised and transformed
          expression values of the two channels on the slide).
   Similarly the matrices  \code{slideDistanceGreen},
   \code{slideDistanceGreenLogRaw},
   \code{slideDistanceRed},
   and \code{slideDistanceRedLogRaw} contain calculated distances
   for each pair of slides$_{ij}$ based on the mad of the difference
   of the same channel (normalised or logged) taken over all spots.
   

   A brief summary of all parameters given in
   the \code{data.frame} \code{qualityParameters}:

   \code{width}
   a robust estimate of the noise, i.e. the median absolute deviation
   of the difference of the normalised channels taken over all spots, i.e.
   the "width" of the scatterplot

   \code{medianDistance}
   a robust measure for the typical distance (similarity) of one slide
   with all other slides, i.e. the median of the "distances"
   between slides (c.f. \code{slideDistance}))

   \code{correlation(LogRaw)}
   of the expression values between the two normalised (log raw) channels
   of the slide taken over all spots

   \code{meanSignalGreen}
   the mean taken over all spots of the green raw data channel 

   \code{meanSignalRed}
   the mean taken over all spots of the red raw data channel

   \code{meanSignal}
   mean taken over all spots of the raw data of both channels,

   \code{signalRangeGreen}
   the range between the 10th and 95th percentile
   of the signal intensities given in the green raw data channel

   \code{signalRangeRed}
   the range between the 10th and 95th percentile
   of the signal intensities given in the red raw data channel

   \code{backgroundRangeGreen}
   the range between the 10th and 95th percentile
   of the background intensities given in the green raw data channel

   \code{backgroundRangeRed}
   the range between the 10th and 95th percentile
   of the background intensities given in the red raw data channel

   \code{signalToBackgroundGreen}
   the ratio of the median signal intensity and the median background
   intensity given in the green raw data channel

   \code{signalToBackgroundRed}
   the ratio of the median signal intensity and the median background
   intensity given in the red raw data channel

   \code{spotReplicatesConcordanceGreen(LogRaw)}
    the median of the standard deviations of all spot replicas
    for each unique identifier
    of the normalised (log raw) green channel is calculated;
    in case of duplicates, i.e.
    \code{replicateSpots == 2},
    the Pearson and Spearman correlation is calculated instead

   \code{spotReplicatesConcordanceGreen(LogRaw)}
    the median of the standard deviations of all spot replicas
    for each unique identifier
    of the normalised (log raw) green channel is calculated;
    in case of duplicates, i.e.
    \code{replicateSpots == 2},
    the Pearson and Spearman correlation is calculated instead

   \code{greenvsAllGreen} and \code{redvsAllRed}
   the correlation between each channel is measured against the
   averaged (median) channel over all hybridisations
   (like a virtual reference) separately for each channel
 }


 \arguments{
  \item{arrayDataObject}{object of type \code{\link{arrayData}};
                         required; default: missing}
  \item{exprSetRGObject}{object of type \code{\link{exprSetRG}};
                         required; default: missing}
  \item{spotIdentifier}{ character string; required; specifies a
                         column of \code{getSpotAttr(arrayDataObject)};
                         the column is used to determine spot replicas;
                         default: "Name"}
  \item{slideNameColumn}{ character string; required; specifies a
                          column of \code{getHybAttr(arrayDataObject)};
                          the column is used to extract the names
                          of the hybridisations; if not found
                          the hybridisations are consecutively numbered;
                          default: "slideName"}
  \item{identifiersToBeSkipped}{vector of character strings of
                                spot identifiers to be excluded
                                from calculations;
                                required; default: \code{NA}}
  \item{resultFileName}{character string; results are stored
                        in a tab-deliminated file if supplied;
                        default: missing}
  \item{verbose}{logical; default \code{TRUE}}
 }
 
 \details{For details on the quality measures read the value section.}

 \seealso{\code{\link{qualityDiagnostics}}}

  \examples{
      spotIdentifierVec <- c("A","A","Blank","B","B","Blank")
      hybNames <- "H1"
      R1 <- N1 <- c(1,1,9,2,2,10)
      R2 <- N2 <- c(2,2,7,4,4,8)
      rawDataIntensityValues <- array(0, dim=c(6,2,1))
      rawDataIntensityValues[,1,] <- R1
      rawDataIntensityValues[,2,] <- R2
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      spotAttr <- data.frame(Name=I(spotIdentifierVec))
      hybAttr <- data.frame(slideName=I(hybNames))
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      indGreen <- 1
      indRed <- 2
      channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
      colnames(channels) <- c("green","red")
      exprSetRGObject <- new("exprSetRG", 	
      exprs <- matrix(c(R1,R2), nrow=6, byrow=FALSE), phenoData=	
          new("phenoData", pData=data.frame(matrix(0,nrow=2,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)		
      Re1 <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")
      stopifnot(all.equal.numeric(as.numeric(Re1$qualityParameters["H1",c("correlation")]),c(1)))
      stopifnot(Re1$replicateSpots==2)

   \dontshow{

      hybNames <- c(hybNames,hybNames)
      hybAttr=data.frame(slideName=I(hybNames))
      rawDataIntensityValues <- array(0, dim=c(6,2,2))
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      rawDataIntensityValues[,1,] <- c(R1,R1)
      rawDataIntensityValues[,2,] <- c(R2,R2)
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      channels <- rbind(channels, channels+2)
      exprSetRGObject <- new("exprSetRG", 	
	exprs=matrix(c(R1,R1,R2,R2), nrow=6, byrow=FALSE), phenoData=	
             new("phenoData", pData=data.frame(matrix(0,nrow=4,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)
      Re1 <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")
      stopifnot(Re1$replicateSpots==2)
      stopifnot(all.equal.numeric(as.numeric(unlist(Re1$qualityParameters[, grep( "spotReplicatesConcordance", colnames(Re1$qualityParameters) )])), rep(1,(length(hybNames)*length(grep( "spotReplicatesConcordance", colnames(Re1$qualityParameters)) ))) ))

      spotIdentifierVec <- c("Blank","A","A","A","B","B","B")
      R1 <- N1 <- c(10,1,1,1,2,2,2)
      R2 <- N2 <- c(11,2,2,2,4,4,4)
      rawDataIntensityValues <- array(0, dim=c(7,2,1))
      rawDataIntensityValues[,1,] <- R1
      rawDataIntensityValues[,2,] <- R2
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      spotAttr=data.frame(Name=I(spotIdentifierVec))
      hybNames <- "H1"
      hybAttr=data.frame(slideName=I(hybNames))
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      indGreen=1
      indRed=2
      channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
      colnames(channels) <- c("green","red")
      exprSetRGObject <- new("exprSetRG", 	
	exprs=matrix(c(R1,R2), nrow=7, byrow=FALSE), phenoData=	
          new("phenoData", pData=data.frame(matrix(0,nrow=2,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)		


      Re2 <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")

      stopifnot(all.equal.numeric(as.numeric(Re2$qualityParameters["H1",c("correlation")]),c(1)))
      stopifnot(Re2$replicateSpots==3)

      rawDataIntensityValues[1,1,1] <- NA
      intensities(arrayDataObject) <- rawDataIntensityValues
      Re2NA <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")

      hybNames <- c("H1","H2")
      Xr1 <- Xn1 <- cbind(R1,R2)
      Xr2 <- Xn2 <- cbind(R2,R1)
      rawDataIntensityValues <- array(0, dim=c(7,2,2))
      rawDataIntensityValues[,1,1:2] <- Xr1
      rawDataIntensityValues[,2,1:2] <- Xr2
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      spotAttr=data.frame(Name=I(spotIdentifierVec))
      hybAttr=data.frame(slideName=I(hybNames))
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      indGreen=1:2
      indRed=3:4
      channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
      colnames(channels) <- c("green","red")
      exprSetRGObject <- new("exprSetRG", 	
	exprs=as.matrix(cbind(Xr1,Xr2)), phenoData=	
          new("phenoData", pData=data.frame(matrix(0,nrow=4,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)	   

      Re3 <- qualityParameters(arrayDataObject=arrayDataObject,
                               exprSetRGObject=exprSetRGObject,
                               identifiersToBeSkipped= "Blank",
                               resultFileName=file.path(tempdir(),"qP.txt"))

      Re3 <- qualityParameters(arrayDataObject=arrayDataObject,
                               exprSetRGObject=exprSetRGObject,
                               identifiersToBeSkipped= "Blank")

      stopifnot(all.equal.numeric(as.numeric(Re3$qualityParameters["H2",c("correlation")]),c(1)))
      stopifnot(Re3$replicateSpots==3)
   }

	}

 \keyword{utilities}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/readIntensities.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{readIntensities}

 \title{readIntensities}

 \alias{readIntensities}

 \description{
              The function takes the \code{data.frame}
              \code{slideDescription} as input and reads
              the listed image analysis raw data files of
              the column \code{slideNameColumn}; cf.
              function \code{\link{readpDataSlides}}. Each
              image analysis raw data file must contain
              tab separated columns and a header line -
              not necessarily at the top of the file; cf.
              the arguments \code{removePattern} and
              \code{skip}. Each file may only contain the
              information for one channel, cf. argument
              \code{channelColumn}.
              The raw data information is returned as an
              object of class \code{\link{arrayData}}.
              Note: All image analysis quantification
              (=raw data) files have to correspond
              to the same type of microarray.
             }

 \details{Details on the argument \code{type}:
     \code{type="GenePix"} defines 
     \code{spotAnnoColumns =  c("Block", "Column", "Row", "Name", "ID")}
     and
     \code{dataColumns = c("F532.Median", "B532.Median",
                           "F635.Median", "B635.Median")} and corresponding
     \code{names(dataColumns) = c("greenForeground", "greenBackground",
      "redForeground", "redBackground")}, a dynamically determined argument 
     \code{skip =  grep("Block...Column", imageFile) - 1} and
     \code{removePattern = NULL},
     whereas
     \code{type="ScanAlyze"} defines
     \code{spotAnnoColumns = c( "HEADER", "SPOT", "GRID", "ROW", "COL" )}
     and
     \code{dataColumns = c("CH1I", "CH1B", "CH2I", "CH2B")} and corresponding
     \code{names(dataColumns) = c("greenForeground", "greenBackground",
                                  "redForeground", "redBackground")},
     \code{skip = 0} and
     \code{removePattern = "^REMARK"}.
     }   
 \usage{readIntensities(slideDescription, fileNameColumn="fileName", slideNameColumn, channelColumn = NULL, loadPath=".", type = "GenePix", spotAnnoColumns = NULL, dataColumns = NULL, removePattern = NULL, skip = NULL, spotIdentifier, quote = "\"'", verbose = TRUE)}

 \arguments{
  \item{slideDescription}{\code{data.frame}; required; default: missing.
         (cf. the return value of the function \code{\link{readpDataSlides}})
         The \code{data.frame} must contain at least one column;
         this column has to be named as the argument \code{fileNameColumn}.
         It may additionally contain a column named \code{slideNameColumn}.
                         }
  \item{fileNameColumn}{ character string; required; default: "fileName".
                         \code{fileNameColumn} specifies the column which
                         contains all image quantification result files
                         in the \code{data.frame} of argument
                         \code{slideDescription}.}
  \item{slideNameColumn}{ character string; optional; default missing;
        refers to the \code{data.frame} of argument \code{slideDescription}.
        If \code{slideNameColumn} is missing the value is set
        to \code{fileNameColumn}.}
 \item{channelColumn}{ named vector of character strings;
                       optional; default \code{NULL}. 
         If the \code{data.frame} of argument
         \code{slideDescription} contains information
         for each channel of every slide/hybridisation separately, the
         \code{channelColumn} vector contains the column name of the
         \code{data.frame} of argument \code{slideDescription}
         used to specify the channel.
         If \code{length(channelColumn) == 1} the character strings
         "green" and "red" are assumed to be used for the coding,
         otherwise \code{names(channelColumn)} must contain:
         \code{c("channelColumnName","green","red")}.
                     }
  \item{loadPath}{ character string; required; default: ".".
      The path is used to load the image quantification result files;
      note: "." refers to the working directory.
      }
  \item{spotIdentifier}{ character string; optional; default missing.
                         \code{spotIdentifier} specifies the column
                         in the image analysis result files which contain
                         spot or gene identifiers.}
  \item{type}{character string; required;
              possible values: "GenePix", "ScanAlyze",
              "generic" and "genericOneFilePerChannel";
              cf. Details section.
              Note: value "generic" requires the arguments
              \code{spotAnnoColumns}, \code{dataColumns}
              and possibly \code{skip} and \code{removePattern},
              value "genericOneFilePerChannel" additionally requires
              the argument "channelColumn";
              whereas "GenPix"
              and "ScanAlyze" use predefined values if not
              otherwise specified;
              default: "GenePix".}
  \item{spotAnnoColumns}{ vector of character strings;
        the column names of the image analysis data file.
        The columns must contain the same information for all
        files, e.g. the information on the layout of the microarray.
        The argument \code{spotIdentifier} is automatically
        added to the vector if not already included; default: \code{NULL} }
  \item{dataColumns}{ named vector of character strings;
         the column names of the image analysis data file.
         The columns  contain the raw intensities values of each spot; 
         \code{names(dataColumns)} must contain:
         \code{c("greenForeground", "greenBackground",
                 "redForeground", "redBackground")};
         default: \code{NULL}
       }
  \item{removePattern}{ character string defining
               a regular expression; default: \code{NULL};
               all lines of each image analysis file,
               which match the regular expression are discarded.
             }
  \item{skip}{ integer; default: \code{NULL};
               number of lines skipped in each image analysis data file;
               Argument \code{skip} applies after all lines matched by
               the argument \code{removePattern} have been discarded.
             }
  \item{quote}{ character string; required; default: \code{quote = "\"'"}.
                The argument \code{quote} is passed to the corresponding argument
                of \code{\link{read.table}} which is used inside this function.
              }
  \item{verbose}{logical; required; default \code{TRUE}}

 }

 \value{object of class \code{\link{arrayData}}}

 \seealso{ \code{\link{readpDataSlides}},
           \code{\link{arrayData-class}}
   }

 \keyword{IO}

 \author{Andreas Buness <a.buness@dkfz.de>}

 \examples{

   \dontshow{

       LOADPATH <- file.path(.path.package("arrayMagic"), "extdata")

 	slideDescription <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesDescription"
                           )
       dataColumns=c("a","b","c","d")
       names(dataColumns)= c("greenForeground","greenBackground",
                             "redForeground","redBackground")
       resultObject <- readIntensities(slideDescription=slideDescription,
                                       fileNameColumn="files",
                                       loadPath=LOADPATH,
                                       type="generic",
                                       spotAnnoColumns=c("e","f"),
                                       dataColumns=dataColumns,
                                       skip=7
                                      )

 	slideDescriptionB <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesTwoColourDescription"
                           )
       channelColumn <-  "channel"
       resultObjectB <- readIntensities(slideDescription=slideDescriptionB,
                                        fileNameColumn="files",
                                        loadPath=LOADPATH,
                                        channelColumn=channelColumn,
                                        type="generic",
                                        spotAnnoColumns=c("e","f"),
                                        dataColumns=dataColumns,
                                        skip=7
                                       )
 	slideDescriptionC <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesTwoColourDescription2"
                           )
       channelColumn <-  c("channel","xgreen","xred")
       names(channelColumn) <- c("channelColumnName", "green", "red")
       resultObjectC <- readIntensities(slideDescription=slideDescriptionC,
                                        fileNameColumn="files",
                                        loadPath=LOADPATH,
                                        channelColumn=channelColumn,
                                        type="generic",
                                        spotAnnoColumns=c("e","f"),
                                        dataColumns=dataColumns,
                                        skip=7
                                       )

     stopifnot( all( match(unlist(getHybAttr(resultObjectB)), unlist(getHybAttr(resultObjectC)))))
      stopifnot( all(unlist(getHybAttrRed(resultObjectB)[,c("files","name","sample")]) ==
                     unlist(getHybAttrRed(resultObjectC)[c(1,3,2),c("files","name","sample")])))

      stopifnot( all(unlist(getHybAttrGreen(resultObjectB)[,c("files","name","sample")]) ==
                     unlist(getHybAttrGreen(resultObjectC)[c(1,3,2),c("files","name","sample")])))

 	slideDescriptionD <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesTwoColourDescription3"
                           )
       channelColumn <-  c("channel","xgreen","xred")
       names(channelColumn) <- c("channelColumnName", "green", "red")
       resultObjectD <- readIntensities(slideDescription=slideDescriptionD,
                                        fileNameColumn="files",
                                        loadPath=LOADPATH,
                                        channelColumn=channelColumn,
                                        type="generic",
                                        spotAnnoColumns=c("e","f"),
                                        dataColumns=dataColumns,
                                        skip=7
                                       )
     stopifnot( all( match(unlist(getHybAttr(resultObjectC)), unlist(getHybAttr(resultObjectD)))))

 stopifnot( all(getHybAttrRed(resultObjectC)[,c("files","name","sample","channel")] ==
                getHybAttrRed(resultObjectD)[,c("files","name","sample","channel")]))

 stopifnot( all(getHybAttrGreen(resultObjectC)[,c("files","name","sample","channel")] ==
                getHybAttrGreen(resultObjectD)[,c("files","name","sample","channel")]))

slideDescription <- data.frame(fileName="lc7b048rex2.DAT")
r <- readIntensities(slideDescription=slideDescription, loadPath=LOADPATH, type="ScanAlyze")
slideDescription <- data.frame(fileName="lc7b048rex.DAT")
r2 <- readIntensities(slideDescription=slideDescription, loadPath=LOADPATH, type="ScanAlyze")
 spotAnnoColumns <- c( "HEADER", "SPOT", "GRID", "ROW", "COL" )
 dataColumns <- c("CH1I", "CH1B", "CH2I", "CH2B")
 names(dataColumns) <-  c("greenForeground","greenBackground","redForeground","redBackground")
  r3 <- readIntensities(slideDescription=slideDescription, loadPath=LOADPATH, spotAnnoColumns = spotAnnoColumns, dataColumns=dataColumns, type="generic")
 stopifnot(  all( getIntensities(r) == getIntensities(r2) ) )
 stopifnot(  all( getIntensities(r) == getIntensities(r3) ) )


   }

 }

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/readpDataSlides.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{readpDataSlides}

 \title{Reads the description of all slides or channels}

 \alias{readpDataSlides}

 \keyword{IO}

 \description{The function reads the \code{slideDescriptionFile},
              which contains all information row-wise
              for each slide/microarray
              or for each channel in a tab-deliminated text file.
              The file is read up to the first line
              containing solely "white space".
	}

 \value{ \code{\link{data.frame}} }

 \usage{readpDataSlides(slideDescriptionFile = "slideDescription.txt", loadPath = ".", deleteBlanks = TRUE, verbose = TRUE)}

 \arguments{

  \item{slideDescriptionFile}{ character string;
       required; default "slideDescription.txt".
       The first line of the file must contain all column names,
       in particular the column named "fileName" which contains
       image analyis result file names and possibly
       additionally a column which contains the slide names;
       cf. the arguments \code{fileNameColumn} and
                         \code{slideNameColumn}
           of \code{\link{readIntensities}}.
       }
  \item{loadPath}{ character string; required; default: ".".
       The path is used to load the \code{slideDescriptionFile};
       note: "." refers to the working directory.
       }
  \item{deleteBlanks}{ logical; required; default: \code{TRUE}.
                       Any blank character is removed from
                       the text body of the
                       \code{slideDescriptionFile}
                     }
  \item{verbose}{ logical; required; default: \code{TRUE} }

 }

 \examples{
       LOADPATH <- file.path(.path.package("arrayMagic"), "extdata")
 	SLIDEDESCRIPTIONFILE <- "slideDescription"
  
 	resultObject <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE
                  )
 }

 \seealso{\code{\link{readIntensities}},
          \code{\link{processArrayData}}
          }
 }

 \author{Andreas Buness <a.buness@dkfz.de>}

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/removeSpots.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{removeSpots}

 \title{Remove specified spots from objects}

 \alias{removeSpots}

 \usage{removeSpots(arrayDataObject, exprSetRGObject=NULL, spotsToBeRemoved=NULL, spotIdentifier="Name")}

 \description{All elements matching the strings in \code{spotsToBeRemoved}
              are taken out of the object \code{arrayDataObject} and 
              the corresponding ones out of the
              object \code{exprSetRGObject} as well,
              if supplied.
              }

 \value{A named list containing
        an object of type \code{\link{arrayData}} labelled "arrayDataObject",
        an object of type \code{\link{exprSetRG}} labelled "exprSetRGObject"
        and an integer specifying the number of removed items
        labelled "nrOfRemovedItems".
        }


 \arguments{

  \item{arrayDataObject}{object of type \code{\link{arrayData}};
                         required; default: missing}
  \item{exprSetRGObject}{object of type \code{\link{exprSetRG}};
                         optional; default: \code{NULL}}
  \item{spotIdentifier}{character string, i.e. name of the
                        column of \code{getSpotAttr(arrayDataObject)}
                        used for matching;
                        default "Name"}
  \item{spotsToBeRemoved}{vector of character strings;
                          default: \code{NULL}}
 }
 
 \details{}

 \seealso{\code{\link{arrayData-class}},
          \code{\link{exprSetRG-class}}
         }

 \examples{

  intensities <- array(data=runif(600),dim=c(100,2,3))
  dimnames(intensities) <- list(NULL, c("green","red"), NULL)
  arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","Blank","Blank","z"),20))), hybAttrList=NULL)
  res <- removeSpots(arrayDataObject, spotsToBeRemoved=c("x","z"))
  stopifnot( dim(getIntensities(res[["arrayDataObject"]]))[1] == 3*20 )

   \dontshow{

  indGreen=1:3
  indRed=4:6
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprSetRGObject <- new("exprSetRG", exprs=matrix(data=runif(600),nrow=100,ncol=6), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
  res2 <- removeSpots(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
  stopifnot( dim(exprs(res2[["exprSetRGObject"]]))[1] == 3*20 )
  res3 <- removeSpots(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("ggrrrr"))
  stopifnot( dim(exprs(res3[["exprSetRGObject"]]))[1] == 100 )
  stopifnot( dim(getIntensities(res3[["arrayDataObject"]]))[1] == 100 )

   }
  }

 \keyword{utilities} ## required

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{rowFtests}
\alias{rowFtests}
\alias{rowttests}
\title{F-test and t-test for rows of a matrix}
\description{F-test and t-test for rows of a matrix}

\usage{
rowFtests(x, fac)
rowttests(x, fac)} 

\arguments{
  \item{x}{Matrix}
  \item{fac}{Factor, with \code{length(fac)=ncol(x)}. For
    \code{rowttests}, \code{fac} must have exactly two levels.}
}
\details{If \code{fac} is specified, \code{rowttests} performs for each
  row of \code{x} a two-sided, two-class t-test with equal variances.
  \code{fac} must be a factor of length \code{ncol(x)} with two levels,
  corresponding to the two groups.
  
  If \code{fac} is missing, \code{rowttests} performs for each row of
  \code{x} a two-sided one-class t-test against the null hypothesis 'mean=0'.

  With the current implementation, \code{NA}s are not allowed. This
  could be changed if desirable.
}
\value{  
A list with the test statistics, p-values, degrees of freedom.
}
\author{Wolfgang Huber <w.huber@dkfz.de>}
\seealso{\code{\link[multtest:mt.teststat]{mt.teststat}}}
\examples{
   x  = matrix(runif(9700), ncol=97)
   k2 = floor(runif(ncol(x))*2)
   k7 = floor(runif(ncol(x))*7)

   t1 = rowttests(x)
   t2 = rowttests(x, factor(k2))
   ft = rowFtests(x, factor(k7))

   if(require(multtest)) {
     fs = mt.teststat(x, k7, test="f")
     stopifnot(all(abs(fs - ft$statistic) < 1e-6))

     ts2 = mt.teststat(x, k2, test="t.equalvar")
     stopifnot(all(abs(ts2 - t2$statistic) < 1e-6))

     ts1 = apply(x, 1, function(x) t.test(x)$statistic)
     stopifnot(all(abs(ts1 - t1$statistic) < 1e-6))
   }
}
\keyword{math}

\eof
\name{savepng}
\alias{savepdf}
\alias{savepng}
\title{Save the contents of the current graphics device to a PDF or PNG file}
\description{Save the contents of the current graphics device to a PDF or PNG file}

\usage{
  savepng(fn, dir, width=480, asp=1)
  savepdf(fn, dir, width=6, asp=1)
}

\arguments{
  \item{fn}{character: name of the output file (without extension .png or .pdf)}
  \item{dir}{character: directory to which the file should be
    written. If \code{NULL}, use the filename in \code{fn} only.}
  \item{width}{numeric: width of the image in pixels (png) or inches (pdf)}
  \item{asp}{numeric: aspect ratio; height=width*asp}
}

\details{
}

\value{  
Character: name of the written file.
}

\author{Wolfgang Huber \url{http://www.dkfz.de/mga/whuber}}

\seealso{\code{\link{dev.copy}},\code{\link{pdf}},\code{\link{png}}}

\examples{
  x = seq(0, 20*pi, len=1000)
  plot(x*sin(x), x*cos(x), type="l")

  try({   ## on some machines, png or pdf may not be available
  savepdf("spiral", dir=tempdir())
  \dontrun{
  savepng("spiral", dir=tempdir())
  }
  })    
}

\keyword{programming}
\keyword{error}

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/shorth.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{shorth}

 \title{shorth}

 \alias{shorth}

 \keyword{univar}

 \description{

 Given a sample of real values, find the midpoint of the "shorth"

 Let f be the empirical distribution function, and w be the width of
 the shorth (typically 0.5). Find q that minimizes

                       \deqn{f^{-1}(q+w)  - f^{-1}(q)}{
                             f^{-1}(q+w)  - f^{-1}(q) }

}

 \value{}

 \arguments{
  \item{z}{}
 }
 
 \details{}

 \examples{
	}

 \author{}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/simpleApply.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{simpleApply}

 \title{simpleApply}

 \alias{simpleApply}

 \usage{simpleApply(arrayObject, dimensions, func, funcResultDimensionality, DEBUG=FALSE)}

 \keyword{iteration}

 \description{Note: very slow.
   \code{func} is applied to all subsets
   of \code{arrayObject} defined by \code{dimensions}, i.e.
   for every element i of \code{arrayObject}[\code{dimensions}]
   the function \code{func} is applied to \code{arrayObject}[i].
   \code{func} must be unary.
   Due to the recursive definition the function might
   not only be slow but also very memory intensive.
   The function aims to give you more control on the dimensionality
   of the return value in contrast to \code{\link{apply}};
   cf. the examples.
   Attention: Be careful with \code{funcResultDimensionality} !
   }

 \value{\code{array} of \code{dim=c(dim( arrayObject[dimensions] ),
                              funcResultDimensionality     )};
        possibly use \code{\link{aperm}} to rearrange the dimensions}


 \arguments{
  \item{arrayObject}{object of type \code{array}; required; default: missing}
  \item{dimensions}{increasing numeric vector; required; default: missing}
  \item{func}{unary function; required; default: missing}
  \item{funcResultDimensionality}{numeric (vector) specifying the
                      dimensionality of the result value of \code{func}}
  \item{DEBUG}{logical; required; default: \code{FALSE};
               to trace the recursive calling you may use \code{DEBUG=TRUE}}

 }
 

 \examples{

a <- array(c(1:30),dim=c(3,2,5))
r <- simpleApply(a, 1, function(x){return(x[2,5])}, 1)
stopifnot( all(r == matrix(data=c(28:30))))

r <- simpleApply(a, 2, function(x){return(x[,])}, c(3,5))
stopifnot( all( a == aperm(r,c(2,1,3)) ) )

vec <- 1:10; dim(vec) <- c(10,1)
mat <- matrix(data=rep(1:10,4),nrow=10,ncol=4,byrow=FALSE)
r <- simpleApply(mat,1,function(y){return(mean(y))},1)
stopifnot(all(r==vec))

r <- simpleApply(mat, 1:2, function(x) return(x), 1)
stopifnot( all(r[,,1] == mat) )

r <- simpleApply(a, c(1,3) , function(x) return(x), dim(a)[2])
stopifnot( all(aperm(r[,,],c(1,3,2)) == a) )

r <- simpleApply(a, 1:2, function(x) return(x[2]), 1)
stopifnot( all(r[,,] == a[,,2]) )

r <- simpleApply(a, 1, function(x) return(x), c(dim(a)[2],dim(a)[3]))
stopifnot( all( r== a ) )

 \dontshow{

r <- simpleApply(matrix(c(1, 2)), 1, sum, 1)
stopifnot( all(r == matrix(c(1,2))) )

a <- array(c(1:30),dim=c(3,2,5))
r <- simpleApply(a, 1, function(x){return(x[1])}, 1)
stopifnot( all(r == matrix(data=c(1:3))))

r <- simpleApply(a, 1, function(x){return(x[1,3])}, 1)
stopifnot( all(r == matrix(data=c(13:15))))

r <- simpleApply(a, 1, function(x){return(x[,])}, c(2,5))
stopifnot( all( a == r))

r <- simpleApply(a, 3, function(x){return(x[,])}, c(3,2))
stopifnot( all( a == aperm(r,c(2,3,1)) ) )

r2 <- simpleApply(a, 1, function(x){ return(as.vector(x))}, 10)

r <- simpleApply(a, 1:3, function(x) return(x), 1)
stopifnot( all(r[,,,1] == a) )

r <- simpleApply(a, 1:2, function(x) return(x), dim(a)[3])
stopifnot( all(r[,,] == a) )

r <- simpleApply(a, 1:2, function(x) return(x[1]), 1)

r <- simpleApply(a, 1:2, function(x) return(x[1]), 1)
stopifnot( all(r[,,] == a[,,1]) )


 }

	}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/slideMerge.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{slideMerge}

 \title{Averaging of two colour microarray replicas}

 \alias{slideMerge}

 \usage{slideMerge(exprSetRGObject, slideMergeColumn, sampleAnnotationColumns, seExprsHandling="rootMeanSquare", verbose=TRUE)}

 \keyword{utilities}

 \description{ The mean of the expression values is calculated
               separately for each channel.
               If no \code{se.exprs} values are given
               in \code{exprSetRGObject},
               \code{se.exprs} is set to the standard deviation
               of the expression values
               (which is possibly \code{NA}).
               If available it is set to the root-mean-square
               or the mean of the given \code{se.exprs}
               values depending on the
               argument \code{seExprsHandling}.
      The root-mean-square can be useful if the 
      \code{se.exprs} values are estimated standard deviations
      based on the same number observations taken from identical
      distributions.}

 \value{object of class \code{\link{exprSetRG-class}}, i.e.
        the "merged" \code{exprSetRGObject}}


 \arguments{
  \item{exprSetRGObject}{object of class \code{\link{exprSetRG}};
                         required; default missing}
  \item{slideMergeColumn}{character string specifying the variable
            of the \code{phenoData} object of the \code{exprSetRGObject},
            which is used to determine replicas; required; default missing}
  \item{sampleAnnotationColumns}{ vector of character strings;
      optional; default missing.
      A vector which contains all \code{phenoData} variables
      relevant for further analysis.
      The \code{phenoData}-annotation should be consistent for replicas.
      By default the argument \code{sampleAnnotationColumns} is missing
      and all \code{phenoData} variables are used.}
  \item{seExprsHandling}{ character string;
          either "rootMeanSquare" or "mean";
          required; default "rootMeanSquare" }
  \item{verbose}{ logical; required; default: \code{TRUE} }

 }
 
 \details{}

 \seealso{\code{\link{spotMerge}},
          \code{\link{exprSetRG-class}} }

 \examples{

  indGreen=1:2
  indRed=3:4
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprsMatrix <- matrix(rep(1:10,4),nrow=10,ncol=4,byrow=FALSE)
  phenoMatrix <- matrix(c(c(1,2),c(3,3),c(5,5)),nrow=2,ncol=3,byrow=FALSE)
  colnames(phenoMatrix) <- c("one","two","usedForMerge")
  phenoMatrix <- rbind(phenoMatrix,phenoMatrix)
  eSA <- new("exprSetRG", exprs=exprsMatrix, phenoData=
             new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM <- slideMerge(exprSetRGObject=eSA, slideMergeColumn="usedForMerge")
  eSAOne <- slideSubset(eSA,j=c(1))
  stopifnot( all(exprs(eSAOne) == exprs(eSM) ))
  stopifnot( all( se.exprs(eSM) == 0 ) )

 \dontshow{


  eSA2 <- new("exprSetRG", exprs=exprsMatrix, se.exprs=exprsMatrix,
              phenoData= new("phenoData", pData=data.frame(phenoMatrix),
              varLabels=as.list(colnames(phenoMatrix))),
              channels=channels)
  eSM2 <- slideMerge(exprSetRGObject=eSA2, slideMergeColumn="usedForMerge")
  eSA2One <- slideSubset(eSA2,j=c(1))
  stopifnot( all(exprs(eSA2One) == exprs(eSM2) ) )
  stopifnot( all(sqrt(0.5*((se.exprs(eSA2One)*se.exprs(eSA2One))+(se.exprs(eSA2One)*se.exprs(eSA2One)))) == se.exprs(eSM2)) ) 


  indGreen=1:4
  indRed=5:8
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprsMatrix <- matrix(c(rep(1:10,3),rep(rep(0,10),5)),
                        nrow=10,ncol=8,byrow=FALSE)
  phenoMatrix <- matrix(c(c(1:8),rep(1,8),c(1,2,1,3,1,2,1,3)),
                        nrow=8,ncol=3,byrow=FALSE)
  colnames(phenoMatrix) <- c("one","two","usedForMerge")
  eSA3 <- new("exprSetRG", exprs=exprsMatrix, phenoData=
             new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM3 <- slideMerge(exprSetRGObject=eSA3, slideMergeColumn="usedForMerge")

  eSM3One <- slideSubset(eSM3,j=c(1))
  eSM3Two <- slideSubset(eSM3,j=c(2))
  eSM3Three <- slideSubset(eSM3,j=c(3))
  stopifnot( all(exprs(eSM3Three) == 0) )
  stopifnot( all( is.na(se.exprs(eSM3Three)) ) )

  stopifnot( all( is.na(se.exprs(eSM3Two)) ) )
  stopifnot( exprs(getExprSetGreen(eSM3Two)) == c(1:10) )
  stopifnot( all(exprs(getExprSetRed(eSM3Two)) == 0) )
  stopifnot( exprs(getExprSetGreen(eSM3One)) == (c(1:10)) )
  stopifnot( all(exprs(getExprSetRed(eSM3One)) == 0) )
  stopifnot( all(se.exprs(eSM3One) == 0) )

  exprsMatrix <- matrix(c(rep(1:10,2),rep(rep(0,10),6)),
                      nrow=10,ncol=8,byrow=FALSE)
  eSA3 <- new("exprSetRG", exprs=exprsMatrix, phenoData=
             new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM3 <- slideMerge(exprSetRGObject=eSA3, slideMergeColumn="usedForMerge")
  eSM3One <- slideSubset(eSM3,j=c(1))
  eSM3Two <- slideSubset(eSM3,j=c(2))
  eSM3Three <- slideSubset(eSM3,j=c(3))
  stopifnot( all(exprs(eSM3Three) == 0 ))
  stopifnot( all( is.na(se.exprs(eSM3Three)) ) )

  stopifnot( all( is.na(se.exprs(eSM3Two)) ) )
  stopifnot( exprs(getExprSetGreen(eSM3Two)) == c(1:10) )
  stopifnot( all(exprs(getExprSetRed(eSM3Two)) == 0) )
  stopifnot( exprs(getExprSetGreen(eSM3One)) == 0.5*(c(1:10)) )
  stopifnot( all(exprs(getExprSetRed(eSM3One)) == 0 ))
  stopifnot( all(se.exprs(getExprSetRed(eSM3One)) == 0 ))
  stopifnot( (se.exprs(getExprSetGreen(eSM3One)) == apply(cbind(rep(0,10),c(1:10)),1,sd) ))



  indGreen=1:4
  indRed=5:8
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  exprsMatrix <- matrix(c(rep(1:10,3),rep(rep(0,10),5)),
                        nrow=10,ncol=8,byrow=FALSE)
  se.exprsMatrix <- array(1, dim(exprsMatrix) )
  phenoMatrix <- matrix(c(c(1:8),rep(1,8),c(1,2,1,3,1,2,1,3)),
                        nrow=8,ncol=3,byrow=FALSE)
  colnames(phenoMatrix) <- c("one","two","usedForMerge")
  eSA4 <- new("exprSetRG", exprs=exprsMatrix, se.exprs=se.exprsMatrix,
              phenoData= new("phenoData", pData=data.frame(phenoMatrix),
                 varLabels=as.list(colnames(phenoMatrix))),
             channels=channels)
  eSM4 <- slideMerge(exprSetRGObject=eSA4, slideMergeColumn="usedForMerge")

  eSM4One <- slideSubset(eSM4,j=c(1))
  eSM4Two <- slideSubset(eSM4,j=c(2))
  eSM4Three <- slideSubset(eSM4,j=c(3))
  stopifnot( all(exprs(eSM4Three) == 0) )
  stopifnot( all(se.exprs(eSM4Three) == 1 ) ) 
  stopifnot( all(se.exprs(eSM4Two) == 1 ) ) 
  stopifnot( exprs(getExprSetGreen(eSM4Two)) == c(1:10) )
  stopifnot( all(exprs(getExprSetRed(eSM4Two)) == 0) )
  stopifnot( exprs(getExprSetGreen(eSM4One)) == (c(1:10)) )
  stopifnot( all(exprs(getExprSetRed(eSM4One)) == 0) )
  stopifnot( all(se.exprs(eSM4One) == 1) ) 


  indGreen=1:4
  indRed=5:8
  channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
  colnames(channels) <- c("green","red")
  myMatrix <- matrix(c(1:8,rep(1:4,2),c(1,1,1,4,2,2,2,2),c(2,2,2,2,4,1,1,1) ,rep(c(1,1,2,2),2)),nrow=8,ncol=5,byrow=FALSE)
  colnames(myMatrix) <- c("one","two","three","four","merge")
  exprsMatrix <-  matrix(rep(1:10,4), ncol=8, nrow=5, byrow=FALSE) 
  eSA <- new("exprSetRG", exprs=exprsMatrix, phenoData=
                new("phenoData", pData=data.frame(myMatrix),
                varLabels=as.list(colnames(myMatrix))),
              channels=channels)
  eSM <- slideMerge(exprSetRGObject=eSA, slideMergeColumn="merge")
  stopifnot( all(  dim(exprs(eSM)) == c(5,4) ) )
  stopifnot( all(as.matrix(pData((phenoDataSlide(eSM)[,which(varLabels(phenoDataSlide(eSM)) == "slidesInGroup")]))) == matrix(c("1;2","3;4"),ncol=1,nrow=2)) )
	  exprs(eSM)
  stopifnot( all(exprs(getExprSetGreen(eSM)) == cbind(rowMeans(exprs(getExprSetGreen(eSA))[,1:2]), rowMeans(exprs(getExprSetGreen(eSA))[,3:4]))))
  stopifnot( all(exprs(getExprSetRed(eSM)) == cbind(rowMeans(exprs(getExprSetRed(eSA))[,1:2]), rowMeans(exprs(getExprSetRed(eSA))[,3:4]))))
  stopifnot(se.exprs(getExprSetGreen(eSM)) == cbind(as.matrix(apply((exprs(getExprSetGreen(eSA))[,1:2]),1,sd)), as.matrix(apply((exprs(getExprSetGreen(eSA))[,3:4]),1,sd))))
  stopifnot(se.exprs(getExprSetRed(eSM)) == cbind(as.matrix(apply((exprs(getExprSetRed(eSA))[,1:2]),1,sd)), as.matrix(apply((exprs(getExprSetRed(eSA))[,3:4]),1,sd))))
  stopifnot( all( match( unlist(varLabels(phenoDataSlide(eSM))), c("two", "greenSpecific_three", "greenSpecific_four", "redSpecific_three", "redSpecific_four", "merge", "slidesInGroup", "redSpecific_one", "greenSpecific_one")) ) )
  }

	}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/spatialLayout.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{spatialLayout}

 \title{Calculation of two dimensional coordinates}

 \alias{spatialLayout}

 \usage{spatialLayout(value, row, col, block, numberOfValues, nrOfBlocksPerRow = 4, mapping = 0)}

 \description{All \code{value}s are mapped on a matrix representing the
              the spatial layout defined by the function arguments, mainly
              by \code{row}, \code{column} and \code{block} and
              \code{numberOfValues} if not all values for all
              coordinates are given. The result can be 
              visualised with the function
              \code{\link{plot.imageMatrix}}.}

 \value{A matrix representing the spatial layout of all \code{value}s.
        The matrix is labelled as class \code{imageMatrix} and \code{matrix}. }


 \arguments{
  \item{value}{numeric vector; required; default: missing}
  \item{row}{integer vector; required; default: missing}
  \item{col}{integer vector; required; default: missing}
  \item{block}{integer vector; required; default: missing}
  \item{numberOfValues}{integer; optional; default: missing.
        The argument \code{numberOfValues} allows to determine the correct
        spatial layout if not all values for all coordinates are
        passed to the function.}
  \item{nrOfBlocksPerRow}{integer; required; default: 4.
                          Useful if there is a block structured layout
                          with columns and rows assigned within each block
                          as common for microarrays. See examples for a
                          simple case with only one block.}
  \item{mapping}{integer; either zero or one; default: zero,
                 which corresponds to "ScanAlyze" and "GenePix";
                 cf. source code}
 }
 
 \examples{

 value <- rep(c(1,rep(0,49)),10)
 block <- as.integer(gl(10,50))
 col <- rep(c(1:10),50)
 row <- rep(as.integer(gl(5,10)),10)
 sL <- spatialLayout(value=value,row=row,col=col,block=block,nrOfBlocksPerRow=2)
 plot.imageMatrix(sL)
 value <- value[-(201:250)]
 block <- block[-(201:250)]
 col <- col[-(201:250)]
 row <- row[-(201:250)]
 sL <- spatialLayout(value=value,row=row,col=col,block=block,nrOfBlocksPerRow=2,numberOfValues=500)
 plot.imageMatrix(sL)

 value <- 1:200
 block <- rep(1, 200)
 col <- rep(1:20, 10)
 row <- as.integer(gl(10,20))
 sLOne <- spatialLayout(value=value,block=block,col=col,row=row,nrOfBlocksPerRow=1)
	}

 \keyword{dplot}

 \seealso{ \code{\link{plot.imageMatrix}} }

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/spotMerge.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{spotMerge}

 \title{Averaging of spot replicas}

 \alias{spotMerge}

 \usage{spotMerge(exprSetRGObject, arrayDataObject, spotIdentifier="Name", spotsToBeRemoved=c("Blank"))}

 \keyword{utilities}

 \description{
 The mean of replicated spots with identical number of replicas is
 calculated for each channel separately
 (note: \code{spotMerge} does require an equal number of replicas).
 All other spots need to be eliminated with the help of the
 argument \code{spotsToBeRemoved}.
 The mean is calculated for the expression levels
 \code{exprs} of the \code{exprSetRGObject} and for the
 \code{intensities} and \code{weights} of the \code{arrayDataObject}.
 Any existing \code{se.exprs}-\code{matrix}
 as part of \code{exprSetRGObject} is discarded.
 The standard deviation of the spot merge operation for the expression
 values is returned as \code{se.exprs}.
 The corresponding rows of \code{spotAttr} in \code{arrayDataObject}
 are concatenated and form a single row of respectively more columns.
}

 \value{A list containing the "merged" \code{exprSetRGObject} and
        \code{arrayDataObject}.}


 \arguments{
  \item{arrayDataObject}{object of type \code{\link{arrayData}};
                         required; default: missing}
  \item{exprSetRGObject}{object of type \code{\link{exprSetRG}};
                         required; default: missing}
  \item{spotIdentifier}{ character string; required; default: "Name" }
  \item{spotsToBeRemoved}{ vector of character strings,
       all spots which match the strings are removed from 
       the analysis before merging; required; default: \code{c("Blank")}}
 }
 
 \details{}

 \seealso{  \code{\link{processArrayData}},
            \code{\link{slideMerge}},
            \code{\link{exprSetRG-class}},
            \code{\link{arrayData-class}}
 }

 \examples{


    intensities <- array(data=runif(600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    spotAttr <- data.frame(Name=I(rep(c("x","y","k","l","z"),20)),
                           Zahl=rep(c(1,2,3,4,5),20),
                           Index=c(1:100))
    arrayDataObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                           spotAttr=spotAttr, hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprMatrix <- matrix(data=1,nrow=100,ncol=6,byrow=FALSE)
    pD <- data.frame(matrix(0,nrow=6,ncol=1))
    exprSetRGObject <- new("exprSetRG", exprs=exprMatrix, se.expr=exprMatrix,
                              phenoData=new("phenoData",
                                pData= pD,varLabels=list(rep("varLabel1",1))),
                              channels=channels)
    resultList <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    resultExprSetRG <- resultList[["exprSetRGObject"]]
    stopifnot( dim(exprs(resultExprSetRG))[1] == 3 )
    stopifnot( dim(exprs(resultExprSetRG))[2] == 6 )
    stopifnot(all(exprs(resultExprSetRG) == 1))
    stopifnot((all(se.exprs(resultExprSetRG) == 0)))
    resultArrayData <- resultList[["arrayDataObject"]]
    stopifnot( all(getIntensities(resultArrayData)[,1,] == getWeights(resultArrayData)) )
    nameColumns <- grep("Name", colnames(getSpotAttr(resultArrayData)))
    zahlColumns <- grep("Zahl", colnames(getSpotAttr(resultArrayData)))
    stopifnot( getSpotAttr(resultArrayData)[1,nameColumns] == rep ("y", 20 ) )
    stopifnot( getSpotAttr(resultArrayData)[1,zahlColumns] == rep (2, 20 ) )

\dontshow{
    stopifnot( getSpotAttr(resultArrayData)[2,nameColumns] == rep ("k", 20 ) )
    stopifnot( getSpotAttr(resultArrayData)[2,zahlColumns] == rep (3, 20 ) )
    stopifnot( getSpotAttr(resultArrayData)[3,nameColumns] == rep ("l", 20 ) )

    se.exprs(exprSetRGObject) <- matrix(nrow=0,ncol=0)
    resultList <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    stopifnot(all(exprs(resultExprSetRG) == 1))
    stopifnot((all(se.exprs(resultExprSetRG) == 0)))

    intensities <- array(data=rep(2,600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","k","l","z"),20))), hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprSetRGObject <- new("exprSetRG", exprs=matrix(data=rep(c(1,2,3,4,5),120),nrow=100,ncol=6,byrow=FALSE), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
    resultList2 <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    resultES <- resultList2[["exprSetRGObject"]]
    resultAD <- resultList2[["arrayDataObject"]]
    stopifnot( dim(exprs(resultES))[1] == 3 )
    stopifnot( dim(exprs(resultES))[2] == 6 )
    stopifnot( all( exprs(resultES)["y",] == 2 ) )
    stopifnot( all( exprs(resultES)["k",] == 3 ) )
    stopifnot( all( exprs(resultES)["l",] == 4 ) )
    stopifnot((all(se.exprs(resultES) == 0)))
    stopifnot( all(getIntensities(resultAD)[,,] == 2) )
 
    intensities <- array(data=rep(3,600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","k","l","z"),20))), hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprSetRGObject <- new("exprSetRG", exprs=matrix(data=rep(c(1,2,3,4,5,5,4,3,2,1),60),nrow=100,ncol=6,byrow=FALSE), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
    resultList2 <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    resultES <- resultList2[["exprSetRGObject"]]
    resultAD <- resultList2[["arrayDataObject"]]
    stopifnot( dim(exprs(resultES))[1] == 3 )
    stopifnot( dim(exprs(resultES))[2] == 6 )
    stopifnot( all( exprs(resultES)["y",] == 3 ) )
    stopifnot( all( exprs(resultES)["k",] == 3 ) )
    stopifnot( all( exprs(resultES)["l",] == 3 ) )
    stopifnot(all(exprs(resultES) == 3))
    stopifnot( all(getIntensities(resultAD)[,,] == 3) )
    stopifnot( all.equal.numeric( se.exprs(resultES)["y",], rep(sd(rep(c(2,4),10)),6) ) )
    stopifnot( all( se.exprs(resultES)["k",] ==  sd(rep(c(3,3),10)) ) )
    stopifnot( all.equal.numeric( se.exprs(resultES)["l",], rep(sd(rep(c(4,2),10)),6) ) )

  }
    

	}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/visualiseHybridisations.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{visualiseHybridisations}

 \title{Microarray intensity data are visualised with respect
        to their spatial layout}

 \alias{visualiseHybridisations}

 \usage{visualiseHybridisations(arrayDataObject, exprSetRGObject, type="raw", hybridisations, slideNameColumn, numberOfSpots, nrOfBlocksPerRow=4, mappingColumns= list(Block="Block", Column="Column", Row="Row"), transFunc=log, savePath=".", plotOutput="pdf")}

 \description{Two colour microarray intensity data are visualised
              with respect to their spatial layout.
              Missing values (\code{NA}) as well as
              minus infinity (\code{-Inf})
              etc. are not visualised.
              They appear to be white, i.e. in the colour of the background.
              \code{-Inf} might be a result of the (log-)transformation
              of the data; cf. the argument \code{transFunc}.}

 \value{None, but a plot is generated.}

 \arguments{

  \item{arrayDataObject}{object of class \code{\link{arrayData}};
                         required; default: missing}
  \item{exprSetRGObject}{object of class \code{\link{exprSetRG}};
                         only required,
                         if \code{type = "normalised"} or
                         \code{type = "normalisedLogRatio"};
                         default: missing}
  \item{type}{vector of character strings; required; default "raw";
              valid strings are "raw", "rawLogRatio",
              "rawLogRatioBackgroundSubtracted", "normalised"
              or "normalisedLogRatio"}
  \item{hybridisations}{vector of integers; optional; default: missing,
                        i.e. all microarray slides}
  \item{slideNameColumn}{character string specifying the column
                         \code{getHybAttr(arrayDataObject)}
                         which contains the names
                         of the hybridisations; optional;
                         default: missing}
  \item{numberOfSpots}{integer; optional; default: missing;
                       but required if the values in \code{arrayDataObject}
                       do not cover the whole microarray slide, i.e.
                       do not contain all spots;
                       cf. \code{\link{spatialLayout}}.}
  \item{nrOfBlocksPerRow}{integer; cf. \code{\link{spatialLayout}};
                          required; default: 4}
  \item{mappingColumns}{list; required; the list elements named
                        "Block", "Column", "Row" define the
                        corresponding column names given in
                        \code{getSpotAttr(arrayDataObject)};
                        the "Block" element is optional, if
                        missing a single block is assumed;
                        default: \code{list(Block="Block",
                        Column="Column", Row="Row")};
                        cf. \code{\link{spatialLayout}}
                       }
  \item{transFunc}{transformation function
                   applied to the raw data,
                   in particular in combination with \code{type = "raw"}
                   you may for example use \code{log} or \code{rank};
                   (note: \code{type = "rawLogRatio"} and
                          \code{type = "rawLogRatioBackgroundSubtracted"}
                          require log );
                   required; default: log}
  \item{savePath}{character string; required; default: "."}
  \item{plotOutput}{character string; required; either "screen", "pdf"
                    or "win.metafile"; default: "pdf"}

 }
 
 \examples{
	}

 \seealso{
           \code{\link{spatialLayout}},
           \code{\link{exprSetRG-class}},
           \code{\link{arrayData-class}}
         }

 \keyword{hplot}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:43.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/visualiseQualityParameters.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{visualiseQualityParameters}

 \title{Graphical representation of quality parameters}

 \alias{visualiseQualityParameters}

 \description{Graphical representation of quality parameters}

 \value{A graphical representation of quality parameters.
        \code{\link{qualityDiagnostics}} does call
        \code{visualiseQualityParameters} }

 \usage{visualiseQualityParameters(qualityParameters, savePath, fileName="visualiseQualityParametersOutput.pdf", width=25, height=25, plotOutput="pdf")}

 \arguments{
  \item{qualityParameters}{\code{data.frame}; required; 
                           contained in the return value of
                           \code{\link{qualityParameters}} }
  \item{fileName}{character string; required;
                  default: "visualiseQualityParametersOutput.pdf" }
  \item{savePath}{character string; optional; default: missing}
  \item{width}{graphics window width}
  \item{height}{graphics window height}
  \item{plotOutput}{character string; required; either "screen", "pdf"
                    or "win.metafile"; default: "pdf"}
 }
 
 \details{For details on the specific parameters
          see \code{\link{qualityParameters}}.
          Lines are only used for easier
          detection of outliers. The ordering
          of the hybridisation is somehow arbitrary,
          and only reflects the (initial) ordering. 
          The "correlation" line for example
          graphically represents the correlation
          coefficients calculated between the
          green and red channel for each hybridisation.
          The horizontal blue line is drawn
          at the height of one. The function
          \code{\link{qualityDiagnostics}} calls
          \code{visualiseQualityParameters}.
         }

 \seealso{\code{\link{qualityParameters}};
          \code{\link{qualityDiagnostics}} }

 \examples{
	}

 \keyword{hplot} ## required

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
\name{write.htmltable}
\alias{write.htmltable}
\title{Write a data frame into an html table within a html page}
\description{Write a \code{data.frame} into an html table within a html page}
\usage{write.htmltable(x, filename, title="", sortby=NULL, decreasing=TRUE)}
\arguments{
  \item{x}{\code{data.frame}; required; default: missing}
  \item{filename}{file name; required; default: missing}
  \item{title}{character string; title of html page; default: ""}
  \item{sortby}{character string; name of column by which to 
                sort the table rows; default: \code{NULL}}
  \item{decreasing}{logical. Should the sort order be increasing or decreasing?
                    default: \code{TRUE}}
}

\details{}

\value{The function is called for its side effect: writing a file.}

\author{Wolfgang Huber \url{http://www.dkfz.de/mga/whuber}}

\seealso{ \code{\link{writeToFile}} }
\examples{}
\keyword{IO}

\eof
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2004-07-02  9:53:44.
% Do NOT modify this file, instead modify the source (/home/buness/R/TestingOfarrayMagic/Rpacks/arrayMagic/R/writeToFile.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


 \name{writeToFile}

 \title{Writes a textual representation of an exprSetRG
        and/or arrayData object}

 \alias{writeToFile}

 \usage{writeToFile(arrayDataObject, exprSetRGObject, additionalDataMatrix, rowSelection, slideNameColumn, channels=c("logRatio"), fileName="dumpedData.txt", savePath=".", fullOutput=TRUE, coding=FALSE)}

 \description{\code{writeToFile} generates a well-formated
              tab-deliminated output file of data
              stored in the \code{\link{exprSetRG}} and/or
              \code{\link{arrayData}} objects.
              Different "views" on either a corresponding pair of
              an \code{\link{exprSetRG}}- and an
              \code{\link{arrayData}}-object or of a
              single object itself are possible.
              The argument \code{channels} allows to specify the "views".
              The microarray slide or channel annotation, as well as
              the spot annotation is aligned to the data block
              if given.
              For further restriction and control of the output,
              e.g. slide subsets or ordering of slides, you may use
              the subsetting operations offered by the
              \code{\link{exprSetRG-class}} and
              \code{\link{arrayData-class}} beforehand
              (e.g. slideSubset and [] ).
             }

 \value{The function is called for its side effect, i.e. writing a file.}


 \arguments{
  \item{arrayDataObject}{object of class \code{\link{arrayData}};
                         optional/required,
                         cf. \code{channels}; default: missing}
  \item{exprSetRGObject}{object of class \code{\link{exprSetRG}};
                         optional/required,
                         cf. \code{channels}; default: missing}
  \item{additionalDataMatrix}{class \code{matrix}; optional; default: missing.
                              The rows must correspond to those of the
                              data objects; \code{colnames} must be supplied.}
  \item{rowSelection}{vector of indexes; optional; default: missing}
  \item{slideNameColumn}{character string; optional; default: missing;
     must refer to a valid column in
     \code{\link{getHybAttr}}(\code{arrayDataObject})
     or in \code{\link{pDataSlide}}(\code{exprSetRGobject}) }
  \item{channels}{vector of character strings; default: \code{c("logRatio")};
       valid character strings are:
       "logRatio", "green", "red", "rawGreen", "rawRed",
       "rawGreenRelative", "rawRedRelative",
       "se.exprsLogRatio", "se.exprsGreen", "se.exprsRed".
       "Raw"-types must not mix with not "raw"-types and vice versa.
       "logRatio"-types must not mix with "colour"-types.
       The "raw" types require the argument \code{arrayDataObject},
       all other types requires at least the argument \code{exprSetRGObject}.}
  \item{fileName}{character string; required; default: "dumpedData.txt"}
  \item{savePath}{character string; required; default: "."}
  \item{fullOutput}{logical; adds \code{phenoData} information at the top
                   of the table ; by default: \code{TRUE}}
  \item{coding}{logical; adds integer-coded-\code{phenoData} information
                at the top to the table only if \code{coding = TRUE} and
                \code{fullOutput = TRUE}; default: \code{FALSE}}
 }
 
 \details{}

 \seealso{
           \code{\link{exprSetRG-class}},
           \code{\link{arrayData-class}},
           \code{\link{write.htmltable}}
         }

 \examples{
  \dontshow{
   indGreen <- c(2,4,6); indRed <- c(1,3,5)
   channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
   colnames(channels) <- c("green","red")
   myPData <- data.frame(commonOne=c(1,1,2,2,3,3), commonTwo=c(1,1,1,1,2,2), redOne=c(1,NA,2,NA,3,NA), redTwo=c(1,-1,2,-1,3,-1), greenOne=c(NA,10,NA,20,NA,30), greenTwo=c(-10,10,-10,20,-10,30))
   myPhenoData <- new("phenoData", pData=myPData, varLabels=as.list(colnames(myPData)))
   e <- new("exprSetRG", exprs=matrix(1,nrow=10,ncol=6), se.exprs=matrix(0,nrow=10,ncol=6), phenoData=myPhenoData, channels=channels)
   writeToFile(exprSetRGObject=e, savePath=tempdir())
   writeToFile(exprSetRGObject=e, channels=c("se.exprsLogRatio"), savePath=tempdir() )
   writeToFile(exprSetRGObject=e, channels=c("logRatio","se.exprsLogRatio"), slideNameColumn="commonTwo", savePath=tempdir() )
   writeToFile(exprSetRGObject=e, channels=c("logRatio","se.exprsLogRatio"), slideNameColumn="commonTwo", rowSelection=1:5, coding=TRUE, savePath=tempdir() )
   spotAttr <- data.frame(spots=c("a","b","c","d","e","f","1","2","3","4"))
   hL <- list(green=myPData[,indGreen],red=myPData[,indRed])
   aD <- new("arrayData", spotAttr=spotAttr, hybAttrList=hL)
   writeToFile(exprSetRGObject=e, arrayDataObject=aD, savePath=tempdir())
   hL <- list(green=myPData[,indGreen],red=myPData[,indGreen]) ## Attention green twice
   intensities <- array(data=runif(120),dim=c(10,2,6))
   dimnames(intensities) <- list(NULL, c("green","red"), NULL)
   aD <- new("arrayData", spotAttr=spotAttr, hybAttrList=hL, intensities=intensities)
   writeToFile(arrayDataObject=aD, channels="rawRed", savePath=tempdir())
   writeToFile(arrayDataObject=aD, channels=c("rawRed", "rawRedRelative"), savePath=tempdir())
   writeToFile(arrayDataObject=aD, channels=c("rawGreen", "rawRedRelative") ,coding=TRUE, savePath=tempdir())
   writeToFile(arrayDataObject=aD, channels=c("rawGreen", "rawRedRelative") , slideNameColumn="commonTwo", savePath=tempdir())
  }
 }

 \keyword{IO}

 \author{Andreas Buness <a.buness@dkfz.de>}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\eof
