### Name: writeToFile
### Title: Writes a textual representation of an exprSetRG and/or arrayData
###   object
### Aliases: writeToFile
### Keywords: IO

### ** Examples

  ## Don't show: 
   indGreen <- c(2,4,6); indRed <- c(1,3,5)
   channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
   colnames(channels) <- c("green","red")
   myPData <- data.frame(commonOne=c(1,1,2,2,3,3), commonTwo=c(1,1,1,1,2,2), redOne=c(1,NA,2,NA,3,NA), redTwo=c(1,-1,2,-1,3,-1), greenOne=c(NA,10,NA,20,NA,30), greenTwo=c(-10,10,-10,20,-10,30))
   myPhenoData <- new("phenoData", pData=myPData, varLabels=as.list(colnames(myPData)))
   e <- new("exprSetRG", exprs=matrix(1,nrow=10,ncol=6), se.exprs=matrix(0,nrow=10,ncol=6), phenoData=myPhenoData, channels=channels)
   writeToFile(exprSetRGObject=e, savePath=tempdir())
   writeToFile(exprSetRGObject=e, channels=c("se.exprsLogRatio"), savePath=tempdir() )
   writeToFile(exprSetRGObject=e, channels=c("logRatio","se.exprsLogRatio"), slideNameColumn="commonTwo", savePath=tempdir() )
   writeToFile(exprSetRGObject=e, channels=c("logRatio","se.exprsLogRatio"), slideNameColumn="commonTwo", rowSelection=1:5, coding=TRUE, savePath=tempdir() )
   spotAttr <- data.frame(spots=c("a","b","c","d","e","f","1","2","3","4"))
   hL <- list(green=myPData[,indGreen],red=myPData[,indRed])
   aD <- new("arrayData", spotAttr=spotAttr, hybAttrList=hL)
   writeToFile(exprSetRGObject=e, arrayDataObject=aD, savePath=tempdir())
   hL <- list(green=myPData[,indGreen],red=myPData[,indGreen]) ## Attention green twice
   intensities <- array(data=runif(120),dim=c(10,2,6))
   dimnames(intensities) <- list(NULL, c("green","red"), NULL)
   aD <- new("arrayData", spotAttr=spotAttr, hybAttrList=hL, intensities=intensities)
   writeToFile(arrayDataObject=aD, channels="rawRed", savePath=tempdir())
   writeToFile(arrayDataObject=aD, channels=c("rawRed", "rawRedRelative"), savePath=tempdir())
   writeToFile(arrayDataObject=aD, channels=c("rawGreen", "rawRedRelative") ,coding=TRUE, savePath=tempdir())
   writeToFile(arrayDataObject=aD, channels=c("rawGreen", "rawRedRelative") , slideNameColumn="commonTwo", savePath=tempdir())
  
## End Don't show
 


