### Name: spotMerge
### Title: Averaging of spot replicas
### Aliases: spotMerge
### Keywords: utilities

### ** Examples


    intensities <- array(data=runif(600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    spotAttr <- data.frame(Name=I(rep(c("x","y","k","l","z"),20)),
                           Zahl=rep(c(1,2,3,4,5),20),
                           Index=c(1:100))
    arrayDataObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                           spotAttr=spotAttr, hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprMatrix <- matrix(data=1,nrow=100,ncol=6,byrow=FALSE)
    pD <- data.frame(matrix(0,nrow=6,ncol=1))
    exprSetRGObject <- new("exprSetRG", exprs=exprMatrix, se.expr=exprMatrix,
                              phenoData=new("phenoData",
                                pData= pD,varLabels=list(rep("varLabel1",1))),
                              channels=channels)
    resultList <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    resultExprSetRG <- resultList[["exprSetRGObject"]]
    stopifnot( dim(exprs(resultExprSetRG))[1] == 3 )
    stopifnot( dim(exprs(resultExprSetRG))[2] == 6 )
    stopifnot(all(exprs(resultExprSetRG) == 1))
    stopifnot((all(se.exprs(resultExprSetRG) == 0)))
    resultArrayData <- resultList[["arrayDataObject"]]
    stopifnot( all(getIntensities(resultArrayData)[,1,] == getWeights(resultArrayData)) )
    nameColumns <- grep("Name", colnames(getSpotAttr(resultArrayData)))
    zahlColumns <- grep("Zahl", colnames(getSpotAttr(resultArrayData)))
    stopifnot( getSpotAttr(resultArrayData)[1,nameColumns] == rep ("y", 20 ) )
    stopifnot( getSpotAttr(resultArrayData)[1,zahlColumns] == rep (2, 20 ) )

## Don't show: 
    stopifnot( getSpotAttr(resultArrayData)[2,nameColumns] == rep ("k", 20 ) )
    stopifnot( getSpotAttr(resultArrayData)[2,zahlColumns] == rep (3, 20 ) )
    stopifnot( getSpotAttr(resultArrayData)[3,nameColumns] == rep ("l", 20 ) )

    se.exprs(exprSetRGObject) <- matrix(nrow=0,ncol=0)
    resultList <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    stopifnot(all(exprs(resultExprSetRG) == 1))
    stopifnot((all(se.exprs(resultExprSetRG) == 0)))

    intensities <- array(data=rep(2,600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","k","l","z"),20))), hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprSetRGObject <- new("exprSetRG", exprs=matrix(data=rep(c(1,2,3,4,5),120),nrow=100,ncol=6,byrow=FALSE), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
    resultList2 <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    resultES <- resultList2[["exprSetRGObject"]]
    resultAD <- resultList2[["arrayDataObject"]]
    stopifnot( dim(exprs(resultES))[1] == 3 )
    stopifnot( dim(exprs(resultES))[2] == 6 )
    stopifnot( all( exprs(resultES)["y",] == 2 ) )
    stopifnot( all( exprs(resultES)["k",] == 3 ) )
    stopifnot( all( exprs(resultES)["l",] == 4 ) )
    stopifnot((all(se.exprs(resultES) == 0)))
    stopifnot( all(getIntensities(resultAD)[,,] == 2) )
 
    intensities <- array(data=rep(3,600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","k","l","z"),20))), hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprSetRGObject <- new("exprSetRG", exprs=matrix(data=rep(c(1,2,3,4,5,5,4,3,2,1),60),nrow=100,ncol=6,byrow=FALSE), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
    resultList2 <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, spotsToBeRemoved=c("x","z"))
    resultES <- resultList2[["exprSetRGObject"]]
    resultAD <- resultList2[["arrayDataObject"]]
    stopifnot( dim(exprs(resultES))[1] == 3 )
    stopifnot( dim(exprs(resultES))[2] == 6 )
    stopifnot( all( exprs(resultES)["y",] == 3 ) )
    stopifnot( all( exprs(resultES)["k",] == 3 ) )
    stopifnot( all( exprs(resultES)["l",] == 3 ) )
    stopifnot(all(exprs(resultES) == 3))
    stopifnot( all(getIntensities(resultAD)[,,] == 3) )
    stopifnot( all.equal.numeric( se.exprs(resultES)["y",], rep(sd(rep(c(2,4),10)),6) ) )
    stopifnot( all( se.exprs(resultES)["k",] ==  sd(rep(c(3,3),10)) ) )
    stopifnot( all.equal.numeric( se.exprs(resultES)["l",], rep(sd(rep(c(4,2),10)),6) ) )

  ## End Don't show
    

        


