### Name: qualityParameters
### Title: Calculation of quality characteristics for DNA microarray
###   hybridisations
### Aliases: qualityParameters
### Keywords: utilities

### ** Examples

      spotIdentifierVec <- c("A","A","Blank","B","B","Blank")
      hybNames <- "H1"
      R1 <- N1 <- c(1,1,9,2,2,10)
      R2 <- N2 <- c(2,2,7,4,4,8)
      rawDataIntensityValues <- array(0, dim=c(6,2,1))
      rawDataIntensityValues[,1,] <- R1
      rawDataIntensityValues[,2,] <- R2
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      spotAttr <- data.frame(Name=I(spotIdentifierVec))
      hybAttr <- data.frame(slideName=I(hybNames))
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      indGreen <- 1
      indRed <- 2
      channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
      colnames(channels) <- c("green","red")
      exprSetRGObject <- new("exprSetRG",       
      exprs <- matrix(c(R1,R2), nrow=6, byrow=FALSE), phenoData=        
          new("phenoData", pData=data.frame(matrix(0,nrow=2,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)           
      Re1 <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")
      stopifnot(all.equal.numeric(as.numeric(Re1$qualityParameters["H1",c("correlation")]),c(1)))
      stopifnot(Re1$replicateSpots==2)

   ## Don't show: 

      hybNames <- c(hybNames,hybNames)
      hybAttr=data.frame(slideName=I(hybNames))
      rawDataIntensityValues <- array(0, dim=c(6,2,2))
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      rawDataIntensityValues[,1,] <- c(R1,R1)
      rawDataIntensityValues[,2,] <- c(R2,R2)
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      channels <- rbind(channels, channels+2)
      exprSetRGObject <- new("exprSetRG",       
        exprs=matrix(c(R1,R1,R2,R2), nrow=6, byrow=FALSE), phenoData=   
             new("phenoData", pData=data.frame(matrix(0,nrow=4,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)
      Re1 <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")
      stopifnot(Re1$replicateSpots==2)
      stopifnot(all.equal.numeric(as.numeric(unlist(Re1$qualityParameters[, grep( "spotReplicatesConcordance", colnames(Re1$qualityParameters) )])), rep(1,(length(hybNames)*length(grep( "spotReplicatesConcordance", colnames(Re1$qualityParameters)) ))) ))

      spotIdentifierVec <- c("Blank","A","A","A","B","B","B")
      R1 <- N1 <- c(10,1,1,1,2,2,2)
      R2 <- N2 <- c(11,2,2,2,4,4,4)
      rawDataIntensityValues <- array(0, dim=c(7,2,1))
      rawDataIntensityValues[,1,] <- R1
      rawDataIntensityValues[,2,] <- R2
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      spotAttr=data.frame(Name=I(spotIdentifierVec))
      hybNames <- "H1"
      hybAttr=data.frame(slideName=I(hybNames))
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      indGreen=1
      indRed=2
      channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
      colnames(channels) <- c("green","red")
      exprSetRGObject <- new("exprSetRG",       
        exprs=matrix(c(R1,R2), nrow=7, byrow=FALSE), phenoData= 
          new("phenoData", pData=data.frame(matrix(0,nrow=2,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)           

      Re2 <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")

      stopifnot(all.equal.numeric(as.numeric(Re2$qualityParameters["H1",c("correlation")]),c(1)))
      stopifnot(Re2$replicateSpots==3)

      rawDataIntensityValues[1,1,1] <- NA
      intensities(arrayDataObject) <- rawDataIntensityValues
      Re2NA <- qualityParameters(arrayDataObject=arrayDataObject, exprSetRGObject=exprSetRGObject, identifiersToBeSkipped= "Blank")

      hybNames <- c("H1","H2")
      Xr1 <- Xn1 <- cbind(R1,R2)
      Xr2 <- Xn2 <- cbind(R2,R1)
      rawDataIntensityValues <- array(0, dim=c(7,2,2))
      rawDataIntensityValues[,1,1:2] <- Xr1
      rawDataIntensityValues[,2,1:2] <- Xr2
      dimnames(rawDataIntensityValues) <- list(NULL, c("green","red"), NULL)
      spotAttr=data.frame(Name=I(spotIdentifierVec))
      hybAttr=data.frame(slideName=I(hybNames))
      arrayDataObject <- new("arrayData", intensities=rawDataIntensityValues, hybAttrList=list(red=hybAttr,green=hybAttr), spotAttr=spotAttr)
      indGreen=1:2
      indRed=3:4
      channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
      colnames(channels) <- c("green","red")
      exprSetRGObject <- new("exprSetRG",       
        exprs=as.matrix(cbind(Xr1,Xr2)), phenoData=     
          new("phenoData", pData=data.frame(matrix(0,nrow=4,ncol=1)),
              varLabels=list(rep("varLabel1",1))), channels=channels)      

      Re3 <- qualityParameters(arrayDataObject=arrayDataObject,
                               exprSetRGObject=exprSetRGObject,
                               identifiersToBeSkipped= "Blank",
                               resultFileName=file.path(tempdir(),"qP.txt"))

      Re3 <- qualityParameters(arrayDataObject=arrayDataObject,
                               exprSetRGObject=exprSetRGObject,
                               identifiersToBeSkipped= "Blank")

      stopifnot(all.equal.numeric(as.numeric(Re3$qualityParameters["H2",c("correlation")]),c(1)))
      stopifnot(Re3$replicateSpots==3)
   ## End Don't show

        


