### Name: detectReplicas
### Title: detectReplicas
### Aliases: detectReplicas
### Keywords: utilities

### ** Examples


aD <- data.frame(ID=c("z", "x", "x", "x", "y", "z", "z", "y", "y"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(re[["nrOfReplicas"]] == 3 )

aD <- data.frame(ID=c("Blank", "Control1", "Blank", "Control2"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(is.na(re[["nrOfReplicas"]]))

 ## Don't show: 
aD <- data.frame(ID=c("Blank", "Blank", "x", "x", "Control1", "y", "x", "z", "y", "Control2"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(is.na(re[["nrOfReplicas"]]))

aD <- data.frame(ID=c("z", "x", "Control1", "y"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Control1"))
stopifnot(re[["nrOfReplicas"]] == 1 )

aD <- data.frame(ID=c("Blank", "x", "x", "Control1", "y", "z", "z", "y", "Control2"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(re[["nrOfReplicas"]] == 2 )
 ## End Don't show
  


