\name{hgu133a.pdnn.params}
\alias{chiptype.pdnn.params}
%\alias{hgu133a.pdnn.params}
\alias{hgu95av2.pdnn.params}
%\alias{mgu74av2.pdnn.params}
%\alias{pdnn-energy-parameter_hg_u133a}
\alias{pdnn-energy-parameter_hg-u95av2}
%\alias{pdnn-energy-parameter_mg_u74av2}
\docType{data}
\title{Chip-type specific data}
\description{
Chip-type specific data structure.
}
\usage{
%data(hgu133a.pdnn.params)
data(hgu95av2.pdnn.params)
}
\format{
  The format is a list:
\describe{
  \item{Eg}{environment (one entry per dinucleotide)}
  \item{Wg}{numerical vector.}
  \item{En}{environment (one entry per dinucleotide)}
  \item{Wn}{numerical vector.}
  \item{gene.Sn}{list (one entry per affyID)}
  \item{gene.Sg}{list (one entry per affyID)}
  \item{gene.xy}{list (one entry per affyID)}
  \item{params.gene}{environment}
}
}
\details{
  These chip-specific data structures are generated from the data files
  made available by the author of the PDNN paper (see the section source). They
  are stored as \code{data} to save some computation time.
  The data structures were made using the function
  \code{\link{pdnn.params.chiptype}}. The data files are included in the
  the directory `data' of the package. 
}
\note{
  To lower the size of the package, the only chip-specific data structures
  included in the package is the one for HG-U95Av2.
}
\source{
    Li Zhang, Michael F. Miles and Kenneth D. Aldape - A model of molecular interactions on short oligonucleotide
  arrays, 2003, Nature Biotech., vol. 21, n.7
}
\examples{
## give the path the original energy parameter files included in the package
list.files(system.file("exampleData", package="affypdnn"),
           "^pdnn-energy-parameter_", full.names=TRUE)
}
\keyword{datasets}

\eof
\name{expressopdnn}
\alias{affypdnn}
\alias{expressopdnn}
\alias{pdnn.scalevalue.exprSet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Position Dependant Nearest Neighbors model for affy}
\description{
  a wrapper to perform the PDNN method.
}
\usage{
pdnn.scalevalue.exprSet(eset, scale.to=500)
expressopdnn(afbatch,
      # background correction
             bg.correct = FALSE,
             bgcorrect.method = NULL,
             bgcorrect.param = list(),
      # normalize
             normalize = FALSE,
             normalize.method = NULL,
             normalize.param = list(),
%       # pm correction
              pmcorrect.method = c("pdnn", "pdnnpredict"),
%              pmcorrect.param = list(),
      # pdnn
             params.chiptype = NULL,          
      # expression values
             summary.subset = NULL,
      # PDNN expression values scaling
             eset.normalize = TRUE,
             scale.to = 500,
      # misc.
             verbose = TRUE,
             widget = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{afbatch}{object of \code{\link[affy]{AffyBatch-class}}}
  \item{bg.correct}{a boolean to express whether background correction
    is wanted or not.}
  \item{bgcorrect.method}{the name of the background adjustment method}
  \item{bgcorrect.param}{a list of parameters for bgcorrect.method (if
    needed/wanted)}
  \item{eset}{An object of \code{\link[Biobase]{exprSet-class}}}
  \item{normalize}{ normalization step wished or not.}
  \item{normalize.method}{the normalization method to use}
  \item{normalize.param}{a list of parameters to be passed to the
    normalization method (if wanted).}
   \item{pmcorrect.method}{the name of the PM adjustement method (only
     two choices here, default to 'pdnn').}
%   \item{pmcorrect.param}{a list of parameters for pmcorrect.method (if
%     needed/wanted)}
  \item{params.chiptype}{An object with chip type specific
    parameters. If \code{NULL}, the parameter files included in the
    package will be used whenever possible...}
  \item{eset.normalize}{is any normalization step on expression values
    to be performed}
  \item{scale.to}{a value to scale against.}
  \item{summary.subset}{a list of 'affyids'. If \code{NULL}, a
    expression summary value is computed for everything on the chip.}
  \item{verbose}{logical value. If \code{TRUE} it writes out some
    messages.}
  \item{widget}{a boolean to specify the use of widgets (the package
    tkWidget is required). NOTE: this not yet implemented !}
}
\details{
  \code{expressopdnn} is very similar to \code{\link[affy]{expresso}}. It is
  mainly a wrapper around the pre-processing steps `background
  correction', `normalization', `perfect match correction' and
  the PDNN method to compute expression values (see the first
  reference for more details about the preprocessing steps and
  and the second reference for further details about the PDNN method).

  The wrapper \code{expresso} has no way to handle easily the
  computation of chip-wide results that have to be used during
  the \code{computeExprSet} step. An easy way to overcome this
  was to write this simple wrapper.

  \code{pdnn.scalevalue} is performed after the expression values
  have computed to somehow `normalize' the values between different
  chips. When setting \code{normalize} to \code{TRUE} this step
  might be considered unnecessary (and the \code{eset.normalize} set
  to \code{FALSE}).
}
\value{
  An object of \code{\link[Biobase]{exprsSet-class}}, with an attribute
  \code{pps.warnings} as returned by the method \code{\link[affy]{computeExprSet}}.
}
\seealso{ \code{\link[affy]{expresso} and \code{\link[affy]{computeExprVal.method.pdnn}}}}
\examples{

library(affydata)
data(Dilution)

## one CEL to go faster
afbatch <- Dilution[1]

## Take only few IDs (the 10 first)
ids <- ls(getCdfInfo(afbatch))[1:10]
eset <- expressopdnn(afbatch, bg.correct=FALSE,
                     normalize=FALSE,
                     summary.subset=ids) 

}
\keyword{manip}


\eof
\name{find.params.pdnn}
\alias{find.params.pdnn}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ A function to find the experiment specific PDNN parameters}
\description{
  A function to find the paramaters specific to the chips in an
  AffyBatch object.
}
\usage{
find.params.pdnn(abatch, params.chiptype, optim.method = "BFGS", verbose = TRUE, give.warnings=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{abatch}{ an instance of \code{\link[affy]{Affybatch-class}}. }
  \item{params.chiptype}{ chip-type specific parameters (see details)}
  \item{optim.method}{method for the optimization function
    \code{\link{optim}}. When \code{FALSE}, a steepest-descent method of our own
  is used.}
  \item{verbose}{ verbosity (\code{TRUE} or \code{FALSE}) }
  \item{give.warnings}{ report probeset IDs in the \code{abatch} that could not be found in
    the \code{params.chiptype}}
}
\details{
  This function fits PDNN parameters that are specific to experimental
  values. The parameters common to all the chips of a certain type
  are returned by the function \code{\link{pdnn.params.chiptype}}.
}
\value{
  A list of
  \item{lambda}{The lambda's}
  \item{Bs}{The B's}
  \item{Ns}{The N's}
  \item{Fs}{The F's}
}
\references{ Li Zhang, Michael F. Miles and Kenneth D. Aldape - A model of molecular interactions on short oligonucleotide
  arrays, 2003, Nature Biotech., vol. 21, n.7 }

\seealso{ \code{\link{pdnn.params.chiptype}}, \code{\link{generateExprVal.method.pdnn}}}
\examples{
## load a chip-specific parameter file
## (as returned by the function pdnn.params.chiptype)
data(hgu95av2.pdnn.params)

## load experimental data
library(affydata)
data(Dilution)

## one CEL to go faster
afbatch <- Dilution[1]
params <- find.params.pdnn(afbatch, hgu95av2.pdnn.params, optim.method =
FALSE, give.warnings=FALSE)

}
\keyword{ manip }


\eof
\name{generateExprVal.method.pdnn}
\alias{generateExprVal.method.pdnn}
\alias{pmcorrect.pdnn}
\alias{pmcorrect.pdnnpredict}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Compute PM correction and summary expression value }
\description{
  Compute PM correction and summary expression value with PDNN method
}
\usage{
pmcorrect.pdnn(object, params, gene=NULL, gene.i=NULL,
               params.chiptype=NULL, outlierlim=3, callingFromExpresso=FALSE)
pmcorrect.pdnnpredict(object, params, gene=NULL, gene.i=NULL,
               params.chiptype=NULL, outlierlim=3, callingFromExpresso=FALSE)
generateExprVal.method.pdnn(probes, params)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{ object of \code{\link[affy]{ProbeSet}} }
  \item{probes}{ matrix of PM-corrected signals (should be coming out of
  \code{pmcorrect.pdnn})}
  \item{params}{ experiments specific parameters}
  \item{gene}{ gene (probe set) ID (from wich the \code{gene.i} would be
  derived)}
  \item{gene.i}{ gene index (see details)}
  \item{params.chiptype}{ chip-specific parameters}
  \item{outlierlim}{ threshold for tagging a probe as an outlier}
  \item{callingFromExpresso}{ is the function called through
    expresso. DO NOT play with that.}
}
\details{
  Only one of \code{gene}, \code{gene.i} should be specified. For most
  the users, this is \code{gene}.
  \code{\link{pmcorrect.pdnn}} and \code{\link{pmcorrect.pdnnpredict}}
  return what is called GSB and GSB + NSB + B in the paper by Zhang Li
  and collaborators.
}
\value{
  \code{pmcorrect.pdnn} and \code{pmcorrect.pdnnpredict} return a matrix (one row per probe, one column
  per chip) with attributes attached. \code{generateExprVal} returns a
  \code{list}:
  \item{exprs }{expression values}
  \item{se.exprs}{se expr. val.}
}
\seealso{ \code{\link{pdnn.params.chiptype}}}
\examples{

data(hgu95av2.pdnn.params)
library(affydata)
data(Dilution)

## only one CEL to go faster
abatch <- Dilution[1]

## get the chip specific parameters
params <- find.params.pdnn(abatch, hgu95av2.pdnn.params)

## The thrill part: do we get like in the Figure 1-a of the reference ?
par(mfrow=c(2,2))
##ppset.name <- sample(geneNames(abatch), 2)
ppset.name <- c("41206_r_at", "31620_at")
ppset <- probeset(abatch, ppset.name)
for (i in 1:2) {
##ppset[[i]] <- transform(ppset[[i]], fun=log) # take the log as they do
probes.pdnn <- pmcorrect.pdnnpredict(ppset[[i]], params,
                                     params.chiptype=hgu95av2.pdnn.params)
##probes.pdnn <- log(probes.pdnn)
plot(ppset[[i]], main=paste(ppset.name[i], "\n(raw intensities)"))
matplotProbesPDNN(probes.pdnn, main=paste(ppset.name[i], "\n(predicted intensities)"))
}

## pick the 50 first probeset IDs
## (to go faster)
ids <- geneNames(abatch)[1:100]

## compute the expression set (object of class 'exprSet')
eset <- computeExprSet(abatch, pmcorrect.method="pdnn",
                       summary.method="pdnn", ids=ids,
                       summary.param = list(params, params.chiptype=hgu95av2.pdnn.params))

}
\keyword{manip}


\eof
\name{matplotProbesPDNN}
\alias{matplotProbesPDNN}
\title{ Plot the PDNN computed probe intensities }
\description{
  Plot the probe intensities as computed by 'pmcorrect.pdnn' or 'pmcorrect.pdnnpredict'
}
\usage{
matplotProbesPDNN(x, type="l", ...)
}
\arguments{
  \item{x}{ a matrix (and attributes) as return by \code{pmcorrect.pdnn}
    or \code{pmcorrect.pdnnpredict}. }
  \item{type}{type of plot (same as in \code{matplot}}
  \item{\dots}{ optional arguments to be passed to \code{matplot} }
}
\details{
  The crosses are the probe intensities which are considered `ok' by the
  outlier detection part of the algorithm, while the circles are the
  ones considered `outliers'
}
\value{
  Only used for its side-effect.
}
\seealso{\code{\link{pmcorrect.pdnn}} and \code{\link{pmcorrect.pdnnpredict}}}
\examples{
# to appear...
}
\keyword{ hplot }

\eof
\name{pdnn.params.chiptype}
\alias{pdnn.params.chiptype}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ A function to fit PDNN parameters }
\description{
  A function to fit PDNN parameters that are chip-type specific
}
\usage{
pdnn.params.chiptype(energy.param.file, probes.file = NULL, probes.pack= NULL,
                     probes.data.frame = NULL,
                     seq.name, x.name, y.name, affyid.name, verbose = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{energy.param.file}{ Path to the energy data file (see details) }
  \item{probes.file}{ Path to the probe files (see details) }
  \item{probes.pack}{ Name of the probe pack (see details) }
  \item{probes.data.frame}{ A \code{data.frame}}
  \item{seq.name, x.name, y.name, affyid.name}{ The names of the columns
    in the data.frame from \code{probes.pack} or \code{probes.file} for
  the probe sequences, the X positions, the Y positions and the probe
  set ID respectively}
  \item{verbose}{ verbosity (\code{TRUE} or \code{FALSE} }
}
\details{
  The parameters \code{probes.file}, \code{probes.pack} and
  \code{probes.data.frame} are mutually exclusive.
  The function fits PDNN parameters that are specific to chip-types
  (hence specific to the probe sequences).
  It requires data files like the one found on Li Zhang's web page:
  (http://odin.mdacc.tmc.edu/~zhangli/PerfectMatch/)
  This should be computed once for all for a given chip type.
  Computed values for the chips are included in the package.
  This allows 'automagic' use of them when these chips types are used
  (as done in the function \code{\link{expressopdnn}}).
}
\value{
  A list of:
  \item{Eg}{environment. One entry per dinucleotide.}
  \item{Wg}{numerical vector}
  \item{En}{environment. One entry per dinucleotide.}
  \item{Wn}{numerical vector}
  \item{params.gene}{environment. One entry per gene, each entry is
    is a list of elements Sg, Sn, xy  and gene.i}
}
\warning{ The X and Y positions in the \code{data.frame} are expected to be
  original ones in the Affymetrix files (starting at zero. They are offset by one within
  this function.}
\seealso{ \code{\link{find.params.pdnn}} }
\examples{
if (interactive()) {
  energy.file <- system.file("exampleData", "pdnn-energy-parameter_hg-u95av2.txt", package="affypdnn")

  params.chiptype <- pdnn.params.chiptype(energy.file, probes.pack="hgu95av2probe")
}

}
\keyword{ manip }


\eof
\name{transform.ProbeSet}
\alias{transform.ProbeSet}
\title{ A function to tranform a ProbeSet }
\description{
  A function to transform the PMs and MMs in a ProbeSet
}
\usage{
transform.ProbeSet(x, fun = I, ...)
}
\arguments{
  \item{x}{ object of \code{\link[affy]{ProbeSet-class}} }
  \item{fun}{ a function. The identity function by default. }
  \item{\dots}{ optional arguments for \code{fun}}
}
\details{
  The function \code{fun} is applied to the slots \code{pm} and
  \code{mm}.
  The function \code{vsnh} in the package \code{vsn} is a recommended
  argument for \code{fun}.
}
\value{
  An object of class \code{ProbeSet}.
}
\author{ Laurent }
\note{ This function should make to the package \code{affy} for the version
  1.4.x.}
\examples{
library(affydata)

data(Dilution)

ppset.name <- sample(geneNames(Dilution), 1)
ppset <- probeset(Dilution, ppset.name)[[1]]
ppset.log <- transform(ppset, fun=log)

par(mfrow=c(1,2))
plot(ppset)
plot(ppset.log)

}
\keyword{ manip }


\eof
