### Name: plotFreqStat
### Title: frequency plots and significance analysis
### Aliases: plotFreqStat aCGH.test.old aCGH.test threshold.func
###   changeProp.func changeProp.overall.func table.bac.func lengthGain.na
###   propGain.na lengthLoss.na propLoss.na prop.na gainloss.func
###   plotFreqStatColors plotFreqStatGrey plotFreqGivenStat
###   plotfreqGivenStatFinalColors plotfreq.stat.final.func
###   plotfreq.stat.chrom.final.func plotfreq.givenstat.final.colors.func
### Keywords: htest hplot

### ** Examples


data(colorectal)

## Use mt.maxT function from multtest package to test
## differences in group means for each clone grouped by sex
colnames(phenotype(colorectal))
sex <- phenotype(colorectal)$sex
sex.na <- !is.na(sex)
colorectal.na <- colorectal[ ,sex.na, keep = TRUE ]
dat <- log2.ratios.imputed(colorectal.na)
resT.sex <- mt.maxT(dat, sex[sex.na], test = "t", B = 1000)

## Plot the result along the genome
plotFreqStat(colorectal.na, resT.sex, sex[sex.na],
             titles = c("Male", "Female"))

## Adjust the p.values from previous exercise with "fdr"
## method and plot them
resT.sex.fdr <- resT.sex
resT.sex.fdr$adjp <- p.adjust(resT.sex.fdr$rawp, "fdr")
plotFreqStat(colorectal.na, resT.sex.fdr, sex[sex.na],
             titles = c("Male", "Female"))

## Derive statistics and p-values for testing the linear association of
## age with the log2 ratios of each clone along the samples

age <- phenotype(colorectal)$age
age.na <- !is.na(age)
colorectal.na <- colorectal[ ,age.na, keep = TRUE ]
dat <- log2.ratios.imputed(colorectal.na)
stat.age <- sapply(1:nrow(dat),
                   function(i) {
                      if (i %% 100 == 0)
                         cat(i, "\n")
                      lm.fit <-
                          summary(lm(dat[i,] ~ age[age.na]))
                      c(lm.fit$fstatistic[1],
                        1 - pf(lm.fit$fstatistic[1],
                               lm.fit$fstatistic[2],
                               lm.fit$fstatistic[3])
                       )
                   }
                   )
## Make resT
resT.age <- data.frame(index = 1:ncol(stat.age),
                       teststat = stat.age[ 1, ],
                       rawp = stat.age[ 2, ],
                       adjp = p.adjust(stat.age[ 2, ], "fdr"))
#write out the table of results:
tbl.age <- data.frame(clones.info(colorectal), resT.age)
write.table(tbl.age, "table.age.txt", sep="\t", col.names = TRUE,
            row.names = FALSE, quote = FALSE)




