### Name: impute.lowess
### Title: Imputing log2 ratios
### Aliases: impute.lowess
### Keywords: models

### ** Examples


datadir <- system.file("data", package = "aCGH")
clones.info <-
      read.table(file = file.path(datadir, "clones.info.ex.csv"),
                 header = TRUE, sep = "\t")
log2.ratios <-
      read.table(file = file.path(datadir, "log2.ratios.ex.csv"),
                 header = TRUE, sep = "\t")
ex.acgh <- create.aCGH(log2.ratios, clones.info)

## Imputing the log2 ratios 

log2.ratios.imputed(ex.acgh) <- impute.lowess(ex.acgh)




