### Name: find.hmm.states
### Title: Determines states of the clones
### Aliases: find.hmm.states hmm.run.func mu1.func as.matrix.dist
###   plotChrom.hmm.func plotCGH.hmm.func smoothData.func
###   thresholdData.func plotChrom.samples.func plotChrom.grey.samples.func
### Keywords: models

### ** Examples


datadir <- system.file("examples", package = "aCGH")
latest.mapping.file <-
      file.path(datadir, "human.clones.info.Jul03.csv")
ex.acgh <-
    aCGH.read.Sprocs(system(paste("ls -1", file.path(datadir,
                    "*.txt")), intern = TRUE), latest.mapping.file,
                    chrom.remove.threshold = 23)
ex.acgh

hmm(ex.acgh) <- find.hmm.states(ex.acgh, aic = TRUE, delta = 1.5)
summary(ex.acgh)




