### Name: aCGH
### Title: Class aCGH
### Aliases: aCGH create.aCGH log2.ratios clones.info is.aCGH dim.aCGH
###   num.clones nrow.aCGH num.samples num.chromosomes ncol.aCGH
###   clone.names row.names.aCGH rownames.aCGH clone.names<-
###   row.names<-.aCGH rownames<-.aCGH col.names.aCGH col.names<-.aCGH
###   colnames.aCGH colnames<-.aCGH sample.names sample.names<-
###   log2.ratios.imputed log2.ratios.imputed<- hmm hmm<- sd.samples
###   sd.samples<- genomic.events genomic.events<- phenotype phenotype<-
###   [.aCGH print.aCGH summary.aCGH plot.aCGH minna maxna corna floor.func
###   length.num.func prop.num.func subset.hmm
### Keywords: classes

### ** Examples


## Creating aCGH object from log2.ratios and clone info files
## For alternative way look at aCGH.read.Sprocs help

datadir <- system.file("data", package = "aCGH")
clones.info <-
      read.table(file = file.path(datadir, "clones.info.ex.csv"),
                 header = TRUE, sep = "\t")
log2.ratios <-
      read.table(file = file.path(datadir, "log2.ratios.ex.csv"),
                 header = TRUE, sep = "\t")
pheno.type <-
      read.table(file = file.path(datadir, "pheno.type.ex.csv"),
                 header = TRUE, sep = "\t")
ex.acgh <- create.aCGH(log2.ratios, clones.info, pheno.type)

## Printing, summary and basic plotting for objects of class aCGH

data(colorectal)
colorectal
summary(colorectal)
sample.names(colorectal)
phenotype(colorectal)
plot(colorectal)

## Subsetting aCGH object

colorectal[1:1000, 1:30]

## Imputing the log2 ratios 

log2.ratios.imputed(ex.acgh) <- impute.lowess(ex.acgh)

## Determining hmm states of the clones
## WARNING: Calculating the states takes some time

hmm(ex.acgh) <- find.hmm.states(ex.acgh)

## Calculating the standard deviations for each array

sd.samples(ex.acgh) <- computeSD.Samples(ex.acgh)

## Finding the genomic events associated with each sample

genomic.events(ex.acgh) <- find.genomic.events(ex.acgh)

## Plotting and printing the hmm states

plotHmmStates(ex.acgh, 1)
postscript("/tmp/hmm.states.temp.ps")
plotHmmStates(ex.acgh, 1)
dev.off()

## Plotting summary of the sample profiles

plotSummaryProfile(colorectal)




