\name{MEXP14}
\docType{data}
\alias{MEXP14}
\alias{160miame2.txt.xml}
\alias{am2730miame}
\alias{am2731miame}
\alias{am2732m}
\alias{am2736m}
\alias{am2737m}
\alias{Flounder_Environmental_Tyne_vs_Alde_Male.xml}
\alias{tm1826m}
\alias{tm1827m}
\alias{tm1829m}
\alias{tm1830m}
\alias{tm1831m}

\title{Example dataset in MAGEML-format}

\description{This dataset is available from ArrayExpress(http://www.ebi.ac.uk/arrayexpress/) as E-MEXP-14 and contains data from a study for comparison of environmentally sampled flounder from the Tyne and Alde estuaries.
 }
\details{See ArrayExpress}
\references{Timothy Williams, Karl Gensberg, Steven Minchin and James Chipman (2003). A DNA expression array to detect toxic stress response in European flounder (Platichthys flesus). Aquatic Toxicology, 65, 141-157}


\keyword{datasets}
\source{ArrayExpress, http://www.ebi.ac.uk/arrayexpress/}

\eof
\name{getArrayLayout}
\alias{getArrayLayout}
\title{Creation of a marrayLayout object}
\description{
This function creates a marrayLayout object.
}
\usage{
getArrayLayout( mageOM )
}

\arguments{
  \item{mageOM}{Reference to MAGE Object Model}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}\cr 
Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}.}

\seealso{\code{\link{importMAGEOM}}}

\examples{
data<-system.file("MAGEMLdata", package="RMAGEML")
#To obtain a marrayInfo object containing the database identifiers of the features present on the array.#
mageom<-importMAGEOM(directory=data)
getArrayLayout(mageom)
}
\keyword{methods}

\eof
\name{getArrayLayoutLimma}
\alias{getArrayLayoutLimma}
\title{Get layout for limma}
\description{
This function gets the genes dataframe.
}
\usage{
getArrayLayoutLimma( mageOM, DED = "none" )
}

\arguments{
  \item{mageOM}{Reference to MAGE Object Model}
  \item{DED}{the DesinElement Dimension}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}\cr 
Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}.}

\seealso{\code{\link{importMAGEOM}}}

\examples{
data<-system.file("MAGEMLdata", package="RMAGEML")
#To obtain a marrayInfo object containing the database identifiers of the features present on the array.#
mageom<-importMAGEOM(directory=data)
getArrayLayoutLimma(mageom, DED="DED:707")
}
\keyword{methods}

\eof
\name{getGnames}
\alias{getGnames}
\title{Creation of a Gnames marrayInfo object}
\description{
This function creates a marrayInfo object containing the database identifiers of the features present on the array.
}
\usage{
getGnames( mageOM, DED = "none" )
}

\arguments{
  \item{mageOM}{Reference to MAGE Object Model}
  \item{DED}{the DesignElement Dimension}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}\cr 
Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}.}

\seealso{\code{\link{importMAGEOM}}}

\examples{
data<-system.file("MAGEMLdata", package="RMAGEML")
#To obtain a marrayInfo object containing the database identifiers of the features present on the array.#
mageom<-importMAGEOM(directory=data)
getGnames(mageom, DED="DED:707")
}
\keyword{methods}

\eof
\name{importMAGEML}
\alias{importMAGEML}
\title{import MAGEML documents}
\description{
This function imports MAGEML documents and creates a marrayRaw object.
}
\usage{
importMAGEML(directory = ".", package = "marray", DED = "none", QTD = "none", name.Rf="none", name.Rb="none", name.Gf="none" ,name.Gb =
"none")
}

\arguments{
  \item{directory}{Directory which contains the MAGEML files that need to be imported}
  \item{package}{name of package to which the MAGEML should be imported}
  \item{DED}{the DesignElement Dimension}
  \item{QTD}{the Quantitation Type Dimension}
  \item{name.Rf}{the name of the red foreground intensity}
  \item{name.Rb}{the name of the red background intensity}
  \item{name.Gf}{the name of the green foreground intensity}
  \item{name.Gb}{the name of the green background intensity}

}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}\cr 
Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}.}

\seealso{\code{\link{getGnames}},\code{\link{getArrayLayout}}, \code{\link{makeMarrayRaw}}}

\examples{
data<-system.file("MAGEMLdata", package="RMAGEML")
#will return marrayRaw object.#
importMAGEML(directory = data, package = "marray", DED = "DED:707", QTD = "QTD:707", name.Rf = "QT:F635 Mean", name.Rb = "QT:B635 Median", name.Gf = "QT:F532 Mean" ,name.Gb = "QT:B532 Median")
}
\keyword{methods}

\eof
\name{importMAGEOM}
\alias{importMAGEOM}
\title{import MAGEOM of MAGEML documents}
\description{
This function imports the MAGE Object Model MAGEML documents and creates a reference to this object.
}
\usage{
importMAGEOM(directory = ".")
}

\arguments{
  \item{directory}{Directory which contains the MAGEML files that need to be imported}
}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}\cr 
Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}.}

\seealso{\code{\link{getGnames}},\code{\link{getArrayLayout}}}

\examples{
data<-system.file("MAGEMLdata", package="RMAGEML")
#will return a reference to the MAGE Object Model.#
importMAGEOM(directory=data)
}
\keyword{methods}

\eof
\name{makeMarrayRaw}
\alias{makeMarrayRaw}
\title{Creation of a marrayRaw object}
\description{
This function creates a marrayRaw object.
}
\usage{
makeMarrayRaw(mageOM, layout, gnames, directory = ".", DED = "none", QTD = "none", name.Rf = "none", name.Rb = "none", name.Gf = "none" ,name.Gb = "none")
}

\arguments{
  \item{mageOM}{Reference to MAGE Object Model}
  \item{directory}{Directory which contains the MAGEML files that need to be imported}
  \item{gnames}{the Gnames marrayInfo object e.g. created by getGnames}
  \item{layout}{the marrayLayout object e.g. created by getLayout}
  \item{QTD}{the Quantitation Type Dimension}
  \item{DED}{the Design Element Dimension}
  \item{name.Rf}{the name of the red foreground intensity}
  \item{name.Rb}{the name of the red background intensity}
  \item{name.Gf}{the name of the green foreground intensity}
  \item{name.Gb}{the name of the green background intensity}

}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}\cr 
Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}.}

\seealso{\code{\link{importMAGEOM}}, \code{\link{getGnames}}, \code{\link{getArrayLayout}}}

\examples{
data<-system.file("MAGEMLdata", package="RMAGEML")
#To obtain a marrayInfo object containing the database identifiers of the features present on the array.#
mageom<-importMAGEOM(directory=data)
gnames<-getGnames(mageom, DED = "DED:707")
layout<-getArrayLayout(mageom)
makeMarrayRaw(mageOM=mageom, layout = layout, gnames = gnames, directory = data, DED = "DED:707",QTD = "QTD:707", name.Rf = "QT:F635 Mean", name.Rb = "QT:B635 Median", name.Gf = "QT:F532 Mean" ,name.Gb = "QT:B532 Median")
}
\keyword{methods}

\eof
\name{makeRG}
\alias{makeRG}
\title{Creation of a RGList object}
\description{
This function creates a RGList object.
}
\usage{
makeRG(mageOM, genes, directory = ".", QTD = "none", DED = "none",  name.Rf = "none", name.Rb = "none", name.Gf = "none" ,name.Gb = "none")
}

\arguments{
  \item{mageOM}{Reference to MAGE Object Model}
  \item{directory}{Directory which contains the MAGEML files that need to be imported}
  \item{genes}{the Gnames marrayInfo object e.g. created by getGnames}
  \item{QTD}{the Quantitation Type Dimension}
  \item{DED}{the Design Element Dimension}
  \item{name.Rf}{the name of the red foreground intensity}
  \item{name.Rb}{the name of the red background intensity}
  \item{name.Gf}{the name of the green foreground intensity}
  \item{name.Gb}{the name of the green background intensity}

}

\references{Spellman PT, Miller M, Stewart J, Troup C, Sarkans U, Chervitz S, Bernhart D, Sherlock G, Ball C, Lepage M, Swiatek M, Marks WL, Goncalves J, Markel S, Iordan D, Shojatalab M, Pizarro A, White J, Hubley R, Deutsch E, Senger M, Aronow BJ, Robinson A, Bassett D, Stoeckert CJ Jr and Brazma A.
Design and implementation of microarray gene expression markup language (MAGE-ML).
Genome Biol. 2002 Aug 23;3(9):RESEARCH0046.
}

\author{Steffen Durinck, \url{http://www.esat.kuleuven.ac.be/~sdurinck}\cr 
Joke Allemeersch, \url{http://www.esat.kuleuven.ac.be/~jallemee}.}

\seealso{\code{\link{importMAGEOM}}, \code{\link{getArrayLayoutLimma}}}

\examples{
data<-system.file("MAGEMLdata", package="RMAGEML")
#To obtain a marrayInfo object containing the database identifiers of the features present on the array.#
mageom<-importMAGEOM(directory=data)
genes<-getArrayLayoutLimma(mageom, DED = "DED:707")
makeRG(mageOM=mageom, genes = genes, directory=data, DED = "DED:707", QTD = "QTD:707", name.Rf = "QT:F635 Mean", name.Rb = "QT:B635 Median", name.Gf = "QT:F532 Mean" ,name.Gb = "QT:B532 Median")
}
\keyword{methods}

\eof
