/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import org.apache.html.dom.HTMLCollectionImpl;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.html.dom.HTMLElementImpl;
import org.apache.html.dom.HTMLTableCellElementImpl;
import org.apache.html.dom.HTMLTableElementImpl;
import org.apache.html.dom.HTMLTableSectionElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLTableRowElementImpl
extends HTMLElementImpl
implements HTMLTableRowElement {
    HTMLCollection _cells;

    public int getRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            parent = parent.getParentNode();
        }
        if (parent instanceof HTMLTableElement) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public int getSectionRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public void deleteCell(int index) {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableCellElement) {
                if (index == 0) {
                    this.removeChild(child);
                    return;
                }
                --index;
            }
            child = child.getNextSibling();
        }
    }

    public void setRowIndex(int rowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            parent = parent.getParentNode();
        }
        if (parent instanceof HTMLTableElement) {
            ((HTMLTableElementImpl)parent).insertRowX(rowIndex, this);
        }
    }

    public void setSectionRowIndex(int sectionRowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            ((HTMLTableSectionElementImpl)parent).insertRowX(sectionRowIndex, this);
        }
    }

    public String getAlign() {
        return this.capitalize(this.getAttribute("align"));
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public String getCh() {
        String ch = this.getAttribute("char");
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        return ch;
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public String getVAlign() {
        return this.capitalize(this.getAttribute("valign"));
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public void setCh(String ch) {
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        this.setAttribute("char", ch);
    }

    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    int getRowIndex(Node parent) {
        NodeList rows = ((HTMLElement)parent).getElementsByTagName("TR");
        int i = 0;
        while (i < rows.getLength()) {
            if (rows.item(i) == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public HTMLCollection getCells() {
        if (this._cells == null) {
            this._cells = new HTMLCollectionImpl(this, -3);
        }
        return this._cells;
    }

    public void setCells(HTMLCollection cells) {
        Node child = this.getFirstChild();
        while (child != null) {
            this.removeChild(child);
            child = child.getNextSibling();
        }
        int i = 0;
        child = cells.item(i);
        while (child != null) {
            this.appendChild(child);
            child = cells.item(++i);
        }
    }

    public HTMLElement insertCell(int index) {
        HTMLTableCellElementImpl newCell = new HTMLTableCellElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "TD");
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableCellElement) {
                if (index == 0) {
                    this.insertBefore(newCell, child);
                    return newCell;
                }
                --index;
            }
            child = child.getNextSibling();
        }
        this.appendChild(newCell);
        return newCell;
    }

    public HTMLTableRowElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

