/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasHardwares;
import org.biomage.Interface.HasSoftwares;
import org.biomage.Interface.HasType;
import org.biomage.Protocol.Hardware;
import org.biomage.Protocol.Parameterizable;
import org.biomage.Protocol.Software;
import org.xml.sax.Attributes;

public class Protocol
extends Parameterizable
implements Serializable,
HasSoftwares,
HasHardwares,
HasType {
    String text;
    String title;
    protected OntologyEntry type;
    protected HasHardwares.Hardwares_list hardwares = new HasHardwares.Hardwares_list();
    protected HasSoftwares.Softwares_list softwares = new HasSoftwares.Softwares_list();

    public Protocol() {
    }

    public Protocol(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "text");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.text = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "title")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.title = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Protocol");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Protocol>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.text != null) {
            out.write(" text=\"" + this.text + "\"");
        }
        if (this.title != null) {
            out.write(" title=\"" + this.title + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.type != null) {
            out.write("<Type_assn>");
            this.type.writeMAGEML(out);
            out.write("</Type_assn>");
        }
        if (this.hardwares.size() > 0) {
            out.write("<Hardwares_assnreflist>");
            for (i = 0; i < this.hardwares.size(); ++i) {
                modelClassName = ((Hardware)this.hardwares.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Hardware)this.hardwares.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Hardwares_assnreflist>");
        }
        if (this.softwares.size() > 0) {
            out.write("<Softwares_assnreflist>");
            for (i = 0; i < this.softwares.size(); ++i) {
                modelClassName = ((Software)this.softwares.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Software)this.softwares.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Softwares_assnreflist>");
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getModelClassName() {
        return new String("Protocol");
    }

    public void setType(OntologyEntry type) {
        this.type = type;
    }

    public OntologyEntry getType() {
        return this.type;
    }

    public void setHardwares(HasHardwares.Hardwares_list hardwares) {
        this.hardwares = hardwares;
    }

    public HasHardwares.Hardwares_list getHardwares() {
        return this.hardwares;
    }

    public void addToHardwares(Hardware hardware) {
        this.hardwares.add(hardware);
    }

    public void addToHardwares(int position, Hardware hardware) {
        this.hardwares.add(position, hardware);
    }

    public Hardware getFromHardwares(int position) {
        return (Hardware)this.hardwares.get(position);
    }

    public void removeElementAtFromHardwares(int position) {
        this.hardwares.removeElementAt(position);
    }

    public void removeFromHardwares(Hardware hardware) {
        this.hardwares.remove(hardware);
    }

    public void setSoftwares(HasSoftwares.Softwares_list softwares) {
        this.softwares = softwares;
    }

    public HasSoftwares.Softwares_list getSoftwares() {
        return this.softwares;
    }

    public void addToSoftwares(Software software) {
        this.softwares.add(software);
    }

    public void addToSoftwares(int position, Software software) {
        this.softwares.add(position, software);
    }

    public Software getFromSoftwares(int position) {
        return (Software)this.softwares.get(position);
    }

    public void removeElementAtFromSoftwares(int position) {
        this.softwares.removeElementAt(position);
    }

    public void removeFromSoftwares(Software software) {
        this.softwares.remove(software);
    }
}

