/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.DesignElement;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Common.Extendable;
import org.biomage.DesignElement.Feature;
import org.biomage.DesignElement.MismatchInformation;
import org.biomage.Interface.HasFeature;
import org.biomage.Interface.HasMismatchInformation;
import org.xml.sax.Attributes;

public class FeatureInformation
extends Extendable
implements Serializable,
HasFeature,
HasMismatchInformation {
    protected Feature feature;
    protected HasMismatchInformation.MismatchInformation_list mismatchInformation = new HasMismatchInformation.MismatchInformation_list();

    public FeatureInformation() {
    }

    public FeatureInformation(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<FeatureInformation");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</FeatureInformation>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.feature != null) {
            out.write("<Feature_assnref>");
            out.write("<" + this.feature.getModelClassName() + "_ref identifier=\"" + this.feature.getIdentifier() + "\"/>");
            out.write("</Feature_assnref>");
        }
        if (this.mismatchInformation.size() > 0) {
            out.write("<MismatchInformation_assnlist>");
            for (int i = 0; i < this.mismatchInformation.size(); ++i) {
                ((MismatchInformation)this.mismatchInformation.elementAt(i)).writeMAGEML(out);
            }
            out.write("</MismatchInformation_assnlist>");
        }
    }

    public String getModelClassName() {
        return new String("FeatureInformation");
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setMismatchInformation(HasMismatchInformation.MismatchInformation_list mismatchInformation) {
        this.mismatchInformation = mismatchInformation;
    }

    public HasMismatchInformation.MismatchInformation_list getMismatchInformation() {
        return this.mismatchInformation;
    }

    public void addToMismatchInformation(MismatchInformation mismatchInformation) {
        this.mismatchInformation.add(mismatchInformation);
    }

    public void addToMismatchInformation(int position, MismatchInformation mismatchInformation) {
        this.mismatchInformation.add(position, mismatchInformation);
    }

    public MismatchInformation getFromMismatchInformation(int position) {
        return (MismatchInformation)this.mismatchInformation.get(position);
    }

    public void removeElementAtFromMismatchInformation(int position) {
        this.mismatchInformation.removeElementAt(position);
    }

    public void removeFromMismatchInformation(MismatchInformation mismatchInformation) {
        this.mismatchInformation.remove(mismatchInformation);
    }
}

