/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Description;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BQS.BibliographicReference;
import org.biomage.Common.Describable;
import org.biomage.Description.DatabaseEntry;
import org.biomage.Description.ExternalReference;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasAnnotations;
import org.biomage.Interface.HasBibliographicReferences;
import org.biomage.Interface.HasDatabaseReferences;
import org.biomage.Interface.HasExternalReference;
import org.xml.sax.Attributes;

public class Description
extends Describable
implements Serializable,
HasDatabaseReferences,
HasBibliographicReferences,
HasExternalReference,
HasAnnotations {
    String text;
    String URI;
    protected ExternalReference externalReference;
    protected HasAnnotations.Annotations_list annotations = new HasAnnotations.Annotations_list();
    protected HasDatabaseReferences.DatabaseReferences_list databaseReferences = new HasDatabaseReferences.DatabaseReferences_list();
    protected HasBibliographicReferences.BibliographicReferences_list bibliographicReferences = new HasBibliographicReferences.BibliographicReferences_list();

    public Description() {
    }

    public Description(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "text");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.text = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "URI")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.URI = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Description");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Description>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.text != null) {
            out.write(" text=\"" + this.text + "\"");
        }
        if (this.URI != null) {
            out.write(" URI=\"" + this.URI + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        int i;
        super.writeAssociations(out);
        if (this.externalReference != null) {
            out.write("<ExternalReference_assn>");
            this.externalReference.writeMAGEML(out);
            out.write("</ExternalReference_assn>");
        }
        if (this.annotations.size() > 0) {
            out.write("<Annotations_assnlist>");
            for (i = 0; i < this.annotations.size(); ++i) {
                ((OntologyEntry)this.annotations.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Annotations_assnlist>");
        }
        if (this.databaseReferences.size() > 0) {
            out.write("<DatabaseReferences_assnlist>");
            for (i = 0; i < this.databaseReferences.size(); ++i) {
                ((DatabaseEntry)this.databaseReferences.elementAt(i)).writeMAGEML(out);
            }
            out.write("</DatabaseReferences_assnlist>");
        }
        if (this.bibliographicReferences.size() > 0) {
            out.write("<BibliographicReferences_assnlist>");
            for (i = 0; i < this.bibliographicReferences.size(); ++i) {
                ((BibliographicReference)this.bibliographicReferences.elementAt(i)).writeMAGEML(out);
            }
            out.write("</BibliographicReferences_assnlist>");
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public String getURI() {
        return this.URI;
    }

    public String getModelClassName() {
        return new String("Description");
    }

    public void setExternalReference(ExternalReference externalReference) {
        this.externalReference = externalReference;
    }

    public ExternalReference getExternalReference() {
        return this.externalReference;
    }

    public void setAnnotations(HasAnnotations.Annotations_list annotations) {
        this.annotations = annotations;
    }

    public HasAnnotations.Annotations_list getAnnotations() {
        return this.annotations;
    }

    public void addToAnnotations(OntologyEntry ontologyEntry) {
        this.annotations.add(ontologyEntry);
    }

    public void addToAnnotations(int position, OntologyEntry ontologyEntry) {
        this.annotations.add(position, ontologyEntry);
    }

    public OntologyEntry getFromAnnotations(int position) {
        return (OntologyEntry)this.annotations.get(position);
    }

    public void removeElementAtFromAnnotations(int position) {
        this.annotations.removeElementAt(position);
    }

    public void removeFromAnnotations(OntologyEntry ontologyEntry) {
        this.annotations.remove(ontologyEntry);
    }

    public void setDatabaseReferences(HasDatabaseReferences.DatabaseReferences_list databaseReferences) {
        this.databaseReferences = databaseReferences;
    }

    public HasDatabaseReferences.DatabaseReferences_list getDatabaseReferences() {
        return this.databaseReferences;
    }

    public void addToDatabaseReferences(DatabaseEntry databaseEntry) {
        this.databaseReferences.add(databaseEntry);
    }

    public void addToDatabaseReferences(int position, DatabaseEntry databaseEntry) {
        this.databaseReferences.add(position, databaseEntry);
    }

    public DatabaseEntry getFromDatabaseReferences(int position) {
        return (DatabaseEntry)this.databaseReferences.get(position);
    }

    public void removeElementAtFromDatabaseReferences(int position) {
        this.databaseReferences.removeElementAt(position);
    }

    public void removeFromDatabaseReferences(DatabaseEntry databaseEntry) {
        this.databaseReferences.remove(databaseEntry);
    }

    public void setBibliographicReferences(HasBibliographicReferences.BibliographicReferences_list bibliographicReferences) {
        this.bibliographicReferences = bibliographicReferences;
    }

    public HasBibliographicReferences.BibliographicReferences_list getBibliographicReferences() {
        return this.bibliographicReferences;
    }

    public void addToBibliographicReferences(BibliographicReference bibliographicReference) {
        this.bibliographicReferences.add(bibliographicReference);
    }

    public void addToBibliographicReferences(int position, BibliographicReference bibliographicReference) {
        this.bibliographicReferences.add(position, bibliographicReference);
    }

    public BibliographicReference getFromBibliographicReferences(int position) {
        return (BibliographicReference)this.bibliographicReferences.get(position);
    }

    public void removeElementAtFromBibliographicReferences(int position) {
        this.bibliographicReferences.removeElementAt(position);
    }

    public void removeFromBibliographicReferences(BibliographicReference bibliographicReference) {
        this.bibliographicReferences.remove(bibliographicReference);
    }
}

