/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioSequence;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioSequence.SequencePosition;
import org.biomage.Common.Extendable;
import org.biomage.Interface.HasCoordinate;
import org.biomage.Interface.HasSubregions;
import org.xml.sax.Attributes;

public class SeqFeatureLocation
extends Extendable
implements Serializable,
HasSubregions,
HasCoordinate {
    String strandType;
    protected HasSubregions.Subregions_list subregions = new HasSubregions.Subregions_list();
    protected SequencePosition coordinate;

    public SeqFeatureLocation() {
    }

    public SeqFeatureLocation(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "strandType");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.strandType = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<SeqFeatureLocation");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</SeqFeatureLocation>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.strandType != null) {
            out.write(" strandType=\"" + this.strandType + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.subregions.size() > 0) {
            out.write("<Subregions_assnlist>");
            for (int i = 0; i < this.subregions.size(); ++i) {
                ((SeqFeatureLocation)this.subregions.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Subregions_assnlist>");
        }
        if (this.coordinate != null) {
            out.write("<Coordinate_assn>");
            this.coordinate.writeMAGEML(out);
            out.write("</Coordinate_assn>");
        }
    }

    public void setStrandType(String strandType) {
        this.strandType = strandType;
    }

    public String getStrandType() {
        return this.strandType;
    }

    public String getModelClassName() {
        return new String("SeqFeatureLocation");
    }

    public void setSubregions(HasSubregions.Subregions_list subregions) {
        this.subregions = subregions;
    }

    public HasSubregions.Subregions_list getSubregions() {
        return this.subregions;
    }

    public void addToSubregions(SeqFeatureLocation seqFeatureLocation) {
        this.subregions.add(seqFeatureLocation);
    }

    public void addToSubregions(int position, SeqFeatureLocation seqFeatureLocation) {
        this.subregions.add(position, seqFeatureLocation);
    }

    public SeqFeatureLocation getFromSubregions(int position) {
        return (SeqFeatureLocation)this.subregions.get(position);
    }

    public void removeElementAtFromSubregions(int position) {
        this.subregions.removeElementAt(position);
    }

    public void removeFromSubregions(SeqFeatureLocation seqFeatureLocation) {
        this.subregions.remove(seqFeatureLocation);
    }

    public void setCoordinate(SequencePosition coordinate) {
        this.coordinate = coordinate;
    }

    public SequencePosition getCoordinate() {
        return this.coordinate;
    }
}

