/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;
import org.apache.xalan.xsltc.runtime.BasisLibrary;

public final class UnionIterator
extends NodeIteratorBase {
    private final DOM _dom;
    private static final int InitSize = 8;
    private int _heapSize = 0;
    private int _size = 8;
    private LookAheadIterator[] _heap = new LookAheadIterator[8];
    private int _free = 0;
    private int _returnedLast;

    public UnionIterator(DOM dom) {
        this._dom = dom;
    }

    public NodeIterator cloneIterator() {
        LookAheadIterator[] heapCopy = new LookAheadIterator[this._heap.length];
        try {
            UnionIterator clone = (UnionIterator)super.clone();
            int i = 0;
            while (i < this._free) {
                heapCopy[i] = this._heap[i].cloneIterator();
                ++i;
            }
            clone.setRestartable(false);
            clone._heap = heapCopy;
            return clone.reset();
        }
        catch (CloneNotSupportedException e) {
            BasisLibrary.runTimeError(7, e.toString());
            return null;
        }
    }

    public UnionIterator addIterator(NodeIterator iterator) {
        if (this._free == this._size) {
            LookAheadIterator[] newArray = new LookAheadIterator[this._size *= 2];
            System.arraycopy(this._heap, 0, newArray, 0, this._free);
            this._heap = newArray;
        }
        ++this._heapSize;
        this._heap[this._free++] = new LookAheadIterator(iterator);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int next() {
        while (this._heapSize > 0) {
            int smallest = this._heap[0].node;
            if (smallest == 0) {
                if (this._heapSize <= 1) return 0;
                LookAheadIterator temp = this._heap[0];
                this._heap[0] = this._heap[--this._heapSize];
                this._heap[this._heapSize] = temp;
            } else if (smallest == this._returnedLast) {
                this._heap[0].step();
            } else {
                this._heap[0].step();
                this.heapify(0);
                this._returnedLast = smallest;
                return this.returnNode(this._returnedLast);
            }
            this.heapify(0);
        }
        return 0;
    }

    public NodeIterator setStartNode(int node) {
        if (this._isRestartable) {
            this._startNode = node;
            int i = 0;
            while (i < this._free) {
                this._heap[i].iterator.setStartNode(node);
                this._heap[i].step();
                ++i;
            }
            this._heapSize = this._free;
            int i2 = this._heapSize / 2;
            while (i2 >= 0) {
                this.heapify(i2);
                --i2;
            }
            this._returnedLast = 0;
            return this.resetPosition();
        }
        return this;
    }

    private void heapify(int i) {
        while (true) {
            int r;
            int l;
            int smallest;
            int n = smallest = (l = (r = i + 1 << 1) - 1) < this._heapSize && this._dom.lessThan(this._heap[l].node, this._heap[i].node) ? l : i;
            if (r < this._heapSize && this._dom.lessThan(this._heap[r].node, this._heap[smallest].node)) {
                smallest = r;
            }
            if (smallest == i) break;
            LookAheadIterator temp = this._heap[smallest];
            this._heap[smallest] = this._heap[i];
            this._heap[i] = temp;
            i = smallest;
        }
    }

    public void setMark() {
        int i = 0;
        while (i < this._free) {
            this._heap[i].setMark();
            ++i;
        }
    }

    public void gotoMark() {
        int i = 0;
        while (i < this._free) {
            this._heap[i].gotoMark();
            ++i;
        }
    }

    public NodeIterator reset() {
        int i = 0;
        while (i < this._free) {
            this._heap[i].iterator.reset();
            this._heap[i].step();
            ++i;
        }
        this._heapSize = this._free;
        int i2 = this._heapSize / 2;
        while (i2 >= 0) {
            this.heapify(i2);
            --i2;
        }
        this._returnedLast = 0;
        return this.resetPosition();
    }

    private static final class LookAheadIterator {
        public int node;
        public int markedNode;
        public NodeIterator iterator;

        public LookAheadIterator(NodeIterator iterator) {
            this.iterator = iterator;
        }

        public int step() {
            this.node = this.iterator.next();
            return this.node;
        }

        public LookAheadIterator cloneIterator() {
            LookAheadIterator clone = new LookAheadIterator(this.iterator.cloneIterator());
            clone.node = this.node;
            clone.markedNode = this.node;
            return clone;
        }

        public void setMark() {
            this.markedNode = this.node;
            this.iterator.setMark();
        }

        public void gotoMark() {
            this.node = this.markedNode;
            this.iterator.gotoMark();
        }
    }
}

