\name{BVcliques}
\alias{BVcliques}
\title{ Find the bivariate cliques from the marginal data. }
\description{
 The maximal cliques of the intersection graph are obtained by first
 finding the cliques for the marginal data and then combining them using
 the algorithm in Gentleman and Vandal (1999).
}
\usage{
BVcliques(intvlx, intvly, Lxopen=TRUE, Rxopen=FALSE,
                    Lyopen=TRUE, Ryopen=FALSE )
}
\arguments{
  \item{intvlx}{ The cliques for one marginal component, alternatively
    the marginal intervals can be supplied. }
  \item{intvly}{ The cliques for the other marginal component, alternatively
    the marginal intervals can be supplied. }
  \item{Lxopen}{ Boolean indicating whether the left end point in the x
    coordinate is open.}
  \item{Rxopen}{ Boolean indicating whether the right end point in the x
      coordinate is open.}
  \item{Lyopen}{ Boolean indicating whether the left end point in the y
      coordinate is open.}
  \item{Ryopen}{ Boolean indicating whether the right end point in the y
    coordinate is open.}
}

\value{
  A list of the maximal cliques of the intersection graph of the data.
}
\references{ \emph{Graph--Theoretical Aspects of Bivariate Censored
    Data}, R. Gentleman and A. Vandal, 1999, submitted. }
\author{ A. Vandal and R. Gentleman }

\seealso{  \code{\link{BVclmat}}, \code{\link{BVsupport}} }

\examples{
   data(cmv)
   cmv.cl <- BVcliques(cmv[,1:2], cmv[,3:4], Lxopen=FALSE, Lyopen=FALSE )
}
\keyword{ manip}



\eof
\name{BVclmat}
\alias{BVclmat}
\title{ Comput the clique matrix from the clique list. }
\description{
  Given the clique list, obtained from \code{\link{BVcliques}}, the
  clique matrix is obtained. This is the m (number of cliques) by n
  (number of observations) matrix. A[i,j] is one if individual j is in
  maximal clique i.
}
\usage{
BVclmat(cliques)
}

\arguments{
  \item{cliques}{ The clique list. }
}

\value{
  The m by n clique matrix.
}
\references{  \emph{Graph--Theoretical Aspects of Bivariate Censored
    Data}, R. Gentleman and A. Vandal, 1999, submitted. }
\author{ A. Vandal and R. Gentleman }

\seealso{  \code{\link{BVcliques}}, \code{\link{BVsupport}} }

\examples{
   data(cmv)
   bcl <- BVcliques(cmv[,1:2], cmv[,3:4])
   A <- BVclmat(bcl)
}
\keyword{manip}

\eof
\name{BVsupport}
\alias{BVsupport}
\title{ Compute the support for the cliques of a bivariate intersection
  graph.  }
\description{
  Given the regions where the events occurred and the cliques of the
  intersection graph the support of the cliques is computed. For each
  clique it is the intersection of the event time regions for all
  observations in that clique.
}
\usage{
BVsupport(intvlx, intvly, cliques=BVcliques(intvlx, intvly))
}
\arguments{
  \item{intvlx}{ The event time intervals for one dimension. }
  \item{intvly}{ The event time intervals for the other dimension. }
  \item{cliques}{ The list of maximal cliques of the intersection graph,
  optionally. }
}
\value{
  An m by 4 matrix containing the corners of the intervals of support
  for the maximal cliques of the intersection graph corresponding to the
  first two arguments to the function.
}
\references{\emph{Graph--Theoretical Aspects of Bivariate Censored
    Data}, R. Gentleman and A. Vandal, 1999, submitted. }
\author{ A. Vandal and R. Gentleman }

\seealso{ \code{\link{BVcliques}}, \code{\link{BVclmat}} }

\examples{
  data(cmv)
  cmv.cl <- BVcliques(cmv[,1:2], cmv[,3:4])
  boxes <- BVsupport(cmv[,1:2], cmv[,3:4], cmv.cl)
}
\keyword{manip}

\eof
\name{Bisect}
\alias{Bisect}

\title{An implementation of the bisection algorithm for root finding. }
\description{
  Most of the optimizations in \emph{Icens} have a one dimensional
  root-finding component. Since the quantities involved are generally
  restricted to a subset of [0,1] we use bisection to find the roots.
}
\usage{
Bisect(tA, pvec, ndir, Meps, tolbis=1e-07)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{tA}{ The transpose of the clique matrix. }
  \item{pvec}{ The current estimate of the probability vector. }
  \item{ndir}{ The direction to explore. }
  \item{Meps}{ Machine epsilon, elements of \code{pvec} that are less
    than this are assumed to be zero. }
  \item{tolbis}{ The tolerance used to determine if the algorithm has
    converged.  }
}
\details{
 We search from \code{pvec} in the direction \code{ndir} to obtain the
 new value of \code{pvec} that maximizes the likelihood.
}
\value{
  The new estimate of \code{pvec}.
}
\references{ Any book on optimization. }
\author{ Alain Vandal and Robert Gentleman. }


\keyword{ optimize }

\eof
\name{EM}
\alias{EM}
\title{ A function to compute the NPMLE of p based on the incidence
  matrix A. }
\description{
 The incidence matrix, \code{A} is the m by n matrix that represents the
 data. There are m probabilities that must be estimated. The EM, or
 expectation maximization, method is applied to these data.
}
\usage{
EM(A, pvec, maxiter=500, tol=1e-12)
}

\arguments{
  \item{A}{ The incidence matrix. }
  \item{pvec}{ The probability vector. }
  \item{maxiter}{ The maximum number of iterations. }
  \item{tol}{ The tolerance used to judge convergence. }
}
\details{
  Lots.
}
\value{
 An object of class \code{\link{icsurv}} containing the following
 components: 
  \item{pf }{The NPMLE of the probability vector.}
  \item{numiter }{The number of iterations used.}
  \item{converge }{ A boolean indicating whether the algorithm
    converged.}
  \item{intmap }{ If present indicates the real representation of the
    support for the values in \code{pf}. }
}
\references{The EM algorithm applied to the maximal cliques of the
  intersection graph of the censored data. \emph{The empirical distribution
    function with arbitrarily grouped, censored and truncated data},
  B. W. Turnbull, 1976, JRSS;B.}
\author{ Alain Vandal and Robert Gentleman. }

\seealso{ \code{\link{VEM}}, \code{\link{ISDM}}, \code{\link{EMICM}},
     \code{\link{PGM}} }

\examples{
    data(cosmesis)
    csub1 <- subset(cosmesis, subset= Trt==0, select=c(L,R))
    EM(csub1)
    data(pruitt)
    EM(pruitt)
}
\keyword{nonparametric }





\eof
\name{EMICM}
\alias{EMICM}
\title{ Compute the NPMLE for censored data using the EMICM. }
\description{
  An implementation of the hybrid EM ICM (Iterative convex minorant)
  estimator of the distribution function proposed by Wellner and Zahn (1997).
}
\usage{
EMICM(A, EMstep=TRUE, ICMstep=TRUE, keepiter=FALSE, tol=1e-07,
maxiter=1000) 
}
\arguments{
  \item{A}{ Either the m by n clique matrix or the n by 2 matrix
    containing the event time intervals. }
  \item{EMstep}{ Boolean, indicating whether to take an EM step in the
    iteration. }
  \item{ICMstep}{ Boolean, indicating whether to take an ICM step. }
  \item{keepiter}{  Boolean determining whether to keep the iteration
    states. }
  \item{tol}{ The maximal L1 distance between successive estimates
    before stopping iteration. }
  \item{maxiter}{ The maximal number of iterations to perform before
    stopping. }
}
\details{
  Lots, and they're complicated too!
}
\value{
  An  object of class \code{\link{icsurv}} containing the following
  components:
  \item{pf }{ The estimated probabilities.}
  \item{sigma }{ The NPMLE of the survival function on the maximal
    antichains. }
  \item{weights }{ The diagonal of the likelihood function's second
    derivative. }
  \item{lastchange }{ A vector of differences between the last two
    iterations. }
  \item{numiter }{ The total number of iterations performed.}
  \item{iter }{ Is only present if \code{keepiter} is true; states of
    sigma  during the iteration.}
  \item{intmap }{ The real representation associated with the
    probabilities reported in \code{pf}.}
}
\references{\emph{A hybrid algorithm for computation of the nonparametric
maximum likelihood estimator from censored data}, J. A. Wellner and
Y. Zhan, 1997, JASA.  }
\author{ Alain Vandal and Robert Gentleman }
\seealso{ \code{\link{EM}},\code{\link{VEM}}, \code{\link{PGM}} }

\examples{
  data(cosmesis)
  csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
  EMICM(csub1)
  data(pruitt)
  EMICM(pruitt)
}
\keyword{optimize}

\eof
\name{ISDM}
\alias{ISDM}
\title{ Estimate the NPMLE of censored data using the ISDM method
  proposed in Lesperance and Kalbfleisch (19 }
\description{
  ISDM is a method for estimating the NPMLE of censored data.
}
\usage{
ISDM(A, pvec, maxiter=500, tol=1e-07, tolbis=1e-08, verbose=FALSE)
}
\arguments{
  \item{A}{ The m by n incidence, or clique, matrix. Or the n by 2
    matrix containing the event intervals.}
  \item{pvec}{ An initial estimate of the probability vector; not required. }
  \item{maxiter}{Maximum number of iterations to be made. }
  \item{tol}{ The tolerance used to determine convergence. }
  \item{tolbis}{ A second tolerance used for the steps. }
  \item{verbose}{ Boolean, should verbose output be printed. }
}
\details{
  Lots of complicated stuff should go here.
}
\value{
A list containing:
  \item{pf }{The estimated NPMLE of the probability vector.}
  \item{numiter }{The number of iterations performed.}
}
\references{ An Algorithm for Computing the Nonparametric MLE of a Mixing
  Distribution, Lesperance, Mary L. and Kalbfleisch, John D., JASA,
  1992 }
\author{Alain Vandal and Robert Gentleman }

\seealso{ \code{\link{VEM}}, \code{\link{EMICM}},
     \code{\link{PGM}} }

\examples{
    data(cosmesis)
    csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
    ISDM(csub1)
#    data(pruitt)
#    ISDM(pruitt)  
}
\keyword{optimize}

\eof
\name{Icens-internal}
\alias{BVmacprod}
\alias{EMICMmac}
\alias{Intersection}
\alias{Subset}
\alias{VEMICMmac}   
\alias{rescaleP}

\title{Internal Icens functions}
\description{
 Internal Icens functions
}
\usage{
These are not really user level functions.
}
\details{
  These are not to be called by the user.
}
\keyword{ts}

\eof
\name{MLEintvl}
\alias{MLEintvl}
\title{ Compute the real representation for the maximal cliques. }
\description{
  The intervals on the real line that corresponds to the intersections
  of the maximal cliques are computed and returned.
}
\usage{
MLEintvl(intvls, ml=Maclist(intvls))
}
\arguments{
  \item{intvls}{ The n by 2 matrix containing the event time intervals
    for the individuals under study. }
  \item{ml}{ The \code{\link{Maclist}} computed for the \code{intvls}. }
}
\value{
 An m by 2 matrix, where m is the number of maximal cliques. The first
 column contains the left end point of the real representation for the
 appropriate maximal clique and the second column contains the right end
 point. 
}
\references{ Computational Methods for Censored Data using Intersection
  Graphs, R. Gentleman and A. Vandal, JCGS, 2000. }
\author{Alain Vandal and Robert Gentleman  }
\seealso{ \code{\link{Maclist}} }

\examples{
   data(cosmesis)
   csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
   MLEintvl(csub1)
}
\keyword{manip }

\eof
\name{Maclist}
\alias{Maclist}
\title{ A function to  }
\description{
  Returns a list of maximal cliques of the intersction graph of the
  real valued intervals supplied in \code{m}. These are one dimensional
  intervals with one interval for each individual. The algorithm is
  coded in interpreted code and should be moved to compiled code for speed.
  How do we handle exact failure times?
  Which algorithm is used?
}
\usage{
Maclist(intvls, Lopen=TRUE, Ropen=FALSE)
}
\arguments{
  \item{intvls}{ A n by 2 matrix, the first column is the left endpoints and
  the second column contains the right endpoints of the failure time
  intervals.}
  \item{Lopen}{A boolean indicating whether the intervals are open on
    the left.}
  \item{Ropen}{ A boolean indicating whether the intervals are open on
    the right.}
}
\value{
  A list of length m. Each element of the list corresponds to one
  maximal antichain. The row numbers (from \code{m}) identify the
  individuals and all row numbers for the individuals in the maximal
  clique. Maximal cliques occur in their natural (left to right) order.
}
\references{Computational Methods for Censored Data using Intersection
  Graphs, R. Gentleman and A. Vandal, JCGS, 2000. }
\author{ Alain Vandal and Robert Gentleman }

\seealso{ \code{\link{Macmat}} }

\examples{
   data(cosmesis)
   csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
   ml1 <- Maclist(csub1)
}

\keyword{manip }

\eof
\name{Macmat}
\alias{Macmat}
\title{A function to compute the incidence matrix for an intersction graph. }
\description{
  Returns the Petrie matrix and Petrie pairs of an interval order given its
  list of maximal antichains. These can be obtained from
  \code{\link{Maclist}}. 
}
\usage{
Macmat(ml)
}
\arguments{
  \item{ml}{ A list containing the maximal cliques of the intersection
    graph of the data. }
}
\details{
  Not worth mentioning?
}
\value{
  A list containing two components.  
  \item{pmat }{The Petrie or clique matrix of the underlying interval order.}
  \item{ppairs }{The Petrie pairs for each observation. These indicate
    the first and last maximal clique occupied by the observation.}
}
\references{Computational Methods for Censored Data using Intersection
  Graphs, R. Gentleman and A. Vandal, JCGS, 2000.  }
\author{ Alain Vandal and Robert Gentleman}

\seealso{ \code{\link{Maclist}} }

\examples{
   data(cosmesis)
   csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
   ml1 <- Maclist(csub1)
   mm1 <- Macmat(ml1)
}
\keyword{manip }

\eof
\name{PGM}
\alias{PGM}
\title{ An implementation of the projected gradient methods for finding
  the NPMLE. }
\description{
  An estimate of the NPMLE is obtained by using projected gradient
  methods. This method is a special case of the methods described in Wu
  (1978). 
}
\usage{
PGM(A, pvec, maxiter = 500, tol=1e-07, told=2e-05, tolbis=1e-08,
    keepiter=FALSE)
}
\arguments{
  \item{A}{ \code{A} is either the m by n clique matrix or the n by 2
    matrix containing the left and right end points for each event time. }
  \item{pvec }{ An initial estimate of the probability vector. }
  \item{maxiter }{ The maximum number of iterations to take. }
  \item{tol}{ The tolerance for decreases in likelihood. }
  \item{told}{ \code{told} does not seem to be used. }
  \item{tolbis}{ The tolerance used in the bisection code. }
  \item{keepiter}{ A boolean indicating whether to return the number of
    iterations.  }
}
\details{
  New directions are selected by the projected gradient method. The new
  optimal \code{pvec} is obtained using the bisection algorithm, moving
  in the selected direction. Convergence requires both the \eqn{L_1}
  distance for the improved \code{pvec} and the change in likelihood to
  be below \code{tol}.
}
\value{
  An object of class \code{\link{icsurv}} containing the following
  components: 
  \item{pf }{The NPMLE of \code{pvec}. }
  \item{sigma }{The cummulative sum of \code{pvec}.}
  \item{lval }{ The value of the log likelihood at \code{pvec}.} 
  \item{clmat }{ The clique matrix. }
  \item{method }{ The method used, currently only "MPGM" is possible. }
  \item{lastchange }{ The difference between \code{pf} and the previous
    iterate. }
  \item{numiter}{ The number of iterations carried out. }
  \item{eps}{ The tolerances used. }
  \item{converge }{ A boolean indicating whether convergence occurred
    within \code{maxiter} iterations. }
  \item{iter }{ If \code{keepiter} is true then this is a matrix
    containing all iterations - useful for debugging.}
}
\references{ \emph{Some Algorithmic Aspects of the Theory of Optimal
    Designs}, C.--F. Wu, 1978, Annals. }
\author{ Alain Vandal and Robert Gentleman. }

\seealso{ \code{\link{VEM}}, \code{\link{ISDM}}, \code{\link{EMICM}},
     \code{\link{PGM}}, \code{\link{EM}} }

\examples{
    data(cosmesis)
    csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
    PGM(csub1)
    data(pruitt)
    PGM(pruitt)
}
\keyword{optimize}

\eof
\name{PMGA}
\alias{PMGA}
\title{ Implement the pool monotone groups algorithm. }
\description{
  For isotonization problems some increase in speed and decrease in
  complexity can be achieved through the use of the pool monotone groups
  algorithm of Y.L. Zhang and M.A. Newton (1997).
  It isotonizes a weighted and ordered set of values.
}
\usage{
PMGA(est, ww=rep(1, length(est)))
}
\arguments{
  \item{est}{ The vector of values, in the appropriate order. }
  \item{ww}{ The weight vector. }
}
\details{
  To be supplied at some later date.
}
\value{
 An object containing the following components:
  \item{est }{ The isotonized estimates. }
  \item{ww }{The weights associated with the isotonized estimates. }
  \item{poolnum }{ The number of values pooled in the current
    estimate. }
  \item{passes }{ The number of passes which were required to isotonize
    the list. } 
}
\references{ Y.L. Zhang and M.A. Newton (1997),
    http://www.stat.wisc.edu/~newton/newton.html) }
\author{ Alain Vandal and Robert Gentleman. }

\seealso{ \code{\link{EMICM}} }

\keyword{optimize}

\eof
\name{Plotboxes}
\alias{Plotboxes}
\title{ Plot the event time regions for bivariate data. }
\description{ Plot rectangles described by the interval given in the
  first two arguments.}
\usage{
Plotboxes(int1, int2, textp=FALSE, showmac=FALSE, showsupp=FALSE, showmp=FALSE,
cliques=NULL, macprod=NULL, density=c(2, 8, 20), col=c(2, 3, 4),
offsetx=0.02, offsety=0.03) 
}

\arguments{
  \item{int1}{ The intervals for the x dimension. }
  \item{int2}{ The intervals for the y dimension. }
  \item{textp}{ }
  \item{showmac}{ Boolean, if true then the maximal cliques are shown in
  a different colour? }
  \item{showsupp}{  }
  \item{showmp}{ }
  \item{cliques}{  }
  \item{macprod}{  }
  \item{density}{  }
  \item{col}{  }
  \item{offsetx}{  }
  \item{offsety}{  }
}

\value{
  No value is returned. The event rectangles are plotted on the active
  graphics device.
}
\references{ \emph{Graph--Theoretical Aspects of Bivariate Censored
    Data}, R. Gentleman and A. Vandal, 1999, submitted. }
\author{ A. Vandal and R. Gentleman }
\seealso{ \code{\link{BVclmat}}, \code{\ling{BVsupport}},
  \code{\link{BVcliques}}  }

\examples{
   data(cmv)
   Plotboxes(cmv[,1:2], cmv[,3:4], showmac=TRUE)
}
\keyword{aplot}




\eof
\name{VEM}
\alias{VEM}
\title{ Compute the NPMLE of p via the Vertex Exchange Method. }
\description{
  The Vertex Exchange Method is used to obtain the NPMLE of \code{p}.
}
\usage{
VEM(A, pvec, maxiter=500, tol=1e-07, tolbis=1e-07), keepiter=FALSE)
}
\arguments{
  \item{A}{ The m by n incidence matrix or the n by 2 matrix of intervals. }
  \item{pvec}{ The initial estimate for the probability vector. }
  \item{maxiter}{ The maximum number of iterations allowed. }
  \item{tol}{ The tolerance used to determine convergence. }
  \item{tolbis}{ The tolerance used in the bisection stage of the
    algorithm. }
  \item{keepiter}{Should iteration information be retained and returned.}
} 
\details{
  Lots.
}
\value{
  An object of class \code{\link{icsurv}} with the following components.
  \item{pf }{The NPMLE of the probability vector. }
  \item{numiter }{The number of iterations used.}
  \item{lval}{The value of the logarithm of the likelihood at the
    NPMLE. }
  \item{converge}{Boolean stating whether the iteration converged.}
  \item{intmap}{If present it contains the real representations for the
    maximimal cliques. These are the intervals (on the real line) where
    the mass in \code{pf} is placed.}
}
\references{ \emph{A Vertex-exchange-method in $D$-optimal Design Theory
    }, D. Bohning, Metrika, 1986. }
\author{ Robert Gentleman and Alain Vandal }

\seealso{ \code{\link{EM}}, \code{\link{ISDM}}, \code{\link{EMICM}},
     \code{\link{PGM}} }

\examples{
    data(cosmesis)
    csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
    VEM(csub1)
    data(pruitt)
    VEM(pruitt)
}
\keyword{optimize}




\eof
\name{cmv}
\alias{cmv}
\non_function{}
\title{ Data on times to shedding of cytomegalovirus and to colonization
  of mycobacterium avium complex.  }
\description{
  The \code{cmv} data frame has 204 rows and 4 columns.
  The intervals should be treated as closed at both ends to replicate
  the analysis in Betensky and Finkelstein.
}
\format{
This data frame contains the following columns:
\describe{
  \item{cmvL}{
    The left end of the CMV shedding interval. 
  }
  \item{cmvR}{
    The right end of the CMV shedding interval.
  }
  \item{macL}{
    The left end of the MAC colonization interval.
  }
  \item{macR}{
    The right end of the MAC colonization interval.
  }
}
}
\details{
  Betensky and Finkelstein, 1999 present data from the AIDS Clinical
Trials Group protocol ACTG 181. This was a natural history substudy of
a comparative trial. Patients were scheduled for clinic visits during
follow--up and data was collected on the time until two events;
shedding of cytomegalovirus (CMV) in the urine and blood and for
colonization of mycobacterium avium complex (MAC) in the sputum or
stool. 
}
\source{
Betensky, R. A. and Finkelstein, D. M., 1999,  
\emph{A nonparametric maximum likelihood estimator for bivariate interval
censored data},
Statistics in Medicine,
}
\examples{
data(cmv)
}
\keyword{datasets}

\eof
\name{cosmesis}
\alias{cosmesis}
\non_function{}
\title{ The time taken until cosmetic deterioration of breast cosmesis. }
\description{
  The \code{cosmesis} data frame has 95 rows and 3 columns.
 

}
\format{
This data frame contains the following columns:
\describe{
\item{L}{
The left end point of the cosmetic deterioration interval.
}
\item{R}{
The right end point of the cosmetic deterioration interval.
}
\item{Trt}{
The treatment indicator. It is zero for those that received radiotherapy.
}
}
}

\source{
 \emph{A semiparametric model for regression analysis of
   interval-censored failure time data,} D. M. Finkelstein and
 R. A. Wolfe, 1985, Biometrics.
}
\examples{
data(cosmesis)
}
\keyword{datasets}

\eof
\name{hiv}
\alias{hiv}
\non_function{}
\title{ Intervals for infection time and disease onset for 257
  hemophiliac patients.  }
\description{
The \code{hiv} data frame has 257 rows and 4 columns.
}
\format{
This data frame contains the following columns:
\describe{
\item{yL}{
The left end point of the infection time interval.
}
\item{yR}{
The right end point of the infection time interval.
}
\item{zL}{
The left end point of the disease onset interval.
}
\item{zR}{
The right end point of the disease onset interval.
}
\item{Age}{ Coded as 1 if the estimated age at infection was less than 20 
  and 2 if the estimated age at infection was greater than 20.}
\item{Trt}{ Treatment, Light or Heavy}
}
}
\details{
  The setting is as follows. Individuals were infected with the HIV virus
at some unknown time they subsequently develop AIDS at a second
unknown time. The data consist of two intervals, \eqn{(y_L, y_R)}
and \eqn{(z_L,z_R)}, such that the infection time was in the first
interval and the time of disease onset was in the second interval.
A quantity of interest is the incubation time of the disease which is
\eqn{T=Z-Y}. The authors argue persuasively that
this should be considered as bivariate interval censored data.
They note that simply forming the differences \eqn{(z_L-y_R, z_R-y_L)} and
analysing the
resultant data assumes an incorrect likelihood.
DeGruttola and Lagakos transform the problem slightly to study the joint
distribution of \eqn{Y} and \eqn{T=Z-Y}.
This is equivalent to estimating the joint distribution of \eqn{Z} and
\eqn{Y} then transforming.
The data, as reported, have been discretized into six month intervals.

We use the data as reported in Table 1 of DeGruttola and Lagakos, 1989.
The patients were 257 persons with Type A or B hemophilia treated at
two hospitals in France.
They were then examined intermittently (as they came in for treatment?)
and their HIV and AIDS status was determined.
Kim, De Gruttola and Lagakos report some covariate information and
their paper is concerned with the modeling of that information. In
this paper we concentrate only on the event times and ignore the
covariate information; that topic being worthy of separate
investigation.

}
\source{
DeGruttola, V. and Lagakos, S.W.,
1989,
\emph{Analysis of doubly-censored survival data, with application to {AIDS}},
Biometrics.

Kim, Mimi Y. and De Gruttola, Victor G. and Lagakos, Stephen W., 1993,
\emph{Analyzing Doubly Censored Data With Covariates, With Application
  to  AIDS},
Biometrics.

}
\examples{
data(hiv)
}
\keyword{datasets}

\eof
\name{icsurv}
\alias{icsurv}
\title{ The class of objects returned by the estimation routines in the
  Icens library. }
\description{
  An object of class \code{icsurv} must contain the following
  components:
  \item{converge}{A boolean indicating whether the iteration producing
    \code{pf} converged.}
  \item{pf }{The probability vector.}
  

  It can optionally contain any of the following components:
  \item{clmat }{The clique matrix used to obtain \code{pf}.}
  \item{intmap}{The real representations of the support for the
    components of \code{pf}.}
  \item{iter }{A matrix containing every iterative estimate of
    \code{pf}, useful for debugging.}
  \item{lval}{The value of the \bold{log} likelihood at \code{pf}.}
  \item{numiter}{The number of iterations taken.}
  \item{sigma}{The cumulative sum of \code{pf}.}
  \item{weights}{Weights used in the EMICM algorithm.}
}

\author{ Alain Vandal and Robert Gentleman. }

\seealso{ \code{\link{VEM}}, \code{\link{ISDM}}, \code{\link{EMICM}},
     \code{\link{PGM}}, \code{\link{EM}} }
\keyword{methods}

\eof
\name{plot.icsurv}
\alias{plot.icsurv}
\title{ A plot method for the estimates produced by the estimation
  methods in Icens. }
\description{
  Procduces nice plots of the estimated NPMLE.
}
\usage{
plot.icsurv(x, type="eq", surv=FALSE, bounds=FALSE, shade=3, density=30,
angle=45, lty=1, new=TRUE, xlab="Time", ylab="Probability", main="GMLE",
ltybnds=2, ...)
}
\arguments{
  \item{x}{ The estimate of the NPMLE. }
  \item{type}{ Three options, "eq" for equivalence call, "gw" for the
    Groeneboom-Wellner estimate, and "lc" for the left-continuous estimate. }
  \item{surv}{ ~~Describe \code{surv} here~~ }
  \item{bounds}{ ~~Describe \code{bounds} here~~ }
  \item{shade}{ ~~Describe \code{shade} here~~ }
  \item{density}{ ~~Describe \code{density} here~~ }
  \item{angle}{ ~~Describe \code{angle} here~~ }
  \item{lty}{ ~~Describe \code{lty} here~~ }
  \item{new}{ ~~Describe \code{new} here~~ }
  \item{xlab}{ ~~Describe \code{xlab} here~~ }
  \item{ylab}{ ~~Describe \code{ylab} here~~ }
  \item{main}{ ~~Describe \code{main} here~~ }
  \item{ltybnds}{ ~~Describe \code{ltybnds} here~~ }
  \item{\dots}{ ~~Describe \code{\dots} here~~ }
}

\value{
  No value is returned. A plot of the NPMLE is made on the active
  graphics device.
}

\author{Alain Vandal and Robert Gentleman.  }

\seealso{\code{\link{VEM}}, \code{\link{ISDM}}, \code{\link{EMICM}},
  \code{\link{PGM}}  }

\examples{
    data(cosmesis)
    csub1 <- subset(cosmesis, subset=Trt==0, select=c(L,R))
    e1 <- VEM(csub1)
    par(mfrow=c(2,2))
    plot(e1)
    data(pruitt)
    e2 <- EM(csub1)
    plot(e2)
    e3 <- PGM(csub1)
    plot(e3)
    e4 <- EMICM(csub1)
    plot(e4)
}
\keyword{hplot}

\eof
\name{pruitt}
\alias{pruitt}
\non_function{}
\title{ A small artificial, bivariate right-censored data set. }
\description{
The \code{pruitt} data was given in Pruitt (1993) as an example for
testing different methods of estimating the bivariate NPMLE for right
censored data.
This matrix represents the clique matrix of the intersection graph of
the data set given by Pruitt.
}
\format{
This data frame contains 
8 columns, labeled A through H that represent the observations. There
are seven rows corresponding to the seven maximal cliques in the
intersection graph.
}
\source{
Small Sample Comparison of Six Bivariate Survival Curve
            Estimators, Journal of Statistical Computation and Simulation,
R. Pruitt, 1993.
}
\examples{
data(pruitt)
}
\keyword{datasets}

\eof
