### Name: robust.boot
### Title: Robust Error Resistant Bootstrap Algorithm
### Aliases: robust.boot
### Keywords: nonparametric

### ** Examples

# load GeneTS library
library(GeneTS)

# small example data set 
data(caulobacter)
dat <- caulobacter[,1:15]
dim(dat)

# test statistic: vector of means 
test.fun <- function(data, i)
{
  res <- apply(data[i,], 2, mean) 
  if (runif(1) < .01) stop("Error!") # in 1 percent of cases an error occurs ... 
  return(res)
}

# perform bootstrap
b.out <- robust.boot(dat, test.fun, 1000)

# despite the errors bootstrapping has finished
dim(b.out$t)

# bootstrap means
bag <- apply(b.out$t, 2, mean)
bag



