### Name: fisher.g.test
### Title: Fisher's Exact g Test for Multiple (Genetic) Time Series
### Aliases: fisher.g.test
### Keywords: htest

### ** Examples

# load GeneTS library
library(GeneTS)

# load data set
data(caulobacter)

# how many samples and and how many genes?
dim(caulobacter)

# p-values from Fisher's g test
pval.caulobacter <- fisher.g.test(caulobacter)
pval.caulobacter

# test with FDR controlled at on the level 0.05
fdr.control(pval.caulobacter, Q = 0.05)



