### Name: fdr.estimate.eta0
### Title: Estimate the Proportion of Null p-Values
### Aliases: fdr.estimate.eta0
### Keywords: htest

### ** Examples

# load GeneTS library
library(GeneTS)

# load data set
data(caulobacter)

# how many genes and how many samples?
dim(caulobacter)

# p-values from Fisher's g test
pval.caulobacter <- fisher.g.test(caulobacter)

# Proportion of null p-values for different methods
fdr.estimate.eta0(pval.caulobacter)
fdr.estimate.eta0(pval.caulobacter, method="adaptive")
fdr.estimate.eta0(pval.caulobacter, method="bootstrap")
fdr.estimate.eta0(pval.caulobacter, method="smoother")



