\name{GSint}
\alias{GSint}
\title{ Creation of GSint class object }
\description{
The \code{GSint} class object contains the expression values and the annotations
of the GeneSpring Expriment Interpretation object. Apart from the \code{new} function,
the function \code{GSint} can be used to create a new \code{GSint} object.
}

\usage{
new("GSint",
        expName       = ....  # Object of class "character",
        a.nor         = ....  # Object of class "matrix",
        se.nor        = ....  # Object of class "matrix",
        sd.nor        = ....  # Object of class "matrix",
        n.nor         = ....  # Object of class "matrix",
        a.raw         = ....  # Object of class "matrix",
        se.raw        = ....  # Object of class "matrix",
        sd.raw        = ....  # Object of class "matrix",
        n.raw         = ....  # Object of class "matrix",
        a.ctr         = ....  # Object of class "matrix",
        se.ctr        = ....  # Object of class "matrix",
        sd.ctr        = ....  # Object of class "matrix",
        n.ctr         = ....  # Object of class "matrix",
        expparam      = ....  # Object of class "data.frame",
        numConditions = ....  # Object of class "numeric",
        ngenes        = ....  # Object of class "numeric"
)

GSint(expName = "GeneSpring experiment",
        a.nor = matrix(nc = 0, nr = 0),
        se.nor = matrix(nc = 0, nr = 0),
        sd.nor = matrix(nc = 0, nr = 0),
        n.nor = matrix(nc = 0, nr = 0),
        a.raw = matrix(nc = 0, nr = 0), 
        se.raw = matrix(nc = 0, nr = 0), 
        sd.raw = matrix(nc = 0, nr = 0), 
        n.raw = matrix(nc = 0, nr = 0),
        a.ctr = matrix(nc = 0, nr = 0),
        se.ctr = matrix(nc = 0, nr = 0),
        sd.ctr = matrix(nc = 0, nr = 0),
        n.ctr = matrix(nc = 0, nr = 0),
        expparam = data.frame(),
        numConditions = 0,
        ngenes = 0
)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{expName}{Experiment name}
\item{a.nor}{Matrix representing the AVERAGE expression values for the NORMALIZED expression values}
\item{se.nor}{Matrix representing the STANDARD ERROR for the NORMALIZED expression values}
\item{sd.nor}{Matrix representing the STANDARD DEVIATION for the NORMALIZED expression values}
\item{n.nor}{Matrix representing the NUMBER OF REPLICATES in this condition for the NORMALIZED values}
\item{a.raw}{Matrix representing the AVERAGE expression values for the RAW expression values}
\item{se.raw}{Matrix representing the STANDARD ERROR for the RAW expression values}
\item{sd.raw}{Matrix representing the STANDARD DEVIATION for the RAW expression values}
\item{n.raw}{Matrix representing the NUMBER OF REPLICATES in this condition for the RAW values}
\item{a.ctr}{Matrix representing the AVERAGE expression values for the CONTROL values}
\item{se.ctr}{Matrix representing the STANDARD ERROR for the CONTROL values}
\item{sd.ctr}{Matrix representing the STANDARD DEVIATION for the CONTROL values}
\item{n.ctr}{Matrix representing the NUMBER OF REPLICATES in this condition for the CONTROL values}
\item{expparam}{Data drame representin the sample attributes or experimental parameters}
\item{numConditions}{Numeric value representing the number of conditions (or samples) in this interpretaion or experiment}
\item{ngenes}{Numeric values representing the number of genes in the experiment}
}
\details{
The \code{GSint} class object is a representation of a GeneSpring Experiment Interpretation.
The object consists of 16 slots:

1) The name of the experiment (slot: expName)
2) Twelve slots representing the various types of expression data as matrix objects
3) The experimental parameters (slot: expparam)
4) The number of samples or conditions in the experiment (slot: numConditions)
5) The number of genes (slot: ngenes)

All of the expression value slots are optional and are not guaranteed to contain data.
When a GeneSpring Experiment is read in from file, only the a.nor slot and optionally
the a.ctr slot will contain data.
When a GeneSpring Experiment INTERPRETATION is read, any of the 12 expression values slots
could contain data. Which data slots are filled is dependent on which choices were made
in the construction of the external programs in GeneSpring.

For more information about GeneSpring external programs see the GeneSpring manual.
For more information about the differences between an Experiment and an Interpretation
see the R manual entries for \code{\link{GSload.int}} and \code{\link{GSload.exp}}.
}

\value{
Both \code{GSint} and \code{new} return an object of class \code{GSint}.
}
\references{ 

For more information on using GeneSpring with R see
\url{http://www.silicongenetics.com/cgi/SiG.cgi/Support/GeneSpring/GSnotes/R.smf}
}

\author{ 
   Thon de Boer, Silicon Genetics, Redwood city, CA, USA \email{thon@silicongenetics.com}

}

\note{ This and any other functions in the GeneSpring package are only useful,
when using Silicon Genetics Gene Expression software GeneSpring.
}

\seealso{
\code{\link{GSload.int}},
\code{\link{GSload.exp}},
\code{\link{GSsave.exp}},
\code{\link{GSint2BC}},
\code{\link{BC2GSint}}
}

\examples{
#Create some simple sample annotation
ep <- t(data.frame(SampleName=1:10))
#Create a GSint object with random data as the RAW data object
gs.int <- GSint(expName="Random data",a.raw=matrix(rnorm(1000),nc=10),expparam=ep)

gs.int@expName
t(gs.int@expparam)
}

\keyword{ IO }% at least one, from doc/KEYWORDS

\eof
\name{GSint2BC}
\alias{GSint2BC}
\alias{BC2GSint}
\title{ Convertors for GeneSpring GSint and Bioconductor exprSet objects }

\description{
These functions convert GeneSpring Experiment (Interpretation) objects
into BioConductor expression objects and vice versa.
}

\usage{
expr.set <- GSint2BC(interpretation, what = "nor")
gs.int <- BC2GSint(exprSet)
}

\arguments{
  \item{interpretation}{ GeneSpring Expereiment Interpretation object }
  \item{what}{ For \code{GSload.intBC()} only. Indicates what data from the
   GeneSpring Experiment Interpretation should be used.
   Valid values for \code{what} can be \code{nor} and \code{raw}, representing
   Normalized or Raw expression values. The Control values cannot be used.}
  \item{exprSet}{ GeneSpring Expereiment Interpretation object }
}

\details{
The GeneSpring Experiment Interpretation and the BioConductor objects are
quite similar, but there are some differences. GeneSpring interpretations
can contain information on both normalized and original raw values, and
can include, Standard Error, Standard Deviation and number of replicates
information, but the BioConductor objects can contain more sample attribute
information in the form of the MIAME annotations.

These functions provide convertors for both types of objects.

When converting a GeneSpring object into a BioConductor object, the user
has the choice of either using the normalized or raw expression values for
the BioConductor exprSet object. Conversely, when a BioConductor objects is
converted into a GeneSpring object, the expression values are loaded as
normalized values.

The phenoData objects describing the phenotypical data for the samples in a
BioConductor object are converted into Experimental Parameter objects in the
GeneSpring class object, and vice versa.

The experiment name and any of the other annotations for the BioConductor
objects that are stored in the MIAME objects are currently not converted,
although future versions of these convertors may provide better mapping.
}

\value{
The return value depends on which fucntion was called.
The \code{BC2GSint()} function returns an object of class \code{GSint}.
The \code{GSint2BC()} function returns a BioConductor object of class \code{exprSet}.
See the documentation on \code{GSint} and \code{exprSet} for more information.
}

\references{ 

For more information on using GeneSpring with R see
\url{http://www.silicongenetics.com/cgi/SiG.cgi/Support/GeneSpring/GSnotes/R.smf}
}
\author{ 
   Thon de Boer, Silicon Genetics, Redwood city, CA, USA \email{thon@silicongenetics.com}

}
\note{ This and any other functions in the GeneSpring package are only useful,
when using Silicon Genetics Gene Expression software GeneSpring.
}

\seealso{
\code{\link{GSload.exp}},
\code{\link{GSload.int}},
\code{\link{GSsave.exp}}
}
\examples{
#Use the example data etc. from exprSet
library(Biobase)
data(geneData)
data(geneCov)
covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
names(covdesc) <- names(geneCov)
pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
eset <- new("exprSet", exprs=geneData, phenoData=pdata)

#Convert the objects into GeneSpring objects and back again
gs.int <- BC2GSint(eset)
expr.set <- GSint2BC(gs.int)

}
\keyword{ IO }% at least one, from doc/KEYWORDS


\eof
\name{GSload.exp}
\alias{GSload.exp}
\alias{GSload.expBC}
%- Also NEED an '\alias' for EACH other topic documented here.

\title{ Read GeneSpring Experiment from file}

\description{
A GeneSpring Experiment is read in, usually from a file,
but a connection object (like \code{stdin()}) can also be passed.
The return value can either be an object of class \code{GSint} or
BioConductor \code{exprSet} representing the Experiment Interpretation
from GeneSpring.
}

\usage{
gs.int<-GSload.exp(filename = "GS_R_in.txt")
expr.set<-GSload.expBC(filename = "GS_R_in.txt")
}

%- maybe also 'usage' for other objects documented here.

\arguments{
\item{filename}{ Name of the file containing the GeneSpring Experiment Interpretation. Can also be a connection object.}
}

\details{
A GeneSpring Experiment is quite distinct from a GeneSpring Experiment INTERPRETATION.
See \code{\link{GSload.int}} for more information on GeneSpring Experiment Interpretations.

A GeneSpring Experiment consists of the Normalized expression values for each sample
and optionally the Control values for that normalized value. The control values for an
experiment are the values that are used to create the normalized values by simply
dividing the Raw expression value by the Control value. The GeneSpring Normalization
routines will calculate the control values for each gene and these values can be used
in subsequent analysis.

In a GeneSpring Experiment, each sample or hybridization has its own column (set)
of expression values, wheras the expression values for an Experiment INTERPRETATION
represent the mean value of the replicate values for that condition.

For example, if there are 4 replicates for samples of time 0, there will be
one column of normalized data for time 0 in the Experiment Interpretation,
and there will be four columns of average values for each of the replicates, in
the GeneSpring Experiment.

The experimental parameters for the experiment, are stored in the header of the file,
with each sample's parameter in columns above the expression values. When control values
are present in the file, the paramter value is simply \code{control}.

The names of the experimental parameters can also indicate whether or not the parameter
has any unit indentifier (like hour, mM, etc.) and this will be a suffix of the 
parameter name in parenthesis. The experimental parameters will also contain an
indication wheter or not the values are numeric or not, but the addition of an
asterisk character for non-numeric values and the absence of the asterisk for numerical values.

The final character of the parameter name will indicate how the parameter was used
in GeneSpring. When the parameter is used as a discontinuous parameter, the character
is a \sQuote{C}. When the parareter is used as a color coding paramter, the character
is a \sQuote{S}. When the parameter is not used to indicate a group or color coding
the character is a \sQuote{R}. When a parameter was used as the continuous parameter,
the last character is missing or empty.

When loading experimental parameters from file, the units and indication of use will be discarded.


}

}

\value{
The return value depends on which fucntion was called.
The \code{GSload.exp} function returns a object of class \code{GSint}.
The \code{GSload.expBC} function returns a BioConductor object of class \code{exprSet}.
See the documentation on \code{GSint} and \code{exprSet} for more information.
}
\references{ 

For more information on using GeneSpring with R see
\url{http://www.silicongenetics.com/cgi/SiG.cgi/Support/GeneSpring/GSnotes/R.smf}
}

\author{ 
   Thon de Boer, Silicon Genetics, Redwood city, CA, USA \email{thon@silicongenetics.com}

}

\note{ This and any other functions in the GeneSpring package are only useful,
when using Silicon Genetics Gene Expression software GeneSpring.
}

\seealso{
\code{\link{GSload.int}},
\code{\link{GSsave.exp}},
\code{\link{GSint2BC}},
\code{\link{BC2GSint}}
}
\examples{

}
\keyword{ IO }% at least one, from doc/KEYWORDS


\eof
\name{GSload.genelist}
\alias{GSload.genelist}
\alias{GSsave.genelist}
\title{ Load and save GeneSpring gene lists }
\description{
These functions load and save list of genes from and to GeneSpring.
Gene lists can consists of a simple list of genes or can contain one column
of associtated values containing either the classifications or some numeric value
representing the result of an analysis (Like P values after a ANOVA for instance).
}
\usage{
glist <- GSload.genelist(filename = "GS_R_in.txt")
GSsave.genelist(genelist, filename = "GS_R_out.txt")
}
\arguments{
  \item{filename}{ Name of the file of the genelist. Can be connection object like \code{stdin()}. }
  \item{genelist}{ Gene list to be saved to the file. Can either be a list or a data frame/matrix.}
}
\details{
Gene lists are either simple lists or vectors of gene names or data.frames.
When the gene list contains associated values, the gene list is stored as a data.frame,
with the gene names as the row.names of the data.frame and the values in the first (and only)
column of the data.frame.

There are two types of gene lists within GeneSpring, although only one is actually called
a gene lists while the other one is called a classification.

Gene lists proper are list of genes in GeneSpring with an optional NUMERICAL associated value.
This numerical values usually represents the result of one or more analyses, like the P value
of an ANOVA, or the number of samples that passed the filter that was applied.

The other type of gene lists are those lists that are produced when a Classification
is saved to a file. The classification objects are the result of the clustering
methods in GeneSpring, like K-means clustering or the QT-clustering. When classifications
are stored in file from GeneSpring, the classifications are simply gene lists with STRING
associated values, where the values designate the cluster name that gene belongs to.

The two functions \code{GSload.genelist} and \code{GSsave.genelist} will not make a distinction
between the two types of gene lists and it is left to the user to determine from the contents
of the genelists which of the two types has been loaded.

When a classification is attempted to be loaded into GeneSpring as a proper gene list, the
associated values will simply be missing if they are non-numerical.
}
\value{
The GSload.genelist() function will return either a vector of genenames, if the input was a 
simple list of genes, or a data.frame where the gene names are the row names
and one column of associated data.
}
\references{ 

For more information on using GeneSpring with R see
\url{http://www.silicongenetics.com/cgi/SiG.cgi/Support/GeneSpring/GSnotes/R.smf}
}
\author{ 
   Thon de Boer, Silicon Genetics, Redwood city, CA, USA \email{thon@silicongenetics.com}

}
\note{ This and any other functions in the GeneSpring package are only useful,
when using Silicon Genetics Gene Expression software GeneSpring.
}

\seealso{

}
\examples{
#Create a simple GeneList
glist <- c("160640_at","101906_at", "104099_at")
#Save the genelist to a file
GSsave.genelist(glist, filename = "GS_R_out.txt")
#Load the genelist again
g2 <- GSload.genelist(filename = "GS_R_out.txt")
#Add some values to the genelist as associated values by making a data.frame out of it
g3 <- data.frame(value=rnorm(3), row.names = g2)
#Save the genelist again to the default file ("GS_R_out.txt")
GSsave.genelist(g3)
#Load the gene list and display
GSload.genelist(filename = "GS_R_out.txt")

#Create classification style gene list
g4 <- data.frame(classification=c("Cluster 1","Cluster 2", "Cluster 1"), row.names = g2)
GSsave.genelist(g4)
#Load the gene list and display
GSload.genelist(filename = "GS_R_out.txt")


}
\keyword{ IO }

\eof
\name{GSload.int}
\alias{GSload.int}
\alias{GSload.intBC}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Read GeneSpring Experiment Interpretation from file}
\description{
A GeneSpring Experiment Interpretation is read in, usually from a file,
but a connection object (like \code{stdin()}) can also be passed.
The return value can either be an object of class \code{GSint} or
BioConductor \code{exprSet} representing the Experiment Interpretation
from GeneSpring.
}
\usage{
gs.int <- GSload.int(filename = "GS_R_in.txt")
expr.set <- GSload.intBC(filename = "GS_R_in.txt", what = "nor")
}
%- maybe also 'usage' for other objects documented here.

\arguments{

\item{filename}{Name of the file containing the GeneSpring Experiment Interpretation. Can also be a connection object.}
\item{what}{ For \code{GSload.intBC()} only. Indicates what data from the
GeneSpring Experiment Interpretation should be used.
Valid values for \code{what} can be \code{nor} and \code{raw}, representing
Normalized or Raw expression values. The Control values cannot be used.}

}
\details{
A GeneSpring Experiment INTERPRETATION is quite distinct from a GeneSpring
Experiment. See \code{GSload.exp()} for more information on GeneSpring Experiments.

A GeneSpring Experiment Interpretation can consist of a maximum of three sets
of six (eighteen total) columns for each condition;
The sets can be the Normalized, Raw and Control sets and each set can consists of
the Average, Min, Max, Standard error, Standard Deviation and Number of samples per condition.
The \code{GSint} class will be populated based on the names of the columns.
The column names can be any of the following:

x.AVERAGE, x.MIN, x.MAX, x.STDERR, x.STDDEV, x.N

Where x can be either N, C or R, representing Normalized, Control and Raw data
If there is more than one conditions, each consecutive set is numerbed by adding a
number to the end of the name
The first column does not have a number and the second will start numbering at 1

If there is more than one type (i.e if there is both Normalized and Raw data),
Each value type (AVERAGE, MIN, STDEV etc) is listed first for each data type

Examples:

N.AVERAGE, R.AVERAGE, N.MIN, R.MIN, N.AVERAGE.1, R.AVERAGE.1, N.MIN.1 etc.

Since teh GeneSpring user can determine what data to send to the external program,
it is up to the R programmer to determine which columns contains what type of data.

}
\value{
The return value depends on which fucntion was called.
The \code{GSload.int} function returns a object of class \code{GSint}.
The \code{GSload.intBC} function returns a BioConductor object of class \code{exprSet}.
See the documentation on \code{GSint} and \code{exprSet} for more information.
}
\references{ 

For more information on using GeneSpring with R see
\url{http://www.silicongenetics.com/cgi/SiG.cgi/Support/GeneSpring/GSnotes/R.smf}
}
\author{ 
   Thon de Boer, Silicon Genetics, Redwood city, CA, USA \email{thon@silicongenetics.com}

}
\note{ This and any other functions in the GeneSpring package are only useful,
when using Silicon Genetics Gene Expression software GeneSpring.
}

\seealso{
\code{\link{GSload.exp}},
\code{\link{GSsave.exp}}
\code{\link{GSint2BC}},
\code{\link{BC2GSint}}
}
\examples{

}
\keyword{ IO }% at least one, from doc/KEYWORDS

\eof
\name{GSsave.exp}
\alias{GSsave.exp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Save a GeneSpring Interpretation to file}
\description{
The normalized values of the GeneSpring Interpretation object will be written to file.
If the Interpretation object contains Control values, they will also be used.
The experimental paramters and the experiment name will also be inlucded.
}
\usage{
GSsave.exp(interpretation, filename = "GS_R_out.txt")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{interpretation}{ The GeneSpring Experiment Interpretation object of class \code{GSint}}
  \item{filename}{ Name of the file. Can also be a connection object.}
}
\details{
A GeneSpring Experiment consists of the Normalized expression values for each sample
and optionally the Control values for that normalized value. Each sample or hybridization
has its own column (set) of expression values, wheras the expression values for
an Experiment INTERPRETATION represent the mean value of the replicate values for that
condition.

For more information see the manual entry for \code{\link{GSload.exp}}.
}
\value{
This function does not return a usable value upon return.
}
\references{

For more information on using GeneSpring with R see
\url{http://www.silicongenetics.com/cgi/SiG.cgi/Support/GeneSpring/GSnotes/R.smf}
}

\author{

   Thon de Boer, Silicon Genetics, Redwood city, CA, USA \email{thon@silicongenetics.com}

}

\note{
This and any other functions in the GeneSpring package are only useful,
when using Silicon Genetics Gene Expression software GeneSpring.
}

\seealso{
\code{\link{GSload.exp}},
\code{\link{GSload.int}}

}
\examples{

#Use the example data etc. from exprSet
library(Biobase)
data(geneData)
data(geneCov)
covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
names(covdesc) <- names(geneCov)
pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
eset <- new("exprSet", exprs=geneData, phenoData=pdata)

#Convert the objects into GeneSpring objects
gs.int <- BC2GSint(eset)

#Save the Experiment in GeneSpring format
GSsave.exp(gs.int, filename = "GS_R_out.txt")

}
\keyword{ IO }

\eof
