\name{#PKGNAME#UNIGENE}
\alias{#PKGNAME#UNIGENE}
\title{Annotation of probe identifiers by UniGene identifiers}
\description{
  This is an R environment (hash table) object mapping probe identifiers
  to UniGene cluster identifiers
}
\details{
  Probe ids are keys and the corresponding UniGene cluster ids are
  values. Values may be vectors of length 1 or greater depending on
  whether a given probe id can be mapped to only one or more UniGene
  cluster ids. NA is assigned to probe ids that can not be mapped to any
  UniGene cluster id at this time.
  
  Mappings were based on data provided by:

  #LLSOURCE#

  Package built #DATE#
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/LocusLink}
}
\examples{
  # Convert the environment to a list
xx <- as.list(#PKGNAME#UNIGENE)
        # Remove probe ids that do no map to any UniGene id
        xx <- xx[!is.null(xx)]
if(length(xx) > 0){
  # The UniGene ids for the first two elements of XX
xx[1:2]
                # Get the first one
                xx[[1]]
}
}

\keyword{datasets}

