\name{#PKGNAME#PATH}
\alias{#PKGNAME#PATH}
\title{Annotation of probe identifiers by KEGG pathway identifiers}
\description{
  This is an R environment (hash table) object mapping probe identifiers
  to KEGG pathway identifiers
}
\details{
  Probe ids are keys and the corresponding KEGG pathway ids are
  values. Values are vectors of length 1 or greater depending on whether
  a given probe identifier can be associated with only one or more
  pathways. NA is assigned to probe ids that can not be associated with
  any pathway at this time.

  Pathway name for a given pathway id can be obtained using the KEGG
  data package that can either be built using AnnBuilder or downloaded
  from Bioconductor \url{http://www.bioconductor.org}.

  Mappings were based on data provided by:

  #KEGGSOURCE#

  #LLSOURCE#

  Package built #DATE#
}
\references{
  \url{http://www.genome.ad.jp/kegg/} and \url{http://www.ncbi.nlm.nih.gov}
}
\examples{
  # Convert the environment to a list
xx <- as.list(#PKGNAME#PATH)
        # Remove probe ids that do not map to any pathway id
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
  # The pathway ids for the first two elements of XX
xx[1:2]
                # Get the first one
                xx[[1]]
} 
}
\keyword{datasets}

