\name{#PKGNAME#MAP}
\alias{#PKGNAME#MAP}
\title{Annotation of probe identifiers by cytobands}
\description{

  This is an R environment (hash table) mapping probe identifiers to
  cytobands, which are the positions of cytogenetic bands within chromosomes
}
\details{

  Probe ids are keys and cytobands are values. Values are vectors of
  length 1 and NA is assigned to probe ids that can not be mapped to any
  cytoband at this time.

  The physical location of each band on a chromosome can be obtained
  from another environment named "organism"CYTOLOC in a separate data
  package for human(humanCHRLOC), mouse(mouseCHRLOC), and rat(ratCHRLOC).  
  
  Mappings were based on data provided by:

  #LLSOURCE#

  Package built #DATE#
}
\references{
  \url{http://www.ncbi.nlm.nih.gov}
}
\examples{
  # Convert the environment to a list
xx <- as.list(#PKGNAME#MAP)
        # Remove probe ids that do not map to any cytoband
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
  # The cytobands for the first two elements of XX
xx[1:2]
                # Get the first one
                xx[[1]]
}
}
\keyword{datasets}

