\name{#PKGNAME#GO}
\alias{#PKGNAME#GO}
\title{Annotation of probe ids by Gene Ontology information}
\description{
This is an R environment (hash table) object mapping probe ids to Gene
Ontology information collected from Gene Ontology consortium for the
genes represented by the probs. Associations of GO information to genes
can be of various types depicted by the evidence code.  
}
\details{
  Probe ids are keys and GO information are values, each of which is
  list of one (mapped to none or one set of GO information) or more
  (mapped to more than one sets of GO information) elements. When a
  probe id is mapped to at lest one set of GO information, each element
  of the list contains a sub list of three elements named "GOID",
  "Ontology", and "Evidence". Values for element "GOID" gives the Gene
  Ontology identifiers the key probe ids corresponding to. Values for
  element "Ontology" can be an abbreviation of MF (mocular function), BP
  (biological process), or CC (cellular component) for the GO category
  the GO id belongs to. Values for element "Evidence" contain an
  evidence code indicating what kind of evidence is found to support the
  association of the GO id to the key probe id. The evidence codes in
  use include:
  
  IMP: inferred from mutant phenotype  
  IGI: inferred from genetic interaction
  IPI: inferred from physical interaction  
  ISS: inferred from sequence similarity 
  IDA: inferred from direct assay  
  IEP: inferred from expression pattern  
  IEA: inferred from electronic annotation  
  TAS: traceable author statement  
  NAS: non-traceable author statement  
  ND: no biological data available  
  IC: inferred by curator
  
  Mappings between probe ids and GO information were obtained through
  their mappings to LocusLink ids. NA is assigned to probe identifiers
  that can not be mapped to any Gene Ontology information. Mappings
  between Gene Ontology ids an Gene Ontology terms and other information
  are available in a separate data package named GO.
  
  Mappings were based on data provided by:
  #LLSOURCE#
  
  Package built #DATE#
}
\references{
\url{ftp://ftp.ncbi.nih.gov/refseq/LocusLink/LL_tmpl.gz}
}
\examples{
        # Convert to a list
xx <- as.list(#PKGNAME#GO)
        # Remove all the NAs
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
            # Try the firest one
            got <- xx[[1]]           
            got[[1]][["GOID"]]
            got[[1]][["Ontology"]]
            got[[1]][["Evidence"]]

}
}
\keyword{datasets}

