\name{#PKGNAME#CHRLOC}
\alias{#PKGNAME#CHRLOC}
\title{Annotation of probe ids by chromosomal location}
\description{
This is an R environment (hash table) object mapping probe ids to
chromosomal locations measured as number of base pairs from the p arm. 
}
\details{
  Probe ids are key and their corresponding chromosomal locations are
  values with NAs assigned to probe ids whose chromosomal locations are
  not known. Values are named vectors of length 1 or more depending on
  whether a given probe id can be mapped to a single or multiple
  locations on one or more than onw chromosomes. The names give the
  chromosome number of concern. Chromosomal locations on positions the
  antisense strand have a leading "-" sign (e. g. -1234567). Chromosomal
  locations on both the sense and antisense strand are measured as the
  number of base pairs from the p (5' end of the sense strand) to q (3'
  end of the sense strand) arms.  When a gene can not be placed on a
  chromosome with confidence, "random" is appended to the end of the
  name for a chromosomal location value.  

  Mappings were based on data provided by:

  #GPSOURCE#
  
  Package built #DATE#
}
\references{
\url{http://www.genome.ucsc.edu/goldenPath/hg16/database/}
}
\examples{
  # Covert to a list
xx <- as.list(#PKGNAME#CHRLOC)
        # Remove probe ids that do not map to any CHRLOC
        xx <- xx[!is.na(xx)]
if(length(xx) > 0){
    # Gets the location for the first five probes
            xx[1:5]
            # Gets the first one
            xx[[1]]
}
}
\keyword{datasets}

