\name{GOMFCHILDREN}
\alias{GOMFCHILDREN}
\title{Annotation of GO identifiers by the GO identifiers of their
  direct chileren} 
\description{
This is an R environment (hash table) mapping GO ids to the GO
ids of their direct children under molecular function (MF). Direct
children of a given GO id are those GO ids correponding to all the
children nodes that have direct link to the node for the GO id of
concern based on the directed acyclic graph defined by Gene Ontology
Consortium. GO terms for children nodes are more specific than that for
the parents 
}
\details{
  GO ids are keys and the corresponding children GO ids are values. Values are
  vectors of length 1 or greater depending on whether the GO id of concern
  has only one or more children. GO ids that do not have any child
  node are assigned NA as the values.

  Molecular function is defined as the tasks performed by individual
  gene products; examples are transcription factor and DNA helicase as
  defined by Gene Ontology Consortium.  
  
  Mappings were based on data provided by:

  #GOSOURCE#
  
  Package built: #DATE#
}
\references{
\url{http://www.geneontology.org/} and
\url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
    require("GO", character.only = TRUE) || stop("GO unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOMFCHILDREN)
    # Remove GO ids that do not have any children
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # Get the children GO ids for the first elents of xx
        goids <- xx[[1]]
        # Find out the GO terms for the first parent goid
        GOId(GOTERMS[[goids[1]]])
        Ontology(GOTERMS[[goids[1]]])
        Synonym(GOTERMS[[goids[1]]])
        Secondary(GOTERMS[[goids[1]]])
        Definition(GOTERMS[[goids[1]]])
        Category(GOTERMS[[goids[1]]])
    }
}
\keyword{datasets}

