\name{GOMFANCESTOR}
\alias{GOMFANCESTOR}
\title{Annotation of GO identifiers by the GO identifiers of their
  ancestors} 
\description{
This is an R environment (hash table) mapping GO ids to all the GO
ids of their ancestors under molecular function (MF). Ancestors are
defined as the direct or indirect parent/grand parent nodes of a
given node for a GO id based on the directed acyclic graph defined by
Gene Ontology Consortium. GO terms for ancestor nodes are more general 
}
\details{
  GO ids are keys and the corresponding ancestor GO ids are
  values. Values are lists of length 1 or greater depending on whether
  the GO id of concern has only one or more ancestor cohorts. Each list
  contains a vector of GO ids. The first element of the list contains a
  vector of GO ids for all the direct parents, the second element of
  the list contains a vectors of GO ids for all the grand parents, and
  so on. GO ids that do not have any offspring node are assigned NA as
  the values. 

  Molecular function is defined as the tasks performed by individual
  gene products; examples are transcription factor and DNA helicase as
  defined by Gene Ontology Consortium.  
  
  Mappings were based on data provided:

  #GOSOURCE#
  
  Package built: #DATE#
}
\references{
\url{http://www.geneontology.org/} and
\url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
  require("GO", character.only = TRUE) || stop("GO unavailable")
  # Convert the environment object to a list
  xx <- as.list(GOMFANCESTOR)
  # Remove GO ids that do not have any ancestor
  xx <- xx[!is.na(xx)]
  if(length(xx) > 0){
    # Get the ancestor GO ids for the first two elents of xx
    goids <- xx[1:2]
  }
}
\keyword{datasets}

