### Name: unifyMappings
### Title: A function to unify mapping result from different sources
### Aliases: unifyMappings
### Keywords: manip

### ** Examples

myDir <- file.path(.path.package("AnnBuilder"), "temp")
geneNMap <- matrix(c("32468_f_at", "D90278", "32469_at", "L00693",
                   "32481_at", "AL031663", "33825_at", " X68733",
                   "35730_at", "X03350", "36512_at", "L32179",
                   "38912_at", "D90042", "38936_at", "M16652",
                   "39368_at", "AL031668"), ncol = 2, byrow = TRUE)
colnames(geneNMap) <- c("PROBE", "ACCNUM")
write.table(geneNMap, file = file.path(myDir, "geneNMap"), sep = "\t",
quote = FALSE, row.names = FALSE, col.names = FALSE)

temp <- matrix(c("32468_f_at", NA, "32469_at", "2",
                   "32481_at", NA, "33825_at", " 9",
                   "35730_at", "1576", "36512_at", NA,
                   "38912_at", "10", "38936_at", NA,
                   "39368_at", NA), ncol = 2, byrow = TRUE)
temp
write.table(temp, file = file.path(myDir, "srcone"), sep = "\t",
quote = FALSE, row.names = FALSE, col.names = FALSE)
temp <- matrix(c("32468_f_at", NA, "32469_at", NA,
                   "32481_at", "7051", "33825_at", NA,
                   "35730_at", NA, "36512_at", "1084",
                   "38912_at", NA, "38936_at", NA,
                   "39368_at", "89"), ncol = 2, byrow = TRUE)
temp
write.table(temp, file = file.path(myDir, "srctwo"), sep = "\t",
quote = FALSE, row.names = FALSE, col.names = FALSE)
otherMapping <- c(srcone = file.path(myDir, "srcone"),
srctwo = file.path(myDir, "srctwo"))

baseFile <-  file.path(myDir, "geneNMap")
llParser <- file.path(.path.package("AnnBuilder"), "scripts", "gbLLParser")
ugParser <- file.path(.path.package("AnnBuilder"), "scripts", "gbUGParser")
if(.Platform$OS.type == "unix"){
    llUrl <-  "http://www.bioconductor.org/datafiles/wwwsources/Tll_tmpl.gz"
    ugUrl <-  "http://www.bioconductor.org/datafiles/wwwsources/Ths.data.gz"
    fromWeb = TRUE
}else{
    llUrl <- file.path(.path.package("AnnBuilder"), "data", "Tll_tmpl")
    ugUrl <- file.path(.path.package("AnnBuilder"), "data", "Ths.data")
    fromWeb = FALSE
}
ll <- LL(srcUrl = llUrl, parser = llParser, baseFile = baseFile)
ug <- UG(srcUrl = ugUrl, parser = ugParser, baseFile = baseFile,
organism = "human") 
# Only works interactively
if(interactive()){
    unified <- unifyMappings(base =  geneNMap, ll = ll, ug = ug,
               otherSrc = otherMapping, fromWeb = fromWeb)
    read.table(unified, sep = "\t", header = FALSE)

    unlink(c(file.path(myDir, "geneNMap"), file.path(myDir, "srcone"),
    file.path(myDir, "srctwo"), unified))
}



