### Name: UG-class
### Title: Class "UG" a sub-class of pubRepo to handle data from UniGene
### Aliases: UG-class orgName orgName<- orgName,UG-method
###   orgName<-,UG-method UG
### Keywords: classes

### ** Examples

if(interactive()){
# Parse a truncated version of Hs.data.gz from Bioconductor
path <- file.path(.path.package("pubRepo"), "data")
temp <- matrix(c("32469_f_at", "D90278", "32469_at", "L00693", "33825_at",
"X68733", "35730_at", "X03350", "38912_at", "D90042", "38936_at",
"M16652"), ncol = 2, byrow = TRUE)
write.table(temp, "tempfile", sep = "\t", quote = FALSE,
row.names = FALSE, col.names = FALSE)  
ug <- UG(srcUrl =
"http://www.bioconductor.org/datafiles/wwwsources/Ths.data.gz",
parser = file.path(path, "basedUGParser"), baseFile = "tempfile",
organism = "human")
data <- parseData(ug)
unlink("tempfile")
}



