\name{ReposEntry-class}
\docType{class}
\alias{ReposEntry-class}
\alias{ReposEntry}
\alias{repdataframe}
\alias{repObjects}
\alias{repPkgInfos}
\alias{repName}
\alias{repType}
\alias{repURL}
\alias{is.ReposEntry}
\alias{depends}
\alias{suggests}
\alias{uses}
\alias{keywords}
\alias{numSubReps}
\alias{getSubRep}
\alias{getSubRepList}
\alias{hasFiles}
\alias{pkgRVersion}
\alias{downloadFile}
\alias{depends,ReposEntry-method}
\alias{downloadFile,ReposEntry-method}
\alias{getSubRep,ReposEntry-method}
\alias{getSubRepList,ReposEntry-method}
\alias{hasFiles,ReposEntry-method}
\alias{keywords,ReposEntry-method}
\alias{numSubReps,ReposEntry-method}
\alias{pkgRVersion,ReposEntry-method}
\alias{repName,ReposEntry-method}
\alias{repObjects,ReposEntry-method}
\alias{repPkgInfos,ReposEntry-method}
\alias{repPkgs,ReposEntry-method}
\alias{repType,ReposEntry-method}
\alias{repURL,ReposEntry-method}
\alias{repdatadesc,ReposEntry-method}
\alias{repdataframe,ReposEntry-method}
\alias{replisting,ReposEntry-method}
\alias{show,ReposEntry-method}
\alias{suggests,ReposEntry-method}
\alias{summary,ReposEntry-method}
\alias{uses,ReposEntry-method}
\title{A class to represent a repository}
\description{This class models all key information for a server side
  repository, which can then be passed on to clients.  It provides
  access to both the basic administrative information as well as the
  dataframe itself.}
\section{Objects from the Class}{
  The helper function \code{\link{buildReposEntry}} should be used to
  create objects of this class.
}
\section{Slots}{
  \describe{
    \item{\code{replisting}:}{Object of class \code{"replisting"} The
      administrative information for the repository}
    \item{\code{repdatadesc}:}{Object of class \code{"repdatadesc"} The
      representative dataframe for this repository }
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "ReposEntry")}: A verbose
      output of the repository}
    \item{summary}{\code{signature(object = "ReposEntry")}: A brief
      output of the repository}
    \item{repdatadesc}{\code{signature(object = "ReposEntry")}: Returns
      the repdatadesc object }
    \item{repdataframe}{\code{signature(object = "ReposEntry")}: Returns
    the raw dataframe stored in repdatadesc}
    \item{replisting}{\code{signature(object = "ReposEntry")}: Returns
      the replisting object}
    \item{repName}{\code{signature(object = "ReposEntry")}: Returns the name of the repository}
    \item{repObjects}{\code{signature(object = "ReposEntry")}: Returns a
    listing of all distributable objects contained in the repository}
    \item{repPkgInfos}{\code{signature(object = "ReposEntry")}: Returns
      a list of PkgInfo objects for packages stored in the repository }
    \item{repType}{\code{signature(object = "ReposEntry")}: Returns a
      string representing the type of data stored in the repository }
    \item{repURL}{\code{signature(object = "ReposEntry")}: Returns the
      URL of the repository }
    \item{depends}{\code{signature(object = "ReposEntry")}: Returns the
      dependencies for a given package}
    \item{suggests}{\code{signature(object = "ReposEntry")}: Returns the
      \code{suggests} field for a given package}
    \item{uses}{\code{signature(object = "ReposEntry")}: Returns the
      \code{uses} field for a given package}
    \item{keywords}{\code{signature(object = "ReposEntry")}: Returns the
      \code{keywords} field for a given package}
    \item{numSubReps}{\code{signature(object = "ReposEntry")}: Returns
      the number of available subrepositories}
    \item{getSubRep}{\code{signature(object = "ReposEntry")}: Returns a
      \code{ReposEntry} object for a given subrepository}
    \item{getSubRepList}{\code{signature(object = "ReposEntry")}:
      Returns a \code{ReposList} object for all subrepositories}
    \item{hasFiles}{\code{signature(object = "ReposEntry")}: Whether or
      not this repository has any downloadable files}
    \item{pkgRVersion}{\code{signature(object = "ReposEntry")}: Returns
      the version of R that a package was built under}
    \item{downloadFile}{\code{signature(object = "ReposEntry")}: Will
      download a requested file and return the new filename}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{repdatadesc-class}},\code{\link{replisting-class}},
  \code{\link{buildReposEntry}}, \code{\link{ReposList}}}
\examples{
   ## TBD
}
\keyword{classes}

\eof
\name{ReposList-class}
\docType{class}
\alias{ReposList-class}
\alias{ReposList}
\alias{downloadRepFile}
\alias{getRepeEntry}
\alias{numReps}
\alias{repList<-}
\alias{repList}
\alias{repNames}
\alias{repPkgInfoList}
\alias{repPkgs}
\alias{repURLs}
\alias{getRepEntry}
\alias{downloadRepFile,ReposList-method}
\alias{getRepEntry,ReposList-method}
\alias{numReps,ReposList-method}
\alias{repList,ReposList-method}
\alias{repList<-,ReposList-method}
\alias{repNames,ReposList-method}
\alias{repPkgInfoList,ReposList-method}
\alias{repPkgs,ReposList-method}
\alias{repURLs,ReposList-method}
\alias{show,ReposList-method}
\title{Class "ReposList", a class to coordinate repository information}
\description{A class to manage multiple repositories as a single entity.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("ReposList", ...)}.
A convenience function, \code{buildReposList} can be used as well.
}
\section{Slots}{
  \describe{
    \item{\code{repList}:}{Object of class \code{"list"} a list of
      \code{ReposEntry} objects.}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "ReposList")}: Provides a
      display of contained information}
    \item{downloadRepFile}{\code{signature(object = "ReposList")}: Will
      download a file from a given repository }
    \item{getRepEntry}{\code{signature(object = "ReposList")}: Retrieves
    a specific \code{ReposEntry} object from the list}
    \item{numReps}{\code{signature(object = "ReposList")}: The number of
      repositories managed by the list}
    \item{repList<-}{\code{signature(object = "ReposList")}: Edits the
      repository listing.  Can use either another \code{ReposList}, a
      \code{ReposEntry}, or an actual list.}
    \item{repList}{\code{signature(object = "ReposList")}: Retunrs the
      \code{repList} slot.}
    \item{repNames}{\code{signature(object = "ReposList")}: Returns the
      names of the known repositories.}
    \item{repPkgInfoList}{\code{signature(object = "ReposList")}:
      Returns a list of \code{pkgInfo} objects for packages stored in
      the known repositories.}
    \item{repPkgs}{\code{signature(object = "ReposList")}: Returns the
      names of the packages in the known repositories. }
    \item{repURLs}{\code{signature(object = "ReposList")}: Returns the
      URLs for the known repositories.}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildReposList}}, \code{\link{getReposList}},
   \code{\link{ReposEntry}}, \code{\link{pkgInfo}}}

\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
\name{VersionNumber-class}
\docType{class}
\alias{VersionNumber-class}
\alias{major}
\alias{minor}
\alias{stringRep}
\alias{revision}
\alias{VersionNumber}
\alias{max.VersionNumber}
\alias{min.VersionNumber}
\alias{!=,VersionNumber-method}
\alias{<,VersionNumber-method}
\alias{<=,VersionNumber-method}
\alias{==,VersionNumber-method}
\alias{>,VersionNumber-method}
\alias{>=,VersionNumber-method}
\alias{as.character,VersionNumber-method}
\alias{major,VersionNumber-method}
\alias{minor,VersionNumber-method}
\alias{revision,VersionNumber-method}
\alias{show,VersionNumber-method}
\alias{stringRep,VersionNumber-method}
\title{A class to handle version numbers}
\description{This class maintains a version number and provides
  appropriate operations to manipulate it}
\section{Objects from the Class}{
  VersionNumber objects should be created with the function buildVersionNumber.
}
\section{Slots}{
  \describe{
    \item{\code{stringRep}:}{Object of class \code{"character"}, string
      representation of the version (e.g. "1.2.3")}
  }
}

\section{Methods}{
  \describe{
    \item{major}{\code{(VersionNumber)}: The major number of the
      version number }
    \item{minor}{\code{(VersionNumber)}: The minor number of the
      version number }
    \item{revision}{\code{(VersionNumber)}: The revision portion of
      the version number }
    \item{stringRep}{\code{(VersionNumber)}: The string representation
      of the version number }
    \item{show}{\code{(VersionNumber)}: Outputs a string representation.}
    \item{as.character}{\code{(VersionNumber)}: Outputs a string representation.}
    \item{==}{\code{(VersionNumber)}: Equals comparitor}
    \item{!=}{\code{(VersionNumber)}: Not equals comparitor}
    \item{>=}{\code{(VersionNumber)}: Greater or equal comparitor}
    \item{<=}{\code{(VersionNumber)}: Less or equal comparitor}
    \item{<}{\code{(VersionNumber)}: Less than comparitor}
    \item{>}{\code{(VersionNumber)}: Greater than comparitor}    
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildVersionNumber}}}
\examples{
a <- buildVersionNumber("1.2.3")
major(a)
minor(a)
revision(a)
stringRep(a)
}
\keyword{classes}

\eof
\name{buildPkgDepGraph}
\alias{buildPkgDepGraph}
\title{A function to build a package dependency graph}
\description{
  Given a package name, will generate a dependency graph for that
  package, detailing all of that package's dependencies, those packages'
  dependencies, etc.
}
\usage{
buildPkgDepGraph(pkg, repEntry, type, curNodes = vector(mode = "character"))
}
\arguments{
  \item{pkg}{The name of the package to use as the base}
  \item{repEntry}{If desired, the specific repository to look for the
    package.  Defaults to the reposTools system repositories if none is specified.}
  \item{type}{ The download type, ie 'unix', 'windows', etc.  If not
    specified, will attempt to determine the proper type. }
  \item{curNodes}{Any current nodes in a graph.  Not intended to be used
    by the end user.}
}
\details{
  This function will recursively generate a dependency graph for a
  package by first looking at all of its dependencies and then tracking
  downt he dependencies for each of those packages, and so on.  After
  the conclusion of every recursive call, the new subgraph is connected
  to the primary graph via the \code{join} method for graphs.

  If multiple versions of a package are found, the highest version of
  the package will be selected for usage in this function.
}
\value{
  An object of class \code{graphNEL} detailing the dependency graph for
  the specified package.
}
\author{Jeff Gentry}
\seealso{ \code{\link{graphNEL-class}}}
\examples{
  if (require(graph)) {
    z <- buildPkgDepGraph("reposTools")
    if (interactive()) {
      ## If you have Rgraphviz package, can plot the graph
      if (require(Rgraphviz))
         plot(z)
    }
  }
}
\keyword{utilities}

\eof
\name{buildPkgInfo}
\alias{buildPkgInfo}
\title{A constructor function for the pkgInfo class}
\description{
  Returns a created pkgInfo object
}
\usage{
buildPkgInfo(name, vers, path = "")
}
\arguments{
  \item{name}{Name of the package}
  \item{vers}{Package version}
  \item{path}{Path to the package on the system}
}
\details{
  Argument 'vers' can be either a character string or of
  the class 'VersionNumber'.  If the former, it will be coerced
  into a 'VersionNumber' object.
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgInfo}}}
\examples{
a <- buildPkgInfo("foo","1.2.3")
}
\keyword{ utilities }

\eof
\name{buildPkgListing}
\alias{buildPkgListing}
\title{ ~~function to do ... ~~ }
\description{
  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
buildPkgListing(repList, pkgs = NULL, type = NULL)
}
\arguments{
  \item{repList}{A \code{ReposList} object to generate the
    \code{pkgListing} out of.}
  \item{pkgs}{A subset of packages to use.  \code{NULL} implies all
    available packages.}
  \item{type}{A subset of package types (Win32, Source, etc) to use.
    \code{NULL} imples all available types.}
}
\value{
  A valid \code{pkgListing} object, or NULL on failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgListing}}, \code{\link{ReposList}}}
\examples{
}
\keyword{utilities}

\eof
\name{buildReposEntry}
\alias{buildReposEntry}
\alias{buildReposList}
\title{A function to generate ReposEntry objects}
\description{
  A simple helper function to wrap generation of \code{ReposEntry} and
  \code{ReposList} objects.
}
\usage{
buildReposEntry(replisting, repdatadesc)
buildReposList(reps, recurse=TRUE)
}
\arguments{
  \item{replisting}{ An object of type 'replisting'}
  \item{repdatadesc}{an object of type 'repdatadesc'}
  \item{reps}{A list of \code{ReposEntry} objects}
  \item{recurse}{Whether or not to search subrepositories}
}
\value{
  An object of appropriate class, or NULL on failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{ReposEntry-class}}, \code{\link{ReposList}}}
\examples{
}
\keyword{utilities}

\eof
\name{buildVersionNumber}
\alias{buildVersionNumber}
\title{A function to generate a VersionNumber object}
\description{
  Wraps a new call for the VersionNumber class
}
\usage{
buildVersionNumber(vers)
}
\arguments{
  \item{vers}{A string representing the version to create}
}
\value{
  Returns a VersionNumber object for the passed in string, or NULL on
  failure. 
}
\author{Jeff Gentry}
\seealso{ \code{\link{VersionNumber}}}
\examples{
  a <- buildVersionNumber("1.2.3")
}
\keyword{utilities}

\eof
\name{buildVigDf}
\alias{buildVigDf}
\alias{buildPkgDf}
\alias{addManifest}
\alias{addOsSpecific}
\title{Functions to create repository data.frames}
\description{
  These functions are used to generate server side repository data.frames
}
\usage{
buildPkgDf(PACKAGEfile="PACKAGES.in", infoDir=".", prefixPath=NULL,
           mangSep=":v:")
buildVigDf(VIGfile = "Vignettes.in", infoDir = ".")
addManifest(df, ext=".manifest", mangSep=":v:")
addOsSpecific(df, prefixPath=NULL, ext=".status",mangSep=":v:")
}
\arguments{
  \item{PACKAGEfile}{For building a package repository, allows the user
    to specify information manually.}
  \item{VIGfile}{For building a vignette repository, allows the user
    to specify information manually.}
  \item{infoDir}{The path to any manual input files}
  \item{df}{A repository data frame object}
  \item{prefixPath}{Allows the user to specify a different location for
    the stored files}
  \item{ext}{File extension for special manual input files}
  \item{mangSep}{Used internally}
}
\details{
   These functions (especially the add* functions, which are called by
   buildPkgDf), are intended primarily to be called from the genRepos()
   routines, but can be manually invoked.  See help("genRepos") for
   descriptions of the various manual input files and their effects.
}
\value{
   A repository data.frame.
}
\author{Jeff Gentry}
\seealso{\code{\link{repdatadesc-class}},\code{\link{genRepos}}}
\examples{
}
\keyword{utilities}

\eof
\name{checkVers}
\alias{checkVers}
\title{A function to compare versions w/ operation string}
\description{
  Handles comparisons of VersionNumber objects when the operator
  is in string form (e.g. ">=", "==", etc).
}
\usage{
checkVers(x, op, y)
}
\arguments{
  \item{x}{The left side object}
  \item{op}{The operator to use for comparison, in string format}
  \item{y}{The right object to compare}
}
\details{
   Will handle the situation 'x op y' for any op that is a valid
   comparitor in the VersionNumber class.  The string 'op' is converted
   into the proper comparitor and then applied to the values x and y.
}
\value{
  TRUE or FALSE as appropriate
}
\author{ Jeff Gentry }
\examples{
   a <- buildVersionNumber("1.2.3")
   b <- buildVersionNumber("2.0")
   checkVers(a,"<=",b)    ## will see if a <= b
   checkVers(a,"==",b)
   checkVers(a,">",b)
}
\keyword{utilities}


\eof
\name{closeLocLib}
\alias{closeLocLib}
\title{A function to close a library listing}
\description{
  Will remove a local lib listing (locLibList) from the user's
  session.
}
\usage{
closeLocLib()
}
\details{
  This function merely removes "locLibList" from the parent.frame()
  environment.  
}
\author{Jeff Gentry}
\seealso{\code{\link{load.locLib}},\code{\link{save.locLib}},\code{\link{syncLocalLibList}}}

\examples{
     lib <- paste(.find.package("reposTools"),"data/",sep="/")
     load.locLib(lib)
     closeLocLib()
}
\keyword{utilities}

\eof
\name{convert.locLib}
\alias{convert.locLib}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{A function to convert old liblisting.Rda files}
\description{
  This function will convert a liblisting.Rda file from the format used
  before reposTools 1.2.39 and transform it into the \code{localPkg}
  list format used in current incarnations of reposTools.
}
\usage{
convert.locLib(libs = .libPaths())
}
\arguments{
  \item{libs}{A vector of R library directories to convert}
}
\details{
  This function will go through each of the specified R library
  directories.  If it contains an old style liblisting.Rda file, it will
  read in the stored package information and convert it into the new
  format, and write this to the liblisting.Rda file.
}
\value{
  None.  There is a side effect in that the liblisting.Rda file will be
  updated. 
}
\author{Jeff Gentry}
\seealso{\code{localPkg-class}}
\examples{
}
\keyword{utilities}

\eof
\name{genRepos}
\alias{genRepos}
\alias{genPkgRepos}
\alias{genVigRepos}
\title{A function to create a repository}
\description{
  This functionality provides the user with the means to generate a
  repository out of a set of files.
}
\usage{
genRepos(repName, urlBase, urlPath, repType = c("package", "vignette", "data"), PACK = FALSE, Status = FALSE, dir = ".", dataPath = "", infoPath = "")
genVigRepos(dataDir, infoDir, VIG=FALSE)
genPkgRepos(dataDir, infoDir, PACK=FALSE, Status=FALSE)
}
\arguments{
  \item{repName}{The name of the repository}
  \item{urlBase}{A base URL for the repository (e.g. http://www.bioconductor.org/)}
  \item{urlPath}{A path from the urlBase (e.g. packages/download/)}
  \item{repType}{Type of repository: package, vignette, data}
  \item{PACK}{Whether to use manual PACKAGES/Vignettes input file}
  \item{VIG}{Whether to use manual Vignettes input file}
  \item{Status}{Whether to use manual status files}
  \item{dir}{The directory to create the repository in}
  \item{dataPath}{Path to the repository files}
  \item{dataDir}{Directory where repository files are}
  \item{infoPath}{Path to any manual files used}
  \item{infoDir}{Directory where info files are}
}
\details{
  For more detailed information, the user is directed to the vignette
  file "HOWTO set up a simple R repository" in the \code{reposTools}
  package.  To do this, you can use the \code{vignette} command in the
  \code{annotate} package: vignette("HOWTO set up a simple R repository", package="reposTools").  

  genRepos is passed basic information about the repository as well as
  indicators as to what should be autogenerated or manually inputed, and
  will create two files:  One file 'replisting', which contains a matrix
  of repository information and the other 'repdatadesc.rda' which
  contains a data.frame representing the files to be distributed.  These
  two special files are accessed by client functions.
  
  genPkgRepos and genVigRepos are primarly helper functions not really
  intended to be called by the user, but do provide more direct access
  to the functionality.
}
\value{
  genRepos returns a list containing basic information about the
  repository generated.
}
\author{Jeff Gentry}
\seealso{\code{\link{install.packages2}},\code{\link{ReposEntry}},\code{\link{vignette}}}

\examples{
}
\keyword{utilities}

\eof
\name{genReposHtml}
\alias{genReposHtml}
\alias{GenPkgListingHTML}
\alias{GenVigListingHTML}
\alias{genPkgListing}
\title{Functions to generate HTML listings of a repository}
\description{
  These functions are used to create simple HTML web pages to represent
  the sort of data stored in a repository.
}
\usage{
genReposHtml(rep, filename = "index.html", outDir = ".", headerInfo)
GenPkgListingHTML(filename, rep, headerInfo, upFile)
genPkgListing(pkgN, reposDF, filename, upFile)
}
\arguments{
  \item{filename}{Name of the HTML file to create}
  \item{outDir}{Directory to sotre the output}
  \item{rep}{repository to use}
  \item{reposDF}{data.frame for the repository}
  \item{pkgN}{Name of a package}
  \item{headerInfo}{HTML code to put in the header of the page}
  \item{upFile}{Name of the file to link to (link to the level above in
    the hierarchy)}
}
\details{
  These functions can be used to generate simple web pages representing
  one's repository.  The main function is genReposHtml() as this one
  calls the others, which are primarily helper functions.
}
\author{R. Gentleman}
\seealso{\code{\link{genRepos}}}
\examples{
}
\keyword{utilities}

\eof
\name{getLocalPkgs}
\alias{getLocalPkgs}
\title{A function to list the locally installed packages}
\description{
  Will return a list of \code{pkgInfo} objects describing the locally
  installed packages in the library directories specified.
}
\usage{
getLocalPkgs(libs = .libPaths())
}
\arguments{
  \item{libs}{Library directories to check.}
}
\value{
  A list of \code{pkgInfo} objects.
}
\author{Jeff Gentry}
\seealso{\code{pkgInfo}}

\examples{
   getLocalPkgs()
}
\keyword{utilities}

\eof
\name{getMaxVersion}
\alias{getMaxVersion}
\alias{getMaxElement}
\alias{getMinElement}
\title{A function to retrieve the maximum value from a list of VersionNumbers}
\description{
  Given a list of VersionNumber objects, will either return the largest
  version number (getMaxVersion) or the element number for the list that
  corresponds to this value.
}
\usage{
getMaxVersion(x)
getMaxElement(x)
getMinElement(x)
}
\arguments{
  \item{x}{A list of VersionNumber objects}
}
\author{Jeff Gentry}
\examples{
   a <- list(buildVersionNumber("1.2.3"), buildVersionNumber("1.5.0"))
   getMaxVersion(a)
   getMaxElement(a)
}
\keyword{utilities}

\eof
\name{getOptReposList}
\alias{getOptReposList}
\title{A function to get a repository list from options}
\description{
  This function will look at options("repositories") and retrieve a
  \code{ReposList} object for the set of returned repositories.
}
\usage{
getOptReposList(recurse = TRUE)
}
\arguments{
  \item{recurse}{Whether or not to look at any subrepositories, default
    is TRUE}
}
\value{
  Returns an object of type \code{ReposList}, representing any found
  repositories along its search path (getOption("repositories") as well
  as any subrepositories if recurse is TRUE).
}
\author{Jeff Gentry}
\seealso{\code{ReposList}}

\examples{
   getOptReposList()
}
\keyword{utilities}

\eof
\name{getPkgVers}
\alias{getPkgVers}
\alias{is.installed}
\title{Information for an installed package}
\description{
  These functions retrieve information on installed packages, including
  whether or not a package is installed.
}
\usage{
is.installed(pkg, vers=NULL, verbose=TRUE, oper="==", libs=.libPaths())
getPkgVers(pkg, libs = .libPaths(), verbose=TRUE)
}
\arguments{
  \item{pkg}{ The package to check}
  \item{vers}{The version of the package.  NULL implies any version}
  \item{libs}{A R library directory (or vector of directories).  Default
    is .libPaths()}
  \item{verbose}{Extra diagnostics}
  \item{oper}{Allows for a version test instead of a direct '=='}
}
\value{
  is.installed: This function will return a logical representing if the
    specified package is installed or not.  The version parameter
    defaults to NULL, which implies any version of the package.  If a
    version is specified, it can be either as a string or as a
    \code{VersionNumber} object.  If the former, it will be coerced to
    the latter.  Argument \code{oper} can be any comparitive function
    (>, <, !=, etc), but defaults to \code{==}.  This is the comparator
    applied to see if a package of a given version is installed.
  
  getPkgVers:  This function returns a list containing all version
    numbers of any instance of the package being isntalled.  If the
    package is installed only in one occassion, it will be a single
    element list.  If the package is installed multiple times, each
    instance will have a corresponding version number.  Likewise, an
    empty list is returned if the package is not installed.  The
    \code{VersionNumber} class is used for the return value.
}
\author{Jeff Gentry}
\seealso{\code{\link{VersionNumber}}}
\examples{
  lib <- paste(.find.package("reposTools"),"data/",sep="/")
  getPkgVers("reposTools",lib)
}
\keyword{utilities}

\eof
\name{getReplisting}
\alias{getReplisting}
\title{A function to retrieve a repository replisting file}
\description{
  Given a repository URL, will retrieve that repository's replisting
  information. 
}
\usage{
getReplisting(repURL, repFile = "replisting")
}
\arguments{
  \item{repURL}{URL of the repository to access}
  \item{repFile}{Name of the replisting file}
}
\details{
  The 'repFile' argument should almost always be left to its default.

  This function will contact the specified repository, and attempt to
  retrive its replisting file.  This downloaded data is then formed into
  an object of class replisting and returned to the user.
}
\value{
  The appropriate replisting object, or NULL upon failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{replisting-class}}}
\examples{
  z <- getReplisting("http://www.bioconductor.org/repository/sample/package")
  z
}
\keyword{utilities}

\eof
\name{getReposEntry}
\alias{getReposEntry}
\title{A function to retrieve a ReposEntry object from a repository}
\description{
  Will retrieve repository information from a specified repository, and
  pass back a ReposEntry object containing this information.
}
\usage{
getReposEntry(repURL, repFile = "replisting", rddFile = "repdatadesc.rda")
}
\arguments{
  \item{repURL}{URL of the repository}
  \item{repFile}{Name of the remote replisting file}
  \item{rddFile}{Name of the remote dataframe RDA file.}
}
\details{
  The latter two options should be left to the defaults in almost all
  cases.

  The remote replisting and (if available) repdatadesc.rda files are
  downloaded from the specified repository and combined to form a
  ReposEntry object.
}
\value{
  The constructed ReposEntry object, or NULL on failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{ReposEntry-class}}}
\examples{
  z <- getReposEntry("http://www.bioconductor.org/repository/sample/package")
  z
}
\keyword{utilities}

\eof
\name{getReposList}
\alias{getReposList}
\title{A function to get a list of repository entries}
\description{
  This function will take any URLs listed by the "repositories" option,
  and will return a list of ReposEntry objects representing those repositories
}
\usage{
getReposList(reps, recurse=TRUE)
}
\arguments{
  \item{reps}{Either a list of \code{ReposEntry} objects, or a
    \code{ReposList} object}
  \item{recurse}{Whether or not to search through subrepositories.
    Default is TRUE}
}
  \value{
  A \code{ReposList} object, containing all \code{ReposEntry} objects
  that were represented in \code{reps} as well as any subrepositories if
  \code{recurse} is TRUE.  Note that this function is essentially
  useless if \code{reps} is a \code{ReposList} and \code{recurse} is FALSE.
}
\author{Jeff Gentry}
\examples{
}
\keyword{utilities}


\eof
\name{getReposOption}
\alias{getReposOption}
\title{a function to find known repositories}
\description{
  This function will return a vector of all known repositories.
}
\usage{
getReposOption()
}
\details{
  Uses the \code{repositories2} option to determine what repositories
  are known.
}
\value{
  A named vector - elements correspond to repository URLs, the names can
  be used as shortcut names for these repositories.
}
\author{Jeff Gentry}
\seealso{\code{\link{getReposEntry}}}
\examples{
  z <- getReposOption
  z
}
\keyword{utilities}

\eof
\name{getRversion}
\alias{getRversion}
\title{A function to retrieve the current R version}
\description{
  Returns the version of the current R process as a VersionNumber object
}
\usage{
getRversion()
}
\value{
  A VersionNumber object reprsenting the version number of the user's
  copy of R
}
\author{Jeff Gentry}
\examples{
getRversion()
}
\keyword{utilities}

\eof
\name{getVigDeps}
\alias{getVigDeps}
\alias{getPkgDeps}
\alias{getObjectDeps}
\title{ A function to extract dependencies }
\description{
  These function will return a vector of dependencies for either a
  vignette or an installed package (respectively).  Each element of
  the vector will represent a single dependency and may also contain
  in the string any version requirements.
}
\usage{
getObjectDeps(x, suggests=TRUE, uses=TRUE)
getVigDeps(x, suggests=TRUE, uses=TRUE)
getPkgDeps(x, suggests=TRUE, uses=TRUE)
}
\arguments{
  \item{x}{ The name of the object }
  \item{suggests}{Whether or not to load 'suggests' level dependencies}
  \item{uses}{Whether or not to load 'uses' level dependencies}
}
\details{
  Obtains the information from the VignetteDepends directive in the
  vignette header, or the DESCRIPTION file for the package.  

  getObjectDeps is used if one is not sure if 'x' represents a package
  or a vignette.  It is a simple wrapper for these two functions.
}
\value{
  A character vector of dependencies, or an empty vector
}
\author{ Jeff Gentry }

\seealso{ \code{\link{load.depends}},\code{\link{depends}}}
\examples{
   getPkgDeps("affy")
}
\keyword{ utilities }

\eof
\name{.initVersionNumber}
\alias{.initReplisting}
\alias{.initRepdatadesc}
\alias{.initReposEntry}
\alias{.initPkgInfo}
\alias{getReqVers}
\alias{reposToolsCurrentInstalls}
\alias{getReqOper}
\alias{getDepMtrx}
\alias{match.libDf}
\alias{match.pkgName}
\alias{getPkgList}
\alias{getVersionPos}
\alias{havePackage}
\alias{getDigits}
\alias{getVersVals}
\alias{mangleRowNames}
\alias{getPackDcfMatrix}
\alias{getPackDcfList}
\alias{reposDfFromList}
\alias{replaceDFversions}
\alias{getReposSpecialFile}
\alias{mangleRowNames}
\alias{fillBlankVersions}
\alias{copyManualFiles}
\alias{mergeVigListStrings}
\alias{getPkgRows}
\alias{handleRepFun}
\alias{filterVigList}
\alias{downAndInPkg}
\alias{reposDF}
\alias{getArgRepos}
\alias{updateLocLib}
\alias{getMangledName}
\alias{getLocLibURLs}
\title{Undocumented routines -- not for the user. }
\description{
  These are routines that are not intended for public consumption.  They
  are such things as initializers, helper functions, etc that make no
  sense to use outside of a greater context.  

  In the future, some or all of these might be given their own man page with 
  greater detail.
}
\details{
  Not for the user.
}
\keyword{utilities }

\eof
\name{install.packages2}
\alias{install.packages2}
\alias{remove.packages2}
\alias{download.packages2}
\alias{update.packages2}
\alias{checkPrevRepos}
\alias{baseFileSelect}
\alias{handleDownloadedFile}
\alias{installPkg}
\title{Functions to download, install and manipulate local packages}
\description{
  These functions are designed to allow the user to
  install, update and download packages from R repositories, as well as
  remove packages from their local system.
}
\usage{
install.packages2(pkgs, repEntry, lib, recurse = TRUE, type,
getNewest=TRUE, force=FALSE,syncLocal = TRUE, searchOptions = TRUE,
versForce = FALSE, getAllDeps=FALSE, method="auto")

download.packages2(pkgs, repEntry, destDir, recurse=TRUE, type,
getNewest=TRUE, searchOptions=TRUE,versForce=FALSE, force=FALSE, method="auto")

update.packages2(pkgs=NULL, repEntry, libs=.libPaths(), recurse=TRUE,
type, prevRepos=TRUE, force=FALSE, fileSelect=baseFileSelect,
syncLocal=TRUE,versForce=FALSE, searchOptions=TRUE, getNewest=TRUE,
install=TRUE, update=TRUE, getAllDeps=FALSE, method="auto")

remove.packages2(pkgs, lib, force=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{repEntry}{A ReposEntry object specifying a particular repository}
  \item{pkgs}{A character vector of package name(s) to act upon}
  \item{lib}{A path to install (or remove from) the package.  If this
    directory does not exist, it will be created (if possible)}
  \item{destDir}{A path to download the package to}
  \item{libs}{A set of library path(s) to search for packages to update}
  \item{prevRepos}{Whether or not to update a package from the
    repository it was installed from}
  \item{force}{Whether or not to ignore any dependencies}
  \item{fileSelect}{Function to determine if a package needs updating or
    not}
  \item{recurse}{Whether to search through subrepositories for desired packages}
  \item{type}{The type of package to download/install/etc (e.g. Source,
    Win32, etc)}
  \item{syncLocal}{Whether to call syncLocalLibList if no local liblist
    is present}
  \item{searchOptions}{Whether to search repositories listed in
    options("repositories") as well as specified repositories.  Default
    is FALSE which means that if one specifies a repository, *only* that
    repository is used.  If set to TRUE, and a user specifies a
    repository, then any repositories set in the user's options will
    also be used.}
  \item{versForce}{Whether or not to override R version checking on
    binary packages}
  \item{getNewest}{Whether or not to just get the newest available
    version of a package, or to provide alternate means (currently a
    menu selection) of obtaining a package}
  \item{install}{Whether or not to install the downloaded package}
  \item{update}{Whether to seek to update the package or simply install
    the requested version}
  \item{getAllDeps}{Will automatically download all dependencies if
    TRUE, otherwise will prompt the user}
  \item{method}{Defaults to "auto", identical to the same parameter used
    for \code{download.file}}
}
\details{
  When "sets of packages" is specified, the user can pass in a name of a
  package, a \code{pkgInfo} object, a vector of package names, or a list that
  contains either/or representing multiple packages.

  For install.packages2, update.packages2, and remove.packages2, the
  system will by default check to insure that no dependencies from other
  packages are being broken.  This can be overridden using \code{force=TRUE}.

  Also for all packages, the \code{type} parameter's default depends on
  the user's OS.  If the user is using a windows machine, the default
  \code{type} to download from a repository is \code{Win32}, otherwise
  it is \code{Source}.
  
  install.packages2:  User can specify a ReposEntry object, a set of
    packages, or both.  If no package names are specified, it is
    assumed the user wants everything available in the repository denoted
    by the ReposEntry.  Will install packages requested into the library
    directory specified.  If recurse==TRUE, will also search through any
    of the repository's listed subrepositories to find packages.
    Likewise, if searchOptions==TRUE, will also look in the repositories
    listed by options("repositories") (So, if one specifies packages w/o
    a ReposEntry, it will only look here).

  download.packages2:  Operates very similarly to install.packages2,
    except that the syntax is slightly different ('destDir' instead of
    'lib', and no 'syncLocal' option as it does not interact with any
    local library management).  In all other respects, it acts like
    install.packages2 except for the obvious differnece in that it
    doesn't actually install the packages.

  update.packages2:  Used to update a user's packages.  Much like the
    other two, can take (or not) a ReposEntry object and also can be
    told to utilize the "repositories" option.  A set of packages can be
    specified, or alternatively all packages in the specified 'libs'
    parameter will be used.  If prevRepos==TRUE, the system will attempt
    to ascertain where the package was actually installed from
    previously and will update from there instead.
  
  remove.packages2: Will remove packages specified by 'pkgs' from the
  libPath noted by 'lib' and reflect this change in the local library
  listing.
  
  The functions check* are helper functions that do most of the actual
  work.  They are not generally intended to be called directly by the user.
}
\author{Jeff Gentry}
\seealso{\code{\link{syncLocalLibList}},\code{\link{ReposEntry}},\code{\link{genRepos}},\code{\link{pkgInfo}}}
\examples{
## set up a temporary directory for use with these examples
## this directory will be used with the \code{lib}
## parameter.  For normal usage, most users will be okay with using
## the defaults of \code{lib} and not need to specify manually
tmpLib <- tempfile()
dir.create(tmpLib)

## install a package from the standard repositories (listed by
## the command \code{getOption("repositories2")}
install.packages2("hu6800",lib=tmpLib)
## and another one from CRAN
install.packages2("abind",lib=tmpLib)
}
\keyword{utilities}

\eof
\name{load.depends}
\alias{load.depends}
\alias{unresolved.depends}
\alias{checkRVersion}
\alias{check.depends}
\title{A function to load package/vignette dependencies}
\description{
  Given a package or a vignette, will determine any dependencies and
  load the required packages - as well as alerting the user to any
  unresolved problems.
}
\usage{
load.depends(x,suggests=TRUE,uses=TRUE,Rversion=TRUE)
unresolved.depends(x,suggests=TRUE,uses=TRUE,Rversion=TRUE)
}
\arguments{
  \item{x}{The object to check}
  \item{suggests}{Whether or not to fail if \code{suggests} level
    dependencies are not met}
  \item{uses}{Whether or not to fail if \code{uses} level dependencies
    are not met}
  \item{Rversion}{Whether or not to fail if any R version dependencies
    are not met}
}
\details{
  load.depends: The function will first determine if the object is an installed
    package or a vignette.  In either case, it will extract a listing of
    all dependencies (both the names and any versioning requirements).  If
    R is listed as a dependency, this is first checked (as well as any
    versioning: e.g. 'R (>=1.6.0)').  Then, any packages listed as
    dependencies are loaded.  If a package is not able to be loaded, the
    function will halt and print out an appropriate error message.

  unresolved.depends:  This function behaves almost identically to
    load.depends except that instead of loading any depended packages,
    it will return a list with any unresolved dependencies.
  
  There are several levels of dependencies available:

  \code{depends}:  The package/vignette directly depends on the specified
  package for general uses.
  
  \code{suggests}: The package/vignette uses the specified package, but
  only in tangential ways.  A user will generally be able to achieve
  normal functionality without it.
  
  \code{uses}:     The package/vignette is only using the specified
  package for examples, etc.
}
\value{
  If \code{unresolved.depends} is used, a list is returned representing
  any unresolved dependencies.  The list structure is such that each
  element corresponds to one level of dependency (i.e. \code{x$Depends},
  \code{x$Suggests}, \code{x$Uses}) and contains a string detailing
  this information. 
}
\author{ Jeff Gentry }
\seealso{\code{\link{getPkgDeps}}, \code{\link{getVigDeps}}}
\examples{
   load.depends("Biobase")
}
\keyword{ utilities }

\eof
\name{load.locLib}
\alias{load.locLib}
\title{A function to load a local library listing}
\description{
  If one exists, will load a local library listing (liblisting.Rda) from
  the specified library directory, creating an object in the user's
  session named 'locLibList'.
}
\usage{
load.locLib(lib=.libPaths()[1])
}
\arguments{
  \item{lib}{ The R library directory to use }
}
\details{
  Will take the library directory to look at (default is
  .libPaths()[1]), and will load a liblisting.Rda file if one exists in
  that directory.  This will result in an object existing in the
  user's session with the name 'locLibList'.
}
\value{
  TRUE if successful, FALSE otherwise.
  There is also the side effect that an object named 'locLibList' is
  loaded in the user's session if TRUE.
}
\author{Jeff Gentry}
\seealso{\code{\link{closeLocLib}},\code{\link{save.locLib}},\code{\link{syncLocalLibList}}}
\examples{
   lib <- paste(.find.package("reposTools"),"data/",sep="/")
   load.locLib(lib)
}
\keyword{utilities}

\eof
\name{loadRepDD}
\alias{loadRepDD}
\title{ A function to retreive a repository data frame }
\description{
  This function will retrieve teh repository dataframe from a specified
  repository, and return it ot the user.
}
\usage{
loadRepDD(repURL, repDD = "repdatadesc.rda")
}
\arguments{
  \item{repURL}{The URL of the repository }
  \item{repDD}{The filename of the remote file.}
}
\details{
  Argument 'repDD' should remain the default in almost all cases.

  This function will connect to a specified repository and attempt to
  download any repdatadesc.rda file that is present.  There is not
  necessarily such a file in every repository, as some repositories are
  data-less (only containing links).

}
\value{
  A dataframe representing the 'repdatadesc' information for the
  specified repository, or NULL on failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{repdatadesc-class}},\code{\link{getReposEntry}}}

\examples{
   rDf <- loadRepDD("http://www.bioconductor.org/repository/sample/package")
}
\keyword{utilities}

\eof
\name{localPkg-class}
\docType{class}
\alias{localPkg-class}
\alias{Depends}
\alias{Keywords}
\alias{Package}
\alias{Repos}
\alias{Suggests}
\alias{Uses}
\alias{PkgVersion}
\alias{Depends,localPkg-method}
\alias{Keywords,localPkg-method}
\alias{Package,localPkg-method}
\alias{PkgVersion,localPkg-method}
\alias{Repos,localPkg-method}
\alias{Suggests,localPkg-method}
\alias{Uses,localPkg-method}
\title{Class "localPkg": A class to represent locally installed packages}
\description{ This class is used to represent a package, and the
  information necessary for repository management}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("localPkg", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{Package}:}{Object of class \code{"character"} The name
      of the package}
    \item{\code{PkgVersion}:}{Object of class \code{"VersionNumber"} The
    version of the package}
    \item{\code{Keywords}:}{Object of class \code{"character"} Keywords
      for the package}
    \item{\code{Depends}:}{Object of class \code{"character"}
      Dependencies for the package}
    \item{\code{Suggests}:}{Object of class \code{"character"} Suggests
      level dependencies of the package}
    \item{\code{Uses}:}{Object of class \code{"character"} Uses level
      dependencies for the package}
    \item{\code{Repos}:}{Object of class \code{"character"} The
      repository that this package was obtained from}
  }
}

\section{Methods}{
  \describe{
    \item{Depends}{\code{signature(object = "localPkg")}: Returns the
      Depends slot}
    \item{Keywords}{\code{signature(object = "localPkg")}: Returns the
      Keywords slot }
    \item{Package}{\code{signature(object = "localPkg")}: Returns the
      Package slot}
    \item{PkgVersion}{\code{signature(object = "localPkg")}: Returns the
    PkgVersion slot}
    \item{Repos}{\code{signature(object = "localPkg")}: Returns the
      Repos slot}
    \item{Suggests}{\code{signature(object = "localPkg")}: Returns the
      Suggests slot}
    \item{Uses}{\code{signature(object = "localPkg")}: Returns the Uses slot}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{syncLocalLibList}}, \code{\link{install.packages2}}}

\examples{
}
\keyword{classes}

\eof
\name{note}
\alias{note}
\title{ Informational Messages}
\description{
  Generates an informational message that corresponds to its
  argument(s).  Similar to warning() except prefaced by "Note:"
  instead of "Warning message:".
}
\usage{
note(...)
}
\arguments{
  \item{\dots}{character vectors (which are pasted together) or NULL}
}
\details{
  This function essentially cat()'s the created string to the screen.
  It is intended for messages to the user that are deemed to be
  'informational', as opposed to warnings, etc.
}
\author{Jeff Gentry}
\seealso{\code{\link{warning}},\code{\link{stop}}}
\examples{
   note("This is an example of a note")
}
\keyword{utilities}


\eof
\name{pkgInfo-class}
\docType{class}
\alias{pkgInfo-class}
\alias{pkgName}
\alias{pkgVersion}
\alias{pkgPath}
\alias{pkgInfo}
\alias{==,pkgInfo-method}
\alias{pkgName,pkgInfo-method}
\alias{pkgPath,pkgInfo-method}
\alias{pkgVersion,pkgInfo-method}
\alias{show,pkgInfo-method}
\title{A class to hold package information}
\description{This class contains some succinct information about a
  package, including its name and version}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("pkgInfo", ...)}.
  The helper function 'buildPkgInfo' is also provided.
}
\section{Slots}{
  \describe{
    \item{\code{pkgName}:}{Object of class \code{"character"} A string
      representing the name of the package}
    \item{\code{pkgVersion}:}{Object of class \code{"VersionNumber"} A
      VersionNumber object representing the version number of the package }
    \item{\code{pkgPath}:}{Object of class \code{"character"} A string
      reprsenting the path of the installed package}
  }
}

\section{Methods}{
  \describe{
    \item{pkgName}{\code{(pkgInfo)}: The name of the package}
    \item{pkgPath}{\code{(pkgInfo)}: The path to the installed copy of
      the package}
    \item{pkgVersion}{\code{(pkgInfo)}: The version number of the
      package}
    \item{show}{\code{(pkgInfo)}: Displays in the form <pkgName>: <pkgVersion>}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildPkgInfo}}}
\examples{
 a <- buildPkgInfo("Foo","1.2.3")
}
\keyword{classes}

\eof
\name{pkgListing-class}
\docType{class}
\alias{pkgListing-class}
\alias{pkgListing}
\alias{packages}
\alias{pkgList}
\alias{repListing}
\alias{pkgNames}
\alias{pkgVersionList}
\alias{downloadRepFile,pkgListing-method}
\alias{getRepEntry,pkgListing-method}
\alias{packages,pkgListing-method}
\alias{pkgList,pkgListing-method}
\alias{pkgVersionList,pkgListing-method}
\alias{repList,pkgListing-method}
\alias{repListing,pkgListing-method}
\alias{show,pkgListing-method}
\alias{summary,pkgListing-method}
\title{A class to coordinate repository package information}
\description{Coordinates package information from multiple repositories,
  maintaining a list of packages, version information and which versions
  of which packages are from which repositories.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("pkgListing", ...)}.
Also, a convenience function, \code{buildPkgListing} has been provided
which will construct the \code{pkgListing} from just a \code{reposList}
object.
}
\section{Slots}{
  \describe{
    \item{\code{pkgList}:}{A list, detailing packages and versions}
    \item{\code{repList}:}{Object of class \code{"ReposList"}, defines
      the known repositories.}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "pkgListing")}: Summarizes
      information stored.}
    \item{downloadRepFile}{\code{signature(object = "pkgListing")}:
      Downloads a given file from one of the known repositories.}
    \item{getRepEntry}{\code{signature(object = "pkgListing")}:
      Retrieves a specific \code{repEntry} object from the repository
      listing. }
    \item{packages}{\code{signature(object = "pkgListing")}: Lists
      available packages in the known repositories.}
    \item{pkgList}{\code{signature(object = "pkgListing")}: Retrieves
      the \code{pkgList} slot }
    \item{pkgVersionList}{\code{signature(object = "pkgListing")}:
      Returns a more formatted list representing the information in the
      \code{pkgList} slot, allowing for the names to be replaced with
      repository names or URLs as well.}
    \item{repListing}{\code{signature(object = "pkgListing")}: Retrieves
    a \code{replisting} slot from one of the known repositories.}
    \item{repList}{\code{signature(object = "pkgListing")}: Retrieves
      the \code{repList} slot.}
    \item{summary}{\code{signature(object = "pkgListing")}: A briefer
      summary of contents then \code{show}}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildPkgListing}}, \code{\link{ReposList}}, \code{\link{ReposEntry}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
\name{pkgStatus-class}
\docType{class}
\alias{pkgStatus-class}
\alias{pkgStatus}
\alias{package}
\alias{found}
\alias{updated}
\alias{URL}
\alias{URL,pkgStatus-method}
\alias{found,pkgStatus-method}
\alias{package,pkgStatus-method}
\alias{pkgVersion,pkgStatus-method}
\alias{show,pkgStatus-method}
\alias{updated,pkgStatus-method}

\title{Class "pkgStatus", maintains download status of a package}
\description{This class is used during an update/install/etc to maintain
  current download status for a package - whether it was found, updated, etc.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("pkgStatus", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{package}:}{Object of class \code{"character"} The
      package name}
    \item{\code{found}:}{Object of class \code{"logical"} Whether or not
    the packages was found in a repository}
    \item{\code{updated}:}{Object of class \code{"logical"} Whether or
      not the package was downloaded}
    \item{\code{url}:}{Object of class \code{"character"} The URL of the
    repository}
    \item{\code{pkgVersion}:}{Object of class \code{"VersionNumber"} The
    version of the package}
  }
}
\section{Methods}{
  \describe{
    \item{show}{Defines a summary of information for the package}
    \item{package}{Retrieves the package name}
    \item{found}{Retrieves the found slot}
    \item{updated}{Retrieves the updated slot}
    \item{URL}{Retrieves the URL slot}
    \item{pkgVersion}{Retrieves the pkgVersion slot}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgStatusList}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
\name{pkgStatusList-class}
\docType{class}
\alias{pkgStatusList-class}
\alias{pkgStatusList}
\alias{statusList}
\alias{statusList<-}
\alias{notFound}
\alias{notUpdated}
\alias{urls}
\alias{pkgVersions}
\alias{foundPkgs}
\alias{notFoundPkgs}
\alias{updatedPkgs}
\alias{getPackage}
\alias{getFound}
\alias{getUpdated}
\alias{getUrl}
\alias{getPkgVersion}
\alias{foundPkgs,pkgStatusList-method}
\alias{found,pkgStatusList-method}
\alias{getFound,pkgStatusList-method}
\alias{getPackage,pkgStatusList-method}
\alias{getPkgVersion,pkgStatusList-method}
\alias{getUpdated,pkgStatusList-method}
\alias{getUrl,pkgStatusList-method}
\alias{notFoundPkgs,pkgStatusList-method}
\alias{notFound,pkgStatusList-method}
\alias{notUpdated,pkgStatusList-method}
\alias{packages,pkgStatusList-method}
\alias{pkgVersions,pkgStatusList-method}
\alias{show,pkgStatusList-method}
\alias{statusList<-,pkgStatusList-method}
\alias{statusList,pkgStatusList-method}
\alias{updatedPkgs,pkgStatusList-method}
\alias{updated,pkgStatusList-method}
\alias{urls,pkgStatusList-method}
\title{Class "pkgStatusList", maintains status for multiple packages}
\description{Maintains a set of \code{pkgStatus} objects, and methods
  for interacting with them.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("pkgStatusList", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{statusList}:}{Object of class \code{"list"}, a list of
      \code{pkgStatus} objects}
  }
}
\section{Methods}{
  \describe{
    \item{show}{Summarizes the information stored in the listing}
    \item{statusList}{Returns the \code{statusList} slot}
    \item{statusList<-}{Edits the \code{statusList} slot.  User can pass
      in another \code{pkgStatusList}, a \code{pkgStatus} object, or a
      list.  Appends that information on to the current
      \code{statusList}}
    \item{packages}{Returns the names of all packages being handled}
    \item{found}{Returns a numerical vector representing which positions
      in the \code{statusList} have been found}
    \item{notFound}{Returns a numerical vector representing which
      positions have not been found}
    \item{updated}{Returns a numerical vector representing which
      positions have been updated}
    \item{notUpdated}{Returns a numerical vector representing which
      positions have not been updated}
    \item{urls}{Returns the urls from all of the contained
      \code{pkgStatus} instances}
    \item{pkgVersions}{Returns the version number of all handled
      packages}
    \item{foundPkgs}{Returns the names of the found packages}
    \item{notFoundPkgs}{Returns the names of the packages that were not
      found}
    \item{updatedPkgs}{Returns the names of the updated packages}
    \item{getPackage}{Gets the name of a particular package}
    \item{getFound}{Retrieves the \code{found} slot for a particular
      position}
    \item{getUpdated}{Whether or not a particular package was updated}
    \item{getUrl}{A particular package's url}
    \item{getPkgVersion}{A particular package's version number}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgStatus}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}

\eof
\name{repdatadesc-class}
\docType{class}
\alias{repdatadesc-class}
\alias{repdatadesc}
\alias{depends,repdatadesc-method}
\alias{keywords,repdatadesc-method}
\alias{repdatadesc,repdatadesc-method}
\alias{show,repdatadesc-method}
\alias{suggests,repdatadesc-method}
\alias{summary,repdatadesc-method}
\alias{uses,repdatadesc-method}
\title{A class to represent a repository data frame}
\description{Provides a structure and representation for repository
  dataframe objects}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("repdatadesc", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{repdatadesc}:}{Object of class \code{"data.frame"} A
      repository data frame}
  }
}

\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "repdatadesc")}: A verbose
      output of the contents}
    \item{summary}{\code{signature(object = "repdatadesc")}: A brief output
    of the contents}
    \item{repdatadesc}{\code{signature(object = "repdatadesc")}: The
      dataframe itself}
    \item{depends}{\code{signature(object = "repdatadesc")}: Returns the
      \code{depends} information for a given package}
    \item{uses}{\code{signature(object = "repdatadesc")}: Returns the
      \code{uses} information for a given package}
    \item{suggests}{\code{signature(object = "repdatadesc")}: Returns
      the \code{suggests} information for a given package}
    \item{keywords}{\code{signature(object = "repdatadesc")}: Returns
      keywords for a given package.}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{ReposEntry-class}},\code{\link{replisting-class}}}
\examples{
data(sampleRepos)
a <- new("repdatadesc",repdatadesc=reposDF)
a
}
\keyword{classes}

\eof
\name{replisting-class}
\docType{class}
\alias{replisting-class}
\alias{replisting}
\alias{numSubReps,replisting-method}
\alias{replisting,replisting-method}
\alias{repURL,replisting-method}
\alias{show,replisting-method}
\alias{summary,replisting-method}
\title{A class to represent repository information}
\description{Provides structure to basic repository information, such as
  type, URL, subrepositories, etc}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("replisting", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{replisting}:}{Object of class \code{"matrix"} The
      information itself}
  }
}

\section{Methods}{
  \describe{
    \item{summary}{\code{signature(object = "replisting")}: An output of
      the information}
    \item{show}{\code{signature(object = "replisting")}: A verbose
      output of the information}
    \item{replisting}{\code{signature(object = "replisting")}: Returns
      the information matrix}
    \item{numSubReps}{\code{signature(object = "replisting")}: Returns
      the number of available subrepositories}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{ReposEntry-class}},\code{\link{repdatadesc-class}}}
\examples{
## Note that generally the replisting matrix would come from a
## repository 'replisting' file.  Generating it manually here.
a <- matrix(ncol=4,nrow=1)
a[1,] <- c("Test Repository",
  "package","http://www.bioconductor.org/repository","/sample/package")

colnames(a) <- c("repname","reptype","repaddrBase","repaddrPath")

z <- new("replisting",replisting=a)
z
}
\keyword{classes}

\eof
\name{reposToolsLibPaths}
\alias{reposToolsLibPaths}
\title{A function to handle temporary libPaths}
\description{
  The reposTools package needs to maintain state information about
  packages that are installed, and normally does this by writing to a
  file 'liblisting.rda' in each library directory.  At times, a library
  directory is not writeable so reposTools stores this state in another
  directory.  This function keeps track of those directories and will
  join them with the normal .libPaths.
}
\usage{
reposToolsLibPaths(baseLib = .libPaths(), tmpLibPath = file.path(tempdir(), "tempLibs"))
}
\arguments{
  \item{baseLib}{The base set of library directories}
  \item{tmpLibPath}{The temporary directory used to maintain state}
}
\value{
  A vector of library directories
}
\author{Jeff Gentry}
\examples{
  z <- reposToolsLibPaths()
}
\keyword{utilities}

\eof
\name{repositories}
\alias{repositories}
\title{A function to choose a repository}
\description{
  This function will find repositories known by the system and present
  them to the user - allowing the user to select a repository for
  further use.
}
\usage{
repositories(recurse = TRUE)
}
\arguments{
  \item{recurse}{Whether or not to recurse through subrepositories}
}
\details{
  This function uses the repositories available from the
  \code{repositories2} option.
}
\value{
  A \code{repEntry-class} object representing the selected repository,
  or \code{NULL} if the user selects 0 (no repository).
}
\author{Jeff Gentry}
\seealso{\code{repEntry-class}}
\examples{
  if (interactive()) {
    z <- repositories()
    z
 }
}
\keyword{utilities}

\eof
\name{resolve.depends}
\alias{resolve.depends}
\alias{findInstallDepends}
\alias{solveForwardDepends}
\title{A function to check for dependency breakages}
\description{
  Given a particular package, will check to insure that no dependencies
  are being broken if this package were to be changed (newer version
  installed, package removed, etc).
}
\usage{
resolve.depends(pkg, repEntry, force = FALSE, forward=TRUE, libs =
.libPaths(), remove = FALSE, depends = TRUE, suggests = TRUE, uses =
FALSE, searchOptions=TRUE, getAllDeps=FALSE, versForce=FALSE,
method = "auto",getNewest=FALSE)
}
\arguments{
  \item{pkg}{A pkgInfo object describing the package}
  \item{repEntry}{The \code{ReposEntry} object the package is coming from}
  \item{force}{Logical, if force==TRUE, will only \code{warn} the user
    of dependencies, instead of \code{stop}ing}
  \item{forward}{Whether to check for and attempt to aquire any
    dependencies this package might have that are not already installed}
  \item{libs}{Libraries to search for dependency problems}
  \item{remove}{Logical to flag if the user is seeking to remove \code{pkg}}
  \item{depends}{Whether to \code{stop} on unresolved \code{depends}
    level dependencies}
  \item{suggests}{Whether to \code{stop} on unresolved \code{suggests}
    level dependencies}
  \item{uses}{Whether to \code{stop} on unresolved \code{uses} level dependencies}
  \item{searchOptions}{Corresponds with the \code{searchOptions}
    argument to \code{update.packages2} - used if downloading a package
    due to forward=TRUE}
   \item{getAllDeps}{Will automatically download all dependencies if
     TRUE, otherwise will prompt the user}
   \item{versForce}{Whether or not to override R version checking on
    binary packages}
   \item{method}{What download method to use if any packages are
     downloaded and installed.  See the same parameter for \code{install.packages2}}
   \item{getNewest}{Passed down to any install.packages2() call internally}
 }
\details{
  Will look for a local library listing file in every library specified
  by \code{libs}.  If one exists, will check packages in that R library
  to see if the desired action would break any dependency links.  For
  instance, if package X depends on package Y version 2, and the user is
  looking to upgrade package Y to version 3 - or if the user wants to
  remove package Y altogether.

  By default, the system will \code{stop} for any unresolved
  \code{depends} and \code{suggests} level dependencies, but only throw
  a \code{warning} on any \code{uses} level dependencies.  These can be
  toggled by the user.

  If \code{force == TRUE}, only \code{warnings} will be given.
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgInfo}},\code{\link{depends}},\code{\link{syncLocalLibList}}}

\examples{
}
\keyword{utilities}

\eof
\name{save.locLib}
\alias{save.locLib}
\title{A function to save a local lib listing}
\description{
  Will save a locLibList data.frame to a liblisting.Rda file in the R
  library directory specified.
}
\usage{
save.locLib(locLibList, lib)
}
\arguments{
  \item{locLibList}{A local library listing data.frame}
  \item{lib}{The directory to save this data.frame}
}
\details{
  Will save the dataframe locLibList into a file named 'liblisting.Rda' in
  the directory specified by 'lib'
}
\author{Jeff Gentry}
\seealso{\code{\link{closeLocLib}},\code{\link{load.locLib}},\code{\link{syncLocalLibList}}}

\examples{
   lib <- paste(.find.package("reposTools"),"data/",sep="/")
   load.locLib(lib)
   save.locLib(locLibList,lib)
}
\keyword{utilities}

\eof
\name{saveDfRda}
\alias{saveDfRda}
\title{A function to save a repository dataframe file}
\description{
  This function is utilized to provide a uniform name of the dataframe
  object (reposDF) stored in the repdatadesc.rda file.
}
\usage{
saveDfRda(reposDF, outFile = "repdatadesc.rda")
}
\arguments{
  \item{reposDF}{The repository data.frame }
  \item{outFile}{The name of the file to store it in}
}
\details{
  By protocol, all repository data.frames should have the name 'reposDF'
  when stored in the repdatadesc file.  As such, this function provides
  a wrapper to force this naming convention.

  Also by convention, in a repository setting the filename is
  "repdatadesc.rda", so one should not deviate from teh defaults.
}
\author{Jeff Gentry}
\seealso{\code{\link{buildPkgDf}}}
\examples{
   z <- tempfile()
   data(sampleRepos)
   saveDfRda(reposDF,z)
   unlink(z)
}
\keyword{utilities}

\eof
\name{splitDFstrings}
\alias{splitDFstrings}
\title{A function to split vector strings in a data.frame}
\description{
  Given a data.frame and a set of fields, will take any "string of
  strings" (e.g. "foo, blah, bar") and split them into a vector of strings
  (e.g. c("foo", "blah", "bar")).
}
\usage{
splitDFstrings(df, fields, delim = ",[[:space:]]*")
}
\arguments{
  \item{df}{A data.frame}
  \item{fields}{Set of columns (fields) to split}
  \item{delim}{Delimiter to split on.  Default is ", "}
}
\value{
  The data.frame with the specified columns appropriately manipulated.
}
\author{Jeff Gentry}
\examples{
   a <- data.frame(I("foo, blah"))
   colnames(a) <- "bar"
   a
   splitDFstrings(a,"bar")
   a$bar
}
\keyword{utilities}

\eof
\name{syncLocalLibList}
\alias{syncLocalLibList}
\title{A function to synch the local library file}
\description{
  Will look for a file liblisting.Rda in specified R library directory,
  and synch any information that is not in the current liblisting into
  that file.  If no such file exists, will create one.
}
\usage{
syncLocalLibList(lib = .libPaths())
}
\arguments{
  \item{lib}{A vector of library directories to synch.  Default is .libPaths()}
}
\details{
  If there is not currently a liblisting.Rda file in the specified
  lib(s), one will be created.  Any new information (new packages,
  updated versions, etc) will be reflected into the liblisting.Rda
  file.  If multiple libs are specified, this procedure will be repeated
  across all libs.

  The liblisting.Rda file contains an object named \code{locLibList}.
  This object is a list of \code{localPkg} objects.  Each object in the
  list represents one installed package in that library directory.
}
\author{ Jeff Gentry }
\examples{
    ## make a temporary directory for use in this example
    a <- tempfile()
    dir.create(a)
    syncLocalLibList(a)
    unlink(a,recursive=TRUE)
}
\keyword{utilities}


\eof
\name{unpackExtractPkgDESC}
\alias{unpackExtractPkgDESC}
\alias{unpackSourcePkg}
\alias{unpackZipPkg}
\title{Functions to unpack built packages}
\description{
  These functions will unpack (and in some cases extract information
  from) built R packages.
}
\usage{
unpackExtractPkgDESC(pkg)
unpackSourcePkg{pkg}
unpackZipPkg{pkg}
}
\arguments{
  \item{pkg}{A built R package}
}
\details{
  unpackExtractPkgDESC will return a DCF matrix representing the
  DESCRIPTION file of the specified package.  It does this by unpacking
  the package using the appropriate method (currently options are
  limited to .tar.gz and .zip), and reading the file in manually.

  unpackSourcePkg will attempt to uncompress the .tar.gz package
  structure.

  unpackZipPkg will attempt to uncompres a .zip package using the
  system's "unzip" option.
}
\author{Jeff Gentry}
\examples{
}
\keyword{utilities}

\eof
\name{userQuery}
\alias{userQuery}
\title{A function to query the user for input}
\description{
  This function will output a given message and seek a response from the
  user, repeating the message until the input is from a valid set
  provided by the code.
}
\usage{
userQuery(msg, allowed = c("yes", "y", "no", "n"))
}
\arguments{
  \item{msg}{The output message}
  \item{allowed}{Allowed input from the user}
}
\value{
  The input from the user
}
\author{Jeff Gentry}
\examples{
}
\keyword{utilities}

\eof
\name{winConvertSourceRepos}
\alias{winConvertSourceRepos}
\title{A function to convert source repositories to Win32 repositories}
\description{
  This function will take source packages from a repository, convert
  them into Win32 binary packages.
}
\usage{
winConvertSourceRepos(repEntry, pkgs, destDir, recurse = TRUE,
searchOptions = TRUE, errorLog)
}
\arguments{
  \item{repEntry}{A repository URL to convert}
  \item{pkgs}{A set of packages to convert}
  \item{destDir}{Where to store the converted packages}
  \item{recurse}{Whether to convert any sub-repositories.  Default is TRUE}
  \item{searchOptions}{Whether to search the repositories listed in 
	options("repositories") for packages as well.  Default is TRUE.} 
  \item{errorLog}{An optional parameter specifying an output file for
        errors generated by this function}
}
\details{
  The user must specify at least one of \code{repEntry} or \code{pkgs}.
  If only the former is supplied, all packages from that repository will
  be converted.  If only the latter is supplied, then
  \code{searchOptions} must be TRUE and repositories listed in the
  user's options will be searched.  If both are used, then only the
  specified packages are converted from the specified repository.

  The system will convert the packages into a Win32 binary package,
  which is then suitable to be turned into a repository with \code{genRepos}.
}
\author{Jeff Gentry}
\seealso{\code{\link{genRepos}}}
\examples{
}
\keyword{utilities}

\eof
