###########################################################################
# Read in sample microarray data from Swirl zebrafish experiment
data(swirl)

# Summary of the microarray object swirl which contains pre-normalization data - class marrayRaw

swirl

###########################################################################

if(dev.cur() <= 1) get(getOption("device"))()
 
opar <- par(ask= (interactive() &&
                  (.Device %in% c("X11", "GTK", "windows", "Macintosh"))),
            bg="cornsilk", mfrow=c(1,1))

###########################################################################
# Boxplots

# Boxplots of pre-normalization log-ratios for each array in swirl
maBoxplot(swirl, main="Swirl arrays: pre-normalization log-ratios M")

# Boxplots of pre-normalization log-ratios M for each of the 16 
# print-tip-groups 
# - Default arguments
par(mfrow=c(2,2))
for(i in 1:4)
  maBoxplot(swirl[,i])   

par(mfrow=c(1,1))

mtext("Swirl arrays: pre-normalization log-ratios by print-tip-group",line=3)

###########################################################################
# Color images

# Microarray color palettes
Gcol <- maPalette(low = "white", high = "green", k = 50)
Rcol <- maPalette(low = "white", high = "red", k = 50)
RGcol <- maPalette(low = "green", high = "red", k = 50)

# Color images of green and red background and foreground intensities for Swirl 93 array

maImage(swirl[, 3], x ="maGb", main = "Swirl array 93: image of Cy3 background intensities")
maImage(swirl[, 3], x ="maRb", main = "Swirl array 93: image of Cy5 background intensities")
maImage(swirl[, 3], x ="maGf", main = "Swirl array 93: image of Cy3 foreground intensities")
maImage(swirl[, 3], x ="maRf", main = "Swirl array 93: image of Cy5 foreground intensities")

# Color images of pre-normalization intensity log-ratios
maImage(swirl[, 1], main = "Swirl array 81: Image of log-ratios M")
maImage(swirl[, 3], x = "maM", subset = maTop(maM(swirl[, 3]), h = 0.1, l = 0.1), col = RGcol, contours = FALSE, bar = TRUE, main = "Swirl array 93: image of pre-normalization log-ratios M for % 10 tails")

###########################################################################
# Scatter-plots


# Pre-normalization MA-plot for the Swirl 93 array, with the lowess fits for 
# individual print-tip-groups. 
# - Default arguments
maPlot(swirl[,3], main = "Swirl array 93: pre-normalization MA-plot, lowess fits within print-tip-group")

# Pre-normalization MA-plot for the Swirl 81 array, with the lowess fits for 
# individual grid columns and 1% tails of M highlighted
defs <- maDefaultPar(swirl[, 1], x = "maA", y = "maM", z = "maGridCol")
legend.func <- do.call("maLegendLines", defs$def.legend)
lines.func <- do.call("maLowessLines", c(list(TRUE, f = 0.3), defs$def.lines))
text.func<-maText(subset=maTop(maM(swirl)[,1],h=0.01,l=0.01), labels="o", col="violet")
maPlot(swirl[, 1], x = "maA", y = "maM", z = "maGridCol", lines.func=lines.func, text.func = text.func, legend.func=legend.func, main = "Swirl array 81: pre-normalization MA-plot, lowess fits within grid column")


###########################################################################
